/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import java.io.IOException;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.FileUtilities;

public final class RaptorFileIdentity
implements Identity {
    private KeyPair mKeyPair;
    private final String name;
    private final URL url;

    public static RaptorFileIdentity createIdentity(JSch jSch, URL uRL) throws JSchException {
        RaptorFileIdentity raptorFileIdentity = null;
        try {
            byte[] byArray = FileUtilities.readFile((URL)uRL);
            KeyPair keyPair = KeyPair.load((JSch)jSch, (byte[])byArray, null);
            raptorFileIdentity = new RaptorFileIdentity(uRL, keyPair);
        }
        catch (IOException iOException) {
            throw new JSchException(iOException.getLocalizedMessage(), (Throwable)iOException);
        }
        return raptorFileIdentity;
    }

    private RaptorFileIdentity(URL uRL, KeyPair keyPair) {
        this.url = uRL;
        this.name = URLFileSystem.getPath((URL)uRL);
        this.mKeyPair = keyPair;
    }

    public boolean setPassphrase(byte[] byArray) throws JSchException {
        return this.mKeyPair.decrypt(byArray);
    }

    public byte[] getPublicKeyBlob() {
        return this.mKeyPair.getPublicKeyBlob();
    }

    public byte[] getSignature(byte[] byArray) {
        return this.mKeyPair.getSignature(byArray);
    }

    public boolean decrypt() {
        throw new RuntimeException("not implemented");
    }

    public String getAlgName() {
        String string = "";
        switch (this.mKeyPair.getKeyType()) {
            case 1: {
                string = "ssh-dss";
                break;
            }
            case 2: {
                string = "ssh-rsa";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Key Type");
            }
        }
        return string;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEncrypted() {
        return this.mKeyPair.isEncrypted();
    }

    public void clear() {
        this.mKeyPair.dispose();
        this.mKeyPair = null;
    }

    public URL getURL() {
        return this.url;
    }
}

