/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh;

import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.net.URL;
import oracle.dbtools.raptor.ssh.RaptorIdentityRepository;
import oracle.dbtools.raptor.ssh.RaptorStore;
import oracle.dbtools.raptor.ssh.UserInfoImpl;
import oracle.dbtools.raptor.ssh.config.SshConfiguration;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFactory;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;

public final class ClientImpl
extends Client {
    static final String EXT_ID = "oracle.sqldeveloper.ssh";
    static final String STORE_FNAME = "ssh.xml";

    protected Store createStore() {
        URL uRL = this.getStoreURL();
        return RaptorStore.createStore(uRL);
    }

    protected URL getStoreURL() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        URL uRL = extensionRegistry.getSystemDirectory(EXT_ID);
        return URLFactory.newURL((URL)uRL, (String)STORE_FNAME);
    }

    protected void initSSHClient() {
        URL uRL;
        SshConfiguration sshConfiguration = SshConfiguration.getInstance();
        URL uRL2 = sshConfiguration.getKnownHostsFile();
        if (uRL2 != null) {
            this.setKnownHosts(uRL2);
        }
        if ((uRL = sshConfiguration.getConfigFile()) != null) {
            this.setConfigFile(uRL);
        } else {
            this.resetConfigRepository();
        }
        sshConfiguration.addStructureChangeListener(new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                block8: for (ChangeInfo changeInfo : structureChangeEvent.getChangeDetails()) {
                    URL uRL;
                    String string = changeInfo.getPropertyLocalName();
                    if ("KnownHosts".equals(string)) {
                        switch (changeInfo.getChangeType()) {
                            case 3: {
                                ClientImpl.this.setKnownHosts(null);
                                break;
                            }
                            case 0: 
                            case 1: {
                                uRL = changeInfo.getNewValueAsURL();
                                ClientImpl.this.setKnownHosts(uRL);
                            }
                        }
                        continue;
                    }
                    if (!"ConfigFile".equals(string)) continue;
                    switch (changeInfo.getChangeType()) {
                        case 3: {
                            ClientImpl.this.setConfigFile(null);
                            continue block8;
                        }
                        case 0: 
                        case 1: {
                            uRL = changeInfo.getNewValueAsURL();
                            ClientImpl.this.setConfigFile(uRL);
                        }
                    }
                }
            }
        });
    }

    protected void initSession(Session session, HostDescriptor hostDescriptor) {
        session.setUserInfo((UserInfo)new UserInfoImpl());
    }

    protected IdentityRepository getRepository(HostDescriptor hostDescriptor) throws JSchException {
        URL uRL = hostDescriptor.getKeyfile();
        return uRL != null ? RaptorIdentityRepository.getRepository(uRL, this.getSSHClient()) : null;
    }
}

