/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.navigator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.model.AsynchronousNavigatorTreeNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.onsd.OnsdBrowserResources;
import oracle.dbtools.raptor.onsd.connection.NSConnection;
import oracle.dbtools.raptor.onsd.connection.NSConnectionException;
import oracle.dbtools.raptor.onsd.connection.NSConnections;
import oracle.dbtools.raptor.onsd.connection.OnsdTask;
import oracle.dbtools.raptor.onsd.controls.display.DisplayOnsdRowIterator;
import oracle.dbtools.raptor.onsd.navigator.OnsdController;
import oracle.dbtools.raptor.onsd.navigator.OnsdObjectType;
import oracle.dbtools.raptor.onsd.navigator.OnsdTable;
import oracle.dbtools.raptor.onsd.navigator.OnsdViewerDetail;
import oracle.dbtools.raptor.onsd.navigator.ViewerStyle;
import oracle.dbtools.util.Logger;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.kv.KVStore;
import oracle.kv.table.Table;
import oracle.kv.table.TableAPI;

public class TableTreeNode
extends AsynchronousNavigatorTreeNode {
    protected RaptorTask<Collection<Element>> getLoadingTask() {
        return new LoadTask((OnsdTable)this.getElement());
    }

    protected static LinkedHashMap<String, OnsdViewerDetail> getTableViewerDetails() {
        LinkedHashMap<String, OnsdViewerDetail> linkedHashMap = new LinkedHashMap<String, OnsdViewerDetail>();
        linkedHashMap.put("COLUMN_LABEL", new OnsdViewerDetail(ViewerStyle.TABLE, "getColumns"));
        linkedHashMap.put("DATA_LABEL", new OnsdViewerDetail(ViewerStyle.TABLE, "getRows", DisplayOnsdRowIterator.class));
        linkedHashMap.put("INDEX_LABEL", new OnsdViewerDetail(ViewerStyle.TABLE, "getIndexes"));
        linkedHashMap.put("CHILD_TABLE_LABEL", new OnsdViewerDetail(ViewerStyle.TABLE, "getChildTables"));
        linkedHashMap.put("DETAILS_LABEL", new OnsdViewerDetail(ViewerStyle.TABLE, "getDetails"));
        return linkedHashMap;
    }

    protected static OnsdTable getTableElement(Table table, URL uRL) throws IllegalAccessException, InstantiationException {
        String string = table.getFullName();
        URL uRL2 = DBURLFormatHelper.getURL((URL)uRL, (String)string);
        OnsdTable onsdTable = (OnsdTable)NodeFactory.findOrCreate(OnsdTable.class, (URL)uRL2);
        onsdTable.setOnsdObjectType(new OnsdObjectType("TABLE"));
        onsdTable.setName(string);
        LinkedHashMap<String, OnsdViewerDetail> linkedHashMap = TableTreeNode.getTableViewerDetails();
        onsdTable.setViewers(linkedHashMap);
        return onsdTable;
    }

    private class LoadTask
    extends OnsdTask<Collection<Element>> {
        private OnsdTable m_owner;
        private String m_cName;

        LoadTask(OnsdTable onsdTable) {
            super(OnsdBrowserResources.getString("TASK_ONSD_CONNECT"), true, IRaptorTaskRunMode.TASKVIEWER);
            this.m_owner = onsdTable;
            this.m_cName = onsdTable.getConnectionName();
        }

        @Override
        protected String getConnectionName() {
            return this.m_cName;
        }

        protected Collection<Element> doWork() throws TaskException {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            URL uRL = this.m_owner.getURL();
            try {
                NSConnection nSConnection = NSConnections.getInstance().getConnection(this.m_cName, false);
                KVStore kVStore = nSConnection.getStore();
                TableAPI tableAPI = kVStore.getTableAPI();
                Table table = tableAPI.getTable(this.m_owner.getName());
                Map map = table.getChildTables();
                for (String string : map.keySet()) {
                    Table table2 = (Table)map.get(string);
                    OnsdTable onsdTable = TableTreeNode.getTableElement(table2, uRL);
                    onsdTable.setConnectionName(this.m_cName);
                    arrayList.add((Element)onsdTable);
                }
            }
            catch (NSConnectionException nSConnectionException) {
                Logger.warn(OnsdController.class, (Throwable)nSConnectionException);
                throw new TaskException((Throwable)nSConnectionException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.warn(OnsdController.class, (Throwable)illegalAccessException);
                throw new TaskException((Throwable)illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                Logger.warn(OnsdController.class, (Throwable)instantiationException);
                throw new TaskException((Throwable)instantiationException);
            }
            return arrayList;
        }
    }
}

