/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.navigator;

import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.db.BaseConnectionNode;
import oracle.dbtools.raptor.navigator.db.IConnectionNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.onsd.OnsdBrowserResources;
import oracle.dbtools.raptor.onsd.connection.NSConnection;
import oracle.dbtools.raptor.onsd.connection.NSConnectionException;
import oracle.dbtools.raptor.onsd.connection.NSConnections;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.util.WeakCache;

public class OnsdConnection
extends BaseConnectionNode<NSConnection>
implements IConnectionNode<NSConnection> {
    private static WeakCache<String, OnsdConnection> s_cache;

    protected static WeakCache<String, OnsdConnection> getNodeCache() {
        if (s_cache == null) {
            s_cache = new WeakCache();
        }
        return s_cache;
    }

    protected static void cacheNode(String string, OnsdConnection onsdConnection) {
        WeakCache<String, OnsdConnection> weakCache = OnsdConnection.getNodeCache();
        weakCache.put((Object)string, (Object)onsdConnection);
    }

    protected static void uncacheNode(String string) {
        WeakCache<String, OnsdConnection> weakCache = OnsdConnection.getNodeCache();
        weakCache.remove((Object)string);
    }

    public static OnsdConnection findConnectionNode(URL uRL) {
        OnsdConnection onsdConnection = null;
        String string = DBURLFormatHelper.getConnectionName((URL)uRL);
        if (string != null) {
            onsdConnection = (OnsdConnection)((Object)OnsdConnection.getNodeCache().get((Object)string));
        }
        return onsdConnection;
    }

    public static OnsdConnection findOrCreateConnectionNode(URL uRL) {
        WeakCache<String, OnsdConnection> weakCache;
        OnsdConnection onsdConnection = null;
        String string = DBURLFormatHelper.getConnectionName((URL)uRL);
        if (string != null && (onsdConnection = (OnsdConnection)((Object)(weakCache = OnsdConnection.getNodeCache()).get((Object)string))) == null) {
            onsdConnection = new OnsdConnection();
            onsdConnection.setURL(uRL);
        }
        return onsdConnection;
    }

    protected final boolean openConnection() {
        return super.openConnection();
    }

    public final void reopenConnection(NSConnection nSConnection) {
        super.reopenConnection((Object)nSConnection);
    }

    protected final void forgetConnection() {
        super.forgetConnection();
    }

    protected final void closeConnection() {
        super.closeConnection();
    }

    public final boolean isConnectionOpen() {
        return super.isConnectionOpen();
    }

    public String getQualifiedConnectionName() {
        return DBURLFormatHelper.getConnectionName((URL)this.getURL());
    }

    protected NSConnection openConnectionImpl() throws IOException {
        NSConnection nSConnection = null;
        try {
            nSConnection = NSConnections.getInstance().getConnection(this.getQualifiedConnectionName(), true);
            if (nSConnection == null) {
                throw new ExceptionWrapper((Throwable)new ConnectionCanceledException());
            }
        }
        catch (NSConnectionException nSConnectionException) {
            Throwable throwable = nSConnectionException.getCause();
            if (throwable != null) {
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new ExceptionWrapper(throwable);
            }
            throw new ExceptionWrapper(nSConnectionException);
        }
        return nSConnection;
    }

    protected boolean closeConnectionImpl() {
        return NSConnections.getInstance().closeConnection(this.getQualifiedConnectionName());
    }

    public String getShortLabel() {
        return this.getQualifiedConnectionName();
    }

    public Icon getIcon() {
        if (this.isConnectionOpen()) {
            return OnsdBrowserResources.getIcon("ONSD_OPEN_ICON");
        }
        return OnsdBrowserResources.getIcon("ONSD_ICON");
    }

    public void setURL(URL uRL) {
        String string;
        boolean bl = false;
        URL uRL2 = this.getURL();
        if (uRL2 != null) {
            bl = uRL != null;
            string = DBURLFormatHelper.getConnectionName((URL)uRL2);
            if (string != null) {
                OnsdConnection.uncacheNode(string);
            }
        }
        super.setURL(uRL);
        if (uRL != null && (string = DBURLFormatHelper.getConnectionName((URL)uRL)) != null) {
            OnsdConnection.cacheNode(string, this);
        }
        if (bl) {
            UpdateMessage.fireObjectRenamed((Subject)this);
        }
    }

    public String getConnectionName() {
        return Connections.getConnectionName((String)this.getQualifiedConnectionName());
    }

    public String getStoreName() {
        return Connections.getStoreName((String)this.getQualifiedConnectionName());
    }

    public static class ExceptionWrapper
    extends IOException {
        public ExceptionWrapper(Throwable throwable) {
            this.initCause(throwable);
        }
    }
}

