/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.dbtools.raptor.onsd.connection.NSConnection;
import oracle.dbtools.raptor.onsd.jdbc.NoSQLDatabaseMetadata;
import oracle.dbtools.raptor.onsd.jdbc.NoSQLPreparedStatement;
import oracle.dbtools.raptor.onsd.jdbc.NoSQLStatement;
import oracle.dbtools.raptor.onsd.jdbc.abstractdef.AbstractConnection;

public class NoSQLConnection
extends AbstractConnection {
    private NSConnection _connection;

    public NSConnection getDelegate() {
        return this._connection;
    }

    public NoSQLConnection(NSConnection nSConnection) throws SQLException {
        try {
            this._connection = nSConnection;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new NoSQLStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return new NoSQLPreparedStatement(this, string);
    }

    @Override
    public String getSchema() throws SQLException {
        return this._connection.getConnectionInfo().getStoreName();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new NoSQLDatabaseMetadata(this);
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public void close() throws SQLException {
        if (this._connection != null) {
            this._connection = null;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._connection == null;
    }
}

