/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.resultsTable;

import java.awt.FontMetrics;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.text.DateFormat;
import java.text.Format;
import java.util.Locale;
import javax.swing.UIManager;
import oracle.bali.dbUI.db.Column;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.CheckPainter;
import oracle.bali.ewt.grid.NullInputHandler;
import oracle.bali.ewt.painter.FormatPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.share.sort.BooleanComparator;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.DateComparator;
import oracle.bali.share.sort.NumberComparator;
import oracle.bali.share.sort.StringComparator;

public class ResultsTableCustomizer {
    private static ResultsTableCustomizer _sCustomizer;

    public static ResultsTableCustomizer getResultsTableCustomizer() {
        if (_sCustomizer == null) {
            _sCustomizer = new ResultsTableCustomizer();
        }
        return _sCustomizer;
    }

    public boolean displayColumn(Column column) {
        return true;
    }

    public Painter getPainter(Column column) {
        Class type = column.getDataType();
        Painter p = null;
        if (type == Boolean.TYPE || type == Boolean.class) {
            p = CheckPainter.getPainter();
        } else if (type == java.util.Date.class) {
            p = new FormatPainter((Format)DateFormat.getDateInstance());
        } else if (type == Date.class) {
            DateFormat f = DateFormat.getDateInstance(3);
            p = new FormatPainter((Format)f);
        } else if (type == Time.class) {
            DateFormat f = DateFormat.getTimeInstance(3);
            p = new FormatPainter((Format)f);
        } else if (type == Timestamp.class) {
            DateFormat f = DateFormat.getDateTimeInstance(3, 3);
            p = new FormatPainter((Format)f);
        } else {
            p = (Painter)UIManager.get("Grid.DefaultCellPainter");
        }
        return p;
    }

    public CellInputHandler getCellInputHandler(Column column) {
        return NullInputHandler.getCellInputHandler();
    }

    public int getColumnWidth(Column column, FontMetrics metrics) {
        String name = column.getDisplayName(Locale.getDefault());
        return metrics.stringWidth(name) * 2;
    }

    public Comparator getComparator(Column column) {
        Comparator c = null;
        Class type = column.getDataType();
        if (type == Boolean.TYPE || type == Boolean.class) {
            c = BooleanComparator.getComparator();
        } else if (type == Byte.TYPE || type == Byte.class) {
            c = NumberComparator.getComparator();
        } else if (type == Short.TYPE || type == Short.class) {
            c = NumberComparator.getComparator();
        } else if (type == Integer.TYPE || type == Integer.class) {
            c = NumberComparator.getComparator();
        } else if (type == Long.TYPE || type == Long.class) {
            c = NumberComparator.getComparator();
        } else if (type == Float.TYPE || type == Float.class) {
            c = NumberComparator.getComparator();
        } else if (type == Double.TYPE || type == Double.class) {
            c = NumberComparator.getComparator();
        } else if (type == Character.TYPE || type == Character.class) {
            c = new StringComparator(Collator.getInstance());
        } else if (type == String.class) {
            c = new StringComparator(Collator.getInstance());
        } else if (type == java.util.Date.class || type == Date.class || type == Time.class || type == Timestamp.class) {
            c = DateComparator.getComparator();
        }
        return c;
    }

    protected ResultsTableCustomizer() {
    }
}

