/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import oracle.javatools.editor.language.StyledFragment;

public final class StyledFragmentsList {
    private static final boolean DEBUG = false;
    private static final int DEFAULT_LIST_SIZE = 64;
    private static final int MAXIMUM_INCREMENT = 100;
    private static final int MINIMUM_INCREMENT = 10;
    private static final float INCREMENT_RATE = 0.1f;
    private String[] tokenStyleNameList;
    private int[] tokenStartList;
    private int lastTokenEnd;
    private int numTokens;
    private int preferredSize;
    private StyledFragment cachedFragment;

    public StyledFragmentsList() {
        this(64);
    }

    public StyledFragmentsList(int preferredSize) {
        if (preferredSize < 1) {
            preferredSize = 1;
        }
        this.tokenStyleNameList = null;
        this.tokenStartList = null;
        this.lastTokenEnd = -1;
        this.numTokens = 0;
        this.preferredSize = preferredSize;
        this.cachedFragment = new StyledFragment(null, -1, -1);
        this.ensureCapacity(preferredSize);
    }

    private void ensureCapacity(int newSize) {
        int oldSize;
        int n = oldSize = this.tokenStartList == null ? 0 : this.tokenStartList.length;
        if (oldSize >= newSize) {
            return;
        }
        if (this.tokenStyleNameList != null) {
            int increment = (int)((float)newSize * 0.1f);
            increment = Math.min(100, increment);
            increment = Math.max(10, increment);
            newSize += increment;
        }
        String[] newTokenStyleNameList = null;
        int[] newTokenStartList = null;
        newTokenStyleNameList = new String[newSize];
        newTokenStartList = new int[newSize];
        if (this.numTokens > 0) {
            System.arraycopy(this.tokenStyleNameList, 0, newTokenStyleNameList, 0, oldSize);
            System.arraycopy(this.tokenStartList, 0, newTokenStartList, 0, oldSize);
        }
        this.tokenStyleNameList = newTokenStyleNameList;
        this.tokenStartList = newTokenStartList;
    }

    public void add(String styleName, int startOffset, int endOffset) {
        int lastToken = this.numTokens - 1;
        if (this.numTokens > 0 && this.lastTokenEnd != startOffset) {
            throw new IllegalStateException("Fragments not together.");
        }
        if (this.numTokens > 0 && this.tokenStyleNameList[lastToken] == styleName) {
            this.lastTokenEnd = endOffset;
            return;
        }
        this.ensureCapacity(this.numTokens + 1);
        this.tokenStyleNameList[this.numTokens] = styleName;
        this.tokenStartList[this.numTokens] = startOffset;
        this.lastTokenEnd = endOffset;
        ++this.numTokens;
    }

    public void clear() {
        this.numTokens = 0;
    }

    public int size() {
        return this.numTokens;
    }

    public StyledFragment get(int index) {
        if (index < 0 || index >= this.numTokens) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index);
        }
        this.cachedFragment.styleName = this.tokenStyleNameList[index];
        this.cachedFragment.startOffset = this.tokenStartList[index];
        this.cachedFragment.endOffset = index + 1 == this.numTokens ? this.lastTokenEnd : this.tokenStartList[index + 1];
        return this.cachedFragment;
    }
}

