/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.assembly;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.assembly.VariableLengthIntArrayFactory;

public class RunLengthEncodedIntArrayFactory
extends ObjectFactory {
    public static final RunLengthEncodedIntArrayFactory RUN_LENGTH_ENCODED_INT_ARRAY_FACTORY = new RunLengthEncodedIntArrayFactory();
    private static final byte OBJECT_CODE = -116;

    private RunLengthEncodedIntArrayFactory() {
    }

    @Override
    public byte getObjectCode() {
        return -116;
    }

    @Override
    public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
        int count;
        int len = VariableLengthIntArrayFactory.readVariableLengthInt(input);
        int[] array = new int[len];
        for (int i = 0; i < len; i += count) {
            array[i] = VariableLengthIntArrayFactory.readVariableLengthInt(input);
            count = VariableLengthIntArrayFactory.readVariableLengthInt(input);
            for (int j = 1; j < count; ++j) {
                array[i + j] = array[i];
            }
        }
        return array;
    }

    @Override
    public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
        int[] array = (int[])object;
        int len = array.length;
        VariableLengthIntArrayFactory.writeVariableLengthInt(output, len);
        if (len > 0) {
            int count = 1;
            for (int i = 1; i < len; ++i) {
                if (array[i] != array[i - 1]) {
                    VariableLengthIntArrayFactory.writeVariableLengthInt(output, array[i - 1]);
                    VariableLengthIntArrayFactory.writeVariableLengthInt(output, count);
                    count = 1;
                    continue;
                }
                ++count;
            }
            VariableLengthIntArrayFactory.writeVariableLengthInt(output, array[len - 1]);
            VariableLengthIntArrayFactory.writeVariableLengthInt(output, count);
        }
    }
}

