/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.http.auth.basic;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import oracle.dbtools.http.Client;
import oracle.dbtools.http.HttpResources;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.http.SessionType;
import oracle.dbtools.http.auth.Authentication;
import oracle.dbtools.http.auth.AuthenticationEngine;
import oracle.dbtools.http.auth.AuthenticationFailedException;
import oracle.dbtools.http.auth.basic.BasicAuthenticationHandler;
import oracle.dbtools.util.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;

public abstract class BasicAuthenticationEngine
implements AuthenticationEngine {
    private static final String GRANT_TYPE = "grant_type";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String ENCODING_UTF8 = "UTF-8";
    private Client m_client;

    protected BasicAuthenticationEngine() {
    }

    @Override
    public final void init(Client client) {
        this.m_client = client;
    }

    @Override
    public Authentication authenticate(SessionInfo conn) throws AuthenticationFailedException {
        HttpPost post = this.createPost(conn);
        HttpEntity content = this.promptForAuthentication(conn);
        post.setEntity(content);
        return this.doPost(post);
    }

    private HttpPost createPost(SessionInfo conn) throws AuthenticationFailedException {
        SessionType type = this.m_client.getConnectionType();
        URI path = type.getAuthenticationURI(conn);
        HttpPost post = new HttpPost(path);
        this.signRequest((HttpRequest)post);
        return post;
    }

    @Override
    public Authentication reauthenticate(Authentication auth, SessionInfo conn) throws AuthenticationFailedException {
        HttpPost post = this.createPost(conn);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(GRANT_TYPE, "refresh_token"));
        params.add(new BasicNameValuePair("refresh_token", auth.getRefreshToken()));
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, ENCODING_UTF8));
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthenticationFailedException(e);
        }
        return this.doPost(post);
    }

    protected abstract HttpEntity promptForAuthentication(SessionInfo var1) throws AuthenticationFailedException;

    private void signRequest(HttpRequest request) throws AuthenticationFailedException {
        SessionType type = this.m_client.getConnectionType();
        type.signRequest(request);
    }

    private Authentication doPost(HttpPost post) throws AuthenticationFailedException {
        StringBuilder sb = new StringBuilder(post.getRequestLine().toString());
        sb.append('\n').append(post.getURI().toString());
        this.log(sb.toString());
        try {
            return this.m_client.executeRequest((HttpUriRequest)post, new BasicAuthenticationHandler());
        }
        catch (AuthenticationFailedException e) {
            throw e;
        }
        catch (ClientProtocolException e) {
            throw new AuthenticationFailedException(e);
        }
        catch (UnknownHostException e) {
            throw new AuthenticationFailedException(HttpResources.format("MESSAGE_UNKNOWN_HOST", e.getMessage()));
        }
        catch (IOException e) {
            throw new AuthenticationFailedException(e);
        }
    }

    private void log(String s) {
        Logger.fine(AuthenticationEngine.class, (String)s);
    }

    protected final HttpEntity createEntity(String username, String pwdString) throws AuthenticationFailedException {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(GRANT_TYPE, PASSWORD));
        params.add(new BasicNameValuePair(USERNAME, username));
        params.add(new BasicNameValuePair(PASSWORD, pwdString));
        try {
            return new UrlEncodedFormEntity(params, ENCODING_UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthenticationFailedException(e);
        }
    }

    protected final Client getClient() {
        return this.m_client;
    }

    protected HttpEntity authenticateHeadless(SessionInfo conn) throws AuthenticationFailedException {
        String connName = conn.getName();
        String username = conn.getUsername();
        if (username == null) {
            throw new AuthenticationFailedException(HttpResources.format("ERROR_NO_USERNAME", connName));
        }
        char[] pwd = conn.getPassword();
        if (pwd == null || pwd.length == 0) {
            throw new AuthenticationFailedException(HttpResources.format("ERROR_NO_PWD", connName));
        }
        return this.createEntity(username, new String(pwd));
    }
}

