/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.model;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetProviderReference;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Workspace;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.audit.model.ContentRoot;
import oracle.jdeveloper.audit.model.ContentRootFactory;
import oracle.jdevimpl.audit.model.DefaultContentRoot;

public class ProjectContentRootFactory
implements ContentRootFactory {
    @Override
    public void getWorkspaceRoots(Workspace workspace, IntersectedFilters applicationContentFilters, IntersectedFilters auxiliaryContentFilters, Collection<ContentRoot> roots) {
    }

    @Override
    public void getProjectRoots(Workspace workspace, Project project, IntersectedFilters projectContentFilters, IntersectedFilters auxiliaryContentFilters, Collection<ContentRoot> roots) {
        ContentSetProviderReference[] refs;
        HashMap<String, String> labels = new HashMap<String, String>();
        HashSet<String> javaContentSets = new HashSet<String>();
        for (ContentSetProviderReference provider : refs = ProjectContent.getContentSetProviderReferences()) {
            labels.put(provider.key(), provider.label());
            if (!provider.canContainJavaSources()) continue;
            javaContentSets.add(provider.key());
        }
        ProjectContent content = ProjectContent.getInstance((PropertyStorage)project);
        ListStructure contents = content.getContentSetList();
        for (Object keyOrNull : contents) {
            if (keyOrNull == null) continue;
            String key = keyOrNull.toString();
            ContentSet contentSet = content.getContentSet(key);
            LinkedList<ContentSet> queue = new LinkedList<ContentSet>();
            queue.add(contentSet);
            while (!queue.isEmpty()) {
                ContentSet set = (ContentSet)queue.remove();
                PatternFilters rootFilters = set.getPatternFilters();
                for (URL url : set.getURLPath().asList()) {
                    String label = (String)labels.get(key);
                    if (label == null) {
                        int slash = key.lastIndexOf(47);
                        label = slash + 1 < key.length() ? '<' + key.substring(slash + 1) + '>' : '<' + key.substring(0, slash) + '>';
                    }
                    roots.add(new DefaultContentRoot(url, ContentRoot.PROJECT, key, label, javaContentSets.contains(key), projectContentFilters.intersectWith(rootFilters)));
                }
                int count = set.countContentSets();
                for (int n = 0; n < count; ++n) {
                    queue.add(set.getContentSet(n));
                }
            }
        }
    }
}

