/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.transform;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.vcs.VCSManager;
import oracle.javatools.buffer.GuardedTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformContext;
import oracle.jdeveloper.audit.transform.TransformSequenceContext;

public abstract class TransformAdapter {
    private List<Command> deferredCommands;
    private Region selectionRegion;
    private int selectionMargin;
    private int selectionEndMargin;
    private List<Region> highlights;
    private List<Region> removedHighlights;

    protected abstract TransformContext createContext(TransformContext.Shape var1, Transform var2, Violation var3, Location var4, URL var5, Project var6, Workspace var7);

    public TransformContext createContext(Transform transform, Violation violation, Location location) {
        return this.createContext(TransformContext.Shape.WRITE, transform, violation, location, null, null, null);
    }

    public TransformContext newReadContext(Transform transform, Violation violation, Location location) {
        return this.createContext(TransformContext.Shape.READ, transform, violation, location, null, null, null);
    }

    public TransformContext newReadContext(Transform transform, Violation violation) {
        return this.createContext(TransformContext.Shape.READ, transform, violation, violation.getLocation(), null, null, null);
    }

    public TransformContext newWriteContext(Transform transform, Violation violation, Location location) {
        return this.createContext(TransformContext.Shape.WRITE, transform, violation, location, null, null, null);
    }

    public TransformContext newWriteContext(Transform transform, Violation violation) {
        return this.createContext(TransformContext.Shape.WRITE, transform, violation, violation.getLocation(), null, null, null);
    }

    public TransformContext newWriteContext(Transform transform, Violation violation, URL pendingLocation, Project pendingProject, Workspace pendingWorkspace) {
        if (URLFileSystem.exists((URL)pendingLocation)) {
            throw new IllegalArgumentException(pendingLocation + " already exists");
        }
        return this.createContext(TransformContext.Shape.WRITE, transform, violation, null, pendingLocation, pendingProject, pendingWorkspace);
    }

    public TransformContext newCreateContext(Transform transform, Violation violation, Location location, URL pendingLocation) {
        if (URLFileSystem.exists((URL)pendingLocation)) {
            throw new IllegalArgumentException(pendingLocation + " already exists");
        }
        return this.createContext(TransformContext.Shape.CREATE, transform, violation, location, pendingLocation, location.getProject(), location.getWorkspace());
    }

    public TransformContext newCreateContext(Transform transform, Violation violation, Location location, URL pendingLocation, Project pendingProject, Workspace pendingWorkspace) {
        if (URLFileSystem.exists((URL)pendingLocation)) {
            throw new IllegalArgumentException(pendingLocation + " already exists");
        }
        return this.createContext(TransformContext.Shape.CREATE, transform, violation, location, pendingLocation, pendingProject, pendingWorkspace);
    }

    public TransformContext newDeleteContext(Transform transform, Violation violation, Location location) {
        return this.createContext(TransformContext.Shape.DELETE, transform, violation, location, null, null, null);
    }

    public TransformContext newDeleteContext(Transform transform, Violation violation) {
        return this.createContext(TransformContext.Shape.DELETE, transform, violation, violation.getLocation(), null, null, null);
    }

    public TransformContext newMoveContext(Transform transform, Violation violation, Location location, URL pendingLocation, Project pendingProject, Workspace pendingWorkspace) {
        return this.createContext(TransformContext.Shape.MOVE, transform, violation, location, pendingLocation, pendingProject, pendingWorkspace);
    }

    public TransformContext newMoveContext(Transform transform, Violation violation, Location location, URL pendingLocation) {
        return this.createContext(TransformContext.Shape.MOVE, transform, violation, location, pendingLocation, location.getProject(), location.getWorkspace());
    }

    public TransformContext newMoveContext(Transform transform, Violation violation, URL pendingLocation) {
        if (URLFileSystem.exists((URL)pendingLocation)) {
            throw new IllegalArgumentException(pendingLocation + " already exists");
        }
        Location location = violation.getLocation();
        return this.createContext(TransformContext.Shape.MOVE, transform, violation, location, pendingLocation, location.getProject(), location.getWorkspace());
    }

    public boolean isTransformable(ModelAdapter model) {
        Node node = model.getNode();
        return !node.isReadOnly() || VCSManager.getVCSManager().isVersioned(node.getURL());
    }

    public boolean isTransformable(Location location) {
        TextBuffer buffer;
        Node node = location.getModel().getNode();
        return !(node instanceof TextNode) || !((buffer = ((TextNode)node).acquireTextBuffer()) instanceof GuardedTextBuffer) || !((GuardedTextBuffer)buffer).isOffsetRangeGuarded(location.getOffset(), location.getLength());
    }

    public Boolean makeTransformable(TransformContext context) throws Exception {
        return this.makeWritable(context.getNode(), context.getProject(), context.getWorkspace());
    }

    protected Boolean makeWritable(Node node, Project project, Workspace workspace) throws Exception {
        if (node.isReadOnly()) {
            if (VCSManager.getVCSManager().isVersioned(node.getURL())) {
                MetaClass commandClass = VCSManager.getVCSManager().getMetaCheckOutCommand(node);
                Command command = CommandProcessor.createCommandFromMeta((MetaClass)commandClass, (Context)new Context(null, workspace, project, node));
                CommandProcessor.getInstance().invoke(command);
                return !node.isReadOnly();
            }
            return false;
        }
        return null;
    }

    public void beginTransformSequence(TransformSequenceContext sequenceContext) throws InterruptedException, Exception {
    }

    public abstract void beginTransform(TransformContext var1) throws InterruptedException, Exception;

    public void beginTransform(TransformContext context, TransformSequenceContext sequenceContext) throws InterruptedException, Exception {
        this.beginTransform(context);
    }

    public abstract void endTransform(TransformContext var1) throws Exception;

    public abstract void cancelTransform(TransformContext var1) throws Exception;

    public void setPredecessorApplyData(TransformContext context, Object applyData) {
        context.setPredecessorApplyData(applyData);
    }

    public void endTransformSequence(TransformSequenceContext sequenceContext) throws Exception {
    }

    public void cancelTransformSequence(TransformSequenceContext sequenceContext) throws Exception {
    }

    public void invokeLater(Command command) {
        if (this.deferredCommands == null) {
            this.deferredCommands = new ArrayList<Command>();
        }
        this.deferredCommands.add(command);
    }

    public List<Command> getDeferredCommands() {
        List result = this.deferredCommands;
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        this.deferredCommands = null;
        return result;
    }

    public void setSelection(ModelAdapter model, Object construct, int margin, int endMargin) {
        if (model == null) {
            throw new IllegalArgumentException("model null");
        }
        if (construct == null) {
            throw new IllegalArgumentException("construct null");
        }
        model.verifyReadTransaction();
        this.selectionRegion = new ConstructRegion(model, construct);
        this.selectionMargin = margin;
        this.selectionEndMargin = endMargin;
    }

    public void setSelection(Location location, int margin, int endMargin) {
        if (location == null) {
            throw new IllegalArgumentException("model null");
        }
        this.selectionRegion = new LocationRegion(location);
        this.selectionMargin = margin;
        this.selectionEndMargin = endMargin;
    }

    public Location getSelection() {
        if (this.selectionRegion == null) {
            return null;
        }
        Location location = this.selectionRegion.getLocation();
        if (this.selectionMargin != 0 || this.selectionEndMargin != 0) {
            int selectionEndOffset;
            int selectionOffset;
            int offset = location.getOffset();
            int endOffset = location.getEndOffset();
            int width = endOffset - offset;
            if (this.selectionMargin >= 0) {
                this.selectionMargin = Math.min(this.selectionMargin, width);
                selectionOffset = offset + this.selectionMargin;
            } else {
                this.selectionMargin = Math.max(this.selectionMargin, -width);
                selectionOffset = endOffset + this.selectionMargin;
            }
            if (this.selectionEndMargin >= 0) {
                this.selectionEndMargin = Math.min(this.selectionEndMargin, width);
                selectionEndOffset = endOffset - this.selectionEndMargin;
            } else {
                this.selectionEndMargin = Math.max(this.selectionEndMargin, -width);
                selectionEndOffset = offset - this.selectionEndMargin;
            }
            if (selectionEndOffset < selectionOffset) {
                selectionEndOffset = selectionOffset;
            }
            location = location.getModel().getLocation(selectionOffset, selectionEndOffset - selectionOffset);
        }
        this.selectionRegion = null;
        return location;
    }

    public void addHighlight(ModelAdapter model, Object construct) {
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        if (construct == null) {
            return;
        }
        if (this.highlights == null) {
            this.highlights = new ArrayList<Region>();
        }
        this.highlights.add(new ConstructRegion(model, construct));
    }

    public void addRemovedHighlight(ModelAdapter model, Object construct) {
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        if (construct == null) {
            return;
        }
        if (this.removedHighlights == null) {
            this.removedHighlights = new ArrayList<Region>();
        }
        this.removedHighlights.add(new ConstructRegion(model, construct));
    }

    public Collection<Location> getHighlightRegions(TransformContext context) {
        ArrayList<Location> locations = new ArrayList<Location>();
        if (this.highlights != null) {
            for (Region region : this.highlights) {
                locations.addAll(region.getLocations());
            }
        }
        if (this.removedHighlights != null) {
            for (Region region : this.removedHighlights) {
                locations.addAll(region.getLocations());
            }
        }
        this.highlights = null;
        this.removedHighlights = null;
        return locations;
    }

    public boolean equals(Object object) {
        return this.getClass() == object.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class ConstructRegion
    extends Region {
        private ModelAdapter model;
        private Object construct;
        private List<Location> locations;

        public ConstructRegion(ModelAdapter model, Object construct) {
            this.model = model;
            this.construct = construct;
        }

        @Override
        public ModelAdapter getModel() {
            return this.model;
        }

        @Override
        public Location getLocation() {
            List<Location> locations = this.getLocations();
            switch (locations.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return locations.get(0);
                }
            }
            int offset = Integer.MAX_VALUE;
            int endOffset = Integer.MIN_VALUE;
            for (Location location : locations) {
                offset = Math.min(offset, location.getOffset());
                endOffset = Math.max(endOffset, location.getEndOffset());
            }
            return this.model.getLocation(offset, endOffset - offset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Location> getLocations() {
            if (this.locations == null) {
                this.locations = new ArrayList<Location>();
                try {
                    this.model.beginRead();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return this.locations;
                }
                try {
                    if (this.construct instanceof Object[]) {
                        for (Object c : (Object[])this.construct) {
                            if (c == null) continue;
                            this.locations.add(this.model.getLocation(c));
                        }
                    } else if (this.construct instanceof List) {
                        for (Object c : (List)this.construct) {
                            if (c == null) continue;
                            this.locations.add(this.model.getLocation(c));
                        }
                    } else {
                        this.locations.add(this.model.getLocation(this.construct));
                    }
                }
                finally {
                    this.model.endRead();
                }
                this.construct = null;
            }
            return this.locations;
        }
    }

    public static class LocationRegion
    extends Region {
        private Location location;

        @Override
        public ModelAdapter getModel() {
            return this.location.getModel();
        }

        public LocationRegion(Location location) {
            this.location = location;
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        public List<Location> getLocations() {
            return Collections.singletonList(this.location);
        }
    }

    public static abstract class Region {
        public abstract ModelAdapter getModel();

        public abstract Location getLocation();

        public abstract List<Location> getLocations();
    }
}

