/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.dbtools.raptor.controls.ShuttlePanel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.ttdbobjects.TimestenElement;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.dialogs.MessageDialog;

public class PartitionTablePanel
extends BaseEditorPanel<Table> {
    private static final String NOT_DISTRIBUTED = Messages.getString("PartitionTablePanel.notDistributed");
    private static final String DISTRIBUTED_BY_DUPLICATE = Messages.getString("PartitionTablePanel.distributedByDuplicate");
    private static final String DISTRIBUTED_BY_HASH = Messages.getString("PartitionTablePanel.distributedByHash");
    private static final String DISTRIBUTED_BY_REFERENCE = Messages.getString("PartitionTablePanel.distributedByReference");
    private static final long serialVersionUID = 1L;
    private DistributedHashPanel columnSelection;
    private JPanel columnPanel;
    private DistributedReferencePanel foreignKeyPanel;
    private TimestenElement element;
    private JComboBox<String> distributedOpts;

    public PartitionTablePanel() {
        super("Distributed");
    }

    protected boolean isEditable() {
        return false;
    }

    protected void initialiseComponents() {
        Table table = (Table)this.getUpdatedObject();
        this.element = (TimestenElement)((Object)table.getProperty("TIMESTENELEMENT"));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel(Messages.getString("PartitionTablePanel.distributionMethod"));
        this.distributedOpts = new JComboBox();
        this.distributedOpts.addItem(DISTRIBUTED_BY_HASH);
        this.distributedOpts.addItem(DISTRIBUTED_BY_REFERENCE);
        this.distributedOpts.addItem(DISTRIBUTED_BY_DUPLICATE);
        jPanel.add(jLabel);
        jPanel.add(this.distributedOpts);
        this.add(jPanel, "North");
        this.columnSelection = new DistributedHashPanel();
        this.columnPanel = this.columnSelection;
        this.foreignKeyPanel = new DistributedReferencePanel();
        this.foreignKeyPanel.refreshFKValues();
        super.initialiseComponents();
        if (this.isEditing()) {
            Table table2 = (Table)this.getOriginalObject();
            TimestenElement timestenElement = (TimestenElement)((Object)table2.getProperty("TIMESTENELEMENT"));
            switch (timestenElement.getTimestenPartitionType()) {
                case HASH: {
                    this.distributedOpts.setSelectedItem(DISTRIBUTED_BY_HASH);
                    this.add(this.columnPanel, "Center");
                    this.revalidate();
                    break;
                }
                case DUPLICATE: {
                    this.distributedOpts.setSelectedItem(DISTRIBUTED_BY_DUPLICATE);
                    break;
                }
                case REFERENCE: {
                    this.distributedOpts.setSelectedItem(DISTRIBUTED_BY_REFERENCE);
                    this.add(this.foreignKeyPanel, "Center");
                    this.revalidate();
                    break;
                }
                default: {
                    this.distributedOpts.setSelectedItem(NOT_DISTRIBUTED);
                }
            }
            this.distributedOpts.setEnabled(this.element.enableDistEdition());
            this.columnPanel.setEnabled(this.element.enableDistEdition());
            this.foreignKeyPanel.setEnabled(this.element.enableDistEdition());
            for (Component component : this.foreignKeyPanel.getComponents()) {
                component.setEnabled(this.element.enableDistEdition());
            }
            this.columnSelection.setEnabled(this.element.enableDistEdition());
            for (Component component : this.columnPanel.getComponents()) {
                component.setEnabled(this.element.enableDistEdition());
            }
        } else {
            BorderLayout borderLayout = (BorderLayout)this.getLayout();
            Component component = borderLayout.getLayoutComponent("Center");
            if (component != null) {
                this.remove(component);
            }
            this.add(this.columnPanel, "Center");
            this.revalidate();
            this.distributedOpts.setSelectedItem(DISTRIBUTED_BY_HASH);
            this.element.setTimestenPartitionType(TimestenElement.TTPartitionType.HASH);
        }
        this.distributedOpts.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                BorderLayout borderLayout = (BorderLayout)PartitionTablePanel.this.getLayout();
                Component component = borderLayout.getLayoutComponent("Center");
                if (component != null) {
                    PartitionTablePanel.this.remove(component);
                }
                if (itemEvent.getItem().equals(DISTRIBUTED_BY_DUPLICATE)) {
                    PartitionTablePanel.this.element.setTimestenPartitionType(TimestenElement.TTPartitionType.DUPLICATE);
                    PartitionTablePanel.this.revalidate();
                } else if (itemEvent.getItem().equals(DISTRIBUTED_BY_HASH)) {
                    PartitionTablePanel.this.element.setTimestenPartitionType(TimestenElement.TTPartitionType.HASH);
                    PartitionTablePanel.this.add(PartitionTablePanel.this.columnPanel, "Center");
                    PartitionTablePanel.this.revalidate();
                } else if (itemEvent.getItem().equals(DISTRIBUTED_BY_REFERENCE)) {
                    if (!PartitionTablePanel.this.containsFK()) {
                        MessageDialog.error((Component)((Object)PartitionTablePanel.this), (Object)Messages.getString("PartitionTablePanel.referenceError"), (String)Messages.getString("TimesTen.common.error"), null);
                    }
                    PartitionTablePanel.this.element.setTimestenPartitionType(TimestenElement.TTPartitionType.REFERENCE);
                    PartitionTablePanel.this.add(PartitionTablePanel.this.foreignKeyPanel, "Center");
                    PartitionTablePanel.this.revalidate();
                } else if (itemEvent.getItem().equals(NOT_DISTRIBUTED)) {
                    PartitionTablePanel.this.element.setTimestenPartitionType(TimestenElement.TTPartitionType.NONE);
                    PartitionTablePanel.this.revalidate();
                }
                PartitionTablePanel.this.invalidate();
                PartitionTablePanel.this.repaint();
            }
        });
    }

    protected void initialisePanel() {
        if (this.foreignKeyPanel != null) {
            this.foreignKeyPanel.refreshFKValues();
        }
        if (this.columnSelection != null) {
            this.columnSelection.refreshHashColumns();
        }
    }

    private boolean containsFK() {
        for (Constraint constraint : ((Table)this.getUpdatedObject()).getConstraints()) {
            if (!(constraint instanceof FKConstraint)) continue;
            return true;
        }
        return false;
    }

    private class DistributedHashPanel
    extends ShuttlePanel<Column>
    implements ShuttleListener {
        public DistributedHashPanel() {
            super(null, Messages.getString("PartitionTablePanel.availableColumns"), Messages.getString("PartitionTablePanel.selectedColumns"));
        }

        public void refreshHashColumns() {
            Object object;
            Table table = (Table)PartitionTablePanel.this.getUpdatedObject();
            ArrayList<Column> arrayList = new ArrayList<Column>();
            Object object2 = new ArrayList();
            for (Column column : table.getColumns()) {
                if (PartitionTablePanel.this.element.getColumnHash().contains(column)) {
                    object2.add(column);
                    continue;
                }
                arrayList.add(column);
            }
            if (PartitionTablePanel.this.element.getColumnHash().size() == object2.size()) {
                object2.clear();
                object2.addAll(PartitionTablePanel.this.element.getColumnHash());
            } else {
                object = new ArrayList(object2.size());
                for (Column column : PartitionTablePanel.this.element.getColumnHash()) {
                    if (!object2.contains(column)) continue;
                    ((ArrayList)object).add(column);
                }
                object2 = object;
            }
            PartitionTablePanel.this.element.getColumnHash().clear();
            object = object2.iterator();
            while (object.hasNext()) {
                Column column = (Column)object.next();
                PartitionTablePanel.this.element.getColumnHash().add(column);
            }
            this.setFromList(arrayList);
            this.setToList((List)object2);
            this.getShuttle().addShuttleListener((ShuttleListener)this);
        }

        public void refreshElementColumns() {
            PartitionTablePanel.this.element.getColumnHash().clear();
            for (Object object : this.mdlTo.toArray()) {
                PartitionTablePanel.this.element.getColumnHash().add((Column)object);
            }
            PartitionTablePanel.this.element.setTimestenPartitionType(TimestenElement.TTPartitionType.HASH);
        }

        public void shuttleItemsMoved(ShuttleEvent shuttleEvent) {
            this.refreshElementColumns();
        }

        public void shuttleItemsRemoved(ShuttleEvent shuttleEvent) {
            this.refreshElementColumns();
        }

        public void shuttleItemsReordered(ShuttleEvent shuttleEvent) {
            this.refreshElementColumns();
        }
    }

    private class DistributedReferencePanel
    extends JPanel
    implements ItemListener {
        private JComboBox<FKConstraint> foreignKeyCombo;
        private JTable constraintTable;
        private ConstraintJtableModel tableModel;
        private FKConstraint currentConstraint;

        public DistributedReferencePanel() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new FlowLayout(0));
            JLabel jLabel = new JLabel(Messages.getString("TimesTen.common.FK"));
            this.foreignKeyCombo = new JComboBox();
            this.foreignKeyCombo.addItemListener(this);
            jPanel.add(jLabel);
            jPanel.add(this.foreignKeyCombo);
            this.add((Component)jPanel, "North");
            this.tableModel = new ConstraintJtableModel();
            this.constraintTable = new JTable(this.tableModel);
            this.add((Component)new JScrollPane(this.constraintTable), "Center");
        }

        @Override
        public void setEnabled(boolean bl) {
            this.foreignKeyCombo.setEnabled(bl);
            super.setEnabled(bl);
        }

        public void refreshFKValues() {
            this.foreignKeyCombo.removeAllItems();
            String string = PartitionTablePanel.this.element.getForeignKey();
            boolean bl = false;
            for (Constraint constraint : ((Table)PartitionTablePanel.this.getUpdatedObject()).getConstraints()) {
                if (!constraint.getConstraintType().equals("FKConstraint")) continue;
                this.foreignKeyCombo.addItem((FKConstraint)constraint);
                if (!constraint.getName().equals(string)) continue;
                bl = true;
            }
            if ((PartitionTablePanel.this.element.getForeignKey().equals("") || !bl) && this.foreignKeyCombo.getItemCount() > 0) {
                PartitionTablePanel.this.element.setForeignKey(this.foreignKeyCombo.getItemAt(0).getName());
                this.foreignKeyCombo.setSelectedIndex(0);
            }
            if (bl) {
                for (int i = 0; i < this.foreignKeyCombo.getItemCount(); ++i) {
                    if (!this.foreignKeyCombo.getItemAt(i).getName().equals(string)) continue;
                    this.foreignKeyCombo.setSelectedIndex(i);
                    break;
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            String string = itemEvent.getItem().toString();
            PartitionTablePanel.this.element.setForeignKey(string);
            this.currentConstraint = (FKConstraint)this.foreignKeyCombo.getSelectedItem();
            this.tableModel.fireTableDataChanged();
        }

        private class ConstraintJtableModel
        extends AbstractTableModel {
            private final String[] HEADER = new String[]{Messages.getString("PartitionTablePanel.localColumn"), Messages.getString("PartitionTablePanel.referencedColumn")};

            private ConstraintJtableModel() {
            }

            @Override
            public int getRowCount() {
                if (DistributedReferencePanel.this.currentConstraint == null) {
                    return 0;
                }
                return DistributedReferencePanel.this.currentConstraint.getColumns().length;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (DistributedReferencePanel.this.currentConstraint == null) {
                    return null;
                }
                if (n2 == 0) {
                    return DistributedReferencePanel.this.currentConstraint.getColumns()[n];
                }
                if (n2 == 1) {
                    try {
                        PKConstraint pKConstraint = (PKConstraint)DistributedReferencePanel.this.currentConstraint.getReferenceID().resolveID();
                        return pKConstraint.getColumns()[n];
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                }
                return null;
            }

            @Override
            public String getColumnName(int n) {
                return this.HEADER[n];
            }
        }
    }
}

