/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.shutdown;

import java.awt.Dimension;
import java.awt.Frame;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardListener;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.BaseTraversablePanel;
import oracle.dbtools.raptor.timesten.grid.shutdown.DataInstTraversablePanel;
import oracle.dbtools.raptor.timesten.grid.shutdown.DatabaseTraversablePanel;
import oracle.dbtools.raptor.timesten.grid.shutdown.MgmtInstTraversablePanel;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.dbtools.raptor.ui.wizard.BigWizardDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;

public class StopGridWizardMain {
    static final String DB_STATE = "DatabasesState";
    static final String INST_STATE = "InstancesState";
    static final String MGMT_STATE = "MgmtInstancesState";
    static final String DB_TRANSITION = "Database";
    static final String INST_TRANSITION = "Instances";
    static final String MGMT_TRANSITION = "Management";
    private static StopGridWizardMain INSTANCE;
    private static Logger logger;

    public static synchronized StopGridWizardMain getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StopGridWizardMain();
        }
        return INSTANCE;
    }

    public void launchWizard() {
        this.launchWizard(StopGridWizardMain.getFSM());
    }

    private static FSM getFSM() {
        Step step = new Step(Messages.getString("TimesTenGrid.databaseLoadStatus"), DatabaseTraversablePanel.class, TimesTenHelpID.GRID_SHUTDOWN_DB_LOAD_STATUS.toString());
        Step step2 = new Step(Messages.getString("TimesTenGrid.dataInstStatus"), DataInstTraversablePanel.class, TimesTenHelpID.GRID_SHUTDOWN_DATA_INSTS.toString());
        Step step3 = new Step(Messages.getString("TimesTenGrid.mgmtInstStatus"), MgmtInstTraversablePanel.class, TimesTenHelpID.GRID_SHUTDOWN_MGMT_INSTS.toString());
        FSMBuilder fSMBuilder = new FSMBuilder();
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)INST_TRANSITION, (Object)INST_STATE);
        fSMBuilder.newState((Object)INST_STATE, step2, (Object)MGMT_STATE);
        fSMBuilder.newFinalState((Object)MGMT_STATE, step3);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            logger.log(Level.SEVERE, "Could not fire stop grid wizard\n" + fSMInvalidException.getMessage());
            return null;
        }
    }

    private void launchWizard(FSM fSM) {
        Namespace namespace = new Namespace();
        FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
        BigWizardDialog bigWizardDialog = new BigWizardDialog((BaseWizard)fSMWizard, (Frame)Ide.getMainWindow());
        bigWizardDialog.setPreferredSize(new Dimension(700, 600));
        fSMWizard.setDialog((WizardDialog)bigWizardDialog);
        fSMWizard.setWizardTitle(Messages.getString("TimesTenGrid.gridStopWizard"));
        fSMWizard.addWizardListener(new WizardListener(){

            public void wizardSelectionChanged(WizardEvent wizardEvent) {
            }

            public void wizardFinished(WizardEvent wizardEvent) {
            }

            public void wizardCanceled(WizardEvent wizardEvent) {
                DefaultTraversablePanel defaultTraversablePanel = (DefaultTraversablePanel)wizardEvent.getPage().getContent();
                BaseTraversablePanel baseTraversablePanel = (BaseTraversablePanel)defaultTraversablePanel;
                baseTraversablePanel.shutdownAutoRefresh();
            }

            public void wizardApplyState(WizardEvent wizardEvent) {
            }
        });
        fSMWizard.setRoadmapVisible(true);
        WizardDialog wizardDialog = fSMWizard.getDialog((Frame)Ide.getMainWindow());
        WizardLauncher.runDialog((JDialog)wizardDialog);
    }

    static {
        logger = Logger.getLogger(StopGridWizardMain.class.getName());
    }
}

