/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.shutdown;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.json.JsonException;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.BaseTraversablePanel;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class MgmtInstTraversablePanel
extends BaseTraversablePanel {
    private static final String[] HEADER = new String[]{Messages.getString("TimesTenGrid.host"), Messages.getString("TimesTenGrid.instanceColumn"), Messages.getString("TimesTenGrid.daemonstatus"), Messages.getString("TimesTenGrid.serverstatus"), Messages.getString("TimesTenGrid.replicationStatus"), Messages.getString("TimesTenGrid.forceAction")};
    private static final long serialVersionUID = 1L;
    private List<InstanceObject> mgmtInsts = new ArrayList<InstanceObject>();
    private boolean commandExecuted = false;

    public MgmtInstTraversablePanel() {
        super(false);
        this.initGUI();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.model = new MgmtInstancesModel();
        this._objTable = new JTable(this.model){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = "";
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                string = MgmtInstTraversablePanel.this._objTable.getValueAt(n, n2).toString();
                return string;
            }
        };
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this._objTable.getTableHeader().getDefaultRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        TableColumnModel tableColumnModel = this._objTable.getColumnModel();
        tableColumnModel.getColumn(MgmtColIdx.HOST.getValue()).setCellRenderer(this.centerRenderer);
        tableColumnModel.getColumn(MgmtColIdx.INSTANCE.getValue()).setCellRenderer(this.centerRenderer);
        tableColumnModel.getColumn(MgmtColIdx.DAEMON.getValue()).setCellRenderer(new IconTextCellRenderer());
        tableColumnModel.getColumn(MgmtColIdx.SERVER.getValue()).setCellRenderer(new IconTextCellRenderer());
        tableColumnModel.getColumn(MgmtColIdx.REPLICATION.getValue()).setCellRenderer(this.centerRenderer);
        this._objTable.setRowHeight(30);
        TableColumnSizer.setColumnsWidthToFit(this._objTable, true, true);
        this.add(new JScrollPane(this._objTable), new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.dataContext = traversableContext;
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        this.mgmtInsts = this.currentGrid.getAllMgmtInstances();
        this.launchUpdater();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.refreshIntervalCmb.setSelectedIndex(0);
        this.shutdownAutoRefresh();
    }

    @Override
    protected void executeCommand() {
        try {
            Collections.sort(this.mgmtInsts, new MgmtInstComparator());
            for (InstanceObject instanceObject : this.mgmtInsts) {
                if (instanceObject.isStatusAvailable() && !instanceObject.getCSState() && !instanceObject.getDaemonStatus()) {
                    this.printMessageInPanel(MessageFormat.format(Messages.getString("TimesTenGrid.skipStopInstance"), instanceObject.getFullName()));
                    continue;
                }
                GridCommand gridCommand = GridCommand.STOP_WORKING_INSTANCE;
                String string = MessageFormat.format(Messages.getString("TimesTenGrid.stopInstanceMessage"), instanceObject.getFullName());
                if (instanceObject.forceStop()) {
                    gridCommand = GridCommand.STOP_WORKING_INSTANCE_FORCE;
                    string = MessageFormat.format(Messages.getString("TimesTenGrid.forceStopInstanceMessage"), instanceObject.getFullName());
                }
                this.worker.firePropertyChange("message", null, string);
                this.printMessageInPanel(string);
                ArrayList<GridCommandExecutor.ExecOutput> arrayList = this.currentGrid.getExecutor().execCommand(Arrays.asList(instanceObject), gridCommand, false, BaseTraversablePanel.InstanceActionPanelInstanceType.MGMT.getExecMode());
                GridCommandExecutor.ExecOutput execOutput = arrayList.get(0);
                this.printMessageInPanel(execOutput.getOutput());
                logger.info(execOutput.getOutput());
                if (execOutput.getExitCode() == 0) {
                    instanceObject.setDaemonStatus(false);
                    instanceObject.setCSState(false);
                    this.commandExecuted = true;
                    continue;
                }
                throw new GridCommandException("");
            }
            this.currentGrid.disconnect();
        }
        catch (GridCommandException gridCommandException) {
            logger.severe(gridCommandException.getMessage());
            this.printMessageInPanel(gridCommandException.getMessage());
        }
    }

    @Override
    protected void updateStatus(boolean bl) throws GridCommandException, JsonException {
        InstanceObject instanceObject = this.currentGrid.getInstance(this.currentGrid.getExecutor().getWorkingHost().getHostName(), this.currentGrid.getExecutor().getWorkingHost().getInstanceName());
        if (this.commandExecuted && instanceObject != null && instanceObject.getDaemonStatus() || !this.commandExecuted) {
            GridCommand gridCommand = GridCommand.TT_STATUS_ALL;
            this.worker.firePropertyChange("message", null, Messages.getString("TimesTenGrid.getMgmtInstStatus"));
            ArrayList<GridCommandExecutor.ExecOutput> object = this.currentGrid.getExecutor().execCommand(this.mgmtInsts, gridCommand, false, BaseTraversablePanel.InstanceActionPanelInstanceType.MGMT.getExecMode(), 5);
            for (GridCommandExecutor.ExecOutput execOutput : object) {
                execOutput.setInstanceStatus();
            }
            this.currentGrid.updateMgmInstancesModel(this.currentGrid.getExecutor().executeCommandGetJson(GridCommand.MGMT_EXAMINE, true));
        }
        this.updateLastRefresh();
        this.allRight = true;
        for (InstanceObject instanceObject2 : this.mgmtInsts) {
            if (!instanceObject2.getDaemonStatus() || !instanceObject2.getCSState()) continue;
            this.allRight = false;
            break;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateGUIComponents();
        } else {
            SwingUtilities.invokeLater(() -> this.updateGUIComponents());
        }
        if (this.allRight && bl) {
            this.printMessageInPanel(Messages.getString("TimesTenGrid.mgmtInstStopped"));
        }
    }

    private void updateGUIComponents() {
        this.enableWizardButtons();
        this.actionBtn.setEnabled(!this.allRight);
        this.model.fireTableDataChanged();
    }

    @Override
    protected void enableWizardButtons() {
        this.dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(!this.allRight), Boolean.valueOf(false), Boolean.valueOf(this.allRight));
    }

    private class MgmtInstComparator
    implements Comparator<InstanceObject> {
        private MgmtInstComparator() {
        }

        @Override
        public int compare(InstanceObject instanceObject, InstanceObject instanceObject2) {
            if (instanceObject.getType() == InstanceObject.ManagementInstanceRole.ACTIVE) {
                return 1;
            }
            if (instanceObject2.getType() == InstanceObject.ManagementInstanceRole.ACTIVE) {
                return -1;
            }
            return 0;
        }
    }

    private class IconTextCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private IconTextCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl3 = false;
            if (n2 == MgmtColIdx.DAEMON.getValue() || n2 == MgmtColIdx.SERVER.getValue()) {
                bl3 = (Boolean)object;
                if (MgmtInstTraversablePanel.this.currentGrid.getAllMgmtInstances().get(n).isStatusAvailable()) {
                    jLabel.setText(bl3 ? Messages.getString("TimesTenGrid.up") : Messages.getString("TimesTenGrid.down"));
                    jLabel.setIcon(bl3 ? Common.UP_ICON : Common.DOWN_ICON);
                } else {
                    jLabel.setText(Messages.getString("TimesTen.common.unknown"));
                    jLabel.setIcon(null);
                }
            } else {
                jLabel.setText(object.toString());
                jLabel.setIcon(null);
            }
            jLabel.setHorizontalAlignment(0);
            return jLabel;
        }
    }

    private class MgmtInstancesModel
    extends AbstractTableModel {
        private MgmtInstancesModel() {
        }

        @Override
        public int getRowCount() {
            return MgmtInstTraversablePanel.this.mgmtInsts.size();
        }

        @Override
        public int getColumnCount() {
            return HEADER.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == MgmtColIdx.HOST.getValue()) {
                return ((InstanceObject)MgmtInstTraversablePanel.this.mgmtInsts.get(n)).getHost().getName();
            }
            if (n2 == MgmtColIdx.INSTANCE.getValue()) {
                return ((InstanceObject)MgmtInstTraversablePanel.this.mgmtInsts.get(n)).getName();
            }
            if (n2 == MgmtColIdx.DAEMON.getValue()) {
                return ((InstanceObject)MgmtInstTraversablePanel.this.mgmtInsts.get(n)).getDaemonStatus();
            }
            if (n2 == MgmtColIdx.SERVER.getValue()) {
                return ((InstanceObject)MgmtInstTraversablePanel.this.mgmtInsts.get(n)).getCSState();
            }
            if (n2 == MgmtColIdx.REPLICATION.getValue()) {
                return ((InstanceObject)MgmtInstTraversablePanel.this.mgmtInsts.get(n)).getType();
            }
            if (n2 == MgmtColIdx.FORCE.getValue()) {
                return ((InstanceObject)MgmtInstTraversablePanel.this.mgmtInsts.get(n)).forceStop();
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return HEADER[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == MgmtColIdx.FORCE.getValue();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return n == MgmtColIdx.FORCE.getValue() ? Boolean.class : String.class;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == MgmtColIdx.FORCE.getValue()) {
                ((InstanceObject)MgmtInstTraversablePanel.this.mgmtInsts.get(n)).setForceStop((Boolean)object);
                this.fireTableCellUpdated(n, n2);
            }
        }
    }

    private static enum MgmtColIdx {
        HOST(0),
        INSTANCE(1),
        DAEMON(2),
        SERVER(3),
        REPLICATION(4),
        FORCE(5);

        private final int value;

        private MgmtColIdx(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

