/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.shutdown;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.json.JsonException;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.BaseTraversablePanel;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.database.DBDetailedConnectionsPanel;
import oracle.dbtools.raptor.timesten.grid.object.DatabaseObject;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class DatabaseTraversablePanel
extends BaseTraversablePanel {
    private static final String[] HEADER = new String[]{Messages.getString("TimesTenGrid.databaseColumn"), Messages.getString("TimesTen.common.status"), Messages.getString("TimesTenGrid.appConnections")};
    private boolean dbLoaded;
    private List<DatabaseObject> databases = new ArrayList<DatabaseObject>();
    private static final long serialVersionUID = 1L;

    public DatabaseTraversablePanel() {
        super(false);
        this.initGUI();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.model = new DatabasesModel();
        this._objTable = new JTable(this.model){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = "";
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                string = DatabaseTraversablePanel.this._objTable.getValueAt(n, n2).toString();
                return string;
            }
        };
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this._objTable.getTableHeader().getDefaultRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        TableColumnModel tableColumnModel = this._objTable.getColumnModel();
        tableColumnModel.getColumn(DBColIdx.DATABASE.getValue()).setCellRenderer(this.centerRenderer);
        tableColumnModel.getColumn(DBColIdx.STATUS.getValue()).setCellRenderer(this.centerRenderer);
        tableColumnModel.getColumn(DBColIdx.CONNECTIONS.getValue()).setCellRenderer(new HyperLinkCellRenderer());
        this._objTable.setRowHeight(30);
        TableColumnSizer.setColumnsWidthToFit(this._objTable, true, true);
        this._objTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    return;
                }
                int n = DatabaseTraversablePanel.this._objTable.columnAtPoint(mouseEvent.getPoint());
                if (n == DBColIdx.CONNECTIONS.getValue()) {
                    DatabaseObject databaseObject = DatabaseTraversablePanel.this.currentGrid.getDatabases().get(DatabaseTraversablePanel.this._objTable.getSelectedRow());
                    if (databaseObject == null) {
                        return;
                    }
                    DBDetailedConnectionsPanel.showDetailedConnections(databaseObject);
                }
            }
        });
        this.add(new JScrollPane(this._objTable), new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.actionBtn.setText(Messages.getString("TimesTenGrid.databaseStop"));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.dataContext = traversableContext;
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        this.databases = this.currentGrid.getDatabases();
        this.launchUpdater();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        boolean bl;
        boolean bl2 = bl = Common.loadedDBsCount(this.databases) > 0;
        if (bl && !Common.displayConfirm((Component)((Object)this), Messages.getString("TimesTenGrid.dbsNotUnloaded"), Messages.getString("TimesTenGrid.dbsNotUnloadedTitle"), null)) {
            throw new TraversalException(null);
        }
        this.refreshIntervalCmb.setSelectedIndex(0);
        this.shutdownAutoRefresh();
    }

    public Object getExitTransition() {
        return "Instances";
    }

    @Override
    protected void executeCommand() {
        for (DatabaseObject databaseObject : this.databases) {
            if (!databaseObject.getDBStatus().isLoaded() && !databaseObject.getDBStatus().isPartiallyLoaded() && !databaseObject.getDBStatus().isLoading()) continue;
            GridCommand gridCommand = GridCommand.PERL_STOP_DATABASE;
            gridCommand.prepareCommand(databaseObject.getName());
            try {
                this.worker.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.unloadingDBCommand"), databaseObject.getName()));
                this.currentGrid.getExecutor().executePerlScriptCommand(gridCommand, new OutputStream(){
                    private StringBuilder string = new StringBuilder();

                    @Override
                    public void write(int n) throws IOException {
                        SwingUtilities.invokeLater(() -> {
                            try {
                                this.string.append(Character.toString((char)n));
                                if (Character.toString((char)n).equalsIgnoreCase(DatabaseTraversablePanel.this.NEW_LINE)) {
                                    StyledDocument styledDocument = DatabaseTraversablePanel.this.outputPane.getStyledDocument();
                                    styledDocument.insertString(styledDocument.getLength(), this.string.toString(), styledDocument.getStyle("Regular"));
                                    logger.info(this.string.substring(0, this.string.length() - 1).toString());
                                    this.string.delete(0, this.string.length());
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        });
                    }
                });
            }
            catch (GridCommandException gridCommandException) {
                logger.severe(gridCommandException.getMessage());
                this.printMessageInPanel(gridCommandException.getMessage());
            }
        }
    }

    @Override
    protected void updateStatus(boolean bl) throws GridCommandException, JsonException {
        this.worker.firePropertyChange("message", null, Messages.getString("TimesTenGrid.updateDBsStatus"));
        this.currentGrid.updateDatabasesStatus();
        this.updateLastRefresh();
        for (int i = 0; this.worker.commandExecuted() && i < 60; ++i) {
            int n = Common.loadedDBsCount(this.databases);
            this.worker.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.DBsUnloadedCount"), this.databases.size() - n, this.databases.size()));
            if (n == 0) break;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                logger.warning("Interrupted while waiting to get databases status (grid->shuwdown): " + interruptedException.getMessage());
            }
            this.worker.firePropertyChange("message", null, Messages.getString("TimesTenGrid.updateDBsStatus"));
            this.currentGrid.updateDatabasesStatus();
            this.updateLastRefresh();
        }
        this.worker.firePropertyChange("message", null, Messages.getString("TimesTenGrid.updateDBsConnCount"));
        this.currentGrid.updateDatabasesConnections(true);
        this.allRight = true;
        this.dbLoaded = false;
        if (Common.loadedDBsCount(this.databases) > 0) {
            this.allRight = false;
            this.dbLoaded = true;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateGUIComponents();
        } else {
            SwingUtilities.invokeLater(() -> this.updateGUIComponents());
        }
        if (this.allRight && !this.databases.isEmpty() && bl) {
            this.printMessageInPanel(Messages.getString("TimesTenGrid.dbUnLoaded"));
        }
    }

    private void updateGUIComponents() {
        this.enableWizardButtons();
        this.actionBtn.setEnabled(this.dbLoaded);
        this.model.fireTableDataChanged();
        TableColumnSizer.setColumnsWidthToFit(this._objTable, true, true);
    }

    @Override
    protected void enableWizardButtons() {
        this.dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(this.allRight || this.actionBtnClicked), Boolean.valueOf(false));
    }

    private class HyperLinkCellRenderer
    extends DefaultTableCellRenderer {
        private HyperLinkCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Font font = jLabel.getFont();
            Map<TextAttribute, ?> map = font.getAttributes();
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            jLabel.setHorizontalAlignment(0);
            jLabel.setForeground(Color.BLUE);
            jLabel.setFont(font.deriveFont(map));
            return jLabel;
        }
    }

    private class DatabasesModel
    extends AbstractTableModel {
        private DatabasesModel() {
        }

        @Override
        public int getRowCount() {
            return DatabaseTraversablePanel.this.databases.size();
        }

        @Override
        public int getColumnCount() {
            return HEADER.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == DBColIdx.DATABASE.getValue()) {
                return ((DatabaseObject)DatabaseTraversablePanel.this.databases.get(n)).getName();
            }
            if (n2 == DBColIdx.STATUS.getValue()) {
                return ((DatabaseObject)DatabaseTraversablePanel.this.databases.get(n)).getDBStatus().getSummary();
            }
            if (n2 == DBColIdx.CONNECTIONS.getValue()) {
                return ((DatabaseObject)DatabaseTraversablePanel.this.databases.get(n)).getAppConnections();
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return HEADER[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    }

    private static enum DBColIdx {
        DATABASE(0),
        STATUS(1),
        CONNECTIONS(2);

        private final int value;

        private DBColIdx(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

