/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.shutdown;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.json.JsonException;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.BaseTraversablePanel;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class DataInstTraversablePanel
extends BaseTraversablePanel {
    private static final String[] HEADER = new String[]{Messages.getString("TimesTenGrid.host"), Messages.getString("TimesTenGrid.instanceColumn"), Messages.getString("TimesTenGrid.daemonstatus"), Messages.getString("TimesTenGrid.serverstatus"), Messages.getString("TimesTenGrid.forceAction")};
    private List<InstanceObject> dataInsts = new ArrayList<InstanceObject>();
    private static final long serialVersionUID = 1L;

    public DataInstTraversablePanel() {
        super(false);
        this.initGUI();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.model = new DataInstancesModel();
        this._objTable = new JTable(this.model){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = "";
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                string = DataInstTraversablePanel.this._objTable.getValueAt(n, n2).toString();
                return string;
            }
        };
        this._objTable.setAutoCreateRowSorter(true);
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this._objTable.getTableHeader().getDefaultRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        TableColumnModel tableColumnModel = this._objTable.getColumnModel();
        tableColumnModel.getColumn(DataColIdx.HOST.getValue()).setCellRenderer(this.centerRenderer);
        tableColumnModel.getColumn(DataColIdx.INSTANCE.getValue()).setCellRenderer(this.centerRenderer);
        tableColumnModel.getColumn(DataColIdx.DAEMON.getValue()).setCellRenderer(new IconTextCellRenderer());
        tableColumnModel.getColumn(DataColIdx.SERVER.getValue()).setCellRenderer(new IconTextCellRenderer());
        this._objTable.setRowHeight(30);
        TableColumnSizer.setColumnsWidthToFit(this._objTable, true, true);
        this.add(new JScrollPane(this._objTable), new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.dataContext = traversableContext;
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        this.dataInsts = this.currentGrid.getAllDataInstances();
        this.launchUpdater();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() != 2 && !this.allRight && !Common.displayConfirm((Component)((Object)this), Messages.getString("TimesTenGrid.dataInstNotStopped"), Messages.getString("TimesTenGrid.dataInstNotStoppedTitle"), null)) {
            throw new TraversalException(null);
        }
        this.refreshIntervalCmb.setSelectedIndex(0);
        this.shutdownAutoRefresh();
    }

    public Object getExitTransition() {
        return "Management";
    }

    @Override
    protected void executeCommand() {
        try {
            List list;
            String string;
            List list2 = this.dataInsts.stream().filter(instanceObject -> !instanceObject.isStatusAvailable() || instanceObject.isStatusAvailable() && (instanceObject.getDaemonStatus() || instanceObject.getCSState())).collect(Collectors.toList());
            if (list2.isEmpty()) {
                logger.info("All data instances are down");
                return;
            }
            List list3 = list2.stream().filter(instanceObject -> !instanceObject.forceStop()).collect(Collectors.toList());
            if (!list3.isEmpty()) {
                string = Messages.getString("TimesTenGrid.stopInstancesMessage");
                this.worker.firePropertyChange("message", null, string);
                this.printMessageInPanel(string);
                list = this.currentGrid.getExecutor().execCommand(list3, GridCommand.STOP_WORKING_INSTANCE, false, BaseTraversablePanel.InstanceActionPanelInstanceType.DATA.getExecMode());
                for (Object object : list) {
                    this.printMessageInPanel(((GridCommandExecutor.ExecOutput)object).getOutput());
                    logger.info(((GridCommandExecutor.ExecOutput)object).getOutput());
                }
            }
            if (!(list = list2.stream().filter(instanceObject -> instanceObject.forceStop()).collect(Collectors.toList())).isEmpty()) {
                Object object;
                string = Messages.getString("TimesTenGrid.forceStopInstancesMessage");
                this.worker.firePropertyChange("message", null, string);
                this.printMessageInPanel(string);
                ArrayList<GridCommandExecutor.ExecOutput> arrayList = this.currentGrid.getExecutor().execCommand(list, GridCommand.STOP_WORKING_INSTANCE_FORCE, false, BaseTraversablePanel.InstanceActionPanelInstanceType.DATA.getExecMode());
                object = arrayList.iterator();
                while (object.hasNext()) {
                    GridCommandExecutor.ExecOutput execOutput = (GridCommandExecutor.ExecOutput)object.next();
                    this.printMessageInPanel(execOutput.getOutput());
                    logger.info(execOutput.getOutput());
                }
            }
        }
        catch (GridCommandException gridCommandException) {
            this.printMessageInPanel(gridCommandException.getMessage());
            logger.severe("While stopping data instances: " + gridCommandException.getMessage());
        }
    }

    @Override
    protected void updateStatus(boolean bl) throws GridCommandException, JsonException {
        if (!this.dataInsts.isEmpty()) {
            GridCommand gridCommand = GridCommand.TT_STATUS_ALL;
            this.worker.firePropertyChange("message", null, Messages.getString("TimesTenGrid.getDataInstStatus"));
            ArrayList<GridCommandExecutor.ExecOutput> object = this.currentGrid.getExecutor().execCommand(this.dataInsts, gridCommand, false, BaseTraversablePanel.InstanceActionPanelInstanceType.DATA.getExecMode(), 5);
            for (GridCommandExecutor.ExecOutput execOutput : object) {
                execOutput.setInstanceStatus();
            }
        }
        this.updateLastRefresh();
        this.allRight = true;
        for (InstanceObject instanceObject : this.dataInsts) {
            if (!instanceObject.getDaemonStatus() || !instanceObject.getCSState()) continue;
            this.allRight = false;
            break;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateGUIComponents();
        } else {
            SwingUtilities.invokeLater(() -> this.updateGUIComponents());
        }
        if (this.allRight && !this.dataInsts.isEmpty() && bl) {
            this.printMessageInPanel(Messages.getString("TimesTenGrid.dataInstStopped"));
        }
    }

    private void updateGUIComponents() {
        this.enableWizardButtons();
        this.actionBtn.setEnabled(!this.allRight);
        this.model.fireTableDataChanged();
    }

    @Override
    protected void enableWizardButtons() {
        this.dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(this.allRight || this.actionBtnClicked), Boolean.valueOf(false));
    }

    private class IconTextCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private IconTextCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3 = DataInstTraversablePanel.this._objTable.convertRowIndexToModel(n);
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n3, n2);
            boolean bl3 = false;
            if (n2 == DataColIdx.DAEMON.getValue() || n2 == DataColIdx.SERVER.getValue()) {
                bl3 = (Boolean)object;
                if (DataInstTraversablePanel.this.currentGrid.getAllDataInstances().get(n3).isStatusAvailable()) {
                    jLabel.setText(bl3 ? Messages.getString("TimesTenGrid.up") : Messages.getString("TimesTenGrid.down"));
                    jLabel.setIcon(bl3 ? Common.UP_ICON : Common.DOWN_ICON);
                } else {
                    jLabel.setText(Messages.getString("TimesTen.common.unknown"));
                    jLabel.setIcon(null);
                }
            } else {
                jLabel.setText(object.toString());
                jLabel.setIcon(null);
            }
            jLabel.setHorizontalAlignment(0);
            return jLabel;
        }
    }

    private class DataInstancesModel
    extends AbstractTableModel {
        private DataInstancesModel() {
        }

        @Override
        public int getRowCount() {
            return DataInstTraversablePanel.this.dataInsts.size();
        }

        @Override
        public int getColumnCount() {
            return HEADER.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == DataColIdx.HOST.getValue()) {
                return ((InstanceObject)DataInstTraversablePanel.this.dataInsts.get(n)).getHost().getName();
            }
            if (n2 == DataColIdx.INSTANCE.getValue()) {
                return ((InstanceObject)DataInstTraversablePanel.this.dataInsts.get(n)).getName();
            }
            if (n2 == DataColIdx.DAEMON.getValue()) {
                return ((InstanceObject)DataInstTraversablePanel.this.dataInsts.get(n)).getDaemonStatus();
            }
            if (n2 == DataColIdx.SERVER.getValue()) {
                return ((InstanceObject)DataInstTraversablePanel.this.dataInsts.get(n)).getCSState();
            }
            if (n2 == DataColIdx.FORCE.getValue()) {
                return ((InstanceObject)DataInstTraversablePanel.this.dataInsts.get(n)).forceStop();
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return HEADER[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == DataColIdx.FORCE.getValue();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return n == DataColIdx.FORCE.getValue() ? Boolean.class : String.class;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == DataColIdx.FORCE.getValue()) {
                ((InstanceObject)DataInstTraversablePanel.this.dataInsts.get(n)).setForceStop((Boolean)object);
                this.fireTableCellUpdated(n, n2);
            }
        }
    }

    private static enum DataColIdx {
        HOST(0),
        INSTANCE(1),
        DAEMON(2),
        SERVER(3),
        FORCE(4);

        private final int value;

        private DataColIdx(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

