/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.shell.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import oracle.dbtools.raptor.timesten.grid.object.MySSHException;
import oracle.dbtools.raptor.timesten.grid.shell.SSHShellChannel;
import oracle.dbtools.raptor.timesten.grid.shell.TimestenEmulator;
import oracle.dbtools.raptor.timesten.grid.shell.buffer.CurrentScreenBuffer;
import oracle.dbtools.raptor.timesten.grid.shell.buffer.PreviousLinesBuffer;
import oracle.dbtools.raptor.timesten.grid.shell.swing.TestPanel;
import oracle.dbtools.raptor.timesten.grid.shell.swing.TimesTenShellComponent;

public class TimesTenShellPanel
extends JScrollPane {
    private static final long serialVersionUID = -3742102005846904857L;
    private String timestenHome;
    private SSHShellChannel channel;
    private TimesTenShellComponent panel;
    private TimestenEmulator emulator;
    private CurrentScreenBuffer buffer;
    private TestPanel testPanel;
    private static final Logger LOGGER = Logger.getLogger(TimesTenShellPanel.class.getName());
    private boolean firstResize = true;
    private PreviousLinesBuffer previousLinesBuffer;
    private String ttenvPath;

    public TimesTenShellPanel(String string, String string2, char[] cArray, String string3, boolean bl, String string4) {
        super(20, 31);
        this.ttenvPath = string4;
        this.timestenHome = string3;
        try {
            this.setBackground(Color.white);
            this.channel = new SSHShellChannel(string, string2, cArray);
            this.panel = new TimesTenShellComponent(this.channel);
            this.setMinimumSize(new Dimension(500, 400));
            this.previousLinesBuffer = new PreviousLinesBuffer(100);
            this.buffer = new CurrentScreenBuffer();
            this.panel.setBuffers(this.buffer, this.previousLinesBuffer);
            this.buffer.setBufferSize(this.panel.getColumns(), this.panel.getRows());
            this.emulator = new TimestenEmulator(this.panel, this.channel.getInputStream(), this.channel.getOutputStream(), this.buffer, this.previousLinesBuffer);
            this.setViewportView(this.panel);
            this.registerResizeListener();
            if (bl) {
                this.testPanel = new TestPanel(this.buffer, false);
                this.testPanel = new TestPanel(this.previousLinesBuffer, false);
            }
        }
        catch (MySSHException mySSHException) {
            mySSHException.printStackTrace();
        }
    }

    private void registerResizeListener() {
        this.addComponentListener(new ComponentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Class<TimesTenShellComponent> clazz = TimesTenShellComponent.class;
                synchronized (TimesTenShellComponent.class) {
                    Component component = (Component)componentEvent.getSource();
                    int n = Math.max(component.getWidth(), 500);
                    int n2 = Math.max(component.getHeight(), 400);
                    TimesTenShellPanel.this.panel.setTerminalSize(n - 2 * TimesTenShellPanel.this.panel.getCharWidth(), n2);
                    TimesTenShellPanel.this.buffer.resize(TimesTenShellPanel.this.panel.getColumns(), TimesTenShellPanel.this.panel.getRows());
                    TimesTenShellPanel.this.emulator.reset();
                    if (TimesTenShellPanel.this.firstResize) {
                        TimesTenShellPanel.this.firstResize = false;
                        TimesTenShellPanel.this.channel.connectToChannel();
                        if (TimesTenShellPanel.this.ttenvPath != null) {
                            TimesTenShellPanel.this.emulator.executeStatement(TimesTenShellPanel.this.ttenvPath + "\n");
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    public void executeCommand(String string) {
        this.channel.sendCommand(string);
    }

    public void requestComponentFocus() {
        this.panel.requestFocus();
        this.panel.requestFocusInWindow();
    }

    public void runOnClose(Runnable runnable) {
        this.emulator.addRunOnClose(runnable);
    }
}

