/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.navigator;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.loginspector.LogFilter;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;

public class NodeFilterPanel
extends JPanel {
    private JLabel nameLbl;
    private JComboBox<LogFilter.FilterMode> filterTypeCmb;
    private JTextField filterTxt;
    private GridObject _grid;
    private JEWTDialog _dialog;
    private static final long serialVersionUID = 1L;

    public NodeFilterPanel(GridObject gridObject) {
        this._grid = gridObject;
        this.init();
    }

    private void init() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (HostObject hostObject : NodeFilterPanel.this._grid.getHosts()) {
                    NodeFilterPanel.this._grid.getGridNode().refreshHostNode(hostObject, NodeFilterPanel.this.getFilterTxt(), NodeFilterPanel.this.getFilterType());
                }
                NodeFilterPanel.this._dialog.dispose();
            }
        };
        this.setLayout(new GridBagLayout());
        this.nameLbl = new JLabel(Messages.getString("TimesTen.common.name"));
        this.nameLbl.setName(Messages.getString("TimesTen.common.name"));
        this.filterTypeCmb = new JComboBox();
        this.filterTypeCmb.setName("filterTypeCmb");
        this.filterTxt = new JTextField();
        this.filterTxt.setName("filterTxt");
        for (LogFilter.FilterMode filterMode : LogFilter.FilterMode.values()) {
            this.filterTypeCmb.addItem(filterMode);
        }
        this.add((Component)this.nameLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.filterTypeCmb, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.filterTxt, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 24, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.filterTxt.addActionListener(abstractAction);
    }

    public void setDialog(JEWTDialog jEWTDialog) {
        this._dialog = jEWTDialog;
    }

    public String getFilterTxt() {
        return this.filterTxt.getText();
    }

    public void setFilterInfo(String string, LogFilter.FilterMode filterMode) {
        if (string.isEmpty()) {
            this.filterTxt.setText("");
            this.filterTypeCmb.setSelectedIndex(0);
        } else {
            this.filterTxt.setText(string);
            this.filterTypeCmb.setSelectedItem((Object)filterMode);
        }
    }

    public LogFilter.FilterMode getFilterType() {
        return (LogFilter.FilterMode)((Object)this.filterTypeCmb.getSelectedItem());
    }
}

