/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.instance;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.json.JsonException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.TTGUIBasePanel;
import oracle.dbtools.raptor.timesten.grid.installations.InstallationCreatePanel;
import oracle.dbtools.raptor.timesten.grid.navigator.GridMouseListener;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstallationObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.grid.object.TTGridObject;
import oracle.dbtools.raptor.timesten.utils.AutoCompleteComponent;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;

public class NewInstancePanel
extends TTGUIBasePanel {
    private JLabel _nameLabel;
    private JLabel _daemonPortLabel;
    private JLabel _csPortLabel;
    private JLabel _mgmtPortLabel;
    private JLabel _locationLabel;
    private JLabel _installLabel;
    private AutoCompleteComponent _nameTxtField;
    private AutoCompleteComponent _daemonPortTxtField;
    private AutoCompleteComponent _csPortTxtField;
    private AutoCompleteComponent _mgmtPortTxtField;
    private AutoCompleteComponent _locationTxtField;
    private boolean isStandAlone;
    private boolean management;
    private JComboBox<InstallationObject> _installComboBox;
    private JButton _newInstallationBtn;
    private HostObject host;
    private InstallationObject newInstall;
    private Runnable updateInstallationsCmb;
    private InstallationObject dummy;
    static final String CONFIRMATION_ID = "NewInstanceConfirmation";

    public NewInstancePanel() {
        this.host = this.grid.getHost(TTGridRootNode.getInstance().getCurrentHost());
        this.isStandAlone = true;
        this.management = false;
        this.initGUI(true);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, TimesTenHelpID.NEW_INSTANCE.toString());
    }

    public NewInstancePanel(HostObject hostObject, boolean bl) {
        this.host = hostObject;
        this.isStandAlone = false;
        this.management = bl;
        this.initGUI(true);
    }

    private void initGUI(boolean bl) {
        this.dummy = new InstallationObject(null, " ");
        this.dummy.setLocation("");
        this.updateInstallationsCmb = () -> {
            this._installComboBox.removeAllItems();
            this.host = this.grid.getHost(this.host.getName());
            if (this.host != null && !this.host.getInstallations().isEmpty()) {
                for (InstallationObject installationObject : this.host.getInstallations()) {
                    this._installComboBox.addItem(installationObject);
                }
            } else {
                this._installComboBox.addItem(this.dummy);
            }
            this._installComboBox.setSelectedIndex(0);
        };
        this._nameTxtField = new AutoCompleteComponent(15, InstanceObject.getInstanceNameSuggestions());
        this._daemonPortTxtField = new AutoCompleteComponent(5, InstanceObject.getInstanceDaemonPortSuggestions());
        this._csPortTxtField = new AutoCompleteComponent(5, InstanceObject.getInstanceCSPortSuggestions());
        this._locationTxtField = new AutoCompleteComponent(25, InstanceObject.getInstanceHomeSuggestions());
        this._installComboBox = new JComboBox();
        if (bl) {
            this.updateInstallationsCmb.run();
            this._newInstallationBtn = new JButton(Messages.getString("TimesTenGrid.new"));
            this._newInstallationBtn.addActionListener(actionEvent -> this.fireNewInstallation());
        }
        this._nameLabel = new JLabel(Messages.getString("TimesTenGrid.instanceNameLabel"));
        this._nameLabel.setLabelFor(this._nameTxtField);
        this._daemonPortLabel = new JLabel(Messages.getString("TimesTenGrid.daemonPortLabel"));
        this._daemonPortLabel.setLabelFor(this._daemonPortTxtField);
        this._csPortLabel = new JLabel(Messages.getString("TimesTenGrid.csPortLabel"));
        this._csPortLabel.setLabelFor(this._csPortTxtField);
        this._locationLabel = new JLabel(Messages.getString("TimesTenGrid.instLocLabel"));
        this._locationLabel.setLabelFor(this._locationTxtField);
        this._installLabel = new JLabel(Messages.getString("TimesTenGrid.installationLabel"));
        this._installLabel.setLabelFor(this._installComboBox);
        int n = 0;
        this.add((Component)this._nameLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 30, 10, 10), 0, 0));
        this.add((Component)this._nameTxtField, new GridBagConstraints(1, n++, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._locationLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 30, 10, 10), 0, 0));
        this.add((Component)this._locationTxtField, new GridBagConstraints(1, n++, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._daemonPortLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 2, new Insets(10, 30, 10, 10), 0, 0));
        this.add((Component)this._daemonPortTxtField, new GridBagConstraints(1, n++, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._csPortLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 30, 10, 10), 0, 0));
        this.add((Component)this._csPortTxtField, new GridBagConstraints(1, n++, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        if (this.management) {
            this._mgmtPortTxtField = new AutoCompleteComponent(5, InstanceObject.getInstanceMgmtPortSuggestions());
            this._mgmtPortLabel = new JLabel(Messages.getString("TimesTenGrid.mgmtPortLabel"));
            this._mgmtPortLabel.setLabelFor(this._mgmtPortTxtField);
            this.add((Component)this._mgmtPortLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 30, 10, 10), 0, 0));
            this.add((Component)this._mgmtPortTxtField, new GridBagConstraints(1, n++, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        }
        this.setDefaultInstanceInfo(this.host);
        if (this.isStandAlone) {
            this.add((Component)this._installLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 30, 10, 10), 0, 0));
            this.add(this._installComboBox, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
            if (bl) {
                this.add((Component)this._newInstallationBtn, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 22, 0, new Insets(10, 10, 10, 10), 0, 0));
            }
        }
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.instanceInformation")));
        this.setNames();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.validInput()) {
            return;
        }
        if (this.isStandAlone) {
            String string = ((InstallationObject)this._installComboBox.getSelectedItem()).getName();
            this.addNewInstance(this._nameTxtField.getText().trim(), Integer.parseInt(this._csPortTxtField.getText().trim()), Integer.parseInt(this._daemonPortTxtField.getText().trim()), this._locationTxtField.getText().trim(), string);
        }
    }

    public boolean validInput() {
        Object object;
        Object object2;
        String string = this.getName();
        if (string.isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noNameError"));
            return false;
        }
        String string2 = Common.validateName(string, Messages.getString("TimesTenGrid.instanceName"));
        if (string2 != null) {
            Common.displayErrorMsg(this, string2);
            return false;
        }
        if (this.host != null) {
            object2 = this.host.getInstances().iterator();
            while (object2.hasNext()) {
                object = (InstanceObject)object2.next();
                if (!((TTGridObject)object).getName().equalsIgnoreCase(string)) continue;
                Common.displayErrorMsg(this, MessageFormat.format(Messages.getString("TimesTenGrid.instanceExistsError"), this.host.getName()));
                return false;
            }
        }
        if (((String)(object2 = this.getInstanceLocation())).isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noInstLocError"));
            return false;
        }
        for (InstallationObject installationObject : this.host.getInstallations()) {
            if (!installationObject.getLocation().equalsIgnoreCase((String)object2)) continue;
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.sameInstDirInstallLoc"));
            return false;
        }
        if (this.newInstall != null && this.newInstall.getLocation().equalsIgnoreCase((String)object2)) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.sameInstDirInstallLoc"));
            return false;
        }
        object = this.getDaemonPort();
        int n = 0;
        if (((String)object).isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noDaemonPortError"));
            return false;
        }
        try {
            n = Integer.parseInt((String)object);
            if (!Common.validPort(n)) {
                throw new NumberFormatException();
            }
            for (HostObject object3 : this.grid.getHosts()) {
                if (!object3.getExternalAddress().equalsIgnoreCase(this.host.getExternalAddress())) continue;
                for (InstanceObject instanceObject : object3.getInstances()) {
                    if (instanceObject.getCSPort() != n && instanceObject.getDaemonPort() != n && instanceObject.getMgmtPort() != n) continue;
                    Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.invaliddPort"));
                    return false;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.invalidDaemonPortError"));
            return false;
        }
        object = this.getCSPort();
        int n2 = 0;
        if (((String)object).isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noCSPortError"));
            return false;
        }
        try {
            n2 = Integer.parseInt((String)object);
            if (!Common.validPort(n2)) {
                throw new NumberFormatException();
            }
            for (HostObject hostObject : this.grid.getHosts()) {
                if (!hostObject.getExternalAddress().equalsIgnoreCase(this.host.getExternalAddress())) continue;
                for (InstanceObject instanceObject : hostObject.getInstances()) {
                    if (instanceObject.getCSPort() != n2 && instanceObject.getDaemonPort() != n2 && instanceObject.getMgmtPort() != n2) continue;
                    Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.invalidcsPort"));
                    return false;
                }
            }
        }
        catch (NumberFormatException n3) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.invalidCSPortError"));
            return false;
        }
        int n3 = -1;
        if (this.management) {
            int n4;
            object = this.getMgmtPort();
            if (((String)object).isEmpty()) {
                Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noMgmtPortError"));
                return false;
            }
            try {
                n4 = Integer.parseInt((String)object);
                if (!Common.validPort(n4)) {
                    throw new NumberFormatException();
                }
                for (HostObject hostObject : this.grid.getHosts()) {
                    if (!hostObject.getExternalAddress().equalsIgnoreCase(this.host.getExternalAddress())) continue;
                    for (InstanceObject instanceObject : hostObject.getInstances()) {
                        if (instanceObject.getCSPort() != n4 && instanceObject.getDaemonPort() != n4 && instanceObject.getMgmtPort() != n4) continue;
                        Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.invalidMgmtPort"));
                        return false;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.invalidMgmtPortError"));
                return false;
            }
            if (n == n2 || n == n4 || n2 == n4) {
                Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.invalidSamePortDCSM"));
                return false;
            }
        } else if (n == n2) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.invalidSamePort"));
            return false;
        }
        if (this.isStandAlone && (InstallationObject)this._installComboBox.getSelectedItem() == this.dummy) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.installInvalid"));
            return false;
        }
        return true;
    }

    private void addNewInstance(final String string, final int n, final int n2, final String string2, final String string3) {
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.newInstance"), MessageFormat.format(Messages.getString("TimesTenGrid.addingNewInstance"), string, this.host.getName()), null);
        customProgressMonitor.setCancellable(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            boolean createDir;

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    GridCommand gridCommand;
                    GridMouseListener.expander.getExpansionState();
                    customProgressMonitor.start();
                    boolean bl = false;
                    if (NewInstancePanel.this.newInstall != null) {
                        boolean bl2 = bl = (InstallationObject)NewInstancePanel.this._installComboBox.getSelectedItem() == NewInstancePanel.this.newInstall;
                    }
                    if (bl) {
                        this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.createinstallationcommand"));
                        gridCommand = GridCommand.INSTALLATION_CREATE_FULL;
                        gridCommand.prepareCommand(NewInstancePanel.this.host.getName(), NewInstancePanel.this.newInstall.getLocation(), NewInstancePanel.this.newInstall.getName(), NewInstancePanel.this.newInstall.getSource());
                        NewInstancePanel.this.grid.getExecutor().executeCommandGetString(gridCommand, false);
                    }
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.checkingInstanceLoc"));
                    gridCommand = GridCommand.CHECK_REMOTE_DIR_IS_W;
                    gridCommand.prepareCommand(NewInstancePanel.this.host.getExternalAddress(), string2);
                    try {
                        NewInstancePanel.this.grid.getExecutor().executeSimpleCommand(gridCommand);
                    }
                    catch (GridCommandException gridCommandException) {
                        this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.instanceLocError"));
                        this.createDir = TTGUIBasePanel.showLocationMissingWarning(string2, NewInstancePanel.this.host.getName());
                        if (!this.createDir) {
                            this.cancel(true);
                            throw new Exception();
                        }
                        this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.creatingPath"), string2, NewInstancePanel.this.host.getExternalAddress()));
                        gridCommand = GridCommand.CREATE_REMOTE_DIR;
                        gridCommand.prepareCommand(NewInstancePanel.this.host.getExternalAddress(), string2);
                        NewInstancePanel.this.grid.getExecutor().executeSimpleCommand(gridCommand);
                    }
                    NewInstancePanel.this._dialog.dispose();
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.executeCreateInstance"), string));
                    gridCommand = GridCommand.INSTANCE_CREATE2;
                    gridCommand.prepareCommand(string, NewInstancePanel.this.host.getName(), string2, string3, String.valueOf(n2), String.valueOf(n));
                    NewInstancePanel.this.grid.getExecutor().executeCommandGetJson(gridCommand, true);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                    NewInstancePanel.this.grid.setGridComponents(NewInstancePanel.this.grid.getExecutor().executeCommandGetJson(GridCommand.EXPORT_MODEL, true), false);
                    this.firePropertyChange("progress", null, 100);
                }
                catch (JsonException | GridCommandException throwable) {
                    this.firePropertyChange("error", null, throwable.getMessage());
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                customProgressMonitor.finish();
                if (!customProgressMonitor.successfulExecution() || this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.instCreationCancelled"));
                    customProgressMonitor.finish();
                    customProgressMonitor.updateMessage(Messages.getString("TimesTenGrid.instCreationCancelled"));
                } else {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    NewInstancePanel.this.showModelNeedsApplyWarning();
                    GridMouseListener.expander.setExpansionState();
                }
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    private void fireNewInstallation() {
        InstallationCreatePanel installationCreatePanel = new InstallationCreatePanel(this.host);
        this.newInstall = new InstallationObject(null, null);
        this.newInstall.setHost(this.host);
        String string = Messages.getString("TimesTenGrid.newInstallation");
        Dimension dimension = new Dimension(500, 320);
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)installationCreatePanel, (String)string, (ActionListener)installationCreatePanel);
        installationCreatePanel.setDialog(jEWTDialog);
        jEWTDialog.setButtonMask(2);
        jEWTDialog.setSize(dimension);
        jEWTDialog.setMinimumSize(dimension);
        jEWTDialog.setDefaultCloseOperation(2);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.addCustomButton((Component)installationCreatePanel.getOkButton());
        installationCreatePanel.setInstallation(this.newInstall);
        jEWTDialog.setVisible(true);
        if (installationCreatePanel.isOkd()) {
            this.updateInstallationsCmb.run();
            this._installComboBox.addItem(this.newInstall);
            this._installComboBox.setSelectedItem(this.newInstall);
        } else {
            this.newInstall = null;
        }
    }

    public void setDefaultInstanceInfo(HostObject hostObject) {
        int n;
        int n2;
        this.host = hostObject;
        int n3 = hostObject.getInstances().size();
        this._nameTxtField.setText((this.management ? "mgmt_instance" : "instance") + (n3 != 0 ? Integer.valueOf(this.getAvailNameIndex(hostObject.getInstances())) : "1"));
        int n4 = 6625;
        for (n2 = 0; n2 < hostObject.getInstances().size(); ++n2) {
            InstanceObject instanceObject = hostObject.getInstances().get(n2);
            if (instanceObject.getCSPort() != n4 && instanceObject.getDaemonPort() != n4) continue;
            n4 += 100;
            n3 = 0;
        }
        this._csPortTxtField.setText(String.valueOf(n4));
        n2 = 6624;
        for (n = 0; n < hostObject.getInstances().size(); ++n) {
            InstanceObject instanceObject = hostObject.getInstances().get(n);
            if (instanceObject.getDaemonPort() != n2 && instanceObject.getCSPort() != n2) continue;
            n2 += 100;
            n3 = 0;
        }
        this._daemonPortTxtField.setText(String.valueOf(n2));
        if (this.management) {
            n = 3754;
            for (int i = 0; i < hostObject.getInstances().size(); ++i) {
                InstanceObject instanceObject = hostObject.getInstances().get(i);
                if (instanceObject.getDaemonPort() != n && instanceObject.getCSPort() != n && instanceObject.getMgmtPort() != n) continue;
                n += 100;
                n3 = 0;
            }
            this._mgmtPortTxtField.setText(String.valueOf(n));
        }
    }

    private int getAvailNameIndex(List<InstanceObject> list) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (InstanceObject object : list) {
            arrayList.add(object.getName());
        }
        int n = 0;
        while (!bl) {
            String string = (this.management ? "mgmt_instance" : "instance") + ++n;
            if (arrayList.contains(string)) continue;
            return n;
        }
        return 0;
    }

    @Override
    public String getName() {
        return this._nameTxtField.getText().trim();
    }

    public String getInstanceLocation() {
        return this._locationTxtField.getText().trim();
    }

    public String getCSPort() {
        return this._csPortTxtField.getText().trim();
    }

    public String getDaemonPort() {
        return this._daemonPortTxtField.getText().trim();
    }

    public String getMgmtPort() {
        return this.management ? this._mgmtPortTxtField.getText().trim() : null;
    }

    private void setNames() {
        this._nameLabel.setName(Messages.getString("TimesTenGrid.instanceNameLabel"));
        this._daemonPortLabel.setName(Messages.getString("TimesTenGrid.daemonPortLabel"));
        this._csPortLabel.setName(Messages.getString("TimesTenGrid.csPortLabel"));
        this._locationLabel.setName(Messages.getString("TimesTenGrid.instLocLabel"));
        this._installLabel.setName(Messages.getString("TimesTenGrid.installationLabel"));
        this._nameTxtField.setName("_nameTxtField", "_nameCmbBox");
        this._daemonPortTxtField.setName("_daemonPortTxtField", "_daemonPortCmbBox");
        this._csPortTxtField.setName("_csPortTxtField", "_csPortCmbBox");
        this._locationTxtField.setName("_locationTxtField", "_locationCmbBox");
        this._installComboBox.setName("_installComboBox");
        if (this._newInstallationBtn != null) {
            this._newInstallationBtn.setName(Messages.getString("TimesTenGrid.new"));
        }
        if (this.management) {
            this._mgmtPortLabel.setName(Messages.getString("TimesTenGrid.mgmtPortLabel"));
            this._mgmtPortTxtField.setName("_mgmtPortTxtField", "_mgmtPortCmbBox");
        }
    }
}

