/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.editors;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.object.RepositoryObject;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;

public class RepositoryBackupInstancesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ArrayList<RepositoryObject.InstanceInfo> tableData;
    private final String[] HEADER = new String[]{Messages.getString("TimesTenGrid.element"), Messages.getString("TimesTen.common.hostName"), Messages.getString("TimesTenGrid.instanceName"), Messages.getString("TimesTen.common.state")};
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private InstanceInfoTableModel _model;
    private JTable _table;
    private JScrollPane _scrollPane;

    public RepositoryBackupInstancesPanel() {
        this.tableData = new ArrayList();
        this.initGUI();
    }

    public void initGUI() {
        this.setLayout(new GridBagLayout());
        this._model = new InstanceInfoTableModel();
        this._table = new JTable(this._model);
        this._table.setAutoResizeMode(0);
        this._table.setRowSelectionAllowed(false);
        this._table.setColumnSelectionAllowed(false);
        this._table.setAutoCreateRowSorter(true);
        this._scrollPane = new JScrollPane(this._table);
        this.add((Component)this._scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
    }

    public void update(RepositoryObject.Backup backup) {
        this.tableData.clear();
        this.tableData.addAll(Arrays.asList(backup.getInstances()));
        Collections.sort(this.tableData);
        TableColumnSizer.setColumnsWidthToFit(this._table, true, true);
    }

    private class InstanceInfoTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private InstanceInfoTableModel() {
        }

        @Override
        public int getRowCount() {
            return RepositoryBackupInstancesPanel.this.tableData.size();
        }

        @Override
        public int getColumnCount() {
            return RepositoryBackupInstancesPanel.this.HEADER.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == ColIdx.ELEMENTID.ordinal()) {
                return ((RepositoryObject.InstanceInfo)RepositoryBackupInstancesPanel.this.tableData.get(n)).getElementNo();
            }
            if (n2 == ColIdx.INSTANCE.ordinal()) {
                return ((RepositoryObject.InstanceInfo)RepositoryBackupInstancesPanel.this.tableData.get(n)).getInstanceName();
            }
            if (n2 == ColIdx.HOST.ordinal()) {
                return ((RepositoryObject.InstanceInfo)RepositoryBackupInstancesPanel.this.tableData.get(n)).getHostName();
            }
            if (n2 == ColIdx.STATE.ordinal()) {
                return ((RepositoryObject.InstanceInfo)RepositoryBackupInstancesPanel.this.tableData.get(n)).getState();
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return RepositoryBackupInstancesPanel.this.HEADER[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    static enum ColIdx {
        ELEMENTID,
        HOST,
        INSTANCE,
        STATE;

    }
}

