/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.editors;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.editors.HostInstallationsPanel;
import oracle.dbtools.raptor.timesten.grid.editors.HostInstancesPanel;
import oracle.dbtools.raptor.timesten.grid.editors.HostSummaryPanel;
import oracle.dbtools.raptor.timesten.grid.editors.TTBaseEditor;
import oracle.dbtools.raptor.timesten.grid.navigator.AbstractNode;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;

public class HostEditor
extends TTBaseEditor
implements Controller {
    private HostSummaryPanel _summaryPanel;
    private HostInstancesPanel _instancesPanel;
    private HostInstallationsPanel _installationsPanel;
    private HostObject currentHost = null;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public HostEditor() {
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        if (!this.initialized) {
            this._summaryPanel = new HostSummaryPanel();
            this._instancesPanel = new HostInstancesPanel();
            this._installationsPanel = new HostInstallationsPanel();
            this._tabbedPane.addTab(Messages.getString("TimesTenGrid.summary"), this._summaryPanel);
            this._tabbedPane.addTab(Messages.getString("TimesTenGrid.installations"), this._installationsPanel);
            this._tabbedPane.addTab(Messages.getString("TimesTenGrid.instances"), this._instancesPanel);
            this.helpInfo = new HelpInfo(TimesTenHelpID.HOST_EDITOR.toString());
            this.initialized = true;
        }
    }

    @Override
    public void updateContent() {
        this.currentHost = this.currentGrid.getHost(TTGridRootNode.getInstance().getCurrentHost());
        ((AbstractNode)this.context.getNode()).setShortLabel(this.currentHost.getName());
        this._summaryPanel.updateHostInfo(this.currentHost);
        this._instancesPanel.updateHostInfo(this.currentHost);
        this._installationsPanel.updateHostInfo(this.currentHost);
    }

    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == REFRESH_ID) {
            this.refreshInfo();
            return true;
        }
        return false;
    }

    private void refreshInfo() {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){
            StringBuilder errorMessage;
            {
                this.errorMessage = new StringBuilder("");
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected Void doWork() throws TaskException {
                JsonObject jsonObject = null;
                try {
                    jsonObject = HostEditor.this.currentGrid.getSynchronizedWithModel(true);
                    if (!HostEditor.this.currentGrid.updateHostModel(jsonObject, HostEditor.this.currentHost.getName())) {
                        throw new GridCommandException(Messages.getString("TimesTenGrid.hostNotExistent"));
                    }
                }
                catch (JsonException | GridCommandException throwable) {
                    this.errorMessage.append(throwable.getMessage());
                    for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
                        if (!(editor instanceof HostEditor)) continue;
                        List<Editor> list = Arrays.asList(editor);
                        if (!SwingUtilities.isEventDispatchThread()) {
                            try {
                                SwingUtilities.invokeAndWait(() -> EditorManager.getEditorManager().closeEditors(list));
                            }
                            catch (InterruptedException | InvocationTargetException exception) {
                                HostEditor.this.logger.log(Level.SEVERE, exception.getMessage());
                            }
                            break;
                        }
                        EditorManager.getEditorManager().closeEditors(list);
                        break;
                    }
                }
                if (!this.errorMessage.toString().isEmpty()) {
                    HostEditor.this.logger.log(Level.SEVERE, this.errorMessage.toString());
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), this.errorMessage.toString());
                    return null;
                }
                HostEditor.this.currentHost = HostEditor.this.currentGrid.getHost(HostEditor.this.currentHost.getName());
                HostEditor.this._summaryPanel.updateHostInfo(HostEditor.this.currentHost);
                HostEditor.this._instancesPanel.updateHostInfo(HostEditor.this.currentHost);
                HostEditor.this._installationsPanel.updateHostInfo(HostEditor.this.currentHost);
                return null;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(MessageFormat.format(Messages.getString("TimesTenGrid.updateHostInfoTask"), this.currentHost.getName()));
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }
}

