/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.database.AttributesDefinitionPanel;
import oracle.dbtools.raptor.timesten.grid.database.DBDefAttribute;
import oracle.dbtools.raptor.timesten.grid.database.DatabaseSummaryPanel;
import oracle.dbtools.raptor.timesten.grid.editors.TTBaseEditor;
import oracle.dbtools.raptor.timesten.grid.navigator.AbstractNode;
import oracle.dbtools.raptor.timesten.grid.object.DatabaseObject;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.topology.TopologyPanel;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;

public class DatabaseEditor
extends TTBaseEditor {
    private DatabaseSummaryPanel _summaryPanel;
    private AttributesDefinitionPanel _attributePanel;
    private TopologyPanel _topologyPanel;
    private DatabaseObject currentDB = null;
    private static boolean dbNotCreated = false;
    private static final Logger logger = Logger.getLogger(DatabaseEditor.class.getName());

    public DatabaseEditor() {
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        if (!this.initialized) {
            this._summaryPanel = new DatabaseSummaryPanel();
            this._attributePanel = new AttributesDefinitionPanel(true, false, null, this.currentGrid);
            this._attributePanel.setAutoresizeTableOff();
            this._topologyPanel = new TopologyPanel(null, true);
            this._tabbedPane.addTab(Messages.getString("TimesTen.common.status"), this._summaryPanel);
            this._tabbedPane.addTab(Messages.getString("TimesTenGrid.dbDef"), this._attributePanel);
            this._tabbedPane.addTab(Messages.getString("TimesTenGrid.dbTop"), (Component)((Object)this._topologyPanel));
            this.helpInfo = new HelpInfo(TimesTenHelpID.DB_EDITOR.toString());
            this.initialized = true;
        }
    }

    @Override
    public void updateContent() {
        this.currentDB = this.currentGrid.getDatabase(this.context.getNode().getShortLabel());
        ((AbstractNode)this.context.getNode()).setShortLabel(this.currentDB.getName());
        if (!this.currentDB.isStatusAvailable() || this.currentDB.isAllInstanceStatusUnknown()) {
            this.refreshInfo(this::viewTabs);
        } else {
            this.viewTabs();
        }
    }

    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == REFRESH_ID) {
            this.currentDB = this.currentGrid.getDatabase(context.getNode().getShortLabel());
            if (this.currentDB == null) {
                this.close();
            }
            this.refreshInfo(this::viewTabs);
            return true;
        }
        return false;
    }

    public void refreshInfo(final Runnable runnable) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){
            StringBuilder errorMessage;
            {
                super(string, bl, iRaptorTaskRunMode);
                this.errorMessage = new StringBuilder("");
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected Void doWork() throws TaskException {
                JsonObject jsonObject = null;
                GridCommandExecutor gridCommandExecutor = DatabaseEditor.this.currentGrid.getExecutor();
                try {
                    GridCommand gridCommand = GridCommand.EXPORT_MODEL;
                    jsonObject = gridCommandExecutor.executeCommandGetJson(gridCommand, true);
                    DatabaseEditor.this.currentGrid.setGridComponents(jsonObject, false);
                    DatabaseEditor.this.currentGrid.getGridCurrentModel().setGridComponents(gridCommandExecutor.executeCommandGetJson(GridCommand.EXPORT_CURRENTMODEL, true), false);
                    DatabaseEditor.this.currentGrid.getGridCurrentModel().diff(DatabaseEditor.this.currentGrid);
                    if (!DatabaseEditor.this.currentGrid.updateDatabase(jsonObject, DatabaseEditor.this.currentDB.getName())) {
                        throw new GridCommandException(Messages.getString("TimesTenGrid.dbNotExistent"));
                    }
                    DatabaseEditor.this.asyncUpdate(false);
                    DatabaseEditor.this.currentGrid.updateDatabasesStatus(null);
                    DatabaseEditor.this.asyncUpdate(true);
                    gridCommand = GridCommand.TT_STATUS_DB;
                    gridCommand.prepareCommand(DatabaseEditor.this.currentDB.getName());
                    ArrayList arrayList = new ArrayList();
                    DatabaseEditor.this.currentGrid.getHosts().forEach(hostObject -> arrayList.addAll(hostObject.getAppliedDataInstances()));
                    ArrayList<GridCommandExecutor.ExecOutput> arrayList2 = gridCommandExecutor.execCommand(arrayList, gridCommand, false, GridCommand.ExecMode.DATA);
                    for (GridCommandExecutor.ExecOutput execOutput : arrayList2) {
                        execOutput.setInstanceStatus();
                    }
                    DatabaseEditor.this.asyncUpdate(true);
                    DatabaseEditor.this.currentGrid.updateDatabasesConnections(true);
                }
                catch (JsonException | GridCommandException throwable) {
                    logger.severe(throwable.getMessage());
                    this.errorMessage.append(throwable.getMessage());
                    if (throwable.getMessage().contains("Database not found")) {
                        this.errorMessage.setLength(0);
                        this.errorMessage.append(MessageFormat.format(Messages.getString("TimesTenGrid.dbNotCreated"), DatabaseEditor.this.currentDB.getName()));
                        dbNotCreated = true;
                    }
                    for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
                        if (!(editor instanceof DatabaseEditor)) continue;
                        final List<Editor> list = Arrays.asList(editor);
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    EditorManager.getEditorManager().closeEditors(list);
                                }
                            });
                        }
                        catch (InterruptedException | InvocationTargetException exception) {}
                        break;
                    }
                }
                if (this.errorMessage.toString().isEmpty()) {
                    runnable.run();
                    return null;
                }
                if (dbNotCreated) {
                    Common.displayInfoMsg((Component)Ide.getMainWindow(), this.errorMessage.toString(), Messages.getString("TimesTenGrid.dbNotCreatedTitle"));
                    return null;
                }
                Common.displayErrorMsg((Component)Ide.getMainWindow(), this.errorMessage.toString());
                return null;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(MessageFormat.format(Messages.getString("TimesTenGrid.updateDBInfoTask"), this.currentDB.getName()));
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void updateSubComponents(boolean bl) {
        List<DBDefAttribute> list = this.currentGrid.getShowingVersion() == GridObject.ModelVersion.LATEST ? this.currentGrid.getDatabase(this.context.getNode().getShortLabel()).getDBDef().getAttributes() : this.currentGrid.getGridCurrentModel().getDatabase(this.context.getNode().getShortLabel()).getDBDef().getAttributes();
        this._summaryPanel.update(this.currentDB, bl);
        this._attributePanel.update(list);
        this._topologyPanel.updateDraw();
    }

    private void viewTabs() {
        this.currentDB = this.currentGrid.getDatabase(this.context.getNode().getShortLabel());
        this._topologyPanel.setDistributionMap(this.currentDB.getDistributionMap(), "");
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateSubComponents(true);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> this.updateSubComponents(true));
            }
            catch (InterruptedException | InvocationTargetException exception) {
                logger.log(Level.INFO, exception.getMessage());
            }
        }
    }

    private void asyncUpdate(boolean bl) {
        this.currentDB = this.currentGrid.getDatabase(this.context.getNode().getShortLabel());
        this._topologyPanel.setDistributionMap(this.currentDB.getDistributionMap(), "");
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateSubComponents(bl);
        } else {
            SwingUtilities.invokeLater(() -> this.updateSubComponents(bl));
        }
    }
}

