/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Scanner;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.TTGUIBasePanel;
import oracle.dbtools.raptor.timesten.grid.navigator.GridMouseListener;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.utils.AutoCompleteComponent;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class RegisterClientServerDSN
extends TTGUIBasePanel {
    private File selectedFile;
    private File tempFile;
    private boolean export;
    private boolean windows;
    private boolean validFile = false;
    private String OS = null;
    Vector<String> dsnTokens = new Vector();
    Vector<Boolean> dsnSelected = new Vector();
    private JPanel _exportPanel;
    private JPanel _installPanel;
    private JTable installDSNTable;
    private JLabel _fileLabel;
    private AutoCompleteComponent _fileTxtField;
    private JButton _customButton;
    private JButton _browseButton;
    private JButton _checkButton;
    private JButton _uncheckButton;
    private exportDSNModel model = new exportDSNModel();
    static final String CONFIRMATION_ID = "InstallDSNconfirmation";
    private static final String[] COLUMNS_DSN = new String[]{"Selector", "DSN"};

    private String getOsName() {
        this.OS = System.getProperty("os.name");
        return this.OS;
    }

    private boolean isWindows() {
        return this.getOsName().startsWith("Windows");
    }

    public RegisterClientServerDSN(boolean bl) {
        this.export = bl;
        this.windows = this.isWindows();
        this.dsnTokens.clear();
        this.dsnSelected.clear();
        this.installDSNTable = new JTable(this.model);
        this.installDSNTable.getColumnModel().getColumn(0).setMaxWidth(50);
        this.installDSNTable.setAutoResizeMode(3);
        if (bl) {
            this.getDSNparameters();
        }
        this.initGUI();
    }

    private void initGUI() {
        this._fileTxtField = new AutoCompleteComponent(25, TTGridRootNode.getStorage().getSuggestion("LOCAL_PATH"));
        this._browseButton = new JButton(Messages.getString("TimesTenGrid.browse"));
        this._browseButton.addActionListener(this);
        this._checkButton = new JButton(Messages.getString("TimesTenGrid.checkDSN"));
        this._checkButton.addActionListener(this);
        this._uncheckButton = new JButton(Messages.getString("TimesTenGrid.uncheckDSN"));
        this._uncheckButton.addActionListener(this);
        this._fileLabel = new JLabel();
        this._fileLabel.setLabelFor(this._fileTxtField);
        this._installPanel = new JPanel(new GridBagLayout());
        this._installPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.installDSNTitle")));
        this._installPanel.add((Component)this._checkButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 25, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._installPanel.add((Component)this._uncheckButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 25, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._installPanel.add((Component)new JScrollPane(this.installDSNTable), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 25, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._exportPanel = new JPanel(new GridBagLayout());
        if (this.export) {
            this._fileLabel.setText(Messages.getString("TimesTenGrid.fileToExport"));
            this._exportPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.exportDSNTitle")));
            this._customButton = new JButton(Messages.getString("TimesTenGrid.exportDSN"));
        } else {
            this._fileLabel.setText(Messages.getString("TimesTenGrid.fileToImport"));
            this._exportPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.importDSNTitle")));
            this._customButton = new JButton(Messages.getString("TimesTenGrid.okInstallDSN"));
            this.add((Component)this._installPanel, new GridBagConstraints(0, 3, 3, 2, 1.0, 1.0, 23, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
        this._customButton.addActionListener(this);
        this._exportPanel.add((Component)this._fileLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 25, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._exportPanel.add((Component)this._fileTxtField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 25, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._exportPanel.add((Component)this._browseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 25, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._exportPanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._fileTxtField.requestFocus();
    }

    public JButton getCustomButton() {
        return this._customButton;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._customButton) {
            if (this.export && this.validFile) {
                String string = this._fileTxtField.getText().trim();
                if (string.isEmpty()) {
                    Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noFile"));
                    return;
                }
                this.selectedFile = new File(string);
                this.makeExportCall();
                if (!this.windows) return;
                if (MessageDialog.getPersistence().getConfirmed(CONFIRMATION_ID) != null) {
                    return;
                }
                if (!Common.displayOptionalConfirm(CONFIRMATION_ID, null, MessageFormat.format(Messages.getString("TimesTenGrid.registerDSNprompt"), this.getDSNs(this.dsnTokens)), Messages.getString("TimesTenGrid.registerDSNTitle"), null)) {
                    this._dialog.dispose();
                    return;
                } else {
                    this.installDSN();
                }
                return;
            } else {
                if (!this.validFile) return;
                this.installDSN();
            }
            return;
        } else if (actionEvent.getSource() == this._browseButton) {
            String string = TTGridRootNode.getInstance().getCurrentDirectory();
            JFileChooser jFileChooser = new JFileChooser(string);
            jFileChooser.setDialogTitle(Messages.getString("TimesTenGrid.exportDSNTitle"));
            jFileChooser.setFileSelectionMode(2);
            int n = this.export ? jFileChooser.showSaveDialog((Component)Ide.getMainWindow()) : jFileChooser.showDialog((Component)Ide.getMainWindow(), "Choose");
            if (n != 0) return;
            TTGridRootNode.getInstance().setCurrentDirectory(jFileChooser.getCurrentDirectory().getAbsolutePath());
            TTGridRootNode.getStorage().saveSuggestion("LOCAL_PATH", jFileChooser.getCurrentDirectory().getAbsolutePath());
            this.selectedFile = jFileChooser.getSelectedFile();
            this._fileTxtField.setText(this.selectedFile.getAbsolutePath());
            this.validFile = true;
            if (this.export) return;
            this.makeImportCall();
            return;
        } else if (actionEvent.getSource() == this._checkButton) {
            for (int i = 0; i < this.dsnSelected.size(); ++i) {
                this.dsnSelected.set(i, true);
            }
            this.model.fireTableDataChanged();
            return;
        } else {
            if (actionEvent.getSource() != this._uncheckButton) return;
            for (int i = 0; i < this.dsnSelected.size(); ++i) {
                this.dsnSelected.set(i, false);
            }
            this.model.fireTableDataChanged();
        }
    }

    public String getDSNs(Vector<String> vector) {
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            string = string + "\n- " + vector.get(i);
        }
        return string;
    }

    private void getDSNparameters() {
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.getClientServerDSN"), Messages.getString("TimesTenGrid.gettingClientServerDSN"), null);
        customProgressMonitor.setCancellable(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void doInBackground() throws Exception {
                GridCommand gridCommand = null;
                String string = null;
                try {
                    customProgressMonitor.start();
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.executeTNSNamesExport"));
                    gridCommand = GridCommand.EXPORT_DSN;
                    gridCommand.prepareCommand("");
                    string = RegisterClientServerDSN.this.grid.getExecutor().executeCommandGetString(gridCommand, true);
                }
                catch (GridCommandException gridCommandException) {
                    this.firePropertyChange("error", null, gridCommandException.getMessage());
                    this.cancel(true);
                }
                try (BufferedWriter bufferedWriter = null;){
                    RegisterClientServerDSN.this.tempFile = File.createTempFile("sys.odbc", "ini");
                    bufferedWriter = new BufferedWriter(new FileWriter(RegisterClientServerDSN.this.tempFile));
                    bufferedWriter.write(string);
                }
                Pattern pattern = Pattern.compile("\\[(.*?)\\]");
                Matcher matcher = pattern.matcher(string);
                matcher.find();
                while (matcher.find()) {
                    RegisterClientServerDSN.this.dsnTokens.addElement(matcher.group(1));
                    RegisterClientServerDSN.this.dsnSelected.addElement(true);
                }
                this.firePropertyChange("progress", 0, 100);
                return null;
            }

            @Override
            protected void done() {
                customProgressMonitor.finish();
                if (!customProgressMonitor.successfulExecution() || this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.TNSNamesExportCancelled"));
                } else {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    RegisterClientServerDSN.this.model.fireTableDataChanged();
                    customProgressMonitor.close();
                }
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    private void installDSN() {
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.installClientServerDSN"), Messages.getString("TimesTenGrid.installingClientServerDSN"), null);
        customProgressMonitor.setCancellable(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    customProgressMonitor.start();
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.executeTNSNamesinstall"));
                    String string = RegisterClientServerDSN.this.selectedFile.getAbsolutePath().replace("\\", "/");
                    String string2 = "cmd /C ttinstalldsn -f ";
                    string2 = string2 + string + " ";
                    for (int i = 0; i < RegisterClientServerDSN.this.dsnSelected.size(); ++i) {
                        if (!RegisterClientServerDSN.this.dsnSelected.get(i).booleanValue()) continue;
                        string2 = string2 + RegisterClientServerDSN.this.dsnTokens.get(i) + " ";
                    }
                    string2.trim();
                    Process process = Runtime.getRuntime().exec(string2);
                }
                catch (IOException iOException) {
                    this.firePropertyChange("error", null, iOException.getMessage());
                    this.cancel(true);
                }
                this.firePropertyChange("progress", 0, 100);
                return null;
            }

            @Override
            protected void done() {
                customProgressMonitor.finish();
                if (!customProgressMonitor.successfulExecution() || this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.TNSNamesInstallCancelled"));
                } else {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.successfulClientServerDSNInstall"));
                    RegisterClientServerDSN.this.model.fireTableDataChanged();
                    customProgressMonitor.close();
                }
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    private void makeImportCall() {
        String string = null;
        Scanner scanner = null;
        try {
            scanner = new Scanner(this.selectedFile);
            string = scanner.useDelimiter("\\Z").next();
            scanner.close();
            Pattern pattern = Pattern.compile("\\[(.*?)\\]");
            Matcher matcher = pattern.matcher(string);
            matcher.find();
            while (matcher.find()) {
                this.dsnTokens.addElement(matcher.group(1));
                this.dsnSelected.addElement(true);
            }
            this.model.fireTableDataChanged();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    private void makeExportCall() {
        String string = "";
        String string2 = "";
        String string3 = "";
        GridCommand gridCommand = null;
        gridCommand = GridCommand.EXPORT_DSN;
        gridCommand.prepareCommand("");
        string = Messages.getString("TimesTenGrid.exportingClientServerDSN");
        string2 = Messages.getString("TimesTenGrid.successfulClientServerDSNExport");
        string3 = Messages.getString("TimesTenGrid.clientServerDSNExportCancelled");
        this.export(gridCommand, string, string2, string3);
    }

    private void export(final GridCommand gridCommand, final String string, final String string2, final String string3) {
        this._progressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), string, Messages.getString("TimesTen.common.pleaseWait"), null);
        this._progressMonitor.setCancellable(true);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                RegisterClientServerDSN.this._progressMonitor.start();
                GridMouseListener.expander.getExpansionState();
                try {
                    FileWriter fileWriter = new FileWriter(RegisterClientServerDSN.this.selectedFile);
                    this.firePropertyChange("message", null, string);
                    fileWriter.write(RegisterClientServerDSN.this.grid.getExecutor().executeCommandGetString(gridCommand, true));
                    fileWriter.close();
                    this.firePropertyChange("message", null, string2);
                    this.firePropertyChange("progress", null, 100);
                }
                catch (IOException | GridCommandException exception) {
                    this.firePropertyChange("error", null, exception.getMessage());
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                if (this.isCancelled()) {
                    RegisterClientServerDSN.this.grid.getExecutor().stopCurrentExecution();
                    this.firePropertyChange("message", null, string3);
                    RegisterClientServerDSN.this._progressMonitor.finish();
                    RegisterClientServerDSN.this._progressMonitor.updateMessage(string3);
                } else {
                    GridMouseListener.expander.setExpansionState();
                    RegisterClientServerDSN.this._progressMonitor.close();
                }
            }
        };
        swingWorker.addPropertyChangeListener(this._progressMonitor);
        this._progressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    class exportDSNModel
    extends AbstractTableModel {
        exportDSNModel() {
        }

        @Override
        public int getRowCount() {
            return RegisterClientServerDSN.this.dsnTokens.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMNS_DSN.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == dsnTableIdx.INSTALL.getValue()) {
                return RegisterClientServerDSN.this.dsnSelected.get(n);
            }
            if (n2 == dsnTableIdx.DSN.getValue()) {
                return RegisterClientServerDSN.this.dsnTokens.get(n);
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == dsnTableIdx.INSTALL.getValue()) {
                RegisterClientServerDSN.this.dsnSelected.set(n, RegisterClientServerDSN.this.dsnSelected.get(n) == false);
            }
            super.setValueAt(object, n, n2);
        }

        @Override
        public String getColumnName(int n) {
            return COLUMNS_DSN[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == dsnTableIdx.INSTALL.getValue();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    private static enum dsnTableIdx {
        INSTALL(0),
        DSN(1);

        private final int value;

        private dsnTableIdx(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

