/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CreateGridTask;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.FirstStepPanel;
import oracle.dbtools.raptor.timesten.grid.SSHChannel;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstallationObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.grid.object.InvalidInputException;
import oracle.dbtools.raptor.timesten.grid.object.MySSHException;
import oracle.dbtools.raptor.timesten.utils.AutoCompleteComponent;
import oracle.ide.Ide;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.javatools.dialogs.MessageDialog;

public class GridMgmtInfoPanel
extends FirstStepPanel
implements FocusListener,
ActionListener,
ItemListener {
    private JPanel _mgmtInstPanel;
    private JPanel _hostPanel;
    private JPanel _instPanel;
    private JPanel _installPanel;
    private JPanel _mainPanel;
    private JLabel _nameLabel;
    private JLabel _hostLabel;
    private JLabel _extAddressLabel;
    private JLabel _intAddressLabel;
    private JLabel _daemonPortLabel;
    private JLabel _csPortLabel;
    private JLabel _mgmtPortLabel;
    private JLabel _locationLabel;
    private JLabel _swLocationLabel;
    private JLabel _installLocationLabel;
    private JLabel _ttGroupLabel;
    private AutoCompleteComponent _nameTxtField;
    private AutoCompleteComponent _hostTxtField;
    private AutoCompleteComponent _extAddressTxtField;
    private AutoCompleteComponent _intAddressTxtField;
    private AutoCompleteComponent _daemonPortTxtField;
    private AutoCompleteComponent _csPortTxtField;
    private AutoCompleteComponent _mgmtPortTxtField;
    private AutoCompleteComponent _locationTxtField;
    private AutoCompleteComponent _swLocationTxtField;
    private AutoCompleteComponent _installLocationTxtField;
    private AutoCompleteComponent _ttGroupTxtField;
    private JCheckBox _defaultHostNameCheckBox;
    private JCheckBox _defaultGroupCheckBox;
    private JButton _browseButton;
    private JButton _createButton;
    private boolean isWizard;
    private String hostName;
    private List<String> dirsToCreate;
    static final String CONFIRMATION_ID = "NewGridConfirmation";
    private static Logger _logger = Logger.getLogger(GridMgmtInfoPanel.class.getName());

    public GridMgmtInfoPanel(boolean bl) {
        this.isWizard = bl;
        this.dirsToCreate = new ArrayList<String>();
        this._mgmtInstPanel = new JPanel(new GridBagLayout());
        this._mgmtInstPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.MgmtInstance")));
        this._hostPanel = new JPanel(new GridBagLayout());
        this._hostPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.HostObjectName")));
        this._instPanel = new JPanel(new GridBagLayout());
        this._instPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.InstanceObjectName")));
        this._installPanel = new JPanel(new GridBagLayout());
        this._installPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.InstallationObjectName")));
        this._hostTxtField = new AutoCompleteComponent(15, HostObject.getHostNameSuggestions());
        this._defaultHostNameCheckBox = new JCheckBox(Messages.getString("TimesTenGrid.useDefault"));
        this._defaultHostNameCheckBox.addItemListener(this);
        this._defaultHostNameCheckBox.setSelected(true);
        this._ttGroupTxtField = new AutoCompleteComponent(25, GridObject.getAdminGroupSuggestions());
        this._defaultGroupCheckBox = new JCheckBox(Messages.getString("TimesTenGrid.useDefault"));
        this._defaultGroupCheckBox.addItemListener(this);
        this._intAddressTxtField = new AutoCompleteComponent(15, HostObject.getHostInternalAddressSuggestions());
        this._extAddressTxtField = new AutoCompleteComponent(15, HostObject.getHostExternalAddressSuggestions());
        this._nameTxtField = new AutoCompleteComponent(15, InstanceObject.getInstanceNameSuggestions());
        this._nameTxtField.setText(Common.getDefaultInstanceName(true));
        this._daemonPortTxtField = new AutoCompleteComponent(15, InstanceObject.getInstanceDaemonPortSuggestions());
        this._daemonPortTxtField.setText(String.valueOf(6624));
        this._csPortTxtField = new AutoCompleteComponent(15, InstanceObject.getInstanceCSPortSuggestions());
        this._csPortTxtField.setText(String.valueOf(6625));
        this._mgmtPortTxtField = new AutoCompleteComponent(15, InstanceObject.getInstanceMgmtPortSuggestions());
        this._mgmtPortTxtField.setText(String.valueOf(3754));
        this._locationTxtField = new AutoCompleteComponent(25, InstanceObject.getInstanceHomeSuggestions());
        this._swLocationTxtField = new AutoCompleteComponent(25, InstallationObject.getInstallationLocationSuggestions());
        this._swLocationTxtField.addFocusListener(this);
        this._installLocationTxtField = new AutoCompleteComponent(25, InstallationObject.getInstallationLocationSuggestions());
        this._browseButton = new JButton(Messages.getString("TimesTenGrid.browse"));
        this._browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(TTGridRootNode.getInstance().getCurrentDirectory());
                jFileChooser.setFileSelectionMode(2);
                jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Compressed files (.zip, .zipx, .gz)", "zip", "zipx", "gz"));
                jFileChooser.setFileFilter(jFileChooser.getChoosableFileFilters()[1]);
                int n = jFileChooser.showOpenDialog((Component)Ide.getMainWindow());
                if (n == 0) {
                    TTGridRootNode.getInstance().setCurrentDirectory(jFileChooser.getCurrentDirectory().getAbsolutePath());
                    File file = jFileChooser.getSelectedFile();
                    GridMgmtInfoPanel.this._swLocationTxtField.setText(file.getAbsolutePath());
                    GridMgmtInfoPanel.this.setEnabledInstallTxtField(file.isFile());
                }
            }
        });
        this._createButton = new JButton(Messages.getString("TimesTenGrid.create"));
        this._createButton.addActionListener(this);
        this._hostLabel = new JLabel(Messages.getString("TimesTenGrid.hostNameLabel"));
        this._hostLabel.setLabelFor(this._defaultHostNameCheckBox);
        this._intAddressLabel = new JLabel(Messages.getString("TimesTenGrid.internalAddrLabel"));
        this._intAddressLabel.setLabelFor(this._intAddressTxtField);
        this._extAddressLabel = new JLabel(Messages.getString("TimesTenGrid.externalAddrLabel"));
        this._extAddressLabel.setLabelFor(this._extAddressTxtField);
        this._nameLabel = new JLabel(Messages.getString("TimesTenGrid.instanceNameLabel"));
        this._nameLabel.setLabelFor(this._nameTxtField);
        this._daemonPortLabel = new JLabel(Messages.getString("TimesTenGrid.daemonPortLabel"));
        this._daemonPortLabel.setLabelFor(this._daemonPortTxtField);
        this._csPortLabel = new JLabel(Messages.getString("TimesTenGrid.csPortLabel"));
        this._csPortLabel.setLabelFor(this._csPortTxtField);
        this._mgmtPortLabel = new JLabel(Messages.getString("TimesTenGrid.mgmtPortLabel"));
        this._mgmtPortLabel.setLabelFor(this._mgmtPortTxtField);
        this._locationLabel = new JLabel(Messages.getString("TimesTenGrid.instLocLabel"));
        this._locationLabel.setLabelFor(this._locationTxtField);
        this._swLocationLabel = new JLabel(Messages.getString("TimesTenGrid.swLocationLabel"));
        this._swLocationLabel.setLabelFor(this._swLocationTxtField);
        this._installLocationLabel = new JLabel(Messages.getString("TimesTenGrid.installLocLabel"));
        this._installLocationLabel.setLabelFor(this._installLocationTxtField);
        this._ttGroupLabel = new JLabel(Messages.getString("TimesTenGrid.ttGroupLabel"));
        this._ttGroupLabel.setLabelFor(this._defaultGroupCheckBox);
        boolean bl2 = Common.isRunningInTTView();
        if (bl2) {
            String string = System.getenv("HOSTNAME");
            this._intAddressTxtField.setText(string);
            this._extAddressTxtField.setText(string);
            this._credPanel.getInstanceAdminTxtField().setText(System.getProperty("user.name"));
            this._swLocationTxtField.setText(System.getenv("TIMESTEN_INSTALL_ROOT"));
        }
        this.setEnabledInstallTxtField(false);
        this._hostTxtField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (GridMgmtInfoPanel.this._intAddressTxtField.getText().isEmpty()) {
                    GridMgmtInfoPanel.this._intAddressTxtField.setText(GridMgmtInfoPanel.this._hostTxtField.getText());
                }
                if (GridMgmtInfoPanel.this._extAddressTxtField.getText().isEmpty()) {
                    GridMgmtInfoPanel.this._extAddressTxtField.setText(GridMgmtInfoPanel.this._hostTxtField.getText());
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        });
        this._intAddressTxtField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                GridMgmtInfoPanel.this._extAddressTxtField.setText(GridMgmtInfoPanel.this._intAddressTxtField.getText());
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        });
        int n = 0;
        this._hostPanel.add((Component)this._hostLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._hostPanel.add((Component)this._hostTxtField, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._hostPanel.add((Component)this._defaultHostNameCheckBox, new GridBagConstraints(2, n++, 1, 1, 0.0, 0.0, 22, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._hostPanel.add((Component)this._intAddressLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._hostPanel.add((Component)this._intAddressTxtField, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._hostPanel.add((Component)this._extAddressLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._hostPanel.add((Component)this._extAddressTxtField, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        n = 0;
        this._instPanel.add((Component)this._nameLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._instPanel.add((Component)this._nameTxtField, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._instPanel.add((Component)this._locationLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._instPanel.add((Component)this._locationTxtField, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._instPanel.add((Component)this._daemonPortLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._instPanel.add((Component)this._daemonPortTxtField, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._instPanel.add((Component)this._csPortLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._instPanel.add((Component)this._csPortTxtField, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._instPanel.add((Component)this._mgmtPortLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._instPanel.add((Component)this._mgmtPortTxtField, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        n = 0;
        this._installPanel.add((Component)this._swLocationLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._installPanel.add((Component)this._swLocationTxtField, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._installPanel.add((Component)this._browseButton, new GridBagConstraints(2, n++, 1, 1, 0.0, 0.0, 22, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._installPanel.add((Component)this._installLocationLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._installPanel.add((Component)this._installLocationTxtField, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._installPanel.add((Component)this._ttGroupLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._installPanel.add((Component)this._ttGroupTxtField, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._installPanel.add((Component)this._defaultGroupCheckBox, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 22, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._mgmtInstPanel.add((Component)this._hostPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._mgmtInstPanel.add((Component)this._instPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._mgmtInstPanel.add((Component)this._installPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 23, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._mainPanel = new JPanel(new GridBagLayout());
        this._mainPanel.setPreferredSize(new Dimension(580, 630));
        this._mainPanel.add((Component)this._gridInfoPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._mainPanel.add((Component)this._mgmtInstPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._mainPanel.add((Component)this._credPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 23, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.setViewportView(this._mainPanel);
        this.setVerticalScrollBarPolicy(20);
        this.setHorizontalScrollBarPolicy(30);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!(propertyChangeEvent.getNewValue() instanceof JComponent)) {
                    return;
                }
                JComponent jComponent = (JComponent)propertyChangeEvent.getNewValue();
                if (GridMgmtInfoPanel.this._mainPanel.isAncestorOf(jComponent)) {
                    ((JComponent)jComponent.getParent()).scrollRectToVisible(jComponent.getBounds());
                }
            }
        });
        this.setNames();
    }

    public JButton getCreateButton() {
        return this._createButton;
    }

    @Override
    public void validateInput() throws InvalidInputException {
        this.checkInput();
        this.testHostConnection();
        throw new InvalidInputException(null);
    }

    public void validateNewGridInput() throws InvalidInputException {
        this.checkInput();
        this.testHostConnection();
    }

    private void checkInput() throws InvalidInputException {
        String string = this._gridInfoPanel.getGridNameTxtField().getText().trim();
        if (string.isEmpty()) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.noGridNameError"));
        }
        String string2 = Common.validateName(string, Messages.getString("TimesTenGrid.gridName"));
        if (string2 != null) {
            throw new InvalidInputException(string2);
        }
        int n = 0;
        try {
            n = (Integer)this._gridInfoPanel.getKSafetySpinner().getValue();
            if (n < 1 || n > 4) {
                throw new InvalidInputException(Messages.getString("TimesTenGrid.invalidKSafetyError"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.invalidKSafetyError"));
        }
        String string3 = this._gridInfoPanel.getMembershipConfTxtField().getText().trim();
        if (string3.isEmpty()) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.noMembershipError"));
        }
        String string4 = this._hostTxtField.getText().trim();
        if (string4.isEmpty() && !this._defaultHostNameCheckBox.isSelected()) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.noHostNameError"));
        }
        String string5 = Common.validateName(string4, Messages.getString("TimesTenGrid.hostNameColumn"));
        if (string5 != null) {
            throw new InvalidInputException(string5);
        }
        string5 = this._intAddressTxtField.getText().trim();
        if (string5.isEmpty()) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.noInternalAddrError"));
        }
        if (!Common.validAddress(string5)) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.internalAddrFormatError"));
        }
        string5 = this._extAddressTxtField.getText().trim();
        if (string5.isEmpty()) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.noExternalAddrError"));
        }
        if (!Common.validAddress(string5)) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.externalAddrFormatError"));
        }
        String string6 = this._nameTxtField.getText().trim();
        if (string6.isEmpty()) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.noNameError"));
        }
        string2 = Common.validateName(string6, Messages.getString("TimesTenGrid.instanceName"));
        if (string2 != null) {
            throw new InvalidInputException(string2);
        }
        String string7 = this._locationTxtField.getText().trim();
        if (string7.isEmpty()) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.noInstLocError"));
        }
        String string8 = this._daemonPortTxtField.getText().trim();
        int n2 = 0;
        if (string8.isEmpty()) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.noDaemonPortError"));
        }
        try {
            n2 = Integer.parseInt(string8);
            if (!Common.validPort(n2)) {
                throw new InvalidInputException(Messages.getString("TimesTenGrid.invalidDaemonPortError"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.invalidDaemonPortError"));
        }
        string8 = this._csPortTxtField.getText().trim();
        int n3 = 0;
        if (string8.isEmpty()) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.noCSPortError"));
        }
        try {
            n3 = Integer.parseInt(string8);
            if (!Common.validPort(n3)) {
                throw new InvalidInputException(Messages.getString("TimesTenGrid.invalidCSPortError"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.invalidCSPortError"));
        }
        string8 = this._mgmtPortTxtField.getText().trim();
        int n4 = 0;
        if (string8.isEmpty()) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.noMgmtPortError"));
        }
        try {
            n4 = Integer.parseInt(string8);
            if (!Common.validPort(n4)) {
                throw new InvalidInputException(Messages.getString("TimesTenGrid.invalidMgmtPortError"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.invalidMgmtPortError"));
        }
        if (n2 == n3 || n2 == n4 || n3 == n4) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.invalidSamePortDCSM"));
        }
        String string9 = this._swLocationTxtField.getText().trim();
        if (string9.isEmpty()) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.noSWLocationError"));
        }
        String string10 = this._installLocationTxtField.getText().trim();
        if (string10.isEmpty() && this._installLocationTxtField.isEnabled()) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.noInstallLocationError"));
        }
        String string11 = this._ttGroupTxtField.getText().trim();
        if (string11.isEmpty() && this._ttGroupTxtField.isEnabled() && !this._defaultGroupCheckBox.isSelected()) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.noTTGroupError"));
        }
        String string12 = this._credPanel.getInstanceAdminTxtField().getText().trim();
        if (string12.isEmpty()) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.noInstanceAdminError"));
        }
        char[] cArray = this._credPanel.getPasswordField().getPassword();
        if (cArray.length == 0) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.noPwdError"));
        }
    }

    private void testHostConnection() {
        this.dirsToCreate = new ArrayList<String>();
        final String string = this._extAddressTxtField.getText().trim();
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor(this, MessageFormat.format(Messages.getString("TimesTenGrid.connectingToHost"), string), Messages.getString("TimesTen.common.pleaseWait"), null);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            StringBuilder error = new StringBuilder();

            @Override
            protected Void doInBackground() {
                customProgressMonitor.start();
                String string9 = GridMgmtInfoPanel.this._credPanel.getInstanceAdminTxtField().getText().trim();
                char[] cArray = GridMgmtInfoPanel.this._credPanel.getPasswordField().getPassword();
                String string2 = GridMgmtInfoPanel.this._gridInfoPanel.getMembershipConfTxtField().getText().trim();
                String string3 = GridMgmtInfoPanel.this._nameTxtField.getText().trim();
                String string4 = GridMgmtInfoPanel.this._locationTxtField.getText().trim();
                String string5 = GridMgmtInfoPanel.this._swLocationTxtField.getText().trim();
                String string6 = GridMgmtInfoPanel.this._installLocationTxtField.getText().trim();
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = Common.isLocalHost(string);
                String[] stringArray = new String[Common.PARAMCHECK_COUNT];
                if (!Common.isAFile(string2)) {
                    if (!bl6) {
                        bl = true;
                        stringArray[Common.CheckIndex.MEMCONFIG_IDX.ordinal()] = string2;
                    } else {
                        this.error.append(Messages.getString("TimesTenGrid.membershipConfFileNE"));
                        return null;
                    }
                }
                if (bl6) {
                    String string7;
                    if (!Common.isADirectory(string4, true)) {
                        string7 = string + ":" + string4;
                        if (!GridMgmtInfoPanel.this.dirsToCreate.contains(string7)) {
                            GridMgmtInfoPanel.this.dirsToCreate.add(string7);
                        }
                    }
                    if (Common.isADirectory(string4 + "/" + string3, false)) {
                        this.error.append(MessageFormat.format(Messages.getString("TimesTenGrid.instHomeAlreadyExists"), string4 + "/" + string3, string));
                        return null;
                    }
                    if (GridMgmtInfoPanel.this._installLocationTxtField.isEnabled()) {
                        if (!Common.isADirectory(string6, true)) {
                            string7 = string + ":" + string6;
                            if (!GridMgmtInfoPanel.this.dirsToCreate.contains(string7)) {
                                GridMgmtInfoPanel.this.dirsToCreate.add(string7);
                            }
                        }
                        if (Common.sameDirectories(string4, string6)) {
                            this.error.append(Messages.getString("TimesTenGrid.sameInstDirInstallLoc"));
                            return null;
                        }
                    } else if (Common.sameDirectories(string4, string5)) {
                        this.error.append(Messages.getString("TimesTenGrid.sameInstDirSWLoc"));
                        return null;
                    }
                } else {
                    bl2 = true;
                    stringArray[Common.CheckIndex.INSTDIR_IDX.ordinal()] = string4;
                    stringArray[Common.CheckIndex.INSTNAME_IDX.ordinal()] = string3;
                }
                boolean bl7 = Common.isAFile(string5);
                boolean bl8 = Common.validTTSWFile(string5);
                if (bl7) {
                    if (!bl8) {
                        this.error.append(Messages.getString("TimesTenGrid.invalidSWLocationError"));
                        return null;
                    }
                    if (!bl6) {
                        bl5 = true;
                        stringArray[Common.CheckIndex.INSTALLLOC_IDX.ordinal()] = string6;
                    }
                } else if (bl6 || !bl6 && !bl8) {
                    bl4 = true;
                    stringArray[Common.CheckIndex.TTINSTALL_IDX.ordinal()] = string5;
                } else if (!bl6 && bl8) {
                    bl3 = true;
                    stringArray[Common.CheckIndex.TTSW_IDX.ordinal()] = string5;
                    bl5 = true;
                    stringArray[Common.CheckIndex.INSTALLLOC_IDX.ordinal()] = string6;
                }
                stringArray[Common.CheckIndex.TTGROUP_IDX.ordinal()] = GridMgmtInfoPanel.this.getTTGroup();
                try {
                    String string8;
                    GridMgmtInfoPanel.this.hostName = SSHChannel.tryConnect(string, string9, cArray, new boolean[]{bl, bl2, bl4, bl3, bl5, true, false, GridMgmtInfoPanel.this.checkTTGroup()}, stringArray);
                    if (stringArray[Common.CheckIndex.INSTDIR_IDX.ordinal()] != null && stringArray[Common.CheckIndex.INSTDIR_IDX.ordinal()].contains("$$CREATE_DIR$$")) {
                        string8 = string + ":" + string4;
                        if (!GridMgmtInfoPanel.this.dirsToCreate.contains(string8)) {
                            GridMgmtInfoPanel.this.dirsToCreate.add(string8);
                        }
                    }
                    if (stringArray[Common.CheckIndex.INSTALLLOC_IDX.ordinal()] != null && stringArray[Common.CheckIndex.INSTALLLOC_IDX.ordinal()].contains("$$CREATE_DIR$$")) {
                        string8 = string + ":" + string6;
                        if (!GridMgmtInfoPanel.this.dirsToCreate.contains(string8)) {
                            GridMgmtInfoPanel.this.dirsToCreate.add(string8);
                        }
                    }
                }
                catch (MySSHException mySSHException) {
                    this.error.append(mySSHException.getMessage());
                    _logger.log(Level.SEVERE, mySSHException.getMessage());
                }
                return null;
            }

            @Override
            protected void done() {
                customProgressMonitor.close();
                if (this.isCancelled()) {
                    return;
                }
                if (this.error.length() > 0) {
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), this.error.toString());
                } else if (GridMgmtInfoPanel.this.isWizard) {
                    GridMgmtInfoPanel.this.dataContext.put("Ready", (Object)1);
                    GridMgmtInfoPanel.this.dataContext.put("APPLY", (Object)true);
                    GridMgmtInfoPanel.this.dataContext.getWizardCallbacks().nextPage();
                } else {
                    GridMgmtInfoPanel.this._dialog.dispose();
                    GridMgmtInfoPanel.this.dataContext = new TraversableContext(new Namespace(), 1);
                    GridMgmtInfoPanel.this.setGridData();
                    GridMgmtInfoPanel.this.dataContext.put("HOSTS", new ArrayList());
                    GridMgmtInfoPanel.this.dataContext.put("APPLY", (Object)false);
                    CreateGridTask createGridTask = new CreateGridTask(GridMgmtInfoPanel.this.dataContext);
                    createGridTask.execute();
                }
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    public String getGridName() {
        return this._gridInfoPanel.getGridNameTxtField().getText().trim();
    }

    public int getKSafety() {
        return (Integer)this._gridInfoPanel.getKSafetySpinner().getValue();
    }

    public String getMembershipService() {
        return "zookeeper";
    }

    public String getMembershipConfiguration() {
        return this._gridInfoPanel.getMembershipConfTxtField().getText().trim();
    }

    public String getInstanceName() {
        return this._nameTxtField.getText().trim();
    }

    public String getExternalAddress() {
        return this._extAddressTxtField.getText().trim();
    }

    public String getInternalAddress() {
        return this._intAddressTxtField.getText().trim();
    }

    public String getHostName() {
        if (this.getUseDefaultHostName()) {
            return this.hostName;
        }
        return this._hostTxtField.getText().trim();
    }

    public boolean getUseDefaultHostName() {
        return this._defaultHostNameCheckBox.isSelected();
    }

    public String getInstanceLocation() {
        return this._locationTxtField.getText().trim();
    }

    public String getInstallLocation() {
        return this._installLocationTxtField.getText().trim();
    }

    public int getCSPort() {
        return Integer.parseInt(this._csPortTxtField.getText().trim());
    }

    public int getDaemonPort() {
        return Integer.parseInt(this._daemonPortTxtField.getText().trim());
    }

    public int getMgmtPort() {
        return Integer.parseInt(this._mgmtPortTxtField.getText().trim());
    }

    public String getSoftwareLocation() {
        return this._swLocationTxtField.getText().trim();
    }

    public String getTTGroup() {
        return this._ttGroupTxtField.getText().trim();
    }

    public boolean checkTTGroup() {
        return this._ttGroupTxtField.isEnabled() && !this.getTTGroup().isEmpty();
    }

    public String getInstanceAdmin() {
        return this._credPanel.getInstanceAdminTxtField().getText().trim();
    }

    public char[] getPassword() {
        return this._credPanel.getPasswordField().getPassword();
    }

    public boolean getSavePassword() {
        return this._credPanel.getSavePwdCheckBox().isSelected();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        String string = this._swLocationTxtField.getText().trim();
        if (!string.isEmpty()) {
            this.setEnabledInstallTxtField(Common.validTTSWFile(string));
        } else {
            this.setEnabledInstallTxtField(false);
        }
    }

    private void setEnabledInstallTxtField(boolean bl) {
        if (!bl) {
            this._installLocationTxtField.setText("");
            this._ttGroupTxtField.setEnabled(bl);
            this._ttGroupTxtField.setText("");
        }
        this._defaultGroupCheckBox.setEnabled(bl);
        this._defaultGroupCheckBox.setSelected(bl);
        this._installLocationTxtField.setEnabled(bl);
    }

    @Override
    protected void setGridData() {
        String string = this.getSoftwareLocation();
        String string2 = this.getTTGroup();
        boolean bl = Common.isAFile(string);
        String string3 = this.getInstallLocation();
        if (!bl && !Common.validTTSWFile(string)) {
            string3 = string;
        }
        this.dataContext.put("HOSTNAME", (Object)this.getHostName());
        this.dataContext.put("INTADDRESS", (Object)this.getInternalAddress());
        String string4 = this.getExternalAddress();
        this.dataContext.put("EXTADDRESS", (Object)string4);
        this.dataContext.put("GRID_NAME", (Object)this.getGridName());
        this.dataContext.put("K_SAFETY", (Object)this.getKSafety());
        this.dataContext.put("MEM_SERVICE", (Object)this.getMembershipService());
        this.dataContext.put("MEM_CONFIG", (Object)this.getMembershipConfiguration());
        this.dataContext.put("NAME", (Object)this.getInstanceName());
        this.dataContext.put("INSTANCE_LOCATION", (Object)this.getInstanceLocation());
        this.dataContext.put("DAEMON_PORT", (Object)this.getDaemonPort());
        this.dataContext.put("CS_PORT", (Object)this.getCSPort());
        this.dataContext.put("MANAGEMENT_PORT", (Object)this.getMgmtPort());
        this.dataContext.put("INSTALLATION_LOCATION", (Object)string3);
        this.dataContext.put("SW_LOCATION", (Object)string);
        if (!string2.isEmpty()) {
            this.dataContext.put("TT_GROUP", (Object)string2);
        }
        this.dataContext.put("INSTANCE_ADMIN", (Object)this.getInstanceAdmin());
        this.dataContext.put("PWD", (Object)this.getPassword());
        this.dataContext.put("SAVE_PWD", (Object)this.getSavePassword());
        this.dataContext.put("LOCAL_PATH", (Object)bl);
        this.dataContext.put("IS_LOCAL_HOST", (Object)Common.isLocalHost(string4));
        this.dataContext.put("DIRS_TO_CREATE", this.dirsToCreate);
        TTGridRootNode.getStorage().saveSuggestion("hostName", this.getHostName());
        TTGridRootNode.getStorage().saveSuggestion("externalAddress", this.getExternalAddress());
        TTGridRootNode.getStorage().saveSuggestion("internalAddress", this.getInternalAddress());
        TTGridRootNode.getStorage().saveSuggestion("daemonPort", String.valueOf(this.getDaemonPort()));
        TTGridRootNode.getStorage().saveSuggestion("csPort", String.valueOf(this.getCSPort()));
        TTGridRootNode.getStorage().saveSuggestion("mgmtPort", String.valueOf(this.getMgmtPort()));
        TTGridRootNode.getStorage().saveSuggestion("instanceHome", this.getInstanceLocation());
        TTGridRootNode.getStorage().saveSuggestion("instanceName", this.getInstanceName());
        TTGridRootNode.getStorage().saveSuggestion("adminGroup", this.getTTGroup());
        TTGridRootNode.getStorage().saveSuggestion("installationLocation", this.getInstallLocation().isEmpty() ? this.getSoftwareLocation() : this.getInstallLocation());
        TTGridRootNode.getStorage().saveSuggestion("membershipConfig", this.getMembershipConfiguration());
        TTGridRootNode.getStorage().saveSuggestion("adminUID", this.getInstanceAdmin());
        TTGridRootNode.getStorage().saveSuggestion("gridName", this.getGridName());
    }

    @Override
    public void setDialog(final JEWTDialog jEWTDialog) {
        super.setDialog(jEWTDialog);
        this._dialog.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                if (MessageDialog.getPersistence().getConfirmed(GridMgmtInfoPanel.CONFIRMATION_ID) != null) {
                    return;
                }
                if (!Common.displayOptionalConfirm(GridMgmtInfoPanel.CONFIRMATION_ID, componentEvent.getComponent(), Messages.getString("TimesTenGrid.pwdLessWarningGC"), Messages.getString("TimesTenGrid.pwdLessSSH"), null)) {
                    jEWTDialog.dispose();
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.validateNewGridInput();
        }
        catch (Exception exception) {
            Common.displayErrorMsg(this, exception.getMessage());
            return;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this._defaultHostNameCheckBox) {
            this._hostTxtField.setEnabled(!this._defaultHostNameCheckBox.isSelected());
            if (this._defaultHostNameCheckBox.isSelected()) {
                this._hostTxtField.setText("");
            }
        } else if (itemEvent.getSource() == this._defaultGroupCheckBox) {
            this._ttGroupTxtField.setText("");
            if (this._defaultGroupCheckBox.isSelected()) {
                this._ttGroupTxtField.setEnabled(false);
            } else {
                this._ttGroupTxtField.setEnabled(this._defaultGroupCheckBox.isEnabled());
            }
        }
    }

    private void setNames() {
        this._nameLabel.setName(Messages.getString("TimesTenGrid.instanceNameLabel"));
        this._hostLabel.setName(Messages.getString("TimesTenGrid.hostNameLabel"));
        this._extAddressLabel.setName(Messages.getString("TimesTenGrid.externalAddrLabel"));
        this._intAddressLabel.setName(Messages.getString("TimesTenGrid.internalAddrLabel"));
        this._daemonPortLabel.setName(Messages.getString("TimesTenGrid.daemonPortLabel"));
        this._csPortLabel.setName(Messages.getString("TimesTenGrid.csPortLabel"));
        this._mgmtPortLabel.setName(Messages.getString("TimesTenGrid.mgmtPortLabel"));
        this._locationLabel.setName(Messages.getString("TimesTenGrid.instLocLabel"));
        this._swLocationLabel.setName(Messages.getString("TimesTenGrid.swLocationLabel"));
        this._installLocationLabel.setName(Messages.getString("TimesTenGrid.installLocLabel"));
        this._ttGroupLabel.setName(Messages.getString("TimesTenGrid.ttGroupLabel"));
        this._nameTxtField.setName("_nameTxtField", "_nameCmbBox");
        this._hostTxtField.setName("_hostTxtField", "_hostCmbBox");
        this._extAddressTxtField.setName("_extAddressTxtField", "_extAddressCmbBox");
        this._intAddressTxtField.setName("_intAddressTxtField", "_intAddressCmbBox");
        this._daemonPortTxtField.setName("_daemonPortTxtField", "_daemonPortCmbBox");
        this._csPortTxtField.setName("_csPortTxtField", "_csPortCmbBox");
        this._mgmtPortTxtField.setName("_mgmtPortTxtField", "_mgmtPortCmbBox");
        this._locationTxtField.setName("_locationTxtField", "_locationCmbBox");
        this._swLocationTxtField.setName("_swLocationTxtField", "_swLocationCmbBox");
        this._installLocationTxtField.setName("_installLocationTxtField", "_installLocationCmbBox");
        this._ttGroupTxtField.setName("_ttGroupTxtField", "_ttGroupCmbBox");
        this._defaultHostNameCheckBox.setName(Messages.getString("TimesTenGrid.useDefault"));
        this._defaultGroupCheckBox.setName("_defaultGroupCheckBox");
        this._browseButton.setName(Messages.getString("TimesTenGrid.browse"));
        this._createButton.setName(Messages.getString("TimesTenGrid.create"));
    }

    static class CredentialsPanel
    extends JPanel {
        private JLabel _instanceAdminLabel;
        private JLabel _pwdLabel;
        private AutoCompleteComponent _instanceAdminTxtField;
        private JPasswordField _pwdField;
        private JCheckBox _savePwdCheckBox;

        public CredentialsPanel() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.credentials")));
        }

        public void initialize() {
            this._instanceAdminTxtField = new AutoCompleteComponent(20, TTGridRootNode.getStorage().getSuggestion("adminUID"));
            this._pwdField = new JPasswordField(20);
            this._savePwdCheckBox = new JCheckBox(Messages.getString("TimesTenGrid.savePwd"));
            this._instanceAdminLabel = new JLabel(Messages.getString("TimesTenGrid.instanceAdminLabel"));
            this._instanceAdminLabel.setLabelFor(this._instanceAdminTxtField);
            this._pwdLabel = new JLabel(Messages.getString("TimesTenGrid.passwordLabel"));
            this._pwdLabel.setLabelFor(this._pwdField);
            this.add((Component)this._instanceAdminLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._instanceAdminTxtField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._pwdLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._pwdField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._savePwdCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.setNames();
        }

        public AutoCompleteComponent getInstanceAdminTxtField() {
            return this._instanceAdminTxtField;
        }

        public JPasswordField getPasswordField() {
            return this._pwdField;
        }

        public JCheckBox getSavePwdCheckBox() {
            return this._savePwdCheckBox;
        }

        private void setNames() {
            this._instanceAdminLabel.setName(Messages.getString("TimesTenGrid.instanceAdminLabel"));
            this._pwdLabel.setName(Messages.getString("TimesTenGrid.passwordLabel"));
            this._instanceAdminTxtField.setName("_instanceAdminTxtField", "_instanceAdminCmbBox");
            this._pwdField.setName("_pwdField");
            this._savePwdCheckBox.setName(Messages.getString("TimesTenGrid.savePwd"));
        }
    }

    static class GridInfoPanel
    extends JPanel {
        private JLabel _gridNameLabel;
        private JLabel _kSafetyLabel;
        private JLabel _membershipConfLabel;
        private AutoCompleteComponent _gridNameTxtField;
        private JSpinner _kSafetySpinner;
        private AutoCompleteComponent _membershipConfTxtField;
        private JButton _browseMemButton;

        public GridInfoPanel() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.gridInfo")));
        }

        public void initialize() {
            this._gridNameTxtField = new AutoCompleteComponent(20, TTGridRootNode.getStorage().getSuggestion("gridName"));
            this._gridNameTxtField.setText(TTGridRootNode.getInstance().getAvailableSampleGridName());
            this._kSafetySpinner = new JSpinner(new SpinnerNumberModel(1, 1, 2, 1));
            this._membershipConfTxtField = new AutoCompleteComponent(20, TTGridRootNode.getStorage().getSuggestion("membershipConfig"));
            this._browseMemButton = new JButton(Messages.getString("TimesTenGrid.browse"));
            this._browseMemButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser(TTGridRootNode.getInstance().getCurrentDirectory());
                    int n = jFileChooser.showOpenDialog((Component)Ide.getMainWindow());
                    if (n == 0) {
                        TTGridRootNode.getInstance().setCurrentDirectory(jFileChooser.getCurrentDirectory().getAbsolutePath());
                        File file = jFileChooser.getSelectedFile();
                        _membershipConfTxtField.setText(file.getAbsolutePath());
                    }
                }
            });
            this._gridNameLabel = new JLabel(Messages.getString("TimesTenGrid.name"));
            this._gridNameLabel.setLabelFor(this._gridNameTxtField);
            this._kSafetyLabel = new JLabel(Messages.getString("TimesTenGrid.kSafetyLabel"));
            this._kSafetyLabel.setLabelFor(this._kSafetySpinner);
            this._membershipConfLabel = new JLabel(Messages.getString("TimesTenGrid.membershipConfLabel"));
            this._membershipConfLabel.setLabelFor(this._membershipConfTxtField);
            this.add((Component)this._gridNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._gridNameTxtField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._kSafetyLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._kSafetySpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._membershipConfLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._membershipConfTxtField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._browseMemButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 22, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.setNames();
        }

        public JSpinner getKSafetySpinner() {
            return this._kSafetySpinner;
        }

        public AutoCompleteComponent getGridNameTxtField() {
            return this._gridNameTxtField;
        }

        public AutoCompleteComponent getMembershipConfTxtField() {
            return this._membershipConfTxtField;
        }

        private void setNames() {
            this._gridNameLabel.setName(Messages.getString("TimesTenGrid.name"));
            this._kSafetyLabel.setName(Messages.getString("TimesTenGrid.kSafetyLabel"));
            this._membershipConfLabel.setName(Messages.getString("TimesTenGrid.membershipConfLabel"));
            this._gridNameTxtField.setName("_gridNameTxtField", "_gridNameCmbBox");
            this._kSafetySpinner.setName("_kSafetySpinner");
            this._membershipConfTxtField.setName("_membershipConfTxtField", "_membershipConfCmbBox");
            this._browseMemButton.setName("_browseMemButton");
        }
    }
}

