/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.SSHChannel;
import oracle.dbtools.raptor.timesten.grid.TTGUIBasePanel;
import oracle.dbtools.raptor.timesten.grid.navigator.GridMouseListener;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.grid.object.MySSHException;
import oracle.dbtools.raptor.timesten.utils.AutoCompleteComponent;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;

public class CloneHostPanel
extends TTGUIBasePanel {
    private JLabel _hostLabel;
    private JLabel _extAddressLabel;
    private JLabel _intAddressLabel;
    private AutoCompleteComponent _hostTxtField;
    private AutoCompleteComponent _extAddressTxtField;
    private AutoCompleteComponent _intAddressTxtField;
    private JCheckBox _useDefaultCheckBox;
    private String baseHostName;
    private String hostName;
    private List<String> dirsToCreate;
    static final String CONFIRMATION_ID = "CloneHostConfirmation";
    private static Logger _logger = Logger.getLogger(CloneHostPanel.class.getPackage().getName());

    public CloneHostPanel(String string) {
        this.baseHostName = string;
        this.dirsToCreate = new ArrayList<String>();
        this._hostTxtField = new AutoCompleteComponent(15, HostObject.getHostNameSuggestions());
        this._useDefaultCheckBox = new JCheckBox(Messages.getString("TimesTenGrid.useDefault"));
        this._useDefaultCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                CloneHostPanel.this._hostTxtField.setEnabled(!CloneHostPanel.this._useDefaultCheckBox.isSelected());
                if (CloneHostPanel.this._useDefaultCheckBox.isSelected()) {
                    CloneHostPanel.this._hostTxtField.setText("");
                }
            }
        });
        this._useDefaultCheckBox.setSelected(true);
        this._intAddressTxtField = new AutoCompleteComponent(15, HostObject.getHostInternalAddressSuggestions());
        this._extAddressTxtField = new AutoCompleteComponent(15, HostObject.getHostExternalAddressSuggestions());
        this._hostLabel = new JLabel(Messages.getString("TimesTenGrid.hostNameLabel"));
        this._hostLabel.setLabelFor(this._hostTxtField);
        this._intAddressLabel = new JLabel(Messages.getString("TimesTenGrid.internalAddrLabel"));
        this._intAddressLabel.setLabelFor(this._intAddressTxtField);
        this._extAddressLabel = new JLabel(Messages.getString("TimesTenGrid.externalAddrLabel"));
        this._extAddressLabel.setLabelFor(this._extAddressTxtField);
        this._hostTxtField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (CloneHostPanel.this._intAddressTxtField.getText().isEmpty()) {
                    CloneHostPanel.this._intAddressTxtField.setText(CloneHostPanel.this._hostTxtField.getText());
                }
                if (CloneHostPanel.this._extAddressTxtField.getText().isEmpty()) {
                    CloneHostPanel.this._extAddressTxtField.setText(CloneHostPanel.this._hostTxtField.getText());
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        });
        this._intAddressTxtField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CloneHostPanel.this._extAddressTxtField.setText(CloneHostPanel.this._intAddressTxtField.getText());
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        });
        this.add((Component)this._hostLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._hostTxtField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._useDefaultCheckBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._intAddressLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._intAddressTxtField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._extAddressLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._extAddressTxtField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, TimesTenHelpID.HOST_CLONE.toString());
        this.setNames();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.validInput();
    }

    private void validInput() {
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor(this, MessageFormat.format(Messages.getString("TimesTenGrid.connectingToHost"), this._extAddressTxtField.getText().trim()), Messages.getString("TimesTen.common.pleaseWait"), null);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            StringBuilder error = new StringBuilder();

            @Override
            protected Void doInBackground() {
                customProgressMonitor.start();
                CloneHostPanel.this.hostName = CloneHostPanel.this._hostTxtField.getText().trim();
                if (CloneHostPanel.this.hostName.isEmpty() && !CloneHostPanel.this._useDefaultCheckBox.isSelected()) {
                    this.error.append(Messages.getString("TimesTenGrid.noHostNameError"));
                    return null;
                }
                String string = Common.validateName(CloneHostPanel.this.hostName, Messages.getString("TimesTenGrid.hostNameColumn"));
                if (string != null) {
                    this.error.append(string);
                    return null;
                }
                string = CloneHostPanel.this._intAddressTxtField.getText().trim();
                if (string.isEmpty()) {
                    this.error.append(Messages.getString("TimesTenGrid.noInternalAddrError"));
                    return null;
                }
                if (!Common.validAddress(string)) {
                    this.error.append(Messages.getString("TimesTenGrid.internalAddrFormatError"));
                    return null;
                }
                string = CloneHostPanel.this._extAddressTxtField.getText().trim();
                if (string.isEmpty()) {
                    this.error.append(Messages.getString("TimesTenGrid.noExternalAddrError"));
                    return null;
                }
                if (!Common.validAddress(string)) {
                    this.error.append(Messages.getString("TimesTenGrid.externalAddrFormatError"));
                    return null;
                }
                try {
                    String[] stringArray = new String[Common.PARAMCHECK_COUNT];
                    HostObject hostObject = CloneHostPanel.this.grid.getHost(CloneHostPanel.this.baseHostName);
                    if (hostObject.getInstances().isEmpty() && hostObject.getInstallations().isEmpty()) {
                        String string2 = SSHChannel.tryConnect(string, CloneHostPanel.this.grid.getExecutor().getWorkingHost().getInstanceAdmin(), CloneHostPanel.this.grid.getExecutor().getWorkingHost().getPwd());
                        if (CloneHostPanel.this.hostName.isEmpty()) {
                            CloneHostPanel.this.hostName = string2;
                        }
                    } else {
                        boolean[] blArray = new boolean[Common.PARAMCHECK_COUNT];
                        blArray[Common.CheckIndex.INSTDIR_IDX.ordinal()] = true;
                        for (InstanceObject instanceObject : hostObject.getInstances()) {
                            String string3;
                            stringArray[Common.CheckIndex.INSTDIR_IDX.ordinal()] = string3 = instanceObject.getHome().substring(0, instanceObject.getHome().lastIndexOf(instanceObject.getName()));
                            stringArray[Common.CheckIndex.INSTNAME_IDX.ordinal()] = instanceObject.getName();
                            String string4 = SSHChannel.tryConnect(string, CloneHostPanel.this.grid.getExecutor().getWorkingHost().getInstanceAdmin(), CloneHostPanel.this.grid.getExecutor().getWorkingHost().getPwd(), blArray, stringArray);
                            if (CloneHostPanel.this.hostName.isEmpty()) {
                                CloneHostPanel.this.hostName = string4;
                            }
                            if (!stringArray[Common.CheckIndex.INSTDIR_IDX.ordinal()].contains("$$CREATE_DIR$$") || CloneHostPanel.this.dirsToCreate.contains(string3)) continue;
                            CloneHostPanel.this.dirsToCreate.add(string3);
                        }
                    }
                    if (CloneHostPanel.this.grid.getHost(CloneHostPanel.this.hostName) != null) {
                        this.error.append(Messages.getString("TimesTenGrid.repeatedHostGrid"));
                        return null;
                    }
                }
                catch (MySSHException mySSHException) {
                    this.error.append(mySSHException.getMessage());
                }
                return null;
            }

            @Override
            protected void done() {
                customProgressMonitor.close();
                if (this.isCancelled()) {
                    return;
                }
                if (this.error.length() > 0) {
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), this.error.toString());
                } else {
                    CloneHostPanel.this._dialog.dispose();
                    CloneHostPanel.this.cloneHost();
                }
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    private void cloneHost() {
        this._progressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.cloneHostTitle"), MessageFormat.format(Messages.getString("TimesTenGrid.creatingHost"), this.hostName), null);
        this._progressMonitor.setCancellable(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    GridCommand gridCommand;
                    CharSequence charSequence;
                    String string = CloneHostPanel.this._extAddressTxtField.getText().trim();
                    GridMouseListener.expander.getExpansionState();
                    CloneHostPanel.this._progressMonitor.start();
                    if (!CloneHostPanel.this.dirsToCreate.isEmpty()) {
                        this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.createRequiredDir"), CloneHostPanel.this.hostName));
                        charSequence = new StringBuilder();
                        for (String string2 : CloneHostPanel.this.dirsToCreate) {
                            ((StringBuilder)charSequence).append(string2);
                            ((StringBuilder)charSequence).append(" ");
                        }
                        gridCommand = GridCommand.CREATE_REMOTE_DIR;
                        gridCommand.prepareCommand(string, ((StringBuilder)charSequence).toString());
                        CloneHostPanel.this.grid.getExecutor().executeSimpleCommand(gridCommand);
                    }
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.addingHost"), CloneHostPanel.this.hostName));
                    charSequence = CloneHostPanel.this.grid.getHost(CloneHostPanel.this.baseHostName).getPhysicalGroupsString().replace(",", " ");
                    if (((String)charSequence).equals(Messages.getString("TimesTenGrid.blank"))) {
                        gridCommand = GridCommand.CLONE_HOST;
                        gridCommand.prepareCommand(CloneHostPanel.this.hostName, CloneHostPanel.this._intAddressTxtField.getText().trim(), string, CloneHostPanel.this.baseHostName);
                    } else {
                        gridCommand = GridCommand.CLONE_HOST_PG;
                        gridCommand.prepareCommand(new String[]{CloneHostPanel.this.hostName, CloneHostPanel.this._intAddressTxtField.getText().trim(), string, charSequence, CloneHostPanel.this.baseHostName});
                    }
                    CloneHostPanel.this.grid.getExecutor().executeCommandGetJson(gridCommand, true);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                    CloneHostPanel.this.grid.setGridComponents(CloneHostPanel.this.grid.getExecutor().executeCommandGetJson(GridCommand.EXPORT_MODEL, true), false);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.hostCloned"));
                    this.firePropertyChange("progress", null, 100);
                }
                catch (JsonException | GridCommandException throwable) {
                    _logger.log(Level.SEVERE, throwable.getMessage());
                    this.firePropertyChange("error", null, throwable.getMessage());
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                CloneHostPanel.this._progressMonitor.finish();
                if (this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.hostCreationCancelled"));
                    CloneHostPanel.this._progressMonitor.updateMessage(Messages.getString("TimesTenGrid.hostCreationCancelled"));
                } else {
                    CloneHostPanel.this.showModelNeedsApplyWarning();
                    GridMouseListener.expander.setExpansionState();
                }
            }
        };
        swingWorker.addPropertyChangeListener(this._progressMonitor);
        this._progressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    @Override
    public void setDialog(final JEWTDialog jEWTDialog) {
        super.setDialog(jEWTDialog);
        this._dialog.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                HostObject hostObject = CloneHostPanel.this.grid.getHost(CloneHostPanel.this.baseHostName);
                if (hostObject.isMgmtHost() && CloneHostPanel.this.grid.getAllMgmtInstancesInLatest().size() > 1) {
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TimesTenGrid.moreThan2MgmtInstCloneError"), CloneHostPanel.this.baseHostName));
                    jEWTDialog.dispose();
                    return;
                }
                if (MessageDialog.getPersistence().getConfirmed(CloneHostPanel.CONFIRMATION_ID) != null) {
                    return;
                }
                if (!Common.displayOptionalConfirm(CloneHostPanel.CONFIRMATION_ID, componentEvent.getComponent(), Messages.getString("TimesTenGrid.pwdLessWarningHC"), Messages.getString("TimesTenGrid.pwdLessSSH"), null)) {
                    jEWTDialog.dispose();
                    return;
                }
                if (hostObject.isMgmtHost() && !Common.displayOptionalConfirm(CloneHostPanel.CONFIRMATION_ID, componentEvent.getComponent(), Messages.getString("TimesTenGrid.mgmtInstWarningHC"), Messages.getString("TimesTenGrid.MgmtInstance"), null)) {
                    jEWTDialog.dispose();
                }
            }
        });
    }

    private void setNames() {
        this._hostLabel.setName(Messages.getString("TimesTenGrid.hostNameLabel"));
        this._extAddressLabel.setName(Messages.getString("TimesTenGrid.externalAddrLabel"));
        this._intAddressLabel.setName(Messages.getString("TimesTenGrid.internalAddrLabel"));
        this._hostTxtField.setName("_hostTxtField", "_hostCmbBox");
        this._extAddressTxtField.setName("_extAddressTxtField", "_extAddressCmbBox");
        this._intAddressTxtField.setName("_intAddressTxtField", "_intAddressCmbBox");
        this._useDefaultCheckBox.setName(Messages.getString("TimesTenGrid.useDefault"));
    }
}

