/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonException;
import javax.swing.SwingWorker;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.Deletable;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.navigator.GridMouseListener;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.DifferenceObject;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class BasicDeletable
implements Deletable {
    private String deleteMsg;
    private String deletingObjMsg;
    private String deletingFromModelMsg;
    private String deleteCancelMsg;
    private String[] cmdArgs;
    private GridCommand cmd;
    private GridObject grid;
    private TTGridRootNode root = TTGridRootNode.getInstance();
    private CustomProgressMonitor _progressMonitor;
    private static Logger _logger = Logger.getLogger(BasicDeletable.class.getPackage().getName());

    public BasicDeletable() {
        this.grid = this.root.getGrid(this.root.getCurrentGrid());
    }

    public void setDeleteMsg(String string) {
        this.deleteMsg = string;
    }

    public void setDeletingObjMsg(String string) {
        this.deletingObjMsg = string;
    }

    public void setDeletingFromModelMsg(String string) {
        this.deletingFromModelMsg = string;
    }

    public void setDeleteCancelMsg(String string) {
        this.deleteCancelMsg = string;
    }

    public void setCmdArgs(String ... stringArray) {
        this.cmdArgs = stringArray;
    }

    public void setCmd(GridCommand gridCommand) {
        this.cmd = gridCommand;
    }

    @Override
    public void deleteObject(final Runnable runnable) {
        this._progressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), this.deleteMsg, this.deletingObjMsg, null);
        this._progressMonitor.setCancellable(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    GridMouseListener.expander.getExpansionState();
                    BasicDeletable.this._progressMonitor.start();
                    this.firePropertyChange("message", null, BasicDeletable.this.deletingFromModelMsg);
                    BasicDeletable.this.cmd.prepareCommand(BasicDeletable.this.cmdArgs);
                    BasicDeletable.this.grid.getExecutor().executeCommandGetString(BasicDeletable.this.cmd, true);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                    BasicDeletable.this.grid.refreshGridModels();
                    this.firePropertyChange("progress", null, 100);
                }
                catch (JsonException | GridCommandException throwable) {
                    _logger.log(Level.SEVERE, throwable.getMessage());
                    this.firePropertyChange("error", null, throwable.getMessage());
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                BasicDeletable.this._progressMonitor.finish();
                if (!BasicDeletable.this._progressMonitor.successfulExecution() || this.isCancelled()) {
                    this.firePropertyChange("message", null, BasicDeletable.this.deleteCancelMsg);
                } else {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    BasicDeletable.this.showModelNeedsApplyWarning();
                    GridMouseListener.expander.setExpansionState();
                    runnable.run();
                }
            }
        };
        swingWorker.addPropertyChangeListener(this._progressMonitor);
        this._progressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    private void showModelNeedsApplyWarning() {
        DifferenceObject differenceObject = this.grid.getGridCurrentModel().diff(this.grid);
        if (differenceObject.areDifferences()) {
            this.grid.getGridNode().updateIcon(false);
            if (MessageDialog.getPersistence().getConfirmed("ModelChangesID") == null) {
                MessageDialog.optionalInformation((String)"ModelChangesID", (Component)Ide.getMainWindow(), (Object)Messages.getString("TimesTenGrid.applyChangesWarn"), (String)Messages.getString("TimesTenGrid.applyChanges"), null);
            }
        }
    }
}

