/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.sql.Connection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseImpl;
import oracle.dbtools.raptor.timesten.ttdbobjects.TimestenElement;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;

public class TableDistributionTab
extends AsynchronousViewerEditor {
    JPanel internalPanel;
    private final String DISTRIBUTED_BY_DUPLICATE = Messages.getString("PartitionTablePanel.distributedByDuplicate");
    private final String DISTRIBUTED_BY_HASH = Messages.getString("PartitionTablePanel.distributedByHash");
    private final String DISTRIBUTED_BY_REFERENCE = Messages.getString("PartitionTablePanel.distributedByReference");
    private final String DISTRIBUTED_METHOD = Messages.getString("PartitionTablePanel.distributionMethod");
    private final String NOT_SUPPORTED = Messages.getString("TimesTen.common.featureNotSupported");

    protected JComponent createViewerUI() {
        this.updateHelper();
        return this.internalPanel;
    }

    private void updateHelper() {
        ViewerNode viewerNode = this.getViewerNode();
        DBObject dBObject = viewerNode.getDBObject();
        Connection connection = dBObject.getConnection();
        Connections.getInstance().lock(connection);
        if (TimesTenPlugInDatabaseImpl.isGridDatabase(connection)) {
            SchemaObject schemaObject;
            Table table;
            TimestenElement timestenElement;
            Connections.getInstance().unlock(connection);
            if (this.internalPanel == null) {
                this.internalPanel = new JPanel(new BorderLayout());
            }
            if ((timestenElement = (TimestenElement)((Object)(table = (Table)(schemaObject = dBObject.getSchemaObject())).getProperty("TIMESTENELEMENT"))).getTimestenPartitionType() == TimestenElement.TTPartitionType.DUPLICATE) {
                JPanel jPanel = new JPanel(new FlowLayout(0));
                JLabel jLabel = new JLabel(this.DISTRIBUTED_METHOD);
                JLabel jLabel2 = new JLabel(this.DISTRIBUTED_BY_DUPLICATE);
                jPanel.add(jLabel);
                jPanel.add(jLabel2);
                this.internalPanel.add((Component)jPanel, "North");
            } else if (timestenElement.getTimestenPartitionType() == TimestenElement.TTPartitionType.HASH) {
                JPanel jPanel = new JPanel(new FlowLayout(0));
                JLabel jLabel = new JLabel(this.DISTRIBUTED_METHOD);
                JLabel jLabel3 = new JLabel(this.DISTRIBUTED_BY_HASH);
                jPanel.add(jLabel);
                jPanel.add(jLabel3);
                JTable jTable = new JTable(new TableDistributionModel(table, timestenElement));
                this.internalPanel.add((Component)jPanel, "North");
                this.internalPanel.add((Component)new JScrollPane(jTable), "Center");
            } else if (timestenElement.getTimestenPartitionType() == TimestenElement.TTPartitionType.REFERENCE) {
                JPanel jPanel = new JPanel(new FlowLayout(0));
                JLabel jLabel = new JLabel(this.DISTRIBUTED_METHOD);
                JLabel jLabel4 = new JLabel(this.DISTRIBUTED_BY_REFERENCE);
                jPanel.add(jLabel);
                jPanel.add(jLabel4);
                JTable jTable = new JTable(new TableDistributionModel(table, timestenElement));
                this.internalPanel.add((Component)jPanel, "North");
                this.internalPanel.add((Component)new JScrollPane(jTable), "Center");
            }
        } else {
            Connections.getInstance().unlock(connection);
            if (this.internalPanel == null) {
                this.internalPanel = new JPanel(new FlowLayout(0));
            }
            JLabel jLabel = new JLabel(this.NOT_SUPPORTED);
            this.internalPanel.add(jLabel);
        }
    }

    protected void updateContent(boolean bl) {
        if (this.internalPanel != null) {
            this.internalPanel.removeAll();
        }
        this.updateHelper();
    }

    protected void cleanUp() {
    }

    public Object getPrintable() {
        return null;
    }

    private class TableDistributionModel
    extends AbstractTableModel {
        private int columnsNumber;
        private Column[] localColumns;
        private Column[] remoteColumns;
        private int rowNumbers;
        private final String[] HEADER = new String[]{Messages.getString("PartitionTablePanel.localColumn"), Messages.getString("PartitionTablePanel.referencedColumn")};
        private Table tableObject;
        private TimestenElement tableElement;

        public TableDistributionModel(Table table, TimestenElement timestenElement) {
            this.tableObject = table;
            this.tableElement = timestenElement;
            if (timestenElement.getTimestenPartitionType() == TimestenElement.TTPartitionType.HASH) {
                this.columnsNumber = 1;
                this.rowNumbers = timestenElement.getColumns().length;
            } else if (timestenElement.getTimestenPartitionType() == TimestenElement.TTPartitionType.REFERENCE) {
                this.columnsNumber = 2;
                String string = timestenElement.getForeignKey();
                try {
                    FKConstraint fKConstraint = (FKConstraint)table.getConstraint(string);
                    PKConstraint pKConstraint = (PKConstraint)fKConstraint.getReferenceID().resolveID();
                    this.localColumns = pKConstraint.getColumns();
                    this.remoteColumns = fKConstraint.getColumns();
                    this.rowNumbers = this.localColumns.length;
                }
                catch (DBException dBException) {
                    dBException.printStackTrace();
                }
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnsNumber;
        }

        @Override
        public int getRowCount() {
            return this.rowNumbers;
        }

        @Override
        public String getColumnName(int n) {
            return this.HEADER[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.tableElement.getTimestenPartitionType() == TimestenElement.TTPartitionType.HASH) {
                return this.tableElement.getColumns()[n];
            }
            if (this.tableElement.getTimestenPartitionType() == TimestenElement.TTPartitionType.REFERENCE) {
                if (n2 == 0) {
                    return this.localColumns[n];
                }
                if (n2 == 1) {
                    return this.remoteColumns[n];
                }
            }
            return null;
        }
    }
}

