/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.editors.TTTableViewer;

public class ReplicationStoreAttributes
extends TTTableViewer {
    private MyTableModel _model;
    private static final Logger _logger = Logger.getLogger(ReplicationStoreAttributes.class.getPackage().getName());

    @Override
    protected final String GetPurposeTxt() {
        return "replication store attributes";
    }

    @Override
    protected void createTableModel() throws Exception {
        if (this._model == null) {
            this._model = new MyTableModel();
            this._table.setModel(this._model);
        } else {
            this._model.init();
        }
        this._model.fireTableDataChanged();
    }

    @Override
    protected void postCreateHook() {
        this._table.setAutoResizeMode(3);
    }

    private class MyTableModel
    extends AbstractTableModel {
        static final int numCols = 2;
        private Vector<Object[]> theRows = new Vector(32);

        private MyTableModel() throws Exception {
            try {
                this.init();
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot profess " + ReplicationStoreAttributes.this.GetPurposeTxt() + " " + sQLException.toString());
                throw sQLException;
            }
        }

        private void init() throws Exception {
            Statement statement = null;
            ResultSet resultSet = null;
            this.theRows.clear();
            try {
                Connection connection = ReplicationStoreAttributes.this._dbObject.getConnection();
                String string = ReplicationStoreAttributes.this._dbObject.getSchemaName();
                String string2 = ReplicationStoreAttributes.this._dbObject.getObjectName();
                if (string2.equalsIgnoreCase("_ACTIVESTANDBY")) {
                    string = TimesTenUtil.getActiveStandbyOwner(connection);
                }
                statement = connection.createStatement();
                resultSet = statement.executeQuery("SELECT TT_STORE_NAME, REP_PORT_NUMBER, RRPOLICY, RRTRIGGER, RRRESUME_LATENCY, RRDURABLE, RET_LOCAL_ACTION, RET_WAIT_TIME, RET_WHEN_STOPPED, COMPRESSION, PEER_TIMEOUT, FAIL_THRESHOLD, HOST_NAME FROM TTREP.TTSTORES tts, TTREP.REPSTORES rs WHERE rs.REPLICATION_OWNER='" + string + "' AND rs.REPLICATION_NAME='" + string2 + "' AND rs.TT_STORE_ID=tts.TT_STORE_ID");
                boolean bl = false;
                while (resultSet.next()) {
                    bl = true;
                    this.theRows.add(new Object[]{Messages.getString("ReplicationStoreAttributes.storeName"), resultSet.getString(1).trim()});
                    this.theRows.add(new Object[]{Messages.getString("TimesTen.common.hostName"), resultSet.getString(13).trim()});
                    this.theRows.add(new Object[]{Messages.getString("ReplicationStoreAttributes.replicationPortNumber"), Integer.toString(resultSet.getInt(2))});
                    String string3 = resultSet.getInt(11) == 1 ? " second" : " " + Messages.getString("TimesTen.common.seconds");
                    this.theRows.add(new Object[]{Messages.getString("ReplicationStoreAttributes.replicationPeerTimeout"), Integer.toString(resultSet.getInt(11)) + string3});
                    this.theRows.add(new Object[]{Messages.getString("ReplicationStoreAttributes.replicationFailureThreshold"), Integer.toString(resultSet.getInt(12)) + Messages.getString("ReplicationStoreAttributes.acummulatedLogFiles")});
                    String string4 = resultSet.getString(10);
                    String string5 = Messages.getString("TimesTen.common.no");
                    if (string4 != null && string4.equalsIgnoreCase("Y")) {
                        string5 = Messages.getString("TimesTen.common.yes");
                    }
                    this.theRows.add(new Object[]{Messages.getString("ReplicationStoreAttributes.compressTraffic"), string5});
                    String string6 = resultSet.getString(3).trim();
                    string5 = Messages.getString("TimesTen.common.noPolicy");
                    if (string6.equals("S")) {
                        string5 = Messages.getString("ReplicationStoreAttributes.disableSingleSubscriber");
                    } else if (string6.equals("A")) {
                        string5 = Messages.getString("ReplicationStoreAttributes.disableAllSubscribers");
                    }
                    this.theRows.add(new Object[]{Messages.getString("ReplicationStoreAttributes.returnServiceFailurePolicy"), string5});
                    this.theRows.add(new Object[]{Messages.getString("ReplicationStoreAttributes.returnServiceFailureThreshold"), Integer.toString(resultSet.getInt(4))});
                    byte[] byArray = resultSet.getBytes(9);
                    string5 = Messages.getString("TimesTen.common.off");
                    if (byArray != null && byArray[0] == 0) {
                        string5 = Messages.getString("TimesTen.common.on");
                    }
                    this.theRows.add(new Object[]{Messages.getString("ReplicationStoreAttributes.returnServiceStateWhenReplicationIsStopped"), string5});
                    byte[] byArray2 = resultSet.getBytes(6);
                    if (byArray2 != null && byArray2[0] == 1) {
                        string5 = Messages.getString("TimesTen.common.on");
                    }
                    string5 = Messages.getString("TimesTen.common.off");
                    this.theRows.add(new Object[]{Messages.getString("ReplicationStoreAttributes.durableCommitsOnReturnReceiptFailure"), string5});
                    int n = resultSet.getInt(5);
                    if (!resultSet.wasNull()) {
                        string3 = n == 1 ? " second" : " seconds";
                        this.theRows.add(new Object[]{Messages.getString("ReplicationStoreAttributes.resumeReturnServiceLatency"), Integer.toString(n) + string3});
                    }
                    String string7 = resultSet.getString(7);
                    string5 = Messages.getString("TimesTen.common.noPolicy");
                    if (string7 != null && string7.equalsIgnoreCase("C")) {
                        string5 = Messages.getString("TimesTen.common.commit");
                    }
                    this.theRows.add(new Object[]{Messages.getString("ReplicationStoreAttributes.defaultCommitBehaviorForReturnTwosafeTran"), string5});
                    int n2 = resultSet.getInt(8);
                    if (!resultSet.wasNull()) {
                        string3 = n2 == 1 ? " second" : " seconds";
                        this.theRows.add(new Object[]{Messages.getString("ReplicationStoreAttributes.defaultTimeoutValueForReturnTwosafeTran"), Integer.toString(n2) + string3});
                    }
                    this.theRows.add(new Object[]{" ", " "});
                }
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "generating " + ReplicationStoreAttributes.this.GetPurposeTxt() + " failed", exception);
                throw exception;
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public final int getColumnCount() {
            return 2;
        }

        @Override
        public final int getRowCount() {
            return this.theRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n > this.theRows.size() || n2 > 2) {
                return null;
            }
            return this.theRows.get(n)[n2];
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("TimesTen.common.attribute");
            }
            if (n == 1) {
                return Messages.getString("TimesTen.common.value");
            }
            return null;
        }
    }
}

