/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.connection;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import javax.swing.text.NumberFormatter;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.dialogs.DialogBase;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.dialogs.MessageDialog;

public class TTStatsConfigurationPanel
extends DialogBase {
    private Map<String, ParameterInfo> _parameterMap;
    private List<ParameterInfo> _parameterList;
    private Connection _conn;
    private static final String _getConfigSQL = "DECLARE currentConfig tt_stats.report_table; BEGIN TT_STATS.GET_CONFIG(params=>:currentConfig); END;";
    private static final String _updateConfigSQL = "call TT_STATS.SET_CONFIG(:param, :value); ";
    private Method _registerIndexTableOutParameterMethod;
    private Method _getPlsqlIndexTableMethod;
    private NumberFormat _myIntegerFieldFormat;
    private static Logger _logger = Logger.getLogger(TTStatsConfigurationPanel.class.getPackage().getName());

    protected TTStatsConfigurationPanel(DBObject dBObject) {
        super(dBObject, null, "TTStatsConfigurationPanel");
    }

    private void initKnownParameterInfo() {
        this._myIntegerFieldFormat = new DecimalFormat("0");
        this._parameterMap = new HashMap<String, ParameterInfo>(16);
        this._parameterList = new ArrayList<ParameterInfo>(16);
        ParameterInfo parameterInfo = new ParameterInfo();
        parameterInfo._name = "MAX_SNAPSHOT_COUNT";
        parameterInfo._humanReadableName = Messages.getString("TimesTenStatistics.maximumSnapshotCount");
        parameterInfo._valueType = 1;
        this._parameterList.add(parameterInfo);
        this._parameterMap.put(parameterInfo._name, parameterInfo);
        parameterInfo = new ParameterInfo();
        parameterInfo._name = "MAX_SNAPSHOT_RETENTION_SIZE";
        parameterInfo._humanReadableName = Messages.getString("TimesTenStatistics.maximumSnapshotRetentionSize");
        parameterInfo._valueType = 1;
        this._parameterList.add(parameterInfo);
        this._parameterMap.put(parameterInfo._name, parameterInfo);
    }

    @Override
    public boolean validateValues() {
        for (ParameterInfo parameterInfo : this._parameterList) {
            if (parameterInfo._valueType == 1) {
                try {
                    Integer.parseInt(parameterInfo._textField.getText());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    String string = Messages.getString("TimesTenStatistics.notValidInputForField");
                    string = parameterInfo._humanReadableName != null ? string.replace("{0}", parameterInfo._humanReadableName) : string.replace("{0}", parameterInfo._name);
                    MessageDialog.error(null, (Object)string, (String)Messages.getString("TimesTen.common.error"), null);
                    return false;
                }
            }
            if (parameterInfo._textField.getText().length() != 0) continue;
            String string = Messages.getString(" TimesTenStatistics.pleaseEnterValue");
            string = parameterInfo._humanReadableName != null ? string.replace("{0}", parameterInfo._humanReadableName) : string.replace("{0}", parameterInfo._name);
            MessageDialog.error(null, (Object)string, (String)Messages.getString("TimesTen.common.error"), null);
            return false;
        }
        return true;
    }

    @Override
    protected void initGUI() {
    }

    private void discoverCustomMethods(Object object) {
        try {
            if (this._registerIndexTableOutParameterMethod == null) {
                this._registerIndexTableOutParameterMethod = object.getClass().getMethod("registerIndexTableOutParameter", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            if (this._getPlsqlIndexTableMethod == null) {
                this._getPlsqlIndexTableMethod = object.getClass().getMethod("getPlsqlIndexTable", Integer.TYPE);
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "Exception during method discovery", exception);
        }
    }

    @Override
    protected void initModel(DBObject dBObject) {
        this.initKnownParameterInfo();
        this._conn = dBObject.getConnection();
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void doInBackground() {
                CallableStatement callableStatement = null;
                Connections.getInstance().lock(TTStatsConfigurationPanel.this._conn);
                try {
                    callableStatement = TTStatsConfigurationPanel.this._conn.prepareCall(TTStatsConfigurationPanel._getConfigSQL);
                    TTStatsConfigurationPanel.this.discoverCustomMethods(callableStatement);
                    TTStatsConfigurationPanel.this._registerIndexTableOutParameterMethod.invoke((Object)callableStatement, 1, 64, 12, Short.MAX_VALUE);
                    callableStatement.execute();
                    SQLWarning sQLWarning = callableStatement.getWarnings();
                    if (sQLWarning == null) {
                        Object object = TTStatsConfigurationPanel.this._getPlsqlIndexTableMethod.invoke((Object)callableStatement, 1);
                        String[] stringArray = (String[])object;
                        int n = 0;
                        for (String string : stringArray) {
                            String string2;
                            String[] stringArray2;
                            if (++n <= 2 || (stringArray2 = string.trim().split("\\s+")).length < 2) continue;
                            if (TTStatsConfigurationPanel.this._parameterMap.get(stringArray2[0].trim()) == null) {
                                string2 = stringArray2[0].trim();
                                ParameterInfo parameterInfo = new ParameterInfo();
                                parameterInfo._name = string2;
                                TTStatsConfigurationPanel.this._parameterMap.put(string2, parameterInfo);
                                TTStatsConfigurationPanel.this._parameterList.add(parameterInfo);
                            } else {
                                string2 = ((ParameterInfo)TTStatsConfigurationPanel.this._parameterMap.get(stringArray2[0].trim()))._humanReadableName;
                            }
                            ((ParameterInfo)TTStatsConfigurationPanel.this._parameterMap.get(stringArray2[0].trim()))._initialValue = stringArray2[1].trim();
                        }
                    } else {
                        _logger.log(Level.SEVERE, "Warnings in prepared statement", sQLWarning);
                    }
                }
                catch (SQLException sQLException) {
                    _logger.log(Level.SEVERE, "Couldn't get configuration", sQLException);
                    MessageDialog.error(null, (Object)TTSQLExceptionScrubber.getInstance().getMessage(TTStatsConfigurationPanel.this._conn, TTStatsConfigurationPanel._getConfigSQL, sQLException), (String)Messages.getString("TimesTen.common.error"), null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    _logger.log(Level.SEVERE, "Couldn't access to discovered method", illegalAccessException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    _logger.log(Level.SEVERE, "Bad arguments passed to discovered method", illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    _logger.log(Level.SEVERE, "Couldn't invoke to discovered method", invocationTargetException);
                }
                finally {
                    if (callableStatement != null) {
                        try {
                            callableStatement.close();
                        }
                        catch (SQLException sQLException) {
                            _logger.log(Level.SEVERE, "Statement couldn't be closed ", sQLException);
                        }
                        Connections.getInstance().unlock(TTStatsConfigurationPanel.this._conn);
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                JFormattedTextField jFormattedTextField = null;
                for (ParameterInfo parameterInfo : TTStatsConfigurationPanel.this._parameterList) {
                    JLabel jLabel;
                    if (parameterInfo._humanReadableName != null && parameterInfo._valueType == 1) {
                        jLabel = new JLabel(parameterInfo._humanReadableName);
                        jFormattedTextField = new JFormattedTextField(new NumberFormatter(TTStatsConfigurationPanel.this._myIntegerFieldFormat));
                    } else {
                        jLabel = new JLabel(parameterInfo._name);
                        jFormattedTextField = new JFormattedTextField();
                    }
                    jFormattedTextField.setText(parameterInfo._initialValue);
                    parameterInfo._label = jLabel;
                    parameterInfo._textField = jFormattedTextField;
                    TTStatsConfigurationPanel.this.addRow(jLabel, (Component)jFormattedTextField);
                }
                TTStatsConfigurationPanel.this.doLayout();
                TTStatsConfigurationPanel.this.repaint();
            }
        };
        swingWorker.execute();
    }

    @Override
    public String getSql() {
        StringBuffer stringBuffer = new StringBuffer();
        for (ParameterInfo parameterInfo : this._parameterList) {
            if (parameterInfo._textField == null || parameterInfo._name == null) continue;
            stringBuffer.append(_updateConfigSQL.replace(":param", '\'' + parameterInfo._name + '\'').replace(":value", parameterInfo._textField.getText()));
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    private class ParameterInfo {
        private static final int INTEGER = 1;
        private String _name;
        private String _humanReadableName;
        private JLabel _label;
        private JFormattedTextField _textField;
        private String _initialValue;
        private int _valueType;

        private ParameterInfo() {
        }
    }
}

