/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.commands;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.query.QueryCache;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseImpl;
import oracle.dbtools.raptor.timesten.connection.TTSQLExceptionListener;
import oracle.dbtools.raptor.timesten.editors.ViewMetaDataViewer;
import oracle.dbtools.raptor.utils.Connections;

public class Describe
extends CommandListener {
    private final String FT_STR_DELIM = "#";
    private final int SB_TBL_FLAG_PROPAGATE = 1;
    private final int SB_TBL_FLAG_READONLY = 2;
    private final int SB_TBL_FLAG_AGING_LRU = 2048;
    private final int SB_TBL_FLAG_AGING_TIMEBASED = 4096;
    private final int SB_TBL_FLAG_AGING_ENABLED = 16384;
    private final int TT_SMALLINT = 1;
    private final int TT_INTEGER = 2;
    private final int BINARY_FLOAT = 3;
    private final int BINARY_DOUBLE = 4;
    private final int TT_CHAR = 5;
    private final int tt_VARCHAR = 6;
    private final int BINARY = 7;
    private final int VARBINARY = 8;
    private final int TT_TIMESTAMP = 16;
    private final int TT_TINYINT = 20;
    private final int TT_BIGINT = 21;
    private final int TT_VARCHAR = 22;
    private final int NUMBER = 25;
    private final int CHAR = 26;
    private final int VAR_CHAR2 = 27;
    private final int VARCHAR2 = 32;
    public static final String DESCRIBE_ENCODING = "UTF-8";
    private static final String THE_EMPTY_STRING;
    private static final String DESCRIBE_TITLE = "Name                           Null     Type \n";
    private static final String DESCRIBE_UNDERLINE = "------------------------------ -------- -----------------------------------------------------------------------------------------------------------\n";
    private static final String SYS_USER = "SYS";
    private static final String TTREP_USER = "TTREP";
    private static final String UNKNOWN = "UNKNOWN";

    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Connections connections = Connections.getInstance();
        if (!connections.isTimesTen(connection)) {
            return false;
        }
        TTSQLExceptionListener tTSQLExceptionListener = TTSQLExceptionListener.getTheInstance();
        String string = null;
        String string2 = null;
        for (int i = 0; i < 3; ++i) {
            boolean bl = false;
            try {
                String[] stringArray;
                String string3 = connection.getMetaData().getUserName();
                string2 = iSQLCommand.getSql();
                if (string2 == null || string2.toUpperCase().indexOf("DESC") != 0 || (stringArray = string2.split("\\s+")).length < 2) continue;
                String string4 = connection.getMetaData().getURL().toString();
                String string5 = string4.substring(string4.indexOf("DSN=") + 4);
                if (string5.indexOf(";") > 0) {
                    string5 = string5.substring(0, string5.indexOf(";"));
                }
                int n = stringArray[1].indexOf(";");
                String string6 = null;
                string6 = n != -1 ? stringArray[1].substring(0, n) : stringArray[1];
                string6 = string6.toUpperCase();
                List<String> list = this.executeDescribeSql(connection, string6, string3);
                scriptRunnerContext.getOutputStream().write(("\n" + iSQLCommand.getSql() + "\n").getBytes(DESCRIBE_ENCODING));
                for (String string7 : list) {
                    scriptRunnerContext.getOutputStream().write(string7.getBytes(DESCRIBE_ENCODING));
                }
                boolean bl2 = true;
                return bl2;
            }
            catch (SQLException sQLException) {
                if (tTSQLExceptionListener.isTransientFailoverException(sQLException, connection) && i < 2) {
                    try {
                        scriptRunnerContext.getOutputStream().write((MessageFormat.format(Messages.getString("TimesTenFailover.retryAttempt"), i + 1) + "\n").getBytes(DESCRIBE_ENCODING));
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                    }
                }
                bl = true;
                string = TTSQLExceptionScrubber.getMessage(sQLException.getLocalizedMessage(), string2);
                return (boolean)string;
            }
            catch (Exception exception) {
                bl = true;
                string = TTSQLExceptionScrubber.getMessage(exception.getLocalizedMessage(), string2);
                return (boolean)string;
            }
            finally {
                if (!bl) continue;
                try {
                    scriptRunnerContext.getOutputStream().write(("\n" + string2.trim() + " " + Messages.getString("TimesTenCommand.failed") + "\n" + string + "\n").getBytes(DESCRIBE_ENCODING));
                }
                catch (Exception exception) {}
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private List<String> executeDescribeSql(Connection connection, String string, String string2) throws SQLException, Exception {
        Object object;
        String string3;
        Statement statement = null;
        ArrayList<String> arrayList = new ArrayList<String>(32);
        String[] stringArray = string.split("\\.", 2);
        if (stringArray.length > 1) {
            string3 = stringArray[0];
            string = stringArray[1];
        } else {
            string3 = string2;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(string3);
        if (!arrayList2.contains(SYS_USER)) {
            arrayList2.add(SYS_USER);
        }
        if (!arrayList2.contains(TTREP_USER)) {
            arrayList2.add(TTREP_USER);
        }
        boolean bl = false;
        String string4 = "";
        for (String exception : arrayList2) {
            void object22;
            Object object2;
            string4 = Describe.getObjectType(connection, exception, string);
            if (string4.equals("")) continue;
            if (arrayList.size() > 0) {
                arrayList.add("\n");
            }
            if (string4.equalsIgnoreCase("BUILT-IN PROCEDURE")) {
                arrayList.add(string4 + " " + string + ":\n");
            } else {
                arrayList.add(string4 + " " + exception + "." + string + ":\n");
            }
            if (string4.equalsIgnoreCase("SYNONYM")) {
                while (string4.equalsIgnoreCase("SYNONYM")) {
                    object2 = "select rtrim(table_owner), rtrim(table_name) from sys.all_synonyms where (rtrim(owner) = :OBJECT_OWNER) and (rtrim(synonym_name) = :OBJECT_NAME)";
                    object2 = Describe.fixupNameAndOwner((String)object2, (String)object22, string);
                    statement = connection.createStatement();
                    ResultSet resultSet = statement.executeQuery((String)object2);
                    if (resultSet.next()) {
                        String string5;
                        String string6 = resultSet.getString(1);
                        String string7 = Describe.getObjectType(connection, string6, string5 = resultSet.getString(2));
                        if (!string7.equalsIgnoreCase("SYNONYM")) {
                            arrayList.add("For " + string7 + " " + string6 + "." + string5 + "\n");
                        }
                        string4 = string7;
                        string = string5;
                        String string8 = string6;
                    }
                    statement.close();
                }
                bl = true;
            }
            if (string4.equalsIgnoreCase("TABLE") || string4.equalsIgnoreCase("MATERIALIZED VIEW")) {
                this.describeTableMV(connection, string, (String)object22, arrayList);
                bl = true;
            }
            if (string4.equalsIgnoreCase("VIEW")) {
                object2 = ViewMetaDataViewer.getViewMetaData(connection, (String)object22, string);
                int n = ((ViewMetaDataViewer.MyTableModel)object2).getNoColumns();
                for (int i = 0; i < n; ++i) {
                    Describe.formatData(arrayList, (String)((ViewMetaDataViewer.MyTableModel)object2).getValueAt(i, 0), (String)((ViewMetaDataViewer.MyTableModel)object2).getValueAt(i, 1), (String)((ViewMetaDataViewer.MyTableModel)object2).getValueAt(i, 2));
                }
                arrayList.add("\n");
                bl = true;
            }
            if (string4.equalsIgnoreCase("SEQUENCE")) {
                this.describeSequence(connection, string, (String)object22, arrayList);
                bl = true;
            }
            if (string4.equalsIgnoreCase("CACHE GROUP")) {
                this.describeCG(connection, string, (String)object22, arrayList);
                bl = true;
            }
            if (string4.equalsIgnoreCase("PACKAGE")) {
                this.describePackage(connection, string, (String)object22, arrayList);
                bl = true;
            }
            if (string4.equalsIgnoreCase("FUNCTION") || string4.equalsIgnoreCase("PROCEDURE")) {
                this.describeFUNPROC(connection, string, string4, (String)object22, arrayList);
                bl = true;
            }
            if (!string4.equalsIgnoreCase("BUILT-IN PROCEDURE")) continue;
            this.describeBIP(connection, string, arrayList);
            bl = true;
            break;
        }
        if (bl) {
            object = arrayList;
            return object;
        }
        object = string4.equals("") ? String.format(Messages.getString("Describe.objNotFound"), string3 + "." + string) : String.format(Messages.getString("Describe.noInfo"), string3 + "." + string);
        arrayList.clear();
        arrayList.add((String)object);
        ArrayList<String> arrayList3 = arrayList;
        return arrayList3;
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void describeFUNPROC(Connection connection, String string, String string2, String string3, List<String> list) throws SQLException {
        Statement statement = null;
        String string4 = "select position,argument_name,in_out,data_type from all_arguments where owner = :OBJECT_OWNER and object_name = :OBJECT_NAME and package_name is null";
        String string5 = Describe.fixupNameAndOwner(string4, string3, string);
        try {
            Object object;
            String[] stringArray;
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string5);
            int n = 0;
            Hashtable<String[], String[]> hashtable = new Hashtable<String[], String[]>();
            while (resultSet.next()) {
                stringArray = resultSet.getString(1).trim();
                object = resultSet.getString(2);
                String string6 = resultSet.getString(3);
                String string7 = resultSet.getString(4);
                if (object == null) {
                    object = "<return value>";
                }
                hashtable.put(stringArray, new String[]{object, string7, string6});
                ++n;
            }
            if (n == 0) {
                list.add("    (none)\n");
            } else {
                int n2;
                int n3;
                int n4;
                stringArray = new String[]{"Argument Name", "Type", "In/Out"};
                object = new int[]{0, 0, 0};
                for (int i = 0; i < 3; ++i) {
                    object[i] = stringArray[i].length();
                }
                String string8 = "";
                int n5 = 1;
                int n6 = n;
                if (string2.equalsIgnoreCase("FUNCTION")) {
                    --n5;
                    --n6;
                }
                for (n4 = n5; n4 <= n6; ++n4) {
                    String[] stringArray2 = (String[])hashtable.get(n4 + "");
                    if (stringArray2 == null) continue;
                    for (n3 = 0; n3 < 3; ++n3) {
                        object[n3] = Math.max((int)object[n3], stringArray2[n3].length());
                    }
                }
                for (n4 = 0; n4 < 3; ++n4) {
                    string8 = string8 + "%-" + (int)object[n4] + "s ";
                }
                string8 = "" + string8.trim() + "\n";
                list.add(String.format(string8, stringArray[0], stringArray[1], stringArray[2]));
                StringBuffer stringBuffer = new StringBuffer();
                for (n2 = 0; n2 < 3; ++n2) {
                    for (n3 = 0; n3 < object[n2]; ++n3) {
                        stringBuffer.append("-");
                    }
                    stringBuffer.append(" ");
                }
                stringBuffer.append("\n");
                list.add(stringBuffer.toString());
                for (n2 = n5; n2 <= n6; ++n2) {
                    String[] stringArray3 = (String[])hashtable.get(n2 + "");
                    list.add(String.format(string8, stringArray3[0], stringArray3[1], stringArray3[2]));
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void describeBIP(Connection connection, String string, List<String> list) throws SQLException {
        String string2 = "call ttProcedureCols('" + string + "')";
        CallableStatement callableStatement = null;
        try {
            callableStatement = connection.prepareCall(string2);
            callableStatement.execute();
            ResultSet resultSet = callableStatement.getResultSet();
            Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
            int n = 0;
            int n2 = -1;
            while (resultSet.next()) {
                String string3 = resultSet.getString(4);
                int n3 = Integer.parseInt(resultSet.getString(5));
                int n4 = Integer.parseInt(resultSet.getString(6));
                String string4 = resultSet.getString(8);
                String string5 = resultSet.getString(9);
                String string6 = resultSet.getString(10);
                String string7 = resultSet.getString(12);
                if (n2 == -1 || n2 != n3) {
                    if (hashtable.size() > 0) {
                        list.addAll(this.getArgumentStrings(hashtable, 2));
                    }
                    if (n3 == 0) {
                        list.add("  Columns:\n");
                    } else {
                        list.add("  Parameters:\n");
                    }
                    n2 = n3;
                    hashtable.clear();
                    n = 0;
                }
                hashtable.put(String.valueOf(n++), new String[]{string3, this.getDataType(n4, string4, string5, string6, string7)});
            }
            if (n2 == -1) {
                list.add("  (none)\n");
            } else {
                list.addAll(this.getArgumentStrings(hashtable, 2));
            }
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void describePackage(Connection connection, String string, String string2, List<String> list) throws SQLException {
        Statement statement = null;
        String string3 = "select owner, argument_name, data_type, defaulted,in_out, char_length, data_precision, data_scale, type_owner, type_name, type_subname, position, subprogram_id, object_name from sys.all_arguments where owner = :OBJECT_OWNER and package_name = :OBJECT_NAME";
        string3 = Describe.fixupNameAndOwner(string3, string2, string);
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            int n = -1;
            Hashtable<String, Object> hashtable = new Hashtable<String, String[]>();
            int n2 = 0;
            while (resultSet.next()) {
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                String string6 = resultSet.getString(4);
                String string7 = resultSet.getString(5);
                String string8 = resultSet.getString(6);
                String string9 = resultSet.getString(7);
                String string10 = resultSet.getString(8);
                String string11 = resultSet.getString(8);
                String string12 = resultSet.getString(10);
                String string13 = resultSet.getString(11);
                String string14 = resultSet.getString(12);
                int n3 = Integer.parseInt(string14);
                int n4 = Integer.parseInt(resultSet.getString(13));
                String string15 = resultSet.getString(14);
                StringBuilder stringBuilder = new StringBuilder();
                if (n4 != n) {
                    n = n4;
                    if (hashtable.size() > 0) {
                        list.addAll(this.getArgumentStrings(hashtable, 3));
                    }
                    hashtable = new Hashtable();
                    n2 = 0;
                    if (n3 == 0 && string7.equalsIgnoreCase("OUT")) {
                        list.add("\n  Function " + string15 + ":\n");
                    } else {
                        list.add("\n  Procedure " + string15 + ":\n");
                    }
                }
                if (n3 == 0) {
                    string4 = "<return value>";
                } else if (string5 == null || string5.equals("")) {
                    stringBuilder.append("      (none)\n");
                    list.add(stringBuilder.toString());
                    continue;
                }
                stringBuilder.append(string5);
                if (string8 != null && !string8.equals("") && Integer.parseInt(string8) > 0) {
                    stringBuilder.append("(");
                    stringBuilder.append(string8);
                    stringBuilder.append(")");
                }
                if (string9 != null && !string9.equals("")) {
                    stringBuilder.append("(");
                    stringBuilder.append(string9);
                    if (string10 != null && !string10.equals("")) {
                        stringBuilder.append(",");
                        stringBuilder.append(string10);
                    }
                    stringBuilder.append(")");
                }
                if (!(string12 == null || string12.equals("") || string11 == null || string11.equals("") || string13 == null || string13.equals(""))) {
                    stringBuilder.append(" ");
                    stringBuilder.append(string11);
                    stringBuilder.append(".");
                    stringBuilder.append(string12);
                    stringBuilder.append(".");
                    stringBuilder.append(string13);
                }
                if (string6 != null && string6.startsWith("Y")) {
                    string7 = string7 + " DEFAULTED";
                }
                hashtable.put(String.valueOf(n2++), new String[]{string4, stringBuilder.toString(), string7});
            }
            if (hashtable.size() > 0) {
                list.addAll(this.getArgumentStrings(hashtable, 3));
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void describeCG(Connection connection, String string, String string2, List<String> list) throws SQLException, Exception {
        Statement statement = null;
        String string3 = "select sys3 as where_clauses, sys4 as table_names, cgduration, refresh_mode, refresh_state, refresh_interval, cgattributes from sys.cache_group where cgowner = :OBJECT_OWNER and cgname = :OBJECT_NAME";
        string3 = Describe.fixupNameAndOwner(string3, string2, string);
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                String string4 = resultSet.getString(1);
                String string5 = resultSet.getString(2);
                String string6 = resultSet.getString(3);
                String string7 = resultSet.getString(4);
                String string8 = resultSet.getString(5);
                String string9 = resultSet.getString(6);
                list.add("  Cache Group Type: " + this.getCgType(resultSet.getString(7)));
                if (!string6.equals("0")) {
                    StringBuffer stringBuffer = new StringBuffer("  Duration: ");
                    stringBuffer.append(string6);
                    stringBuffer.append(" Minute");
                    if (!string6.equals("1")) {
                        stringBuffer.append("s");
                    }
                    stringBuffer.append("\n");
                    list.add(stringBuffer.toString());
                }
                if (string7.equalsIgnoreCase("N")) {
                    list.add("  Autorefresh: No\n");
                } else {
                    list.add("  Autorefresh: Yes\n");
                    boolean bl = false;
                    if (string7.equalsIgnoreCase("I")) {
                        bl = true;
                        list.add("  Autorefresh Mode: Incremental\n");
                    } else if (string7.equalsIgnoreCase("F")) {
                        list.add("  Autorefresh Mode: Full\n");
                    }
                    if (string8.equalsIgnoreCase("N")) {
                        list.add("  Autorefresh State: Off\n");
                    } else if (string8.equalsIgnoreCase("Y")) {
                        list.add("  Autorefresh State: On\n");
                    } else if (string8.equalsIgnoreCase("P")) {
                        list.add("  Autorefresh State: Paused\n");
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    double d = Double.parseDouble(string9);
                    if (d < 1000.0) {
                        stringBuffer.append(" Millisecond");
                    } else if (d < 60000.0) {
                        d /= 1000.0;
                        stringBuffer.append(" Second");
                    } else {
                        d /= 60000.0;
                        stringBuffer.append(" Minute");
                    }
                    if (d != 1.0) {
                        stringBuffer.append("s");
                    }
                    stringBuffer.append("\n");
                    list.add("  Autorefresh Interval: " + String.valueOf((int)d) + stringBuffer.toString());
                    if (bl) {
                        list.add("  Autorefresh Status: " + this.getCgStatus(connection, string, string2));
                    }
                }
                list.addAll(this.getCgTableInfo(connection, string5, string4));
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void describeSequence(Connection connection, String string, String string2, List<String> list) throws SQLException {
        Statement statement = null;
        boolean bl = TimesTenPlugInDatabaseImpl.isGridDatabase(connection);
        String string3 = bl ? "select owner, name, maxval, minval, lastnumber, increment, cycle, cachesize, batchsize from sys.sequences where owner = :OBJECT_OWNER and name = :OBJECT_NAME" : "select owner, name, maxval, minval, lastnumber, increment, cycle, cachesize from sys.sequences where owner = :OBJECT_OWNER and name = :OBJECT_NAME";
        string3 = Describe.fixupNameAndOwner(string3, string2, string);
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                list.add("  Minimum Value: " + resultSet.getString(4) + "\n");
                list.add("  Maximum Value: " + resultSet.getString(3) + "\n");
                list.add("  Current Value: " + resultSet.getString(5) + "\n");
                list.add("  Increment:     " + resultSet.getString(6) + "\n");
                list.add("  Cache:         " + resultSet.getString(8) + "\n");
                String string4 = resultSet.getString(7);
                if (string4.equals("01") || string4.equalsIgnoreCase("Y")) {
                    list.add("  Cycle:         On\n");
                } else {
                    list.add("  Cycle:         Off\n");
                }
                if (bl) {
                    list.add("  Batch:         " + resultSet.getString(9) + "\n");
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void describeTableMV(Connection connection, String string, String string2, List<String> list) throws SQLException {
        Statement statement = null;
        String string3 = "select tblname from sys.tables t where ((tblowner = :OBJECT_OWNER) and (tblname =  :OBJECT_NAME) and (SYS25 & 2097152 = 2097152))";
        string3 = Describe.fixupNameAndOwner(string3, string2, string);
        try {
            int n;
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            boolean bl = resultSet.next();
            String string4 = QueryCache.getQuery((String)"timesten.table.metadata").getSql();
            String string5 = Describe.fixupNameAndOwner(string4, string2, string);
            if (statement != null) {
                statement.close();
            }
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string5);
            char[] cArray = new char[128];
            for (n = 0; n < cArray.length; ++n) {
                cArray[n] = 32;
            }
            n = resultSet.next() ? 1 : 0;
            int n2 = 0;
            if (n != 0) {
                ++n2;
                list.add(DESCRIBE_TITLE);
                list.add(DESCRIBE_UNDERLINE);
                do {
                    Describe.formatData(list, resultSet.getString(1), resultSet.getString(2), resultSet.getString(3));
                } while (resultSet.next());
                if (bl) {
                    list.add("  Has a materialized view log\n");
                }
                if (TimesTenPlugInDatabaseImpl.isGridDatabase(connection)) {
                    this.describeTableDistributionMode(connection, string, string2, list);
                }
                list.add("\n" + n2 + " rows selected\n");
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void describeTableDistributionMode(Connection connection, String string, String string2, List<String> list) throws SQLException {
        Statement statement = null;
        String string3 = "select distributionmode from sys.tables t where ((tblowner = :OBJECT_OWNER) and (tblname =  :OBJECT_NAME))";
        string3 = Describe.fixupNameAndOwner(string3, string2, string);
        try {
            String string4;
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            boolean bl = resultSet.next();
            if (bl && !DistributionMode.getDistType(Integer.parseInt(string4 = resultSet.getString(1))).equals(UNKNOWN)) {
                list.add("DISTRIBUTE BY " + DistributionMode.getDistType(Integer.parseInt(string4)));
                if (DistributionMode.getDistType(Integer.parseInt(string4)).equals(DistributionMode.DISTRIBUTION_HASH_TYPE.getMode())) {
                    this.partitionDistributionHash(connection, string, string2, list);
                } else if (DistributionMode.getDistType(Integer.parseInt(string4)).equals(DistributionMode.DISTRIBUTION_REFERENCE_TYPE.getMode()) || DistributionMode.getDistType(Integer.parseInt(string4)).equals(DistributionMode.DISTRIBUTION_REFERENCE_N_TYPE.getMode())) {
                    this.partitionDistributionReference(connection, string, string2, list);
                }
                list.add("\n");
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void partitionDistributionHash(Connection connection, String string, String string2, List<String> list) throws SQLException {
        Statement statement = null;
        boolean bl = true;
        String string3 = "select rtrim(c.COLNAME),c.distpos from tables t,  columns c WHERE rtrim(t.tblowner) = :OBJECT_OWNER  and rtrim(t.tblname) = :OBJECT_NAME and t.tblid=c.id order by c.distpos";
        string3 = Describe.fixupNameAndOwner(string3, string2, string);
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                int n = resultSet.getInt(2);
                if (n <= 0) continue;
                if (bl && !resultSet.getString(1).contains("ROWKEY#")) {
                    String string4 = resultSet.getString(1);
                    list.add(" (" + string4);
                    bl = false;
                    continue;
                }
                if (resultSet.getString(1).contains("ROWKEY#")) continue;
                list.add(", " + resultSet.getString(1));
            }
            if (!bl) {
                list.add(")");
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void partitionDistributionReference(Connection connection, String string, String string2, List<String> list) throws SQLException {
        Statement statement = null;
        String string3 = "SELECT DISTINCT rtrim(i.ixname) FROM TABLES t, indexes i, columns c WHERE rtrim(t.tblowner) = :OBJECT_OWNER and rtrim(t.tblname) = :OBJECT_NAME and t.tblid=c.id and t.tblid=i.tblid and (t.distributionmode = 6 or t.distributionmode = 7) and i.sys9 & 16384 <> 0";
        string3 = Describe.fixupNameAndOwner(string3, string2, string);
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                String string4 = resultSet.getString(1);
                list.add(" (" + string4 + ")");
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private List<String> getArgumentStrings(Hashtable<String, String[]> hashtable, int n) {
        int n2;
        int n3;
        int[] nArray;
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>(10);
        String[] stringArray2 = new String[]{"", ""};
        String[] stringArray3 = new String[]{"Argument Name", "Type", "In/Out"};
        int[] nArray2 = new int[]{0, 0};
        int[] nArray3 = new int[]{0, 0, 0};
        if (n == 2) {
            stringArray = stringArray2;
            nArray = nArray2;
        } else {
            stringArray = stringArray3;
            nArray = nArray3;
        }
        for (int i = 0; i < n; ++i) {
            nArray[i] = stringArray[i].length();
        }
        String string = "";
        int n4 = hashtable.size();
        for (n3 = 0; n3 < n4; ++n3) {
            String[] stringArray4 = hashtable.get(n3 + "");
            if (stringArray4 == null) continue;
            for (n2 = 0; n2 < n; ++n2) {
                if (stringArray4[n2] == null) continue;
                nArray[n2] = Math.max(nArray[n2], stringArray4[n2].length());
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            string = string + "%-" + nArray[n3] + "s ";
        }
        if (n == 3) {
            string = "  " + string.trim() + "\n";
            arrayList.add(String.format(string, stringArray[0], stringArray[1], stringArray[2]));
            StringBuffer stringBuffer = new StringBuffer("  ");
            for (int i = 0; i < n; ++i) {
                for (n2 = 0; n2 < nArray[i]; ++n2) {
                    stringBuffer.append("-");
                }
                stringBuffer.append(" ");
            }
            stringBuffer.append("\n");
            arrayList.add(stringBuffer.toString());
        } else {
            string = "    " + string.trim() + "\n";
        }
        for (int i = 0; i < n4; ++i) {
            String[] stringArray5 = hashtable.get(i + "");
            if (stringArray5 == null) continue;
            if (n == 3) {
                arrayList.add(String.format(string, stringArray5[0], stringArray5[1], stringArray5[2]));
                continue;
            }
            if (n != 2) continue;
            arrayList.add(String.format(string, stringArray5[0], stringArray5[1]));
        }
        arrayList.add("\n");
        return arrayList;
    }

    private String getCgType(String string) {
        String string2 = "(unknown)";
        int n = string.charAt(3) - 48;
        if (string.startsWith("08")) {
            string2 = "User Managed (Restricted)";
        } else if (string.startsWith("04")) {
            string2 = "User Managed";
        } else if (string.startsWith("05")) {
            string2 = "Read Only";
        } else if (string.startsWith("02")) {
            String string3 = string.substring(4).trim();
            string2 = string3.startsWith("00") ? "Synchronous Writethrough" : (string3.startsWith("01") ? "Asynchronous Writethrough" : (string3.startsWith("03") ? "Asynchronous Writethrough Insert Only" : "Unknown Writethrough"));
            if ((string3 = string3.substring(3).trim()).startsWith("5") || string3.startsWith("6")) {
                string2 = string2 + " global";
            }
        } else if (string.startsWith("01")) {
            string2 = "Read Only";
        } else if (string.startsWith("00")) {
            string2 = "User Managed";
        }
        string = string.substring(2).trim();
        if (string.startsWith("02")) {
            string2 = string2 + " (Dynamic)";
        } else if ((n & 2) != 0) {
            string2 = string2 + " (Dynamic)";
        }
        return string2 + "\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCgStatus(Connection connection, String string, String string2) throws SQLException {
        CallableStatement callableStatement = null;
        String string3 = "call ttCacheDbCgStatus('" + string2 + "','" + string + "');";
        String string4 = "";
        try {
            callableStatement = connection.prepareCall(string3);
            callableStatement.execute();
            ResultSet resultSet = callableStatement.getResultSet();
            if (resultSet.next()) {
                string4 = resultSet.getString(2);
            }
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return string4.equals("") ? "Ok\n" : string4 + "\n";
    }

    private List<String> getCgTableInfo(Connection connection, String string, String string2) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        String[] stringArray = string.split("#");
        String[] stringArray2 = string2.split("#");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i].split("\\.");
            if (i == 0) {
                arrayList.add(this.getCgAgingInfo(connection, stringArray3[0], stringArray3[1]));
                arrayList.add("\n  Root Table: " + stringArray[i]);
            } else {
                String[] stringArray4 = stringArray[i].split(",");
                arrayList.add("\n  Child Table: " + stringArray4[0]);
            }
            if (i < stringArray2.length && !stringArray2[i].equals("")) {
                arrayList.add("\n  Where Clause: " + stringArray2[i].trim());
            }
            arrayList.add("\n  Table Type: " + this.getTableCacheType(connection, stringArray3[0], stringArray3[1]));
        }
        arrayList.add("\n");
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTableCacheType(Connection connection, String string, String string2) throws SQLException {
        Statement statement = null;
        String string3 = "(unknown)";
        int n = 3;
        String string4 = "select sys25 & " + n + " from sys.tables where tblowner = :OBJECT_OWNER and tblname = :OBJECT_NAME";
        string4 = Describe.fixupNameAndOwner(string4, string, string2);
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string4);
            if (resultSet.next()) {
                int n2 = Integer.parseInt(resultSet.getString(1));
                if (n2 == 0) {
                    string3 = "Not Propagate";
                } else if (n2 == 1) {
                    string3 = "Propagate";
                } else if (n2 == 2) {
                    string3 = "Read Only";
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
        return string3 + "\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCgAgingInfo(Connection connection, String string, String string2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        Statement statement = null;
        Statement statement2 = null;
        int n = 6144;
        String string3 = "select case when t.sys25 & 2048 <> 0 then '  Aging: LRU ' when t.sys25 & 4096 <> 0 then '  Aging: Timestamp based uses column ' || RTRIM(c.colname)  || ' ' else '' end,case when t.sys25 & 4096 <> 0 then 'lifetime ' || to_char(T.SYS47) || case t.sys49 WHEN 0 then ' day' when 1 then ' hour' when 2 then ' minute' end || case when t.sys47 = 1 then ' ' else 's ' end else '' end, t.sys47, case when t.sys25 & 4096 <> 0 then 'cycle ' || to_char(t.sys48) || case t.sys50 when 0 then ' day' when 1 then ' hour' when 2 then ' minute' end || case when t.sys48 = 1 then ' ' else 's ' end else '' end, t.sys48, case when t.sys25 & " + n + " <> 0 then case when t.sys25 & " + 16384 + " <> 0 then 'on' else 'off' end else '' end c2 from sys.tables t, sys.columns c where t.tblid = c.id and (t.sys45 = c.colnum or t.sys45 = 0) and t.tblowner = :OBJECT_OWNER and t.tblname = :OBJECT_NAME";
        string3 = Describe.fixupNameAndOwner(string3, string, string2);
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                String string4 = resultSet.getString(1);
                String string5 = resultSet.getString(2);
                String string6 = resultSet.getString(3);
                String string7 = resultSet.getString(4);
                String string8 = resultSet.getString(5);
                String string9 = resultSet.getString(6);
                String string10 = "";
                String string11 = "";
                if (string4 != null && !string4.equals("")) {
                    if (string5 != null && !string5.equals("")) {
                        String string12 = "call ttAgingSecondAdjustmentGet('" + string + "','" + string2 + "');";
                        statement2 = connection.prepareCall(string12);
                        statement2.execute();
                        ResultSet resultSet2 = statement2.getResultSet();
                        if (resultSet2.next()) {
                            long l;
                            long l2;
                            string10 = resultSet2.getString(1);
                            string11 = resultSet2.getString(2);
                            if (statement2 != null) {
                                statement2.close();
                            }
                            stringBuffer.append(string4);
                            if (string10.equals("0")) {
                                stringBuffer.append(string5);
                            } else {
                                stringBuffer.append("lifetime ");
                                l2 = Long.parseLong(string6);
                                l = Long.parseLong(string10);
                                l2 = l2 * 60L + (l - 60L);
                                string6 = String.valueOf(l2);
                                stringBuffer.append(string6);
                                if (n == 1) {
                                    stringBuffer.append(" second ");
                                } else {
                                    stringBuffer.append(" seconds ");
                                }
                            }
                            if (string11.equals("0")) {
                                stringBuffer.append(string7);
                            } else {
                                stringBuffer.append("cycle ");
                                l2 = Long.parseLong(string8);
                                l = Long.parseLong(string11);
                                l2 = l2 * 60L + (l - 60L);
                                string8 = String.valueOf(l2);
                                stringBuffer.append(string8);
                                if (n == 1) {
                                    stringBuffer.append(" second ");
                                } else {
                                    stringBuffer.append(" seconds ");
                                }
                            }
                            stringBuffer.append(string9);
                            stringBuffer.append("\n");
                        } else {
                            stringBuffer.append("  Aging: No aging defined");
                        }
                    } else {
                        stringBuffer.append(string4);
                        stringBuffer.append(string9);
                        stringBuffer.append("\n");
                    }
                } else {
                    stringBuffer.append("  Aging: No aging defined\n");
                }
            } else {
                stringBuffer.append("  Aging: No aging defined\n");
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (statement2 != null) {
                    statement2.close();
                }
            }
            catch (Exception exception) {}
        }
        return stringBuffer.toString();
    }

    private String getDataType(int n, String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (n) {
            case 1: {
                stringBuffer.append("TT_SMALLINT");
                break;
            }
            case 2: {
                stringBuffer.append("TT_INTEGER");
                break;
            }
            case 3: {
                stringBuffer.append("BINARY_FLOAT");
                break;
            }
            case 4: {
                stringBuffer.append("BINARY_DOUBLE");
                break;
            }
            case 5: {
                stringBuffer.append("TT_CHAR (" + string2 + ")");
                break;
            }
            case 6: 
            case 22: {
                stringBuffer.append("TT_VARCHAR (" + string2 + ")");
                break;
            }
            case 7: {
                stringBuffer.append("BINARY (" + string2 + ")");
                break;
            }
            case 8: {
                stringBuffer.append("VARBINARY (" + string2 + ")");
                break;
            }
            case 16: {
                stringBuffer.append("TT_TIMESTAMP");
                break;
            }
            case 20: {
                stringBuffer.append("TT_TINYINT");
                break;
            }
            case 21: {
                stringBuffer.append("TT_BIGINT");
                break;
            }
            case 25: {
                stringBuffer.append("NUMBER (" + string + "," + string3 + ")");
                break;
            }
            case 26: {
                stringBuffer.append("CHAR (" + string2 + ")");
                break;
            }
            case 27: 
            case 32: {
                stringBuffer.append("VARCHAR2 (" + string2 + ")");
            }
        }
        if (string4.equals("0")) {
            stringBuffer.append(" NOT NULL");
        }
        return stringBuffer.toString();
    }

    private static String fixupNameAndOwner(String string, String string2, String string3) {
        String string4 = string;
        string4 = string.replace(":OBJECT_OWNER", "'" + string2 + "'");
        string4 = string4.replace(":OBJECT_NAME", "'" + string3 + "'");
        return string4;
    }

    private static void formatData(List<String> list, String string, String string2, String string3) {
        if (list.size() == 0) {
            list.add(DESCRIBE_TITLE);
            list.add(DESCRIBE_UNDERLINE);
        }
        StringBuffer stringBuffer = new StringBuffer(THE_EMPTY_STRING);
        stringBuffer.insert(0, string);
        stringBuffer.insert(31, string3.equalsIgnoreCase("Yes") ? "" : "NOT NULL");
        stringBuffer.insert(40, string2);
        stringBuffer.append("\n");
        list.add(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getObjectType(Connection connection, String string, String string2) throws SQLException {
        ResultSet resultSet;
        String string3 = "select object_type from sys.all_objects where owner = '" + string + "' and object_name = '" + string2 + "'";
        Statement statement = null;
        Statement statement2 = null;
        String string4 = "";
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                string4 = resultSet.getString(1).trim();
            } else {
                string3 = "call ttProcedures('" + string2 + "');";
                statement2 = connection.prepareCall(string3);
                statement2.execute();
                ResultSet resultSet2 = statement2.getResultSet();
                if (resultSet2.next() && resultSet2.getString(3).trim().equalsIgnoreCase(string2)) {
                    string4 = "BUILT-IN PROCEDURE";
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (statement2 != null) {
                    statement2.close();
                }
            }
            catch (Exception exception) {}
        }
        if (string4.equalsIgnoreCase("TABLE")) {
            string3 = "select name from sys.views where (owner = :OBJECT_OWNER and name = :OBJECT_NAME and sys4 & 1 = 1)";
            string3 = Describe.fixupNameAndOwner(string3, string, string2);
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string3);
                if (resultSet.next()) {
                    string4 = "MATERIALIZED VIEW";
                }
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (string4.length() > 1) {
            string4 = string4.substring(0, 1).toUpperCase() + string4.substring(1).toLowerCase();
        }
        return string4;
    }

    static {
        char[] cArray = new char[128];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = 32;
        }
        THE_EMPTY_STRING = new String(cArray);
    }

    private static enum DistributionMode {
        DISTRIBUTION_HASH_TYPE(4, "HASH"),
        DISTRIBUTION_DUPLICATE_TYPE(5, "DUPLICATE"),
        DISTRIBUTION_REFERENCE_TYPE(6, "REFERENCE"),
        DISTRIBUTION_REFERENCE_N_TYPE(7, "REFERENCE");

        private final int value;
        private final String mode;

        private DistributionMode(int n2, String string2) {
            this.value = n2;
            this.mode = string2;
        }

        public String getMode() {
            return this.mode;
        }

        public static String getDistType(int n) {
            switch (n) {
                case 4: {
                    return DISTRIBUTION_HASH_TYPE.getMode();
                }
                case 5: {
                    return DISTRIBUTION_DUPLICATE_TYPE.getMode();
                }
                case 6: {
                    return DISTRIBUTION_REFERENCE_TYPE.getMode();
                }
                case 7: {
                    return DISTRIBUTION_REFERENCE_N_TYPE.getMode();
                }
            }
            return Describe.UNKNOWN;
        }
    }
}

