/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.timesten.SupportedObjectType;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseImpl;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;

public class TimesTenUtil {
    private static final String[] SYSTEM_SCHEMA;
    private static List<String> _supportedObjects;
    private static Logger theLogger;
    private static final String HOME_DIR;
    private static final String LINE_SEPARATOR;
    private static final String[] SUPPORTED_VERSIONS;

    public static String getRegExForSupportedDrivers() {
        StringBuffer stringBuffer = new StringBuffer(256 * SUPPORTED_VERSIONS.length);
        for (int i = 0; i < SUPPORTED_VERSIONS.length; ++i) {
            String string = SUPPORTED_VERSIONS[i].replace(".", "\\.");
            stringBuffer.append("TimesTen\\s+Data\\s+Manager\\s+");
            stringBuffer.append(string);
            stringBuffer.append("|");
            stringBuffer.append("TimesTen\\s+Data\\s+Manager\\s+Debug\\s+");
            stringBuffer.append(string);
            stringBuffer.append("|");
            stringBuffer.append("TimesTen\\s+Client\\s+");
            stringBuffer.append(string);
            stringBuffer.append("|");
            stringBuffer.append("\\s*TimesTen\\s+" + string + "\\s+Driver\\s*");
            stringBuffer.append("|");
            stringBuffer.append("\\s*TimesTen\\s+" + string + "\\s+Client\\s+Driver\\s*");
            if (i == SUPPORTED_VERSIONS.length - 1) continue;
            stringBuffer.append("|");
        }
        return stringBuffer.toString();
    }

    public static boolean isSystemSchema(String string) {
        if (string == null) {
            return false;
        }
        for (String string2 : SYSTEM_SCHEMA) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSystemObject(DBObject dBObject) {
        String string = dBObject.getSchemaName();
        return TimesTenUtil.isSystemSchema(string);
    }

    public static List<String> getSupportedObjects() {
        return _supportedObjects;
    }

    public static String ttVersion(DBObject dBObject) {
        return TimesTenUtil.ttVersion(dBObject.getConnection());
    }

    public static String ttVersion(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            return databaseMetaData.getDatabaseProductVersion();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String ttFullDotVersion(Connection connection) {
        String string = null;
        try {
            String string2 = connection.getMetaData().getDatabaseProductVersion();
            String[] stringArray = string2.split("\\s+");
            if (stringArray.length > 0) {
                string = stringArray[0];
            } else {
                theLogger.log(Level.SEVERE, "Cannot get full dotted product version " + string2);
            }
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, "Cannot assess database version", sQLException);
        }
        return string;
    }

    public static String getActiveStandbyOwner(Connection connection) {
        String string = "TTREP";
        try {
            int n = connection.getMetaData().getDatabaseMajorVersion();
            if (n >= 11) {
                return string;
            }
            return "TIMESTEN";
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, "Cannot get database major version");
            return string;
        }
    }

    public static boolean isClientServer(Connection connection) {
        try {
            String string = connection.getMetaData().getURL().toString();
            if (string.indexOf(":client:") != -1) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String getUserHomeDir() {
        return HOME_DIR;
    }

    public static String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    public static String getMD5(File file) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) != -1) {
                messageDigest.update(byArray, 0, n);
            }
            byte[] byArray2 = messageDigest.digest();
            for (int i = 0; i < byArray2.length; ++i) {
                stringBuffer.append(Integer.toString((byArray2[i] & 0xFF) + 256, 16).substring(1));
            }
        }
        return stringBuffer.toString();
    }

    public static boolean isMenuEnabledForGridDatatabase(Context context) {
        DatabaseConnection databaseConnection = (DatabaseConnection)context.getElement();
        if (databaseConnection != null && databaseConnection.isConnectionOpen()) {
            try {
                Connection connection = (Connection)databaseConnection.getConnection();
                if (connection == null) {
                    return false;
                }
                return !TimesTenPlugInDatabaseImpl.isGridDatabase(connection);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    public static File getTemporaryFile(String string, String string2) {
        File file = new File(System.getProperty("java.io.tmpdir"));
        File file2 = new File(file, string + System.currentTimeMillis() + "." + string2);
        return file2;
    }

    static {
        SupportedObjectType[] supportedObjectTypeArray;
        SYSTEM_SCHEMA = new String[]{"PUBLIC", "SYS", "TTREP", "GRID", "SYSTEM"};
        _supportedObjects = new ArrayList<String>(16);
        theLogger = Logger.getLogger(TimesTenUtil.class.getPackage().getName());
        for (SupportedObjectType supportedObjectType : supportedObjectTypeArray = SupportedObjectType.values()) {
            _supportedObjects.add(supportedObjectType.getTag());
        }
        HOME_DIR = System.getProperty("user.home");
        LINE_SEPARATOR = System.getProperty("line.separator");
        SUPPORTED_VERSIONS = new String[]{"11.2.1", "11.2.2", "12.1.1"};
    }
}

