/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.timesten.DataSheet;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTIndexBuilder;
import oracle.dbtools.raptor.timesten.TTPackageBuilder;
import oracle.dbtools.raptor.timesten.TTProcedureBuilder;
import oracle.dbtools.raptor.timesten.TTSequenceBuilder;
import oracle.dbtools.raptor.timesten.TTTableBuilder;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.TypeMode;
import oracle.dbtools.raptor.timesten.connection.TTSQLExceptionListener;
import oracle.dbtools.raptor.timesten.ddlgen.TimesTenBundleGenerator;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.ddl.UnsupportedDDLException;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.GenericDiffEngine;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.db.timesten.TimesTenDatabase;
import oracle.javatools.util.ModelUtil;

public class TimesTenPlugInDatabaseImpl
extends JdbcDDLDatabase
implements TimesTenDatabase {
    public static int index_number = 0;
    public static Collection<String> indexNames = new ArrayList<String>();
    private long t = 0L;
    protected static final List theSupportedObjectTypes = Arrays.asList("TABLE", "VIEW", "MATERIALIZED VIEW", "SEQUENCE", "INDEX", "PACKAGE", "PROCEDURE", "FUNCTION", "TIMESTENELEMENT", "TTPrimaryKeyIndexType");
    protected String theConnectionUser;
    protected final Connection theConnection;
    protected DatabaseMetaData theDatabaseMetaData;
    private Map<String, String> theConfiguration = new HashMap<String, String>(64);
    public static final String CHAR_SEMANTICS = "unit";
    private static Logger theLogger = Logger.getLogger(TimesTenPlugInDatabaseImpl.class.getPackage().getName());
    private static WeakHashMap<Connection, Map<String, String>> theGlobalConfiguration = new WeakHashMap();
    private List<String> theSupportedDataTypes;
    private final TTSQLExceptionListener theSqlExceptionListener = TTSQLExceptionListener.getTheInstance();
    private String theCatalog;
    private PropertyManager thePropertyManager;
    private DataSheet theDataSheet = DataSheet.getInstance();

    public TimesTenPlugInDatabaseImpl(String string, Connection connection) {
        super("IdeConnections", string, connection);
        this.theConnection = connection;
        try {
            this.theCatalog = connection.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.getDatabaseConfiguration();
        this.thePropertyManager = new TimesTenBundleGenerator((DBObjectProvider)this);
    }

    private void getDatabaseConfiguration() {
        try {
            CallableStatement callableStatement = this.getConnection().prepareCall("call ttconfiguration");
            ResultSet resultSet = callableStatement.executeQuery();
            while (resultSet.next()) {
                this.theConfiguration.put(resultSet.getString(1), resultSet.getString(2));
            }
            theGlobalConfiguration.put(this.theConnection, this.theConfiguration);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    private void getDatabaseConfiguration(Connection connection) {
        if (connection != this.theConnection) {
            try {
                CallableStatement callableStatement = connection.prepareCall("call ttconfiguration");
                ResultSet resultSet = callableStatement.executeQuery();
                HashMap<String, String> hashMap = new HashMap<String, String>(64);
                while (resultSet.next()) {
                    hashMap.put(resultSet.getString(1), resultSet.getString(2));
                }
                theGlobalConfiguration.put(connection, hashMap);
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException);
            }
        }
    }

    public TypeMode getTypeMode() {
        String string = this.theConfiguration.get("TypeMode");
        if (string.equals("0")) {
            return TypeMode.ORACLE_TYPE_MODE;
        }
        if (string.equals("1")) {
            return TypeMode.TIMESTEN_TYPE_MODE;
        }
        throw new RuntimeException(Messages.getString("TimesTenPlugInDatabaseImpl.UnknownTypeMode") + string);
    }

    public DataType getDataType(String string) {
        DataType dataType = super.getDataType(string.trim().toUpperCase());
        if (dataType != null && !this.isDataTypeSupported(string.trim())) {
            return null;
        }
        return dataType;
    }

    public boolean canCreateDBObject(Schema schema, DBObjectProvider dBObjectProvider, String string) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createObject(SchemaObject schemaObject, boolean bl) throws DBException {
        SchemaObject schemaObject2;
        block5: {
            if (schemaObject == null) {
                throw new DBException(null, Messages.getString("TimesTenPlugInDatabaseImpl.NULLObjectInCreateObject"));
            }
            String string = schemaObject.getType();
            SchemaObject schemaObject3 = schemaObject2 = bl ? this.getObject(string, schemaObject.getSchema(), schemaObject.getName()) : null;
            if (!theSupportedObjectTypes.contains(schemaObject.getType())) throw new DBException((Throwable)new UnsupportedOperationException());
            try {
                this.createObjects((SystemObject[])new SchemaObject[]{schemaObject}, bl);
            }
            catch (DBException dBException) {
                Throwable throwable = dBException.getCause();
                if (!(throwable instanceof SQLException)) break block5;
                int n = ((SQLException)throwable).getErrorCode();
                if (n == 955 || n == 12000 || n == 12006) throw dBException;
                try {
                    this.deleteObject((SystemObject)schemaObject, true);
                    throw dBException;
                }
                catch (DBException dBException2) {
                    // empty catch block
                }
                throw dBException;
            }
        }
        this.finishCreate((SystemObject[])new SchemaObject[]{schemaObject}, (SystemObject[])new SchemaObject[]{schemaObject2});
    }

    protected void finishCreate(SystemObject[] systemObjectArray, SystemObject[] systemObjectArray2) throws DBException {
        ArrayList<SchemaObject> arrayList = new ArrayList<SchemaObject>();
        DBException dBException = null;
        for (int i = 0; i < systemObjectArray.length; ++i) {
            SystemObject systemObject = systemObjectArray[i];
            SystemObject systemObject2 = systemObjectArray2 == null ? null : systemObjectArray2[i];
            Schema schema = DBUtil.getSchema((DBObject)systemObject);
            String string = schema.getName();
            if (systemObject2 != null) {
                this.uncacheObject(systemObject2);
            }
            Object object = null;
            object = systemObject.getType().equals("SEQUENCE") ? this.getCreatedSequenceObject(string, systemObject.getName()) : (systemObject.getType().equals("INDEX") ? this.getCreatedIndexObject(string, systemObject.getName()) : this.getCreatedObject(systemObject.getType(), schema, systemObject.getName()));
            if (object == null) {
                DBException dBException2 = new DBException((DBObject)systemObject, Messages.getString("TimesTenPlugInDatabaseImpl.ErrorFetchingNewObjectBackFromTheDatabase"));
                if (dBException == null) {
                    dBException = dBException2;
                    continue;
                }
                dBException.setNextException(dBException2);
                continue;
            }
            if (systemObject2 != null) {
                DBUtil.updateObjectAndIDs((DBObject)systemObject2, (DBObject)object);
                this.cacheObject(systemObject2, false);
                DBObjectChange.fireObjectUpdated((DBObject)systemObject2);
                continue;
            }
            arrayList.add((SchemaObject)object);
            this.cacheObject((SystemObject)object, false);
        }
        if (arrayList.size() > 0) {
            SchemaObject[] schemaObjectArray = arrayList.toArray(new SchemaObject[arrayList.size()]);
            this.fireObjectsAdded(schemaObjectArray[0].getSchema(), schemaObjectArray);
        }
        if (dBException != null) {
            throw dBException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaObject getCreatedSequenceObject(String string, String string2) throws DBException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT NAME,OWNER FROM SYS.SEQUENCES WHERE OWNER='" + string + "' AND NAME='" + string2 + "'");
            while (resultSet.next()) {
                if (!resultSet.getString(1).trim().equals(string2) || !resultSet.getString(2).trim().equals(string)) continue;
                SchemaObject schemaObject = this.createSchemaObject(string, string2, "SEQUENCE");
                return schemaObject;
            }
        }
        catch (SQLException sQLException) {
            SchemaObject schemaObject = null;
            return schemaObject;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaObject getCreatedIndexObject(String string, String string2) throws DBException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT IXNAME,IXOWNER FROM SYS.INDEXES WHERE IXOWNER='" + string + "' AND IXNAME='" + string2 + "'");
            while (resultSet.next()) {
                if (!resultSet.getString(1).trim().equals(string2) || !resultSet.getString(2).trim().equals(string)) continue;
                SchemaObject schemaObject = this.createSchemaObject(string, string2, "INDEX");
                return schemaObject;
            }
        }
        catch (SQLException sQLException) {
            SchemaObject schemaObject = null;
            return schemaObject;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return null;
    }

    public String getUniqueName(String string, DBObject dBObject, String string2) {
        SchemaObject[] schemaObjectArray;
        long l = System.currentTimeMillis();
        ArrayList<String> arrayList = new ArrayList<String>();
        string = this.normaliseType(string);
        if (!ModelUtil.hasLength((String)string2)) {
            string2 = string + 1;
        }
        if (dBObject instanceof Schema) {
            schemaObjectArray = null;
            try {
                schemaObjectArray = this.listObjects(this.listObjectTypes(), (Schema)dBObject);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (schemaObjectArray != null) {
                for (int i = 0; i < schemaObjectArray.length; ++i) {
                    arrayList.add(schemaObjectArray[i].getName());
                }
            }
        } else if (dBObject instanceof SchemaObject) {
            this.addChildrenNames(dBObject.getOwnedObjects(new String[]{string}), arrayList);
        }
        schemaObjectArray = DBUtil.getUniqueName(arrayList, (String)string2);
        long l2 = System.currentTimeMillis();
        theLogger.log(Level.FINEST, "Elapsed time for unique name " + (l2 - l) + " ms");
        return schemaObjectArray;
    }

    private void addChildrenNames(DBObject[] dBObjectArray, Collection collection) {
        for (int i = 0; i < dBObjectArray.length; ++i) {
            collection.add(dBObjectArray[i].getName());
        }
    }

    protected <T extends SystemObject> Collection<T> listObjectsImpl(DBObjectCriteria<T> dBObjectCriteria) throws DBException {
        String[] stringArray = dBObjectCriteria.getTypeArray();
        SchemaObject schemaObject = null;
        String string = dBObjectCriteria.getSchemaName();
        String string2 = dBObjectCriteria.getNameLike();
        int n = 0;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(128);
        for (String object : stringArray) {
            stringBuffer.append(object + " ");
            if (object.equalsIgnoreCase("SCHEMA")) {
                bl = true;
                continue;
            }
            ++n;
        }
        schemaObject = new String[n];
        n = 0;
        for (String string3 : stringArray) {
            if (string3.equalsIgnoreCase("SCHEMA")) continue;
            schemaObject[n++] = string3;
        }
        ArrayList arrayList = new ArrayList();
        try {
            int n2 = 0;
            ResultSet resultSet = null;
            Object var12_17 = null;
            String string4 = string2;
            DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
            if (bl) {
                arrayList.addAll(this.listSchema(databaseMetaData, dBObjectCriteria));
            }
            if (n == 0) {
                return arrayList;
            }
            if (this.theDataSheet.isCapable(this.getConnection(), DataSheet.FeatureType.AllObjects)) {
                this.addAllObjects(arrayList, (String[])schemaObject, string, string2);
                return arrayList;
            }
            for (String string5 : schemaObject) {
                if (string5.equalsIgnoreCase("INDEX")) {
                    this.addIndexObjects(arrayList, string, string2);
                    continue;
                }
                if (string5.equalsIgnoreCase("SEQUENCE")) {
                    this.addSequenceObjects(arrayList, string, string2);
                    continue;
                }
                if (!string5.equalsIgnoreCase("FUNCTION") && !string5.equalsIgnoreCase("PROCEDURE") && !string5.equalsIgnoreCase("PACKAGE")) continue;
                this.addPlSqlObjects(arrayList, string, string2, string5);
            }
            try {
                resultSet = databaseMetaData.getTables(this.theCatalog, this.isUseSchema() ? string : null, string4, (String[])schemaObject);
                n2 = resultSet.next() ? 1 : 0;
            }
            catch (UnsupportedDDLException unsupportedDDLException) {
                resultSet = databaseMetaData.getTables(this.theCatalog, null, null, (String[])schemaObject);
                n2 = resultSet.next() ? 1 : 0;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            while (n2 != 0) {
                String string5;
                SchemaObject schemaObject2 = null;
                String string6 = resultSet.getString(1);
                String string7 = resultSet.getString(2);
                string5 = resultSet.getString(3);
                String string8 = resultSet.getString(4);
                if (this._catalogMatches(string6) && this._schemaMatches(string, string7) && (string4 != null || this._tableMatches(string2, string5))) {
                    schemaObject2 = this.createSchemaObject(string7, string5, string8);
                }
                if (schemaObject2 != null) {
                    this.markForLazyInit((AbstractBuildableObject)schemaObject2);
                    this.cacheObject((SystemObject)schemaObject2, true);
                    arrayList.add(schemaObject2);
                }
                n2 = resultSet.next() ? 1 : 0;
            }
        }
        catch (SQLException sQLException) {
            throw new DBException((Throwable)sQLException);
        }
        return arrayList;
    }

    private <T extends SystemObject> Collection<T> listSchema(DatabaseMetaData databaseMetaData, DBObjectCriteria<T> dBObjectCriteria) throws DBException {
        ArrayList<SystemObject> arrayList = new ArrayList<SystemObject>();
        try {
            ResultSet resultSet = databaseMetaData.getSchemas();
            Schema schema = null;
            String string = null;
            SystemObject systemObject = null;
            while (resultSet.next()) {
                string = resultSet.getString(1);
                schema = new Schema(string);
                if (!dBObjectCriteria.accept((SystemObject)schema)) continue;
                systemObject = this.findObject("SCHEMA", null, string);
                if (systemObject == null) {
                    schema.setID((DBObjectID)new NameBasedID("SCHEMA", null, string, (AbstractDBObjectProvider)this));
                    this.cacheObject((SystemObject)schema, true);
                    systemObject = schema;
                }
                arrayList.add(systemObject);
            }
        }
        catch (SQLException sQLException) {
            throw new DBException((Throwable)sQLException);
        }
        return arrayList;
    }

    private boolean _catalogMatches(String string) {
        return this.theCatalog == null || string == null || this.theCatalog.equals(string);
    }

    private boolean _schemaMatches(String string, String string2) {
        return !this.isUseSchema() || !ModelUtil.hasLength((String)string) || ModelUtil.areEqual((Object)string, (Object)string2);
    }

    private boolean _tableMatches(String string, String string2) {
        if (string == null) {
            return true;
        }
        String string3 = string.replaceAll("%", ".*");
        if (string3.contains("$")) {
            string3 = string3.replaceAll(Pattern.quote("$"), Matcher.quoteReplacement("\\$"));
        }
        return string2.matches(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIndexObjects(List list, String string, String string2) throws DBException {
        indexNames.clear();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT rtrim(IXNAME) FROM SYS.INDEXES WHERE rtrim(IXOWNER)='" + string + "'");
            SchemaObject schemaObject = null;
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                indexNames.add(string3);
                if (this._tableMatches(string2, string3)) {
                    schemaObject = this.createSchemaObject(string, string3, "INDEX");
                }
                if (schemaObject == null) continue;
                this.markForLazyInit((AbstractBuildableObject)schemaObject);
                this.cacheObject((SystemObject)schemaObject, true);
                list.add(schemaObject);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllObjects(List list, String[] stringArray, String string, String string2) throws DBException {
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        int n = 0;
        long l = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer(128);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("INDEX")) {
                bl = true;
                continue;
            }
            if (++n > 1) {
                stringBuffer.append(" OR ");
            }
            stringBuffer.append(" OBJECT_TYPE = '");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("'");
        }
        if (bl) {
            ++index_number;
            this.addIndexObjects(list, string, string2);
        }
        if (n == 0) {
            return;
        }
        try {
            Connection connection = this.getConnection();
            statement = connection.createStatement();
            String string3 = "SELECT OBJECT_NAME, OBJECT_TYPE FROM SYS.ALL_OBJECTS WHERE OWNER='" + string + "' and (" + stringBuffer.toString() + ")";
            resultSet = statement.executeQuery(string3);
            SchemaObject schemaObject = null;
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                if (this._tableMatches(string2, string4)) {
                    schemaObject = this.createSchemaObject(string, string4, resultSet.getString(2));
                }
                if (schemaObject == null) continue;
                this.markForLazyInit((AbstractBuildableObject)schemaObject);
                this.cacheObject((SystemObject)schemaObject, true);
                list.add(schemaObject);
            }
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, "Select on all_objects failed", sQLException);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        long l2 = System.currentTimeMillis();
        theLogger.log(Level.FINEST, "Elapsed time for all objects " + (l2 - l) + " ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSequenceObjects(List list, String string, String string2) throws DBException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT rtrim(NAME) FROM SYS.SEQUENCES WHERE rtrim(OWNER)='" + string + "'");
            SchemaObject schemaObject = null;
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                if (this._tableMatches(string2, string3)) {
                    schemaObject = this.createSchemaObject(string, string3, "SEQUENCE");
                }
                if (schemaObject == null) continue;
                this.markForLazyInit((AbstractBuildableObject)schemaObject);
                this.cacheObject((SystemObject)schemaObject, true);
                list.add(schemaObject);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPlSqlObjects(List list, String string, String string2, String string3) throws DBException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT OBJECT_NAME FROM ALL_OBJECTS WHERE OWNER = '" + string + "' AND OBJECT_TYPE='" + string3 + "'");
            SchemaObject schemaObject = null;
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                if (this._tableMatches(string2, string4)) {
                    schemaObject = this.createSchemaObject(string, string4, string3);
                }
                if (schemaObject == null) continue;
                this.markForLazyInit((AbstractBuildableObject)schemaObject);
                this.cacheObject((SystemObject)schemaObject, true);
                list.add(schemaObject);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public SchemaObject createSchemaObject(String string, String string2, String string3) throws DBException {
        if (this.getBuilderForType(string3) == null) {
            return null;
        }
        return (SchemaObject)this.findOrCreateObject(string3, null, this.findSchema(string), string2, null, null);
    }

    protected boolean canEditDBObject(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        return true;
    }

    public void canUpdate(Difference difference, boolean bl, boolean bl2) throws DBException {
        super.canUpdate(difference, bl, bl2);
    }

    protected void registerBuilders() {
        super.registerBuilders();
        this.registerBuilder("TABLE", (DBObjectBuilder)new TTTableBuilder((JdbcDatabase)this, this.theCatalog));
        this.registerBuilder("MATERIALIZED VIEW", (DBObjectBuilder)new TTTableBuilder((JdbcDatabase)this, this.theCatalog));
        this.registerBuilder("INDEX", (DBObjectBuilder)new TTIndexBuilder((JdbcDatabase)this, this.theCatalog));
        this.registerBuilder("SEQUENCE", (DBObjectBuilder)new TTSequenceBuilder((JdbcDatabase)this, this.theCatalog));
        this.registerBuilder("PROCEDURE", (DBObjectBuilder)new TTProcedureBuilder((AbstractDBObjectProvider)this, "PROCEDURE"));
        this.registerBuilder("FUNCTION", (DBObjectBuilder)new TTProcedureBuilder((AbstractDBObjectProvider)this, "FUNCTION"));
        this.registerBuilder("PACKAGE", (DBObjectBuilder)new TTPackageBuilder((AbstractDBObjectProvider)this, "PACKAGE"));
        this.registerBuilder("PACKAGE BODY", (DBObjectBuilder)new TTPackageBuilder((AbstractDBObjectProvider)this, "PACKAGE BODY"));
    }

    public Schema getSchema(String string, boolean bl) throws DBException {
        Schema schema = super.getSchema(string);
        if (schema == null) {
            schema = new Schema(string);
        }
        return schema;
    }

    public PropertyManager getPropertyManager() {
        return this.thePropertyManager;
    }

    public DiffEngine getDiffEngine() {
        return GenericDiffEngine.getDiffEngine((boolean)false);
    }

    public String getConnectionUser() throws SQLException {
        if (this.theConnectionUser == null) {
            if (this.theDatabaseMetaData == null) {
                this.theDatabaseMetaData = this.getConnection().getMetaData();
            }
            this.theConnectionUser = this.theDatabaseMetaData.getUserName();
        }
        return this.theConnectionUser;
    }

    public boolean hasPriviledge(String string, Schema schema, String string2) {
        try {
            long l = System.currentTimeMillis();
            String string3 = schema.getName();
            theLogger.log(Level.INFO, "Check privilege type " + string + " schema " + string3 + " privilege " + string2);
            if (TimesTenUtil.isSystemSchema(string3)) {
                return false;
            }
            Connection connection = this.getConnection();
            if (!this.theDataSheet.isCapable(connection, DataSheet.FeatureType.ObjectLevelPrivilege)) {
                return true;
            }
            boolean bl = TimesTenPlugInDatabaseImpl.hasPrivilege(connection, this.getConnectionUser(), string3, string, string2);
            long l2 = System.currentTimeMillis();
            theLogger.log(Level.FINEST, "Elapsed time for hasPrivilege " + (l2 - l) + " ms");
            return bl;
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, "Cannot get connection user ", sQLException);
            return false;
        }
    }

    public boolean hasSystemPrivilege(String string, Schema schema, String string2) {
        return this.hasPriviledge(string, schema, string2);
    }

    public static boolean hasPrivilege(Connection connection, String string, String string2, String string3) {
        try {
            String string4 = connection.getMetaData().getUserName();
            return TimesTenPlugInDatabaseImpl.hasPrivilege(connection, string4, string, string2, string3);
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, "Cannot get privileges", sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasPrivilege(Connection connection, String string, String string2, String string3, String string4) {
        ResultSet resultSet = null;
        try {
            StringBuffer stringBuffer = new StringBuffer(64);
            StringBuffer stringBuffer2 = new StringBuffer(64);
            String string5 = string3 = TimesTenPlugInDatabaseImpl.isPlSqlObject(string3) ? "PROCEDURE" : string3;
            if (string4.equals("CREATE")) {
                stringBuffer.append("CREATE ");
            } else if (TimesTenPlugInDatabaseImpl.isPlSqlObject(string3)) {
                stringBuffer.append("CREATE ");
            } else {
                stringBuffer.append("ALTER ");
            }
            stringBuffer2.append(stringBuffer).append("ANY ");
            if (string.equalsIgnoreCase(string2)) {
                stringBuffer.append(string3);
                if (string3.equalsIgnoreCase("INDEX")) {
                    boolean bl = true;
                    return bl;
                }
            } else {
                stringBuffer.append("ANY ");
                stringBuffer.append(string3);
            }
            stringBuffer2.append(string3);
            String string6 = "select * from sys.user_sys_privs where privilege = 'ADMIN' OR privilege = '" + stringBuffer + "' OR privilege = '" + stringBuffer2 + "'";
            theLogger.log(Level.INFO, string6);
            resultSet = connection.createStatement().executeQuery(string6);
            if (resultSet.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, "Cannot get privileges", sQLException);
            return false;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public static boolean isPlSqlObject(String string) {
        return string.equalsIgnoreCase("PACKAGE") || string.equalsIgnoreCase("PROCEDURE") || string.equalsIgnoreCase("FUNCTION");
    }

    public static String getX10Configuration(Connection connection, String string) {
        String string2 = null;
        Map<String, String> map = theGlobalConfiguration.get(connection);
        if (map != null) {
            string2 = map.get(string);
        }
        return string2;
    }

    protected SystemObject findObject(String string, Schema schema, String string2) {
        return super.findObject(string, schema, string2);
    }

    protected void cacheObject(SystemObject systemObject, boolean bl) {
        super.cacheObject(systemObject, bl);
    }

    public boolean isDataTypeSupported(String string) {
        try {
            if (this.theSupportedDataTypes == null) {
                this.theSupportedDataTypes = new ArrayList<String>(32);
                ResultSet resultSet = this.getConnection().getMetaData().getTypeInfo();
                while (resultSet.next()) {
                    this.theSupportedDataTypes.add(resultSet.getString(1).toUpperCase());
                }
            }
        }
        catch (SQLException sQLException) {
            this.theSupportedDataTypes = null;
            return false;
        }
        return this.theSupportedDataTypes.contains(string);
    }

    Connection getTheConnection() {
        return this.theConnection;
    }

    public static boolean isGridDatabase(Connection connection) {
        String string = TimesTenPlugInDatabaseImpl.getX10Configuration(connection, "TTGrid");
        return string != null && string.equals("1");
    }

    protected void reconnected(Connection connection) {
        super.reconnected(connection);
        if (connection != null) {
            try {
                this.getDatabaseConfiguration(connection);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isConnectionAliveImpl(Connection connection) throws SQLException, DBException {
        theLogger.log(Level.FINEST, "Checking if the connection is alive?");
        Statement statement = null;
        boolean bl = false;
        for (int i = 1; i <= 3; ++i) {
            try {
                statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery("select 1 from dual");
                resultSet.next();
                boolean bl2 = true;
                return bl2;
            }
            catch (SQLException sQLException) {
                if (this.theSqlExceptionListener.isTransientFailoverException(sQLException, connection)) {
                    theLogger.log(Level.WARNING, "Automatic client failover in progress, retrying attempt: " + i);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
                boolean bl3 = false;
                return bl3;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return bl;
    }

    protected Boolean isConnectionClosedImpl(SQLException sQLException, Connection connection) {
        if (sQLException == null || connection == null) {
            return null;
        }
        return !TTSQLExceptionListener.getTheInstance().isConnectionAliveHelper(sQLException, connection);
    }

    static class Registerer
    extends DataTypeRegistry.Registerer {
        Registerer() {
        }

        public void registerDataTypes(DataTypeRegistry dataTypeRegistry) {
        }
    }
}

