/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.timesten.PassThrough3Manager;
import oracle.dbtools.raptor.timesten.ResultSetHandler;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;

public final class SimpleQuery {
    static Hashtable<String, Connection> _connectionMap = null;

    public static SQLException sendQuery(DBObject dBObject, String string, ResultSetHandler resultSetHandler) {
        return SimpleQuery.sendQuery(dBObject, string, resultSetHandler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLException sendQuery(DBObject dBObject, String string, ResultSetHandler resultSetHandler, boolean bl) {
        Object object;
        SQLException sQLException = null;
        final String string2 = dBObject.getSchemaName();
        final String string3 = dBObject.getObjectName();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(){
            {
                this.put("objName", string3 != null ? string3 : "");
                this.put("userName", string2);
            }
        };
        String string4 = "";
        Object object2 = Pattern.compile("\\$\\{(\\w+)\\}").matcher(string);
        Object object3 = new StringBuffer();
        int n = 0;
        while (((Matcher)object2).find()) {
            object = (String)hashtable.get(((Matcher)object2).group(1));
            ((StringBuffer)object3).append(string, n, ((Matcher)object2).start());
            ((StringBuffer)object3).append((String)object);
            n = ((Matcher)object2).end();
        }
        ((StringBuffer)object3).append(string, n, string.length());
        string4 = ((StringBuffer)object3).toString();
        object2 = dBObject.getConnection();
        if (bl && !CGCPanel.inhibitIdleInit) {
            object2 = SimpleQuery.getOracleConnection(dBObject);
        }
        object3 = null;
        PassThrough3Manager passThrough3Manager = new PassThrough3Manager(dBObject);
        try {
            if (bl) {
                passThrough3Manager.setup();
            }
            object3 = object2.createStatement();
            object = object3.executeQuery(string4);
            if (resultSetHandler != null) {
                resultSetHandler.handleResultSet((ResultSet)object);
            }
        }
        catch (SQLException sQLException2) {
            Logger.getLogger("SimpleQuery").log(Level.WARNING, sQLException2.getStackTrace()[0].toString(), sQLException2);
            sQLException = sQLException2;
        }
        catch (Exception exception) {
            Logger.getLogger("SimpleQuery").log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            try {
                if (bl) {
                    passThrough3Manager.restore();
                }
                if (object3 != null) {
                    object3.close();
                }
            }
            catch (Exception exception) {}
        }
        return sQLException;
    }

    public static synchronized void removeOracleConnection(String string) {
        if (CGCPanel.inhibitIdleInit) {
            return;
        }
        if (_connectionMap == null) {
            return;
        }
        _connectionMap.remove(string);
        Logger.getLogger("SimpleQuery").log(Level.INFO, "Cached connection removed for " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Connection getOracleConnection(DBObject dBObject) {
        String string;
        Connection connection;
        if (CGCPanel.inhibitIdleInit) {
            return null;
        }
        if (_connectionMap == null) {
            _connectionMap = new Hashtable();
            Logger.getLogger("SimpleQuery").log(Level.INFO, "Hash of Oracle connection created");
        }
        if ((connection = _connectionMap.get(string = Connections.getInstance().getConnectionName(dBObject.getConnection()))) != null) {
            Logger.getLogger("SimpleQuery").log(Level.INFO, "Return cached oracle connection for " + string);
            return connection;
        }
        try {
            connection = Connections.getInstance().getUniqueConnection(string);
        }
        catch (Exception exception) {
            Logger.getLogger("SimpleQuery").log(Level.WARNING, "getUniqueConnection exception");
            return null;
        }
        if (connection == null) {
            Logger.getLogger("SimpleQuery").log(Level.WARNING, "getUniqueConnection failed");
            return null;
        }
        Logger.getLogger("SimpleQuery").log(Level.INFO, "Oracle connection created for " + string);
        Statement statement = null;
        try {
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            statement.executeQuery("call ttOptSetFlag('PassThrough', 3)");
        }
        catch (SQLException sQLException) {
            Logger.getLogger("SimpleQuery").log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (Exception exception) {
            Logger.getLogger("SimpleQuery").log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
        _connectionMap.put(string, connection);
        Logger.getLogger("SimpleQuery").log(Level.INFO, "Created oracle connection for " + connection);
        return connection;
    }

    public static String ttGridNameGet(DBObject dBObject) {
        class Foo
        implements ResultSetHandler {
            String _it;

            Foo() {
            }

            @Override
            public void handleResultSet(ResultSet resultSet) {
                try {
                    if (resultSet.next()) {
                        this._it = resultSet.getString(1);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Foo foo = new Foo();
        return SimpleQuery.sendQuery(dBObject, "call ttGridNameGet()", foo) == null ? foo._it : null;
    }

    public static int ttOptGetFlag(DBObject dBObject, String string) {
        Foo foo;
        String string2 = "call ttOptGetFlag('" + string + "')";
        class Foo
        implements ResultSetHandler {
            int _flag;

            Foo() {
            }

            @Override
            public void handleResultSet(ResultSet resultSet) {
                try {
                    if (resultSet.next()) {
                        this._flag = resultSet.getInt(2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return SimpleQuery.sendQuery(dBObject, string2, foo = new Foo()) == null ? foo._flag : -1;
    }

    public static void ttOptSetFlag(DBObject dBObject, String string, int n) {
        String string2 = "call ttOptSetFlag('" + string + "', " + n + ")";
        SimpleQuery.noExceptionQuery(dBObject, string2);
    }

    public static boolean anyResultQuery(DBObject dBObject, String string) {
        class Foo
        implements ResultSetHandler {
            boolean good = false;

            Foo() {
            }

            @Override
            public void handleResultSet(ResultSet resultSet) {
                try {
                    if (resultSet.next()) {
                        this.good = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Foo foo = new Foo();
        if (SimpleQuery.sendQuery(dBObject, string, foo) == null) {
            return foo.good;
        }
        return false;
    }

    public static boolean noExceptionQuery(DBObject dBObject, String string) {
        return SimpleQuery.sendQuery(dBObject, string, null) == null;
    }

    public static String[] nStringColQuery(DBObject dBObject, String string, int n) {
        return SimpleQuery.nStringColQuery(dBObject, string, n, false);
    }

    public static String[] nStringColQuery(DBObject dBObject, String string, int n, Boolean bl) {
        class Foo
        implements ResultSetHandler {
            int n;
            String[] str;

            Foo(int n) {
                this.n = n;
                this.str = new String[this.n];
            }

            @Override
            public void handleResultSet(ResultSet resultSet) {
                try {
                    if (resultSet.next()) {
                        for (int i = 0; i < this.n; ++i) {
                            this.str[i] = resultSet.getString(i + 1).trim();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Foo foo = new Foo(n);
        if (SimpleQuery.sendQuery(dBObject, string, foo, bl) == null) {
            return foo.str;
        }
        return null;
    }

    public static String oneStringColQuery(DBObject dBObject, String string) {
        String[] stringArray = SimpleQuery.nStringColQuery(dBObject, string, 1);
        try {
            return stringArray[0];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String[] nString1ColQuery(DBObject dBObject, String string, boolean bl) {
        class Foo
        implements ResultSetHandler {
            int n;
            String[] str;

            Foo() {
            }

            @Override
            public void handleResultSet(ResultSet resultSet) {
                ArrayList<String> arrayList = new ArrayList<String>();
                try {
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getString(1).trim());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.n = arrayList.size();
                this.str = arrayList.toArray(new String[this.n]);
            }
        }
        Foo foo = new Foo();
        if (SimpleQuery.sendQuery(dBObject, string, foo, bl) == null) {
            return foo.str;
        }
        return null;
    }

    public static String ttVersion(DBObject dBObject) {
        String string = dBObject.getConnectionName();
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        String string2 = null;
        string2 = properties.getProperty("DatabaseProductVersion");
        if (string2 == null) {
            try {
                Connection connection = dBObject.getConnection();
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                string2 = databaseMetaData.getDatabaseProductVersion();
                properties.put("DatabaseProductVersion", string2);
                int n = databaseMetaData.getDatabaseMajorVersion();
                properties.put("DatabaseMajorVersion", (Object)n);
                int n2 = databaseMetaData.getDatabaseMinorVersion();
                properties.put("DatabaseMinorVersion", (Object)n2);
                String string3 = databaseMetaData.getDriverVersion();
                properties.put("DriverVersion", (Object)n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }

    public static Object[] getOraTblsNames(DBObject dBObject) {
        class Foo
        implements ResultSetHandler {
            Object[] columns;

            Foo() {
            }

            @Override
            public void handleResultSet(ResultSet resultSet) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        if (string != null) {
                            string = string.trim();
                        }
                        arrayList.add("");
                        arrayList2.add(string);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger("SimpleQuery").log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                this.columns = new Object[]{arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray(new String[arrayList2.size()])};
            }
        }
        Foo foo = new Foo();
        SQLException sQLException = SimpleQuery.sendQuery(dBObject, "select table_name from cat", foo, true);
        if (sQLException == null) {
            return foo.columns;
        }
        Logger.getLogger("SimpleQuery").log(Level.WARNING, "getOraTblsNames failed");
        while (sQLException != null) {
            Logger.getLogger("SimpleQuery").log(Level.WARNING, " code=" + sQLException.getErrorCode() + ", state=" + sQLException.getSQLState() + ", message=" + sQLException.getMessage());
            sQLException = sQLException.getNextException();
        }
        return null;
    }

    public static Object[] getOraTblsNames_gen(DBObject dBObject) {
        class Foo
        implements ResultSetHandler {
            Object[] columns;

            Foo() {
            }

            @Override
            public void handleResultSet(ResultSet resultSet) {
                String string = null;
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                try {
                    while (resultSet.next()) {
                        string = resultSet.getString(1);
                        if (string == null) continue;
                        string = string.trim();
                        String string2 = resultSet.getString(2);
                        if (string2 != null) {
                            string2 = string2.trim();
                        }
                        arrayList.add(string);
                        arrayList2.add(string2);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger("SimpleQuery").log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                this.columns = new Object[]{arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray(new String[arrayList2.size()])};
            }
        }
        Foo foo = new Foo();
        SQLException sQLException = SimpleQuery.sendQuery(dBObject, " select owner, object_name  from sys.all_objects  where  owner <> 'SYS' and  owner <> 'SYSTEM' and  owner <> 'CTXSYS' and  owner <> 'DBSNMP' and  owner <> 'DMSYS' and  owner <> 'EXFSYS' and  owner <> 'MDDATA' and  owner <> 'MDSYS' and  owner <> 'OLAPSYS' and  owner <> 'ORDPLUGINS' and  owner <> 'ORDSYS' and  owner <> 'OUTLN' and  owner <> 'SI_INFORMTN_SCHEMA' and  owner <> 'SYSMAN' and  owner <> 'TSMSYS' and  owner <> 'WKSYS' and  owner <> 'WMSYS' and  owner <> 'XDB' and  object_type in  ('MATERIALIZED VIEW', 'TABLE', 'SYNONYM')  and object_name not like '%_AGENT_STATUS'  and object_name not like '%_REPACTIVESTANDBY'  and object_name not like '%_USER_COUNT'  and object_name not like '%_SYNC_OBJS'  and object_name not like '%_REPPEERS'  group by owner, object_name  having count(*) = 1  order by 1,2 ", foo, true);
        if (sQLException == null) {
            return foo.columns;
        }
        Logger.getLogger("SimpleQuery").log(Level.WARNING, "getOraTblsNames failed");
        while (sQLException != null) {
            Logger.getLogger("SimpleQuery").log(Level.WARNING, " code=" + sQLException.getErrorCode() + ", state=" + sQLException.getSQLState() + ", message=" + sQLException.getMessage());
            sQLException = sQLException.getNextException();
        }
        return null;
    }

    public static Hashtable<String, String> tblsingroups(DBObject dBObject) {
        class Foo
        implements ResultSetHandler {
            Hashtable<String, String> s;

            Foo() {
            }

            @Override
            public void handleResultSet(ResultSet resultSet) {
                this.s = new Hashtable();
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1).trim() + "." + resultSet.getString(2).trim();
                        String string2 = resultSet.getString(3).trim();
                        this.s.put(string, string2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Foo foo = new Foo();
        if (SimpleQuery.sendQuery(dBObject, "SELECT t.tblowner, t.tblname, cg.cgname FROM sys.cache_group cg, sys.tables t WHERE t.cachegroup > 0 AND cg.cgid = t.cachegroup ORDER BY tblowner, tblname", foo) == null) {
            return foo.s;
        }
        return null;
    }

    public static String[] getSynonymInfo(DBObject dBObject) {
        return SimpleQuery.getSynonymInfo(dBObject, false);
    }

    public static String[] getSynonymInfo(DBObject dBObject, Boolean bl) {
        return SimpleQuery.getSynonymInfo(dBObject, dBObject.getSchemaName(), dBObject.getObjectName(), bl);
    }

    public static String[] getSynonymInfo(DBObject dBObject, String string, String string2, Boolean bl) {
        String string3 = "SELECT  RTRIM(OWNER), RTRIM(SYNONYM_NAME), RTRIM(TABLE_OWNER),  RTRIM(TABLE_NAME) FROM SYS.ALL_SYNONYMS WHERE RTRIM(OWNER) = '" + string + "' AND  RTRIM(SYNONYM_NAME) = '" + string2 + "'";
        return SimpleQuery.nStringColQuery(dBObject, string3, 4, bl);
    }

    public static String[] getTTPKType(DBObject dBObject) {
        String string = "SELECT IXTYPE,PAGESPARAM FROM SYS.INDEXES i, SYS.TABLES t WHERE t.TBLID=i.TBLID AND i.ISPRIMARY=0x01 AND  RTRIM(t.TBLOWNER) = '" + dBObject.getSchemaName() + "' AND  RTRIM(t.TBLNAME ) = '" + dBObject.getObjectName() + "'";
        return SimpleQuery.nStringColQuery(dBObject, string, 2);
    }

    public static List<String> getNonNullCols(DBObject dBObject) {
        Foo foo;
        String string = "SELECT RTRIM(COLNAME) FROM SYS.TABLES t, SYS.COLUMNS c WHERE t.tblid = c.id AND RTRIM(t.TBLOWNER) = '" + dBObject.getSchemaName() + "' AND  RTRIM(t.TBLNAME ) = '" + dBObject.getObjectName() + "' AND  c.COLOPTIONS & 0x04 <> 0x04 AND  c.SYS4&4 = 0  ORDER BY c.COLNUM";
        class Foo
        implements ResultSetHandler {
            List<String> s;

            Foo() {
            }

            @Override
            public void handleResultSet(ResultSet resultSet) {
                this.s = new ArrayList<String>();
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1).trim();
                        this.s.add(string);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (SimpleQuery.sendQuery(dBObject, string, foo = new Foo()) == null) {
            return foo.s;
        }
        return null;
    }

    public static String dualEval(DBObject dBObject, String string) {
        String string2 = "select " + string + " from dual";
        return SimpleQuery.oneStringColQuery(dBObject, string2);
    }
}

