/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.delete;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oracle.cloudstorage.api.IReply;
import oracle.cloudstorage.api.delete.DeleteObjectReply;
import oracle.cloudstorage.api.delete.IDeleteObjectReply;
import oracle.cloudstorage.api.delete.IDeleteOrphansReply;
import oracle.cloudstorage.api.get.IGetContainerReply;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.header.Map;
import oracle.cloudstorage.api.http.Status;

public class DeleteOrphansReply
extends DeleteObjectReply
implements IDeleteOrphansReply {
    private String current = null;
    private Iterator<String> iterator = null;

    public DeleteOrphansReply() {
        this(null, null, null, null);
    }

    protected DeleteOrphansReply(Map headers, Status status, String msg, IReply.Context context) {
        super(headers, status == null ? -1 : status.getStatusCode(), msg, context);
    }

    @Override
    public Status getStatus() {
        return this.delegate().getStatus();
    }

    @Override
    public String getMessage() {
        return this.delegate().getMessage();
    }

    @Override
    public Map getHeaders() {
        return this.delegate().getHeaders();
    }

    @Override
    public String getHeader(String key) {
        return this.delegate().getHeader(key);
    }

    @Override
    public String getHeader(Header header) {
        return this.delegate().getHeader(header);
    }

    @Override
    public String getContainerHeader(String containerSuffix) {
        return this.delegate().getContainerHeader(containerSuffix);
    }

    @Override
    public String getObjectHeader(String objectSuffix) {
        return this.delegate().getObjectHeader(objectSuffix);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.delegate().iterator();
    }

    @Override
    public boolean isSuccessful() throws InterruptedException {
        return this.isSuccessful(5L, TimeUnit.SECONDS);
    }

    @Override
    public void applyTo(IDeleteObjectReply deleteObjectReply) {
        for (String segmentId : this.getSegmentIds()) {
            Future<IDeleteObjectReply> futureDeleteSegmentReply = this.getSegmentReply(segmentId);
            deleteObjectReply.put(segmentId, futureDeleteSegmentReply);
        }
    }

    @Override
    public void reset() {
        this.current = this.getSegmentIds().isEmpty() ? null : this.getSegmentIds().iterator().next();
        this.iterator = this.getSegmentIds().iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.reset();
        }
        return this.iterator.hasNext();
    }

    @Override
    public boolean isSuccessful(long timeout, TimeUnit unit) throws InterruptedException {
        while (this.hasNext()) {
            try {
                IDeleteObjectReply reply = this.next(timeout, unit);
                if (reply != null && reply.isSuccessful()) continue;
                return false;
            }
            catch (ExecutionException e) {
                return false;
            }
            catch (TimeoutException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public IDeleteObjectReply current() throws InterruptedException, ExecutionException, TimeoutException {
        return this.current(5L, TimeUnit.SECONDS);
    }

    @Override
    public IDeleteObjectReply current(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Future<IDeleteObjectReply> future = this.current == null ? null : this.getSegmentReply(this.current);
        return future == null ? null : future.get(timeout, unit);
    }

    @Override
    public IDeleteObjectReply next() throws InterruptedException, ExecutionException, TimeoutException {
        return this.next(5L, TimeUnit.SECONDS);
    }

    @Override
    public IDeleteObjectReply next(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.iterator == null) {
            this.reset();
        }
        Future<IDeleteObjectReply> future = this.current == null ? null : this.getSegmentReply(this.current);
        this.current = this.iterator.hasNext() ? this.iterator.next() : null;
        return this.current(timeout, unit);
    }

    private IDeleteObjectReply delegate() {
        IDeleteObjectReply delegate = null;
        try {
            if (this.current == null) {
                this.reset();
            }
            if ((delegate = this.current()) == null) {
                delegate = new DeleteObjectReply(new Map(), -1, "No ophan.", null);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            String msg = "Exception thrown waiting for delete reply from " + this.current + ":\n" + e;
            delegate = new DeleteObjectReply(new Map(), Status.GATEWAY_TIMEOUT.getStatusCode(), msg, this.getContext());
        }
        catch (ExecutionException e) {
            String msg = "Exception thrown waiting for delete reply from " + this.current + ":\n" + e;
            delegate = new DeleteObjectReply(new Map(), Status.GATEWAY_TIMEOUT.getStatusCode(), msg, this.getContext());
        }
        return delegate;
    }

    public static IDeleteOrphansReply from(final IGetContainerReply unsuccessfulReply) {
        return new DeleteOrphansReply(unsuccessfulReply.getHeaders(), unsuccessfulReply.getStatus(), unsuccessfulReply.getMessage(), unsuccessfulReply.getContext()){
            private boolean first;
            {
                super(x0, x1, x2, x3);
                this.first = true;
            }

            @Override
            public boolean isSuccessful() throws InterruptedException {
                return unsuccessfulReply.isSuccessful();
            }

            @Override
            public boolean isSuccessful(long timeout, TimeUnit unit) {
                return false;
            }

            @Override
            public void reset() {
                this.first = true;
            }

            @Override
            public IDeleteObjectReply next(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.next();
            }

            @Override
            public IDeleteObjectReply next() throws InterruptedException, ExecutionException, TimeoutException {
                1 next = this.first ? this : null;
                this.first = false;
                return next;
            }

            @Override
            public boolean hasNext() {
                return this.first;
            }

            @Override
            public IDeleteObjectReply current(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.current();
            }

            @Override
            public IDeleteObjectReply current() throws InterruptedException, ExecutionException, TimeoutException {
                return this.first ? this : null;
            }

            @Override
            public void applyTo(IDeleteObjectReply deleteObjectReply) {
            }

            @Override
            public Future<IDeleteObjectReply> put(String segmentId, Future<IDeleteObjectReply> futureDeleteObjectReply) {
                return null;
            }

            @Override
            public Set<String> getSegmentIds() {
                return Collections.emptySet();
            }

            @Override
            public Future<IDeleteObjectReply> getSegmentReply(String segmentId) {
                return null;
            }
        };
    }
}

