/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.border.TitledPane;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizCommon;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizardArb;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class FlashbackPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox _toEnable = new JCheckBox();
    private JLabel _byScnTextLabel = new JLabel(DpWizardArb.getString("EXP_BY_SCN"));
    private JLabel _byDateTextLabel = new JLabel(DpWizardArb.getString("EXP_BY_DATE"));
    private JRadioButton _byScn = new JRadioButton();
    private JRadioButton _byDate = new JRadioButton();
    private ExtractListModel _listModel = null;

    public FlashbackPane() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    private void addLabelandText(JPanel jPanel, int n, JLabel jLabel, JComponent jComponent, int n2, int n3) {
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)jComponent, new GridBagConstraints(1, n, n2, 1, 0.0, 0.0, 18, n3, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this._toEnable = new JCheckBox();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this._toEnable.setText(DpWizardArb.getString("EXP_ENABLE_FLASHBACK_OPTIONS"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._byScn);
        buttonGroup.add(this._byDate);
        this._byScnTextLabel = new JLabel(DpWizardArb.getString("EXP_BY_SCN"));
        this._byDateTextLabel = new JLabel(DpWizardArb.getString("EXP_BY_DATE"));
        jPanel.add((Component)this._byScnTextLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add((Component)this._byScn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add((Component)this._byDateTextLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        jPanel.add((Component)this._byDate, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        TitledPane titledPane = new TitledPane((Component)this._toEnable, (Component)jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)titledPane, "Center");
        this.add((Component)jPanel3, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(3, 5, 3, 3), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 10.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 1, 1, 0.0, 10.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._toEnable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    FlashbackPane.this.setLocalEnabled(true);
                } else {
                    FlashbackPane.this.setLocalEnabled(false);
                }
            }
        });
    }

    void setLocalEnabled(boolean bl) {
        this._byScnTextLabel.setEnabled(bl);
        this._byDateTextLabel.setEnabled(bl);
        this._byScn.setEnabled(bl);
        this._byDate.setEnabled(bl);
    }

    public static String getScn(ExtractListModel extractListModel) {
        String string = (String)extractListModel.getPropertyValue("EXP_SCN_ON_ENTRY");
        return string;
    }

    public void onEntry(TraversableContext traversableContext) {
        this._listModel = (ExtractListModel)traversableContext.get("KEY_EXPORT_OBJECTS");
        if ((Boolean)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_FLASHBACK_ENABLED", Boolean.FALSE) == Boolean.TRUE) {
            this._toEnable.setSelected(true);
            this.setLocalEnabled(true);
        } else {
            this._toEnable.setSelected(false);
            this.setLocalEnabled(false);
        }
        if (Boolean.valueOf(DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_FLASHBACKSCNBOOL", Boolean.TRUE).equals(Boolean.TRUE)).booleanValue()) {
            this._byScn.setSelected(true);
        } else {
            this._byDate.setSelected(true);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Boolean bl = Boolean.FALSE;
        if (this._toEnable.isSelected()) {
            bl = Boolean.TRUE;
        }
        this._listModel.setProperty("DP_EXP_FLASHBACK_ENABLED", (Object)bl);
        bl = Boolean.FALSE;
        if (this._byScn.isSelected() && this._toEnable.isSelected()) {
            bl = Boolean.TRUE;
        }
        this._listModel.setProperty("DP_EXP_FLASHBACKSCNBOOL", (Object)bl);
    }
}

