/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.shardconsole;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableListValue;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import oracle.dbtools.raptor.metrics.dataobject.MarkerValues;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractGridViewMonitor;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.PanelFactory;

public class ShardMonitor
extends AbstractGridViewMonitor {
    private final ObjectProperty<PanelFactory<Region>> shardCellPanelFactoryProperty = new SimpleObjectProperty((Object)this, "shardCellPanelFactory");
    private final ObjectProperty<PanelFactory<Region>> directorCellPanelFactoryProperty = new SimpleObjectProperty((Object)this, "directorCellPanelFactory");
    private final ObjectProperty<PanelFactory<Region>> groupHeaderPanelFactoryProperty = new SimpleObjectProperty((Object)this, "groupLabelPanelFactory");
    private final ObjectProperty<PanelFactory<Region>> spaceHeaderPanelFactoryProperty = new SimpleObjectProperty((Object)this, "spaceLabelPanelFactory");
    private final ObjectProperty<PanelFactory<Region>> regionHeaderPanelFactoryProperty = new SimpleObjectProperty((Object)this, "regionLabelPanelFactory");
    private final ObjectProperty<PanelFactory<Region>> directorHeaderPanelFactoryProperty = new SimpleObjectProperty((Object)this, "regionLabelPanelFactory");
    private final IntegerProperty wrapAroundProperty = new SimpleIntegerProperty((Object)this, "wrapAround", 0);
    private GridPane[][] cellPanels;

    public PanelFactory<Region> getShardCellPanelFactory() {
        return (PanelFactory)this.shardCellPanelFactoryProperty.get();
    }

    public void setShardCellPanelFactory(PanelFactory<Region> panelFactory) {
        this.shardCellPanelFactoryProperty.set(panelFactory);
    }

    public ObjectProperty<PanelFactory<Region>> shardCellPanelFactoryProperty() {
        return this.shardCellPanelFactoryProperty;
    }

    public PanelFactory<Region> getDirectorCellPanelFactory() {
        return (PanelFactory)this.directorCellPanelFactoryProperty.get();
    }

    public void setDirectorCellPanelFactory(PanelFactory<Region> panelFactory) {
        this.directorCellPanelFactoryProperty.set(panelFactory);
    }

    public ObjectProperty<PanelFactory<Region>> directorCellPanelFactoryProperty() {
        return this.directorCellPanelFactoryProperty;
    }

    public PanelFactory<Region> getGroupHeaderPanelFactory() {
        return (PanelFactory)this.groupHeaderPanelFactoryProperty.get();
    }

    public void setGroupHeaderPanelFactory(PanelFactory<Region> panelFactory) {
        this.groupHeaderPanelFactoryProperty.set(panelFactory);
    }

    public ObjectProperty<PanelFactory<Region>> groupHeaderPanelFactoryProperty() {
        return this.groupHeaderPanelFactoryProperty;
    }

    public PanelFactory<Region> getSpaceHeaderPanelFactory() {
        return (PanelFactory)this.spaceHeaderPanelFactoryProperty.get();
    }

    public void setSpaceHeaderPanelFactory(PanelFactory<Region> panelFactory) {
        this.spaceHeaderPanelFactoryProperty.set(panelFactory);
    }

    public ObjectProperty<PanelFactory<Region>> spaceHeaderPanelFactoryProperty() {
        return this.spaceHeaderPanelFactoryProperty;
    }

    public PanelFactory<Region> getRegionHeaderPanelFactory() {
        return (PanelFactory)this.regionHeaderPanelFactoryProperty.get();
    }

    public void setRegionHeaderPanelFactory(PanelFactory<Region> panelFactory) {
        this.regionHeaderPanelFactoryProperty.set(panelFactory);
    }

    public ObjectProperty<PanelFactory<Region>> regionHeaderPanelFactoryProperty() {
        return this.regionHeaderPanelFactoryProperty;
    }

    public PanelFactory<Region> getDirectorHeaderPanelFactory() {
        return (PanelFactory)this.directorHeaderPanelFactoryProperty.get();
    }

    public void setDirectorHeaderPanelFactory(PanelFactory<Region> panelFactory) {
        this.directorHeaderPanelFactoryProperty.set(panelFactory);
    }

    public ObjectProperty<PanelFactory<Region>> directorHeaderPanelFactoryProperty() {
        return this.directorHeaderPanelFactoryProperty;
    }

    public int getWrapAround() {
        return this.wrapAroundProperty.get();
    }

    public void setWrapAround(int n) {
        this.wrapAroundProperty.set(n);
    }

    public IntegerProperty wrapAroundProperty() {
        return this.wrapAroundProperty;
    }

    protected void scanRelated(Context context, Consumer<List<? extends AbstractContextObject>> consumer) {
        consumer.accept(Collections.singletonList(this.getShardCellPanelFactory()));
        consumer.accept(Collections.singletonList(this.getDirectorCellPanelFactory()));
        consumer.accept(Collections.singletonList(this.getGroupHeaderPanelFactory()));
        consumer.accept(Collections.singletonList(this.getSpaceHeaderPanelFactory()));
        consumer.accept(Collections.singletonList(this.getRegionHeaderPanelFactory()));
        consumer.accept(Collections.singletonList(this.getDirectorHeaderPanelFactory()));
    }

    protected void onInit(Context context) {
        super.onInit(context);
        this.getItem().getUpdating().addListener((observableValue, bl, bl2) -> {
            if (context.isPanelRunning() && !bl2.booleanValue()) {
                this.update();
            }
        });
    }

    protected void onStart(Context context) {
        context.startOwnedInstances();
    }

    protected void onStop(Context context) {
        context.stopOwnedInstances();
    }

    protected void onClose(Context context) {
        context.closeOwnedInstances();
    }

    protected Node createCellPanel(int n, int n2) {
        return this.cellPanels[n][n2];
    }

    private void update() {
        Object object;
        Object object2;
        ArrayList[][] arrayListArray;
        PanelFactory<Region> panelFactory;
        PanelFactory<Region> panelFactory22;
        PanelFactory<Region> panelFactory32;
        ObservableListValue observableListValue = this.getItem().getObservable();
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        TreeMap<Object, Integer> treeMap2 = new TreeMap<Object, Integer>();
        for (Object object3 : observableListValue) {
            panelFactory32 = (String)object3.get("Region", String.class).get();
            treeMap.put((String)panelFactory32, (Integer)null);
            panelFactory22 = (PanelFactory<Region>)object3.get("Space", String.class).get();
            if (panelFactory22 == null) continue;
            treeMap2.put(panelFactory22, null);
        }
        this.getColumns().clear();
        int n = 0;
        for (PanelFactory<Region> panelFactory32 : treeMap.keySet()) {
            treeMap.put((String)panelFactory32, n++);
            panelFactory22 = this.getRegionHeaderPanelFactory();
            panelFactory = new PanelFactory<Region>(Collections.singletonMap("Region", panelFactory32));
            arrayListArray = panelFactory22.createPanel((MarkerValues)panelFactory);
            arrayListArray.start();
            object2 = arrayListArray.getPanel();
            this.getColumns().add(object2);
        }
        this.getRows().clear();
        int n2 = 1;
        for (PanelFactory<Region> panelFactory22 : treeMap2.keySet()) {
            treeMap2.put(panelFactory22, n2++);
            panelFactory = this.getSpaceHeaderPanelFactory();
            arrayListArray = new MarkerValues(Collections.singletonMap("Space", panelFactory22));
            object2 = panelFactory.createPanel((MarkerValues)arrayListArray);
            object2.start();
            Node node = object2.getPanel();
            this.getRows().add(node);
        }
        panelFactory32 = this.getDirectorHeaderPanelFactory();
        panelFactory22 = panelFactory32.createPanel();
        panelFactory22.start();
        panelFactory = panelFactory22.getPanel();
        this.getRows().add(0, panelFactory);
        treeMap2.put("$DIRECTORS", 0);
        arrayListArray = new ArrayList[treeMap.size()][treeMap2.size()];
        for (Node node : observableListValue) {
            String string;
            int n3;
            object = (String)node.get("Region", String.class).get();
            int n4 = (Integer)treeMap.get(object);
            ArrayList<Node> arrayList = arrayListArray[n4][n3 = (string = (String)node.get("Space", String.class).get()) != null ? (Integer)treeMap2.get(string) : 0];
            if (arrayList == null) {
                arrayListArray[n4][n3] = arrayList = new ArrayList<Node>();
            }
            arrayList.add(node);
        }
        this.cellPanels = new GridPane[treeMap.size()][treeMap2.size()];
        for (int i = 0; i < treeMap.size(); ++i) {
            for (int j = 0; j < treeMap2.size(); ++j) {
                object = arrayListArray[i][j];
                if (object == null) {
                    this.cellPanels[i][j] = new GridPane();
                    continue;
                }
                if (j == 0) {
                    this.cellPanels[i][0] = this.initDirectorsPanel((List<DXRow>)object);
                    continue;
                }
                this.cellPanels[i][j] = this.initShardsPanel((List<DXRow>)object);
            }
        }
    }

    private GridPane initDirectorsPanel(List<DXRow> list) {
        int n = this.getWrapAround();
        int n2 = n - 1;
        GridPane gridPane = new GridPane();
        gridPane.getStyleClass().add((Object)"director-grid");
        int n3 = 0;
        int n4 = 0;
        for (DXRow dXRow : list) {
            String string = (String)dXRow.get("Director", String.class).get();
            boolean bl = (Boolean)dXRow.get("MasterDirector", Boolean.class).get();
            String string2 = (String)dXRow.get("DirectorRole", String.class).get();
            String string3 = (String)dXRow.get("Host", String.class).get();
            PanelFactory<Region> panelFactory = this.getDirectorCellPanelFactory();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("Director", string);
            hashMap.put("MasterDirector", bl);
            hashMap.put("DirectorRole", string2);
            hashMap.put("Host", string3);
            MarkerValues markerValues = new MarkerValues(hashMap);
            PanelFactory.Instance instance = panelFactory.createPanel(markerValues);
            instance.start();
            Region region = (Region)instance.getPanel();
            gridPane.add((Node)region, n4, n3);
            if (n > 0 && n4 == n2) {
                ++n3;
                n4 = 0;
                continue;
            }
            ++n4;
        }
        return gridPane;
    }

    private GridPane initShardsPanel(List<DXRow> list) {
        DXRow dXRow2;
        TreeMap<String, DXRow> treeMap = new TreeMap<String, DXRow>();
        TreeMap treeMap2 = new TreeMap();
        for (DXRow dXRow2 : list) {
            SortedMap sortedMap;
            String string = (String)dXRow2.get("Group", String.class).get();
            String string2 = (String)dXRow2.get("Shard", String.class).get();
            if (string == null) {
                sortedMap = treeMap;
            } else {
                sortedMap = (SortedMap)treeMap2.get(string);
                if (sortedMap == null) {
                    sortedMap = new TreeMap();
                    treeMap2.put(string, sortedMap);
                }
            }
            sortedMap.put((String)string2, (DXRow)dXRow2);
        }
        int n = this.getWrapAround();
        dXRow2 = new GridPane();
        dXRow2.getStyleClass().add((Object)"group-shard-grid");
        int n2 = 0;
        if (!treeMap.isEmpty()) {
            n2 = this.addGroupRow((GridPane)dXRow2, n2, null, treeMap, n);
        }
        for (SortedMap sortedMap : treeMap2.keySet()) {
            SortedMap sortedMap2 = (SortedMap)treeMap2.get(sortedMap);
            n2 = this.addGroupRow((GridPane)dXRow2, n2, (String)((Object)sortedMap), sortedMap2, n);
        }
        return dXRow2;
    }

    private int addGroupRow(GridPane gridPane, int n, String string, SortedMap<String, DXRow> sortedMap, int n2) {
        Object object;
        PanelFactory.Instance instance;
        int n3 = 0;
        int n4 = n2 - 1;
        if (string != null) {
            PanelFactory<Region> panelFactory = this.getGroupHeaderPanelFactory();
            MarkerValues object2 = new MarkerValues(Collections.singletonMap("Group", string));
            instance = panelFactory.createPanel(object2);
            instance.start();
            object = (Region)instance.getPanel();
            gridPane.add((Node)object, 0, n);
            ++n3;
            if (n2 > 0) {
                ++n4;
            }
        }
        for (String string2 : sortedMap.keySet()) {
            instance = (DXRow)sortedMap.get(string2);
            object = (String)instance.get("ShardRole", String.class).get();
            boolean bl = (Boolean)instance.get("Primary", Boolean.class).get();
            boolean bl2 = (Boolean)instance.get("Deployed", Boolean.class).get();
            String string3 = (String)instance.get("DbState", String.class).get();
            long l = (Long)instance.get("ReplicaSet", Long.class).get();
            String string4 = (String)instance.get("ConnectString", String.class).get();
            long l2 = (Long)instance.get("ChunkCount", Long.class).get();
            PanelFactory<Region> panelFactory = this.getShardCellPanelFactory();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("Shard", string2);
            hashMap.put("ShardRole", object);
            hashMap.put("Primary", bl);
            hashMap.put("Deployed", bl2);
            hashMap.put("DbState", string3);
            hashMap.put("ReplicaSet", l);
            hashMap.put("ConnectString", string4);
            hashMap.put("ChunkCount", l2);
            MarkerValues markerValues = new MarkerValues(hashMap);
            PanelFactory.Instance instance2 = panelFactory.createPanel(markerValues);
            instance2.start();
            Region region = (Region)instance2.getPanel();
            gridPane.add((Node)region, n3, n);
            if (n2 > 0 && n3 == n4) {
                ++n;
                n3 = string != null ? 1 : 0;
                continue;
            }
            ++n3;
        }
        return n + 1;
    }
}

