/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.experimental.panel;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.control.HubSpoke;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.control.HubSpokePanelFactory;
import oracle.dbtools.raptor.metrics.dataobject.DataObject;
import oracle.dbtools.raptor.metrics.dataobject.MapDataObject;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractMonitorObject;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.PanelFactory;

@DefaultProperty(value="item")
public class HubSpokeMonitor
extends AbstractMonitorObject {
    private final ObjectProperty<MapDataObject> itemProperty = new SimpleObjectProperty((Object)this, "item");
    private final StringProperty pathColumnProperty = new SimpleStringProperty((Object)this, "pathColumn");
    private final ObjectProperty<PanelFactory> nodeFactoryProperty = new SimpleObjectProperty((Object)this, "nodeFactory");
    private final ObjectProperty<PanelFactory> flowFactoryProperty = new SimpleObjectProperty((Object)this, "flowFactory");
    private final ObservableList<PanelFactory> sectorFactories = FXCollections.observableArrayList();

    public MapDataObject getItem() {
        return (MapDataObject)this.itemProperty.get();
    }

    public void setItem(MapDataObject mapDataObject) {
        this.itemProperty.set((Object)mapDataObject);
    }

    public ObjectProperty<MapDataObject> itemProperty() {
        return this.itemProperty;
    }

    public String getPathColumn() {
        return (String)this.pathColumnProperty.get();
    }

    public void setPathColumn(String string) {
        this.pathColumnProperty.set((Object)string);
    }

    public StringProperty pathColumnProperty() {
        return this.pathColumnProperty;
    }

    public PanelFactory getNodeFactory() {
        return (PanelFactory)this.nodeFactoryProperty.get();
    }

    public void setNodeFactory(PanelFactory panelFactory) {
        this.nodeFactoryProperty.set((Object)panelFactory);
    }

    public ObjectProperty<PanelFactory> nodeFactoryProperty() {
        return this.nodeFactoryProperty;
    }

    public PanelFactory getFlowFactory() {
        return (PanelFactory)this.flowFactoryProperty.get();
    }

    public void setFlowFactory(PanelFactory panelFactory) {
        this.flowFactoryProperty.set((Object)panelFactory);
    }

    public ObjectProperty<PanelFactory> flowFactoryProperty() {
        return this.flowFactoryProperty;
    }

    public ObservableList<PanelFactory> getSectorFactories() {
        return this.sectorFactories;
    }

    protected Class<? extends Node> getBindToClass() {
        return HubSpoke.class;
    }

    protected void scanRelated(Context context, Consumer<List<? extends AbstractContextObject>> consumer) {
        PanelFactory panelFactory;
        PanelFactory panelFactory2 = (PanelFactory)this.nodeFactoryProperty.get();
        if (panelFactory2 != null) {
            consumer.accept(Collections.singletonList(panelFactory2));
        }
        if ((panelFactory = (PanelFactory)this.flowFactoryProperty.get()) != null) {
            consumer.accept(Collections.singletonList(panelFactory));
        }
        for (PanelFactory panelFactory3 : this.sectorFactories) {
            consumer.accept(Collections.singletonList(panelFactory3));
        }
    }

    protected List<DataObject> getDataObjects(Context context) {
        return Collections.singletonList(this.getItem());
    }

    protected void onInit(Context context) {
        HubSpoke hubSpoke = (HubSpoke)context.getContainer(HubSpoke.class);
        if (hubSpoke != null) {
            this.getItem().getObservable().addListener(change -> {
                if (change.wasAdded()) {
                    this.addSpoke(hubSpoke, (DXRow)change.getValueAdded());
                }
                if (change.wasRemoved()) {
                    this.removeSpoke(hubSpoke, (DXRow)change.getValueRemoved());
                }
            });
        }
    }

    private void addSpoke(HubSpoke hubSpoke, DXRow dXRow) {
        String string = (String)dXRow.get(this.getPathColumn(), String.class).get();
        hubSpoke.setPanelFactory(new HubSpokePanelFactory(){

            @Override
            public Region createSectorPanel(int n, String string) {
                int n2 = HubSpokeMonitor.this.getSectorFactories().size();
                int n3 = n < n2 ? n : n2 - 1;
                PanelFactory panelFactory = (PanelFactory)HubSpokeMonitor.this.getSectorFactories().get(n3);
                Region region = null;
                if (panelFactory != null) {
                    // empty if block
                }
                return region;
            }

            @Override
            public Region createNodePanel(String string) {
                PanelFactory panelFactory = HubSpokeMonitor.this.getNodeFactory();
                Region region = null;
                if (panelFactory != null) {
                    // empty if block
                }
                return region;
            }

            @Override
            public Region createFlowPanel(String string) {
                PanelFactory panelFactory = HubSpokeMonitor.this.getFlowFactory();
                Region region = null;
                if (panelFactory != null) {
                    // empty if block
                }
                return region;
            }
        });
        hubSpoke.getSpokePaths().add((Object)string);
    }

    private void removeSpoke(HubSpoke hubSpoke, DXRow dXRow) {
        String string = (String)dXRow.get(this.getPathColumn(), String.class).get();
        List<Region> list = hubSpoke.findSpokePanels(string);
        for (Region region : list) {
        }
        hubSpoke.getSpokePaths().remove((Object)string);
    }
}

