/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.experimental.panel;

import java.util.Collections;
import java.util.Iterator;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.panel.AbstractNode;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.panel.NestedNodeValue;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.panel.NodeItem;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.panel.NodeValue;
import oracle.dbtools.raptor.metrics.dataobject.BoundMap;
import oracle.dbtools.raptor.metrics.dataobject.MarkerValues;
import oracle.dbtools.raptor.metrics.observable.DXRow;

public class BoundNode
extends AbstractNode {
    private final StringProperty connectionTypeNameProperty = new SimpleStringProperty((Object)this, "connectionTypeName", "sql");
    private final StringProperty pathProperty = new SimpleStringProperty((Object)this, "path");
    private final StringProperty textColumnProperty = new SimpleStringProperty((Object)this, "textColumn");
    private final ObservableMap<String, Object> connectionParameters = FXCollections.observableHashMap();
    private final ObservableMap<String, Object> queryParameters = FXCollections.observableHashMap();

    public String getConnectionTypeName() {
        return (String)this.connectionTypeNameProperty.get();
    }

    public void setConnectionTypeName(String string) {
        this.connectionTypeNameProperty.set((Object)string);
    }

    public StringProperty connectionTypeNameProperty() {
        return this.connectionTypeNameProperty;
    }

    public String getPath() {
        return (String)this.pathProperty.get();
    }

    public void setPath(String string) {
        this.pathProperty.set((Object)string);
    }

    public StringProperty pathProperty() {
        return this.pathProperty;
    }

    public String getTextColumn() {
        return (String)this.textColumnProperty.get();
    }

    public void setTextColumn(String string) {
        this.textColumnProperty.set((Object)string);
    }

    public StringProperty textColumnProperty() {
        return this.textColumnProperty;
    }

    public ObservableMap<String, Object> getConnectionParameters() {
        return this.connectionParameters;
    }

    public ObservableMap<String, Object> getQueryParameters() {
        return this.queryParameters;
    }

    @Override
    ObservableList<NodeItem> createTreeItems(NodeValue nodeValue) {
        BoundMap boundMap = new BoundMap();
        boundMap.setConnectionTypeName(this.getConnectionTypeName());
        boundMap.setPath(this.getPath());
        boundMap.getConnectionParameters().putAll(this.getConnectionParameters());
        boundMap.getQueryParameters().putAll(this.getQueryParameters());
        nodeValue.addDataObjects(Collections.singletonList(boundMap));
        ObservableList observableList = FXCollections.observableArrayList();
        boundMap.getObservable().addListener(change -> {
            DXRow dXRow;
            if (change.wasAdded()) {
                dXRow = (DXRow)change.getValueAdded();
                ObjectProperty objectProperty = dXRow.get(this.getTextColumn(), Comparable.class);
                this.addItem(nodeValue, (ObservableList<NodeItem>)observableList, (Comparable)objectProperty.get(), dXRow);
                objectProperty.addListener((observableValue, comparable, comparable2) -> {
                    this.removeItem((ObservableList<NodeItem>)observableList, (Comparable<?>)comparable);
                    this.addItem(nodeValue, (ObservableList<NodeItem>)observableList, (Comparable<?>)comparable2, dXRow);
                });
            }
            if (change.wasRemoved()) {
                dXRow = (DXRow)change.getValueRemoved();
                this.removeItem((ObservableList<NodeItem>)observableList, (Comparable)dXRow.get(this.getTextColumn(), Comparable.class).get());
            }
        });
        return observableList;
    }

    private void addItem(NodeValue nodeValue, ObservableList<NodeItem> observableList, Comparable<?> comparable, DXRow dXRow) {
        NestedNodeValue nestedNodeValue = new NestedNodeValue(this, nodeValue, comparable, new MarkerValues(dXRow));
        NodeItem nodeItem = new NodeItem(nestedNodeValue);
        observableList.add((Object)nodeItem);
    }

    private void removeItem(ObservableList<NodeItem> observableList, Comparable<?> comparable) {
        NodeItem nodeItem;
        int n = 0;
        Iterator iterator = observableList.iterator();
        while (iterator.hasNext() && !((NodeValue)(nodeItem = (NodeItem)((Object)iterator.next())).getValue()).getTextObject().equals(comparable)) {
            ++n;
        }
        observableList.remove(n);
    }
}

