/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics;

import java.net.URL;
import java.util.EventObject;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.stage.Window;
import oracle.dbtools.raptor.metrics.panel.AbstractController;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.service.dba.DBAViewer;
import oracle.dbtools.raptor.service.report.ReportViewer;
import oracle.ide.model.SingletonProvider;

public abstract class AbstractDBAController
extends AbstractController {
    private Context context;

    protected void onSetContext(URL uRL, Context context) {
        this.context = context;
    }

    protected Context getContext() {
        return this.context;
    }

    protected void drillToReportViewer(MouseEvent mouseEvent, String string) {
        this.drillToReportViewer(mouseEvent, string, null);
    }

    protected void drillToReportViewer(MouseEvent mouseEvent, String string, Map<String, Object> map) {
        ReportViewer reportViewer;
        if (this.isDoubleClickEvent(mouseEvent) && (reportViewer = (ReportViewer)SingletonProvider.find(ReportViewer.class)) != null) {
            reportViewer.show(this.context.getConnectionName(), string, map);
        }
    }

    protected void drillToDBAViewer(MouseEvent mouseEvent, String string) {
        this.drillToDBAViewer(mouseEvent, null, string);
    }

    protected void drillToDBAViewer(MouseEvent mouseEvent, String string, String string2) {
        DBAViewer dBAViewer;
        if (this.isDoubleClickEvent(mouseEvent) && (dBAViewer = (DBAViewer)SingletonProvider.find(DBAViewer.class)) != null) {
            dBAViewer.show(this.context.getConnectionName(), string, string2);
        }
    }

    protected void drillToDBAViewerKey(MouseEvent mouseEvent, String string, String string2) {
        this.drillToDBAViewerKey(mouseEvent, string, null, string2);
    }

    protected void drillToDBAViewerKey(MouseEvent mouseEvent, String string, String string2, String string3) {
        DBAViewer dBAViewer;
        if (this.isDoubleClickEvent(mouseEvent) && (dBAViewer = (DBAViewer)SingletonProvider.find(DBAViewer.class)) != null) {
            dBAViewer.show("dba", string, string2, string3);
        }
    }

    protected <T> T getNodeData(EventObject eventObject) {
        Object object = null;
        Object object2 = eventObject.getSource();
        if (object2 instanceof Node) {
            Node node = (Node)object2;
            try {
                object = node.getUserData();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (T)object;
    }

    protected <T> T getWindowData(EventObject eventObject) {
        Object object = null;
        Object object2 = eventObject.getSource();
        if (object2 instanceof Window) {
            Window window = (Window)object2;
            try {
                object = window.getUserData();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (T)object;
    }

    protected <T> T getMenuData(EventObject eventObject) {
        Object object = null;
        Object object2 = eventObject.getSource();
        if (object2 instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)object2;
            Menu menu = menuItem.getParentMenu();
            if (menu != null) {
                try {
                    object = menu.getUserData();
                }
                catch (Exception exception) {}
            } else {
                ContextMenu contextMenu = menuItem.getParentPopup();
                if (contextMenu != null) {
                    try {
                        object = contextMenu.getUserData();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return (T)object;
    }

    protected boolean isDoubleClickEvent(MouseEvent mouseEvent) {
        return mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() > 1;
    }
}

