/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.pdbs;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.FileNameConvertControl;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.PdbStorageControl;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.PdbsAction;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionValuesLookup;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class ClonePdbsAction
extends PdbsAction {
    private static final String PDB_NAME = "PdbName";
    private static final String REFRESH = "Refresh";
    private static final String REFRESH_TIME = "RefreshTime";
    private static final String SRC_NAME = "SrcName";
    private static final String DB_LINK = "DbLink";
    private static final String PDB_STORAGE = "PdbStorage";
    private static final String FILE_CONVERT = "FileConvert";
    private static final String HELP_ID = "f1_dba_clone_pdb_html";
    private static final String PARALLEL = "ParallelName";
    private static final String OPEN = "Open";
    private String maxParallel;
    private ActionControl dbLink;
    private ActionControl srcDb;
    private ActionControl refresh;

    protected String getHelpId() {
        return HELP_ID;
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("CLONE_PDB_TITLE");
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    protected List<ActionControl> createControls(final Connection connection) {
        Object object;
        this.maxParallel = DBUtil.getInstance((Connection)connection).executeReturnOneCol("select value FROM v$parameter WHERE name = 'parallel_max_servers'");
        Operation operation = this.getOperation();
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(PDB_NAME, DbaNavigatorResources.getString("PDB_NAME"), "NEW_PDB");
        this.dbLink = new SqlComboBoxActionControl(DB_LINK, DbaNavigatorResources.getString("LINK_LABEL"), connection, "select 'NONE' from dual union select db_link from all_db_links");
        ((JComboBox)this.dbLink.getUI()).setSelectedItem("NONE");
        String string = null;
        if (operation == Operation.PDBS) {
            string = this.getDBObjectName();
        }
        final FileNameConvertControl fileNameConvertControl = new FileNameConvertControl(FILE_CONVERT, DbaNavigatorResources.getString("FILE_NAME_CONVERT_LABEL"), connection, string, true, textBoxActionControl.getValue().get());
        if (operation == Operation.PDBS) {
            this.srcDb = new TextBoxActionControl(SRC_NAME, DbaNavigatorResources.getString("SOURCE_PDB"), string);
            this.srcDb.setEditable(false);
            this.dbLink.setEditable(false);
            textBoxActionControl.addPropertyChangeListener(new PropertyChangeListener((ActionControl)textBoxActionControl){
                final /* synthetic */ ActionControl val$pdbName;
                {
                    this.val$pdbName = actionControl;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    fileNameConvertControl.resetSourcePdbName(connection, ClonePdbsAction.this.srcDb.getValue().get(), this.val$pdbName.getValue().get());
                }
            });
            fileNameConvertControl.resetSourcePdbName(connection, this.srcDb.getValue().get(), textBoxActionControl.getValue().get());
        } else {
            object = new SqlComboBoxActionControl(SRC_NAME, DbaNavigatorResources.getString("SOURCE_PDB"), connection, "select name from v$pdbs where name != 'PDB$SEED'");
            object.getUI().addActionListener(arg_0 -> ClonePdbsAction.lambda$createControls$0((SqlComboBoxActionControl)object, fileNameConvertControl, connection, (ActionControl)textBoxActionControl, arg_0));
            this.srcDb = object;
            textBoxActionControl.addPropertyChangeListener(new PropertyChangeListener((SqlComboBoxActionControl)object, (ActionControl)textBoxActionControl){
                final /* synthetic */ SqlComboBoxActionControl val$sqlCombo;
                final /* synthetic */ ActionControl val$pdbName;
                {
                    this.val$sqlCombo = sqlComboBoxActionControl;
                    this.val$pdbName = actionControl;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    fileNameConvertControl.resetSourcePdbName(connection, this.val$sqlCombo.getUI().getSelectedItem().toString(), this.val$pdbName.getValue().get());
                }
            });
            if (object.getUI().getSelectedItem() != null) {
                fileNameConvertControl.resetSourcePdbName(connection, object.getUI().getSelectedItem().toString(), textBoxActionControl.getValue().get());
            }
        }
        this.dbLink.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JComboBox jComboBox = (JComboBox)ClonePdbsAction.this.srcDb.getUI();
                jComboBox.removeAllItems();
                ResultSet resultSet = null;
                if (((JComboBox)ClonePdbsAction.this.dbLink.getUI()).getSelectedItem().equals("NONE")) {
                    ClonePdbsAction.this.refresh.setEditable(false);
                    if (Connections.getInstance().lock(connection)) {
                        try {
                            resultSet = DBUtil.getInstance((Connection)connection).executeQuery("select pdb_name from cdb_pdbs where pdb_name != 'PDB$SEED' ", (Map)null);
                        }
                        finally {
                            Connections.getInstance().unlock(connection);
                        }
                    }
                } else {
                    ClonePdbsAction.this.refresh.setEditable(true);
                    if (Connections.getInstance().lock(connection)) {
                        try {
                            resultSet = DBUtil.getInstance((Connection)connection).executeQuery("select pdb_name from cdb_pdbs@" + ((JComboBox)ClonePdbsAction.this.dbLink.getUI()).getSelectedItem() + " where pdb_name != 'PDB$SEED' ", (Map)null);
                        }
                        finally {
                            Connections.getInstance().unlock(connection);
                        }
                    }
                }
                try {
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            jComboBox.addItem(resultSet.getString(1));
                        }
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        });
        object = new PdbStorageControl(PDB_STORAGE, DbaNavigatorResources.getString("STORAGE_LABEL"));
        TextBoxActionControl textBoxActionControl2 = new TextBoxActionControl(PARALLEL, DbaNavigatorResources.getString("RELOCATE_PARALLEL") + "  (0-" + this.maxParallel + ")  ", "0");
        this.refresh = new ComboBoxActionControl(REFRESH, DbaNavigatorResources.getString("CLONE_REFRESH"), new String[]{"None", "Manual", "Automatic"}, "None");
        this.refresh.setEditable(false);
        TextBoxActionControl textBoxActionControl3 = new TextBoxActionControl(REFRESH_TIME, DbaNavigatorResources.getString("CLONE_REFRESH_TIME"), "0");
        textBoxActionControl3.setEditable(false);
        this.refresh.addPropertyChangeListener(new PropertyChangeListener((ActionControl)textBoxActionControl3){
            final /* synthetic */ ActionControl val$refreshTime;
            {
                this.val$refreshTime = actionControl;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (((JComboBox)ClonePdbsAction.this.refresh.getUI()).getSelectedItem().equals("Automatic")) {
                    this.val$refreshTime.setEditable(true);
                } else {
                    this.val$refreshTime.setEditable(false);
                }
            }
        });
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(OPEN, DbaNavigatorResources.getString("RELOCATE_OPEN"), false);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add(this.srcDb);
        arrayList.add(this.dbLink);
        arrayList.add((ActionControl)textBoxActionControl2);
        arrayList.add((ActionControl)object);
        arrayList.add((ActionControl)fileNameConvertControl);
        arrayList.add(this.refresh);
        arrayList.add((ActionControl)textBoxActionControl3);
        arrayList.add((ActionControl)booleanCheckBoxActionControl);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "    ";
        stringBuilder.append("BEGIN");
        stringBuilder.append('\n' + string);
        stringBuilder.append("EXECUTE IMMEDIATE 'CREATE PLUGGABLE DATABASE ");
        stringBuilder.append('\"' + values.get(PDB_NAME) + '\"');
        stringBuilder.append(" FROM ");
        stringBuilder.append('\"' + values.get(SRC_NAME) + '\"');
        if (!values.get(DB_LINK).equals("NONE")) {
            stringBuilder.append("@\"" + values.get(DB_LINK) + '\"');
        }
        stringBuilder.append(PdbStorageControl.getStorageClause(PDB_STORAGE, (ActionValuesLookup)values, string));
        stringBuilder.append(FileNameConvertControl.getFileNameConvertClause(FILE_CONVERT, (ActionValuesLookup)values, false, true, string));
        if (Integer.valueOf(values.get(PARALLEL)) > 0 && Integer.valueOf(values.get(PARALLEL)) < Integer.valueOf(this.maxParallel)) {
            stringBuilder.append("\n" + string + "  PARALLEL " + values.get(PARALLEL));
        }
        if (!values.get(REFRESH).equals("None")) {
            if (values.get(REFRESH).equals("Manual")) {
                stringBuilder.append("\n" + string + "  REFRESH MODE MANUAL");
            } else {
                stringBuilder.append("\n" + string + "  REFRESH MODE EVERY " + values.get(REFRESH_TIME) + " MINUTES");
            }
        }
        stringBuilder.append("';");
        if (Boolean.parseBoolean(values.get(OPEN))) {
            if (values.get(REFRESH).equals("None")) {
                stringBuilder.append("\n" + string + "EXECUTE IMMEDIATE 'ALTER PLUGGABLE DATABASE " + values.get(PDB_NAME) + " OPEN READ WRITE'; ");
            } else {
                stringBuilder.append("\n" + string + "EXECUTE IMMEDIATE 'ALTER PLUGGABLE DATABASE " + values.get(PDB_NAME) + " OPEN READ ONLY'; ");
            }
        }
        stringBuilder.append("\nEND;");
        return stringBuilder.toString();
    }

    private static /* synthetic */ void lambda$createControls$0(SqlComboBoxActionControl sqlComboBoxActionControl, FileNameConvertControl fileNameConvertControl, Connection connection, ActionControl actionControl, ActionEvent actionEvent) {
        if (sqlComboBoxActionControl.getUI().getSelectedItem() != null) {
            fileNameConvertControl.resetSourcePdbName(connection, sqlComboBoxActionControl.getUI().getSelectedItem().toString(), actionControl.getValue().get());
        }
    }

    private static enum Operation {
        CONTAINER,
        PDBS;

    }
}

