/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.auditsettings;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SelectionActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditAuditedObjects
extends ActionDialog {
    private static final String OBJECT_TYPES = "OBJECT_TYPES";
    private static final String SCHEMAS = "SCHEMAS";
    private static final String OBJECTS = "OBJECTS";
    private static final String EXEC_CONDS = "EXEC_CONDS";
    private static final String GRANULARITIES = "GRANULARITIES";
    private static final String SELECTIONS = "SELECTIONS";
    private ComboBoxActionControl _objectTypesCtl;
    private ComboBoxActionControl _schemasCtl;
    private ComboBoxActionControl _objectsCtl;
    private ComboBoxActionControl _execCondsCtl;
    private ComboBoxActionControl _granularitiesCtl;
    private SelectionActionControl _selectionCtl;
    private ArrayList<String> _initialValues;

    protected String getTitle() {
        return DbaNavigatorResources.getString("EDIT_AUDITED_OBJECTS_TITLE");
    }

    protected List<ActionControl> createControls(final Connection connection) {
        this._objectTypesCtl = new ComboBoxActionControl(OBJECT_TYPES, DbaNavigatorResources.getString("OBJECT_TYPE_LABEL"), this.toStringArray(this.getObjectTypes()));
        this._schemasCtl = new ComboBoxActionControl(SCHEMAS, DbaNavigatorResources.getString("SCHEMA_LABEL"), this.toStringArray(this.getSchemas(connection)));
        this._objectsCtl = new ComboBoxActionControl(OBJECTS, DbaNavigatorResources.getString("OBJECT_NAME_LABEL"), this.toStringArray(this.getObjects(connection, this._objectTypesCtl.getValue().get(), this._schemasCtl.getValue().get())));
        this._execCondsCtl = new ComboBoxActionControl(EXEC_CONDS, DbaNavigatorResources.getString("EXEC_COND_LABEL"), this.toStringArray(this.getExecConditions()));
        this._granularitiesCtl = new ComboBoxActionControl(GRANULARITIES, DbaNavigatorResources.getString("DML_AUDIT_GRANULARITY_LABEL"), this.toStringArray(this.getGranularities()));
        this._selectionCtl = new SelectionActionControl(SELECTIONS, DbaNavigatorResources.getString("STATEMENTS_LABEL"), this.getInitialItems(connection), this.getSourceItems(connection));
        this._objectTypesCtl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EditAuditedObjects.this._objectsCtl.reset(EditAuditedObjects.this.toStringArray(EditAuditedObjects.this.getObjects(connection, EditAuditedObjects.this._objectTypesCtl.getValue().get(), EditAuditedObjects.this._schemasCtl.getValue().get())));
                EditAuditedObjects.this._selectionCtl.resetListContents(EditAuditedObjects.this.getInitialItems(connection), EditAuditedObjects.this.getSourceItems(connection));
            }
        });
        this._schemasCtl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EditAuditedObjects.this._objectsCtl.reset(EditAuditedObjects.this.toStringArray(EditAuditedObjects.this.getObjects(connection, EditAuditedObjects.this._objectTypesCtl.getValue().get(), EditAuditedObjects.this._schemasCtl.getValue().get())));
                EditAuditedObjects.this._selectionCtl.resetListContents(EditAuditedObjects.this.getInitialItems(connection), EditAuditedObjects.this.getSourceItems(connection));
            }
        });
        this._objectsCtl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (EditAuditedObjects.this._objectsCtl.getNumSelections() > 0) {
                    EditAuditedObjects.this._selectionCtl.resetListContents(EditAuditedObjects.this.getInitialItems(connection), EditAuditedObjects.this.getSourceItems(connection));
                }
            }
        });
        this._execCondsCtl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (EditAuditedObjects.this._objectsCtl.getNumSelections() > 0) {
                    EditAuditedObjects.this._selectionCtl.resetListContents(EditAuditedObjects.this.getInitialItems(connection), EditAuditedObjects.this.getSourceItems(connection));
                }
            }
        });
        this._granularitiesCtl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (EditAuditedObjects.this._objectsCtl.getNumSelections() > 0) {
                    EditAuditedObjects.this._selectionCtl.resetListContents(EditAuditedObjects.this.getInitialItems(connection), EditAuditedObjects.this.getSourceItems(connection));
                }
            }
        });
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)this._objectTypesCtl);
        arrayList.add((ActionControl)this._schemasCtl);
        arrayList.add((ActionControl)this._objectsCtl);
        arrayList.add((ActionControl)this._execCondsCtl);
        arrayList.add((ActionControl)this._granularitiesCtl);
        arrayList.add((ActionControl)this._selectionCtl);
        return arrayList;
    }

    private String[] toStringArray(List<String> list) {
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        return stringArray;
    }

    private List<String> getObjectTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ObjectType objectType : ObjectType.values()) {
            arrayList.add(objectType.getDisplayName());
        }
        return arrayList;
    }

    private List<String> getExecConditions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(DbaNavigatorResources.getString("SUCCESS_OR_FAILURE_ITEM"));
        arrayList.add(DbaNavigatorResources.getString("SUCCESS_ITEM"));
        arrayList.add(DbaNavigatorResources.getString("FAILURE_ITEM"));
        return arrayList;
    }

    private List<String> getGranularities() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(DbaNavigatorResources.getString("BY_SESSION_ITEM"));
        arrayList.add(DbaNavigatorResources.getString("BY_ACCESS_ITEM"));
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getSchemas(Connection connection) {
        ArrayList<String> arrayList;
        block8: {
            arrayList = new ArrayList<String>();
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    HashMap hashMap = new HashMap();
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    resultSet = dBUtil.executeOracleQuery(this.getQuery(connection, "getSchemas"), hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            arrayList.add(resultSet.getString("USERNAME"));
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getObjects(Connection connection, String string, String string2) {
        ArrayList<String> arrayList;
        block8: {
            arrayList = new ArrayList<String>();
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    ObjectType objectType = ObjectType.parseDisplayName(string);
                    String string3 = objectType.getQueryName();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("OWNER", string2);
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    resultSet = dBUtil.executeOracleQuery(this.getQuery(connection, string3), hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            arrayList.add(resultSet.getString("NAME"));
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return arrayList;
    }

    private List<String> getSourceItems(Connection connection) {
        ObjectType objectType = ObjectType.parseDisplayName(this._objectTypesCtl.getValue().get());
        Statement[] statementArray = objectType.getStatements();
        ArrayList<String> arrayList = new ArrayList<String>(statementArray.length);
        for (Statement statement : statementArray) {
            arrayList.add(statement.toString());
        }
        arrayList.removeAll(this.getInitialItems(connection));
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getInitialItems(Connection connection) {
        ArrayList<String> arrayList;
        block16: {
            String string = this._objectTypesCtl.getValue().get();
            String string2 = this._schemasCtl.getValue().get();
            String string3 = this._objectsCtl.getValue().get();
            String string4 = this._execCondsCtl.getValue().get();
            String string5 = this._granularitiesCtl.getValue().get();
            arrayList = new ArrayList<String>();
            boolean bl = false;
            boolean bl2 = false;
            String string6 = null;
            if (string4.equals(DbaNavigatorResources.getString("SUCCESS_OR_FAILURE_ITEM"))) {
                bl = true;
                bl2 = true;
            } else if (string4.equals(DbaNavigatorResources.getString("SUCCESS_ITEM"))) {
                bl = true;
            } else if (string4.equals(DbaNavigatorResources.getString("FAILURE_ITEM"))) {
                bl2 = true;
            }
            if (string5.equals(DbaNavigatorResources.getString("BY_SESSION_ITEM"))) {
                string6 = (bl ? "S/" : "-/") + (bl2 ? "S" : Character.valueOf('-'));
            } else if (string5.equals(DbaNavigatorResources.getString("BY_ACCESS_ITEM"))) {
                string6 = (bl ? "A/" : "-/") + (bl2 ? "A" : Character.valueOf('-'));
            }
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("OWNER", string2);
                    hashMap.put("OBJECT", string3);
                    hashMap.put("OBJECT_TYPE", string);
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    resultSet = dBUtil.executeOracleQuery(this.getQuery(connection, "getObjectAuditFlags"), hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            this.addInitialItemIfMatches(resultSet, "AUDIT_ALTER", string6, Statement.ALTER, arrayList);
                            this.addInitialItemIfMatches(resultSet, "AUDIT_AUDIT", string6, Statement.AUDIT, arrayList);
                            this.addInitialItemIfMatches(resultSet, "AUDIT_COMMENT", string6, Statement.COMMENT, arrayList);
                            this.addInitialItemIfMatches(resultSet, "AUDIT_DELETE", string6, Statement.DELETE, arrayList);
                            this.addInitialItemIfMatches(resultSet, "AUDIT_EXECUTE", string6, Statement.EXECUTE, arrayList);
                            this.addInitialItemIfMatches(resultSet, "AUDIT_FLASHBACK", string6, Statement.FLASHBACK, arrayList);
                            this.addInitialItemIfMatches(resultSet, "AUDIT_GRANT", string6, Statement.GRANT, arrayList);
                            this.addInitialItemIfMatches(resultSet, "AUDIT_INDEX", string6, Statement.INDEX, arrayList);
                            this.addInitialItemIfMatches(resultSet, "AUDIT_INSERT", string6, Statement.INSERT, arrayList);
                            this.addInitialItemIfMatches(resultSet, "AUDIT_LOCK", string6, Statement.LOCK, arrayList);
                            this.addInitialItemIfMatches(resultSet, "AUDIT_READ", string6, Statement.READ, arrayList);
                            this.addInitialItemIfMatches(resultSet, "AUDIT_RENAME", string6, Statement.RENAME, arrayList);
                            this.addInitialItemIfMatches(resultSet, "AUDIT_SELECT", string6, Statement.SELECT, arrayList);
                            this.addInitialItemIfMatches(resultSet, "AUDIT_UPDATE", string6, Statement.UPDATE, arrayList);
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block16;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        this._initialValues = arrayList;
        return arrayList;
    }

    private void addInitialItemIfMatches(ResultSet resultSet, String string, String string2, Statement statement, ArrayList<String> arrayList) throws SQLException {
        if (string2.equals(resultSet.getString(string))) {
            arrayList.add(statement.toString());
        }
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        List list = values.getList(SELECTIONS, "SELECTED_ITEMS");
        if (this._initialValues != null) {
            String string2;
            boolean bl = true;
            for (String string2 : this._initialValues) {
                if (list.contains(string2)) continue;
                if (bl) {
                    stringBuffer.append("NOAUDIT\n    ");
                    bl = false;
                } else {
                    stringBuffer.append(",\n    ");
                }
                stringBuffer.append(string2);
            }
            String string3 = values.get(SCHEMAS);
            string2 = values.get(OBJECTS);
            if (!bl) {
                this.addObject(stringBuffer, string3, string2);
                stringBuffer.append(";\n");
            }
            boolean bl2 = true;
            for (String string4 : list) {
                if (this._initialValues.contains(string4)) continue;
                if (bl2) {
                    stringBuffer.append("AUDIT\n    ");
                    bl2 = false;
                } else {
                    stringBuffer.append(",\n    ");
                }
                stringBuffer.append(string4);
            }
            if (!bl2) {
                String string4;
                this.addObject(stringBuffer, string3, string2);
                String string5 = values.get(GRANULARITIES);
                string4 = values.get(EXEC_CONDS);
                if (string5.equals(DbaNavigatorResources.getString("BY_SESSION_ITEM"))) {
                    stringBuffer.append("\nBY SESSION");
                } else {
                    stringBuffer.append("\nBY ACCESS");
                }
                if (string4.equals(DbaNavigatorResources.getString("SUCCESS_ITEM"))) {
                    stringBuffer.append("\nWHENEVER SUCCESSFUL");
                } else if (string4.equals(DbaNavigatorResources.getString("FAILURE_ITEM"))) {
                    stringBuffer.append("\nWHENEVER NOT SUCCESSFUL");
                }
                stringBuffer.append(";\n");
            }
        }
        return stringBuffer.toString();
    }

    private void addObject(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append("\nON \"");
        stringBuffer.append(string);
        stringBuffer.append("\".\"");
        stringBuffer.append(string2);
        stringBuffer.append("\"");
    }

    public static enum Statement {
        ALTER,
        AUDIT,
        COMMENT,
        DELETE,
        EXECUTE,
        FLASHBACK,
        GRANT,
        INDEX,
        INSERT,
        LOCK,
        READ,
        RENAME,
        SELECT,
        UPDATE;

    }

    public static enum ObjectType {
        DIRECTORY,
        FUNCTION,
        LIBRARY,
        MATERIALIZED_VIEW,
        OBJECT_TYPE,
        PACKAGE,
        PROCEDURE,
        SEQUENCE,
        TABLE,
        VIEW;


        public static ObjectType parseDisplayName(String string) {
            return ObjectType.valueOf(string.replace(' ', '_'));
        }

        public String getDisplayName() {
            return this.toString().replace('_', ' ');
        }

        public Statement[] getStatements() {
            Statement[] statementArray = null;
            switch (this) {
                case DIRECTORY: {
                    statementArray = new Statement[]{Statement.AUDIT, Statement.GRANT, Statement.READ};
                    break;
                }
                case FUNCTION: 
                case PACKAGE: 
                case PROCEDURE: {
                    statementArray = new Statement[]{Statement.AUDIT, Statement.EXECUTE, Statement.GRANT};
                    break;
                }
                case LIBRARY: {
                    statementArray = new Statement[]{Statement.EXECUTE, Statement.GRANT};
                    break;
                }
                case MATERIALIZED_VIEW: {
                    statementArray = new Statement[]{Statement.ALTER, Statement.AUDIT, Statement.COMMENT, Statement.DELETE, Statement.INDEX, Statement.INSERT, Statement.LOCK, Statement.SELECT, Statement.UPDATE};
                    break;
                }
                case OBJECT_TYPE: {
                    statementArray = new Statement[]{Statement.ALTER, Statement.AUDIT, Statement.GRANT};
                    break;
                }
                case SEQUENCE: {
                    statementArray = new Statement[]{Statement.ALTER, Statement.AUDIT, Statement.GRANT, Statement.SELECT};
                    break;
                }
                case TABLE: {
                    statementArray = new Statement[]{Statement.ALTER, Statement.AUDIT, Statement.COMMENT, Statement.DELETE, Statement.FLASHBACK, Statement.GRANT, Statement.INDEX, Statement.INSERT, Statement.LOCK, Statement.RENAME, Statement.SELECT, Statement.UPDATE};
                    break;
                }
                case VIEW: {
                    statementArray = new Statement[]{Statement.AUDIT, Statement.COMMENT, Statement.DELETE, Statement.FLASHBACK, Statement.GRANT, Statement.INSERT, Statement.LOCK, Statement.RENAME, Statement.SELECT, Statement.UPDATE};
                }
            }
            return statementArray;
        }

        public String getQueryName() {
            String string = null;
            switch (this) {
                case DIRECTORY: {
                    string = "getDirectories";
                    break;
                }
                case FUNCTION: {
                    string = "getFunctions";
                    break;
                }
                case PACKAGE: {
                    string = "getPackages";
                    break;
                }
                case PROCEDURE: {
                    string = "getProcedures";
                    break;
                }
                case LIBRARY: {
                    string = "getLibraries";
                    break;
                }
                case MATERIALIZED_VIEW: {
                    string = "getMaterializedViews";
                    break;
                }
                case OBJECT_TYPE: {
                    string = "getObjectTypes";
                    break;
                }
                case SEQUENCE: {
                    string = "getSequences";
                    break;
                }
                case TABLE: {
                    string = "getTables";
                    break;
                }
                case VIEW: {
                    string = "getViews";
                }
            }
            return string;
        }
    }
}

