/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.scheduler;

import java.awt.BorderLayout;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.workflow.scheduler.DialogsLrb;
import oracle.dmt.dataminer.workflow.scheduler.ScheduleWorkflowDialog;
import oracle.dmt.dataminer.workflow.scheduler.SchedulerModel;
import oracle.ide.Context;

public class NodesPanel
extends JPanel {
    private Logger theLogger = Logger.getLogger(this.getClass().getName());
    private Context context;
    private ScheduleWorkflowDialog parent;
    private SchedulerModel model;
    private DataMinerTablePanel runNodesTablePanel;
    private runNodesModel nodesModel;
    private static String COL_NAME = DialogsLrb.get("SCHEDULER_ADVANCED_NODES_NAME");
    private static String COL_TYPE = DialogsLrb.get("SCHEDULER_ADVANCED_NODES_TYPE");
    private JPanel jPanel1;

    public NodesPanel(Context context, ScheduleWorkflowDialog scheduleWorkflowDialog) {
        this.context = context;
        this.parent = scheduleWorkflowDialog;
        this.model = scheduleWorkflowDialog.getModel();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initRes() {
    }

    public void initUI() {
        this.runNodesTablePanel = new DataMinerTablePanel();
        this.nodesModel = new runNodesModel<SchedulerModel.RunNodeInfo>(this.model.getNodes());
        String string = MessageFormat.format(DialogsLrb.get("SCHEDULER_ADVANCED_NODES_TABLE_TITLE"), this.nodesModel.getRowCount());
        this.runNodesTablePanel.setup((TableModel)((Object)this.nodesModel), string, new String[]{COL_NAME, COL_TYPE}, 0);
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.add(this.runNodesTablePanel);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 410, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 278, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    public class runNodesModel<T extends SchedulerModel.RunNodeInfo>
    extends ODMrTableModel<T> {
        private int COL_NAME_IDX;
        private int COL_TYPE_IDX;

        public runNodesModel(List<T> list) {
            super(new String[]{COL_NAME, COL_TYPE}, list);
            this.COL_NAME_IDX = 0;
            this.COL_TYPE_IDX = 1;
        }

        public Object getValueAt(int n, int n2) {
            List list = this.getSrcData();
            SchedulerModel.RunNodeInfo runNodeInfo = (SchedulerModel.RunNodeInfo)list.get(n);
            if (n2 == this.COL_NAME_IDX) {
                return runNodeInfo.getName();
            }
            if (n2 == this.COL_TYPE_IDX) {
                return runNodeInfo.getType();
            }
            return null;
        }
    }
}

