/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.r;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.CommentTextFieldEditor;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.OutputCellEditor;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.controls.renderers.OutputCellRenderer;
import oracle.dmt.dataminer.core.utils.comparator.BooleanComparator;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNodeUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.tviewer.TestCompareNode;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditDialog;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildNodeTableModel;
import oracle.dmt.dataminer.workflow.dialog.build.ModelNameCellEditor;
import oracle.dmt.dataminer.workflow.dialog.build.NewRModelPanel;
import oracle.dmt.dataminer.workflow.inspect.AbstractButtonState;
import oracle.dmt.dataminer.workflow.inspect.GeneralBuildPIPanel;
import oracle.dmt.dataminer.workflow.inspect.ModelBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.r.RBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.r.RBuildPIComponentGUI;
import oracle.dmt.dataminer.workflow.inspect.r.RBuildPIComponentHelper;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.RBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ExtensibleBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RBuildNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.util.Pair;

public class RBuildPIComponentBuildPanel
extends GeneralBuildPIPanel
implements RBuildPIComponentGUI {
    private static final Logger LOGGER = Logger.getLogger(RBuildPIComponentBuildPanel.class.getName());
    private static String NOT_TESTED_STRING_RESOURCE = BuildEditorLrb.get("BUILD_MODEL_NOT_TESTED");
    private static final String NOT_TESTED = "Not tested";
    private List<? extends MiningResultType> miningResults;
    private MiningFunctionType miningFunctionType;
    private boolean isSupervised;
    private JButton viewCompareButton;
    private JButton viewModelButton;
    private JButton removeModelButton;
    private JButton addModelButton;
    private DataMinerTablePanel dataMinerTablePanel;

    public RBuildPIComponentBuildPanel(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        if (abstractBuildNode.getMiningFunctionType() != null) {
            this.loadResults(abstractBuildNode);
        }
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void loadResults(AbstractBuildNode abstractBuildNode) {
        this.miningFunctionType = abstractBuildNode.getMiningFunctionType();
        switch (this.miningFunctionType) {
            case CLASSIFICATION: {
                this.miningResults = MetaDataHelper.getClassificationResultsCollection(abstractBuildNode);
                this.isSupervised = true;
                break;
            }
            case REGRESSION: {
                this.miningResults = MetaDataHelper.getRegressionResultsCollection(abstractBuildNode);
                this.isSupervised = true;
                break;
            }
            default: {
                this.miningResults = Collections.emptyList();
            }
        }
    }

    @Override
    public Context getContext(PropertyModel propertyModel) {
        return RBuildPIComponentHelper.getContext(propertyModel);
    }

    @Override
    public AbstractBuildNode getTargetNode(PropertyModel propertyModel) {
        return RBuildPIComponentHelper.getTargetNode(propertyModel);
    }

    @Override
    public void updateCell(int n, int n2) {
        GenericBaseTableModel genericBaseTableModel = (GenericBaseTableModel)this.getTable().getModel();
        genericBaseTableModel.fireTableCellUpdated(n, n2);
    }

    @Override
    protected int getModelNameIdFromPropertyModel() {
        return RBuildNodePropertyModel.MODEL_NAME.index;
    }

    @Override
    protected int getModelsRerunIdFromPropertyModel() {
        return RBuildNodePropertyModel.MODELS_RERUN.index;
    }

    @Override
    protected int getTestsRerunIdFromPropertyModel() {
        return RBuildNodePropertyModel.TESTS_RERUN.index;
    }

    @Override
    public boolean getClearState() {
        return this._clearSearchState;
    }

    @Override
    public void setClearState(boolean bl) {
        this._clearSearchState = bl;
    }

    @Override
    public JPanel getGUIComponent() {
        return this;
    }

    private void initComponents() {
        this.dataMinerTablePanel = new DataMinerTablePanel();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.dataMinerTablePanel, -1, 500, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.dataMinerTablePanel, -1, 201, Short.MAX_VALUE)));
    }

    public void initRes() {
    }

    @Override
    public void initUI(PropertyModel propertyModel) {
        super.initUI(propertyModel);
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        ModelsTableModel modelsTableModel = new ModelsTableModel(this._models);
        this.setupModelsTable(modelsTableModel);
        modelsTableModel.setWritable(this.isWritable());
        this.dataMinerTablePanel.setup((TableModel)((Object)modelsTableModel), BuildEditorLrb.get("BUILD_MODEL_SETTINGS_LBL"), new String[]{modelsTableModel.columns[0], modelsTableModel.columns[this.isSupervised ? 4 : 3]}, 0);
        this.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    XMLGregorianCalendar xMLGregorianCalendar;
                    boolean bl = false;
                    ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)RBuildPIComponentBuildPanel.this.getTable().getModel());
                    if (modelsTableModel.getDataVector().isEmpty()) {
                        return;
                    }
                    int[] nArray = RBuildPIComponentBuildPanel.this.getTable().getSelectedRowsInModel();
                    ModelType modelType = modelsTableModel.getDataVector().get(nArray[0]);
                    if (modelType.getStatus() == ModelStatusType.COMPLETE) {
                        bl = true;
                    } else if (modelType.getStatus() == ModelStatusType.READY && (xMLGregorianCalendar = modelType.getCreationDate()) != null) {
                        bl = true;
                    }
                    if (bl) {
                        RBuildPIComponentBuildPanel.this.viewModel();
                    }
                }
            }
        });
        this.viewModelButton = new JButton(DataMinerIcons.get(Icons.PI_ATTR_GROUP_MODEL_VIEW_MODEL_ENA));
        this.viewModelButton.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_VIEW"));
        this.viewModelButton.setDisabledIcon(DataMinerIcons.get(Icons.PI_ATTR_GROUP_MODEL_VIEW_MODEL_DIS));
        this.viewModelButton.setEnabled(false);
        this.viewModelButton.addActionListener(actionEvent -> this.viewModel());
        this.viewCompareButton = new JButton(OracleIcons.getIcon((String)"showdifferences.png"));
        this.viewCompareButton.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_RESULTS_COMPARE"));
        this.viewCompareButton.setEnabled(this.isSupervised && this.compareEnabled());
        this.viewCompareButton.addActionListener(actionEvent -> {
            List list = this.miningResults.stream().filter(miningResultType -> miningResultType.getCreationDate() != null).collect(Collectors.toList());
            if (list.isEmpty()) {
                return;
            }
            this.viewCompare(list);
        });
        this.removeModelButton = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.removeModelButton.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_REMOVE"));
        this.removeModelButton.addActionListener(actionEvent -> {
            String string = BuildEditDialog.getModelsDeleteMessage((JTable)((Object)this.getTable()));
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)BuildEditorLrb.get("REMOVE_MODELS_TITLE"), null, (boolean)true)) {
                return;
            }
            int[] nArray = this.getTable().getSelectedRowsInModel();
            ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this.getTable().getModel());
            ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
            for (int i = 0; i < nArray.length; ++i) {
                ModelType modelType = modelsTableModel.getDataVector().get(nArray[i]);
                arrayList.add(modelType);
            }
            this.setValue(arrayList, "modelRemoved", "modelAdded");
        });
        this.removeModelButton.setEnabled(false);
        this.addModelButton = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addModelButton.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ADD"));
        this.addModelButton.addActionListener(actionEvent -> {
            AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
            ModelType modelType = NewRModelPanel.addNewModel(this, (BuildNodeType)abstractBuildNode.getData(), this.getContext((PropertyModel)this._model), abstractBuildNode);
            if (modelType != null) {
                ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
                arrayList.add(modelType);
                this.setValue(arrayList, "modelAdded", "modelRemoved");
            }
        });
        this.addModelButton.setEnabled(this.isWritable());
        if (this.isSupervised) {
            this.dataMinerTablePanel.addControlBarComponents(this.addModelButton, this.removeModelButton, this._duplicateBtn, this.viewModelButton, this.viewCompareButton);
        } else {
            this.dataMinerTablePanel.addControlBarComponents(this.addModelButton, this.removeModelButton, this._duplicateBtn, this.viewModelButton);
        }
        this.getTable().getSelectionModel().addListSelectionListener(listSelectionEvent -> this.handleModelSelectionChanged());
        this.getTable().setFillsViewportHeight(true);
    }

    @Override
    public DataMinerTable getTable() {
        return this.dataMinerTablePanel.getTable();
    }

    public void reloadUI(PropertyModel propertyModel) {
        ModelType modelType;
        ModelsTableModel modelsTableModel;
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        if (abstractBuildNode.getMiningFunctionType() != null) {
            this.loadResults(abstractBuildNode);
        }
        int[] nArray = this.getTable().getSelectedRowsInModel();
        ArrayList<ModelType> arrayList = null;
        if (nArray != null && nArray.length > 0) {
            modelsTableModel = (ModelsTableModel)((Object)this.getTable().getModel());
            arrayList = new ArrayList<ModelType>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                modelType = modelsTableModel.getDataVector().get(nArray[i]);
                arrayList.add(modelType);
            }
        }
        modelsTableModel = new ModelsTableModel(this._models);
        this.setupModelsTable(modelsTableModel);
        if (arrayList != null) {
            Object object;
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            modelType = modelsTableModel.getDataVector();
            for (int i = 0; i < modelType.size(); ++i) {
                object = (ModelType)modelType.get(i);
                if (!arrayList.contains(object)) continue;
                arrayList2.add(i);
            }
            if (!arrayList2.isEmpty()) {
                Integer[] integerArray = arrayList2.toArray(new Integer[arrayList2.size()]);
                object = new int[integerArray.length];
                for (int i = 0; i < integerArray.length; ++i) {
                    object[i] = (ModelType)integerArray[i];
                }
                this.getTable().setSelectedRowsInModel((int[])object);
            }
        }
        this.viewCompareButton.setEnabled(this.isSupervised && this.compareEnabled());
        this.dataMinerTablePanel.removeControlBarButtons();
        if (this.isSupervised) {
            this.dataMinerTablePanel.addControlBarComponents(this.addModelButton, this.removeModelButton, this._duplicateBtn, this.viewModelButton, this.viewCompareButton);
        } else {
            this.dataMinerTablePanel.addControlBarComponents(this.addModelButton, this.removeModelButton, this._duplicateBtn, this.viewModelButton);
        }
    }

    @Override
    protected ModelType getModelType(int n) {
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this.getTable().getModel());
        ModelType modelType = modelsTableModel.getDataVector().get(this.getTable().convertRowIndexToModel(n));
        return modelType;
    }

    private void setupModelsTable(ModelsTableModel modelsTableModel) {
        TableColumn tableColumn;
        Serializable serializable;
        DataMinerTable dataMinerTable = this.getTable();
        TableColumnModel tableColumnModel = dataMinerTable.getColumnModel();
        dataMinerTable.setModel((TableModel)((Object)modelsTableModel));
        dataMinerTable.setSorted(true);
        dataMinerTable.setUpdateSelectionOnSort(true);
        dataMinerTable.getTableHeader().setReorderingAllowed(false);
        dataMinerTable.sizeTableToContents();
        dataMinerTable.setAutoResizeMode(4);
        if (modelsTableModel.getRowCount() == 0) {
            return;
        }
        IconCellRenderer iconCellRenderer = new IconCellRenderer((jTable, object, bl, bl2, n, n2) -> {
            ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)jTable.getModel());
            int n3 = jTable.convertRowIndexToModel(n);
            ModelType modelType = modelsTableModel.getDataVector().get(n3);
            return IconCellRenderer.getIconForPIStatus(modelType.getStatus());
        });
        TableColumn tableColumn2 = tableColumnModel.getColumn(2);
        tableColumn2.setCellRenderer(iconCellRenderer);
        if (this.isSupervised) {
            serializable = new IconCellRenderer((jTable, object, bl, bl2, n, n2) -> {
                ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)jTable.getModel());
                int n3 = jTable.convertRowIndexToModel(n);
                ModelType modelType = modelsTableModel.getDataVector().get(n3);
                Optional<MiningResultType> optional = this.miningResults.stream().filter(miningResultType -> modelType.getId().equals(miningResultType.getModelId())).findAny();
                if (NOT_TESTED.equals(object)) {
                    return OracleIcons.getIcon((String)"incompletestatus.png");
                }
                if (optional.isPresent()) {
                    return IconCellRenderer.getIconForPIStatus(optional.get().getStatus());
                }
                return OracleIcons.getIcon((String)"database_error.png");
            });
            tableColumn = tableColumnModel.getColumn(3);
            tableColumn.setCellRenderer((TableCellRenderer)((Object)serializable));
        }
        serializable = tableColumnModel.getColumn(1);
        ((TableColumn)serializable).setCellEditor(new OutputCellEditor());
        ((TableColumn)serializable).setCellRenderer(new OutputCellRenderer());
        tableColumn = tableColumnModel.getColumn(this.isSupervised ? 5 : 4);
        tableColumn.setCellEditor(new CommentTextFieldEditor(this.getContext((PropertyModel)this._model)));
        tableColumn.setMaxWidth(200);
        TableColumn tableColumn3 = tableColumnModel.getColumn(0);
        tableColumn3.setMinWidth(100);
        tableColumn3.setCellEditor(new ModelNameCellEditor(this.getContext((PropertyModel)this._model), this.getWorkflowModel(), (BuildNodeType)this.getTargetNode((PropertyModel)this._model).getData()));
    }

    @Override
    public boolean isWritable() {
        return RBuildPIComponentHelper.isWritable((PropertyModel)this._model);
    }

    private void setEnabled(AbstractButton[] abstractButtonArray, boolean[] blArray) {
        boolean bl = this.isWritable();
        AbstractButtonState abstractButtonState = new AbstractButtonState(abstractButtonArray, blArray);
        abstractButtonState.setState(bl);
    }

    private void setValue(ModelType modelType, Object object) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        if (object != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(modelType.getId(), (String)object);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(RBuildNodePropertyModel.MODEL_ANNOTATION.index), null, new ComplexProperty("modelAnnotation", hashMap), null, null));
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ANNOTATION"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setValue(List<Pair> list) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(new Property(String.valueOf(RBuildNodePropertyModel.MODEL_USEFOROUTPUT.index), null, new ComplexProperty("modelUseForOutput", list), null, null));
        this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_USEFOR_OUTPUT"), abstractBuildNode, arrayList);
        this.updateWorkFlow();
    }

    @Override
    protected void setValue(List<ModelType> list, String string, String string2) {
        RBuildNode rBuildNode = (RBuildNode)this.getTargetNode((PropertyModel)this._model);
        if (rBuildNode == null || list == null || list.isEmpty()) {
            return;
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.MODEL_ADDED_REMOVED.index), null, new ComplexProperty(string, string2, list), null, null));
        if (rBuildNode.isSupervisedBuildNode()) {
            RBuildNodeType rBuildNodeType = (RBuildNodeType)rBuildNode.getData();
            ExtensibleBuildNodeType.Results results = rBuildNodeType.getResults();
            List list2 = rBuildNode.isClassification() ? results.getClassificationResult() : results.getRegressionResult();
            List<MiningResultType> list3 = this.getModelsResults(list, list2);
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.TESTS_ADDED_REMOVED.index), null, new ComplexProperty("testsRemoved", "testsRestored", list3), null, null));
        }
        this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ADDED_REMOVED"), rBuildNode, arrayList);
        this.updateWorkFlow();
        SwingUtilities.invokeLater(() -> this.resetModelSettingsTable((PropertyModel)this._model));
    }

    private List<MiningResultType> getModelsResults(List<ModelType> list, List<? extends MiningResultType> list2) {
        List<MiningResultType> list3 = list.stream().map(modelType -> list2.stream().filter(miningResultType -> modelType.getId().equals(miningResultType.getModelId())).findAny().orElse(null)).filter(miningResultType -> miningResultType != null).collect(Collectors.toList());
        return list3;
    }

    public void resetModelSettingsTable(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        if (abstractBuildNode.getMiningFunctionType() != null) {
            this.loadResults(abstractBuildNode);
        }
        this.reloadUI(propertyModel);
    }

    protected void updateWorkFlow() {
        this.updateWorkFlowInternal();
    }

    private void handleModelSelectionChanged() {
        Object[] objectArray;
        AbstractButton[] abstractButtonArray;
        boolean bl;
        boolean bl2 = false;
        int n = this.getTable().getSelectedRowCount();
        boolean bl3 = bl = n == 1;
        if (n > 0) {
            XMLGregorianCalendar xMLGregorianCalendar;
            abstractButtonArray = (AbstractButton[])this.getTable().getModel();
            objectArray = this.getTable().getSelectedRowsInModel();
            if (objectArray.length == 0) {
                return;
            }
            ModelType modelType = abstractButtonArray.getDataVector().get(objectArray[0]);
            if (modelType.getStatus() == ModelStatusType.COMPLETE) {
                bl2 = true;
            } else if (modelType.getStatus() == ModelStatusType.READY && (xMLGregorianCalendar = modelType.getCreationDate()) != null) {
                bl2 = true;
            }
        }
        this.viewModelButton.setEnabled(bl2 && bl);
        this.viewCompareButton.setEnabled(this.isSupervised && this.compareEnabled());
        abstractButtonArray = new AbstractButton[]{this.viewCompareButton, this.removeModelButton, this.addModelButton, this._duplicateBtn};
        objectArray = new boolean[]{bl2, n > 0, n != -1, true};
        this.setEnabled(abstractButtonArray, (boolean[])objectArray);
    }

    private boolean compareEnabled() {
        boolean bl = false;
        for (MiningResultType miningResultType : this.miningResults) {
            XMLGregorianCalendar xMLGregorianCalendar = miningResultType.getCreationDate();
            if (xMLGregorianCalendar == null) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void viewCompare(List<? extends MiningResultType> list) {
        Context context = this.getContext((PropertyModel)this._model);
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        try {
            Element[] elementArray = context.getSelection();
            WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
            ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)workflowNodeInspectorElement.getNode().getData();
            TestCompareNode testCompareNode = null;
            switch (extensibleBuildNodeType.getMiningFunction()) {
                case CLASSIFICATION: {
                    testCompareNode = WorkflowEditor.createClassTestCompareNode(context, workflowNode, (BuildNodeType)extensibleBuildNodeType, list);
                    break;
                }
                case REGRESSION: {
                    testCompareNode = WorkflowEditor.createRegressTestCompareNode(context, workflowNode, (BuildNodeType)extensibleBuildNodeType, list);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (testCompareNode != null) {
                EditorUtil.openDefaultEditorInFrame((Node)testCompareNode);
            } else {
                MessageDialog.error((Component)this, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_GENERATE_NODE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
            }
        }
        catch (DBException dBException) {
            LOGGER.log(Level.SEVERE, dBException.getMessage(), dBException);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void viewModel() {
        Context context = this.getContext((PropertyModel)this._model);
        int[] nArray = this.getTable().getSelectedRowsInModel();
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this.getTable().getModel());
        ModelType modelType = modelsTableModel.getDataVector().get(nArray[0]);
        String string = modelType.getName();
        String string2 = this.getTargetNode((PropertyModel)this._model).getData().getName();
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        BaseTreeNode baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, string2, string);
        EditorUtil.openDefaultEditorInFrame((Node)baseTreeNode);
    }

    private class ModelsTableModel
    extends SimpleBaseTableModel
    implements BuildNodeTableModel {
        private final String[] supervisedColumnSet = new String[]{PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_NAME"), PropertyLrb.get("PI_ATTRIBUTES_MODEL_USE_FOR_OUTPUT"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_BUILD"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_ALGORITHM"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_COMMENT")};
        private final String[] unsupervisedColumnSet = new String[]{PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_NAME"), PropertyLrb.get("PI_ATTRIBUTES_MODEL_USE_FOR_OUTPUT"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_BUILD"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_ALGORITHM"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_COMMENT")};
        private static final int MODEL_NAME = 0;
        private static final int OUTPUT = 1;
        private static final int BUILD = 2;
        private static final int UNSUPERVISED_ALGORITHM = 3;
        private static final int UNSUPERVISED_COMMENT = 4;
        private static final int TEST = 3;
        private static final int SUPERVISED_ALGORITHM = 4;
        private static final int SUPERVISED_COMMENT = 5;
        private Map<String, ModelType> srcMap;
        private Vector<ModelType> srcData;
        private boolean writable;
        private String[] columns;

        public ModelsTableModel(List<ModelType> list) {
            this.srcData = new Vector(list.size());
            this.srcData.addAll(list);
            this.srcMap = new HashMap<String, ModelType>();
            for (ModelType modelType : list) {
                this.srcMap.put(modelType.getName(), modelType);
            }
            this.columns = RBuildPIComponentBuildPanel.this.isSupervised ? this.supervisedColumnSet : this.unsupervisedColumnSet;
            this.writable = true;
            this.setColumnIdentifiers(this.columns);
            this.setRowCount(this.srcData.size());
            this.setColumnCount(this.columns.length);
        }

        @Override
        public List<ModelType> getDataList() {
            return new ArrayList<ModelType>(this.srcData);
        }

        public Comparator getColumnSortComparator(int n) {
            switch (n) {
                case 1: {
                    return BooleanComparator.getComparator();
                }
            }
            return super.getColumnSortComparator(n);
        }

        public int getRowCount() {
            return this.srcData != null ? this.srcData.size() : 0;
        }

        public void setWritable(boolean bl) {
            this.writable = bl;
        }

        public Vector<ModelType> getDataVector() {
            return this.srcData;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return object.getClass();
            }
            return String.class;
        }

        @Override
        public String getOriginalModelName(int n) {
            ModelType modelType = this.srcData.get(n);
            return modelType.getName();
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            if (this.srcData.isEmpty()) {
                return object;
            }
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            ModelType modelType = this.srcData.get(n);
            switch (n2) {
                case 0: {
                    object = modelType.getName();
                    break;
                }
                case 1: {
                    object = modelType.isUseForOutput();
                    break;
                }
                case 2: {
                    XMLGregorianCalendar xMLGregorianCalendar = modelType.getCreationDate();
                    if (xMLGregorianCalendar != null) {
                        object = TimeUtils.formatDate(xMLGregorianCalendar);
                        break;
                    }
                    object = _NOT_BUILT;
                    break;
                }
                default: {
                    if (RBuildPIComponentBuildPanel.this.isSupervised && n2 == 3) {
                        Optional<XMLGregorianCalendar> optional = RBuildPIComponentBuildPanel.this.miningResults.stream().filter(miningResultType -> miningResultType.getCreationDate() != null && modelType.getId().equals(miningResultType.getModelId())).map(miningResultType -> miningResultType.getCreationDate()).findAny();
                        object = optional.isPresent() ? TimeUtils.formatDate(optional.get()) : NOT_TESTED_STRING_RESOURCE;
                        break;
                    }
                    if (RBuildPIComponentBuildPanel.this.isSupervised && n2 == 4 || !RBuildPIComponentBuildPanel.this.isSupervised && n2 == 3) {
                        object = MetaDataHelper.getAlgorithmName(modelType);
                        break;
                    }
                    if (RBuildPIComponentBuildPanel.this.isSupervised && n2 == 5 || !RBuildPIComponentBuildPanel.this.isSupervised && n2 == 4) {
                        String string = modelType.getAnnotation();
                        object = string != null ? string : "";
                        break;
                    }
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public boolean isCellEditable(int n, int n2) {
            if (!RBuildPIComponentBuildPanel.this.isSupervised && n2 == 4 || RBuildPIComponentBuildPanel.this.isSupervised && n2 == 5 || n2 == 0 || n2 == 1) {
                return this.writable;
            }
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (!RBuildPIComponentBuildPanel.this.isSupervised && n2 == 4 || RBuildPIComponentBuildPanel.this.isSupervised && n2 == 5) {
                ModelType modelType = this.srcData.get(n);
                RBuildPIComponentBuildPanel.this.setValue(modelType, object);
                this.fireTableCellUpdated(n, n2);
            } else if (n2 == 0) {
                RBuildPIComponentBuildPanel.this.renameModel(this.srcData, object, n, n2);
            } else if (n2 == 1) {
                ModelType modelType = this.srcData.get(n);
                Boolean bl = (Boolean)object;
                ArrayList<Pair> arrayList = new ArrayList<Pair>();
                arrayList.add(new Pair((Object)modelType.getId(), (Object)bl));
                RBuildPIComponentBuildPanel.this.setValue(arrayList);
            }
        }
    }
}

