/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.dynamic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.renderers.AttributeNameCellRenderer;
import oracle.dmt.dataminer.core.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.AddSupplementalPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodesLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.OutputDataTableModel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.prediction.PredictionLrb;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.dynamic.DynamicLrb;
import oracle.dmt.dataminer.workflow.inspect.dynamic.DynamicNodeUtility;
import oracle.dmt.dataminer.workflow.inspect.dynamic.Helper;
import oracle.dmt.dataminer.workflow.model.DynamicNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicAnomalyNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicClusterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicFeatureNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicNodeBaseSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicPredictionNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.SupplementalAttributesType;
import oracle.dmt.dataminer.workflow.xmlschema.TargetAttributes;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericTable;

public class DynamicOutputPanel
extends PIComponentPanel {
    private static Helper _helper = new Helper();
    private DynamicNode _targetNode;
    private DynamicNodeBaseSettingsType _baseSettings;
    private TargetAttributes _targetAttrs = new TargetAttributes();
    private OutputDataTableModel outputDataTblModel;
    private JToggleButton autoBtn;
    private SearchField searchField;
    private JButton addBtn;
    private JButton removeBtn;
    private static Icon _removeIcon;
    private boolean allAutomatic = false;
    private String searchText;
    private SearchCategory searchCategory;
    private TableRowSorter<OutputDataTableModel> sorter = null;
    private List<RowSorter.SortKey> sortKeys = null;
    private RowFilter<OutputDataTableModel, Integer> rowFilter;
    private GenericTable jOutputsTable = new DataMinerTable();
    private ComponentWithTitlebar<JComponent> jOutputsComponent;

    public DynamicOutputPanel(PropertyModel propertyModel) {
        super(propertyModel);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.jOutputsComponent = new ComponentWithTitlebar();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 506, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jOutputsComponent, -1, 486, Short.MAX_VALUE).addContainerGap())));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jOutputsComponent, -1, 289, Short.MAX_VALUE))));
    }

    public void initRes() {
    }

    private void installDataUsageActions() {
        boolean bl = this.isWritable();
        ControlBar controlBar = new ControlBar();
        this.autoBtn = new JToggleButton(DynamicNodesLrb.get("BUILD_DATA_USAGE_AUTOMATIC"), DataMinerIcons.get(Icons.AUTO_USAGE));
        this.autoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                boolean bl2 = bl = !DynamicOutputPanel.this.allAutomatic && jToggleButton.isSelected();
                if (bl && !MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DynamicNodesLrb.get("SUPPLEMENTAL_SETTINGS_WARNING"), (String)DynamicNodesLrb.get("SUPPLEMENTAL_SETTINGS_WARNING_TITLE"), null)) {
                    jToggleButton.doClick();
                    return;
                }
                DynamicOutputPanel.this.setAutoUsage(jToggleButton.isSelected(), bl);
            }
        });
        controlBar.add((Component)this.autoBtn);
        controlBar.addSeparator();
        if (_removeIcon == null) {
            _removeIcon = OracleIcons.getIcon((String)"delete.png");
        }
        this.addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addBtn.setToolTipText(PredictionLrb.get("PREDICTION_EDITOR_TOOLTIP_ADD_TARGET"));
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicOutputPanel.this.handleAddSupplementalColumns();
            }
        });
        controlBar.add((Component)this.addBtn);
        this.addBtn.setEnabled(!this.allAutomatic && bl);
        this.removeBtn = new JButton(_removeIcon);
        this.removeBtn.setToolTipText(PredictionLrb.get("PREDICTION_EDITOR_TOOLTIP_REMOVE_TARGET"));
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicOutputPanel.this.removeSupplementalColumns();
            }
        });
        controlBar.add((Component)this.removeBtn);
        this.removeBtn.setEnabled(!this.allAutomatic && bl);
        this.searchField = new SearchField(SearchField.Style.FILTER);
        controlBar.add((Component)this.searchField);
        this.configureSearchField();
        this.jOutputsComponent.setControlBar(controlBar);
        this.searchField.setEnabled(bl);
    }

    public void initUI(PropertyModel propertyModel) {
        ArrayList<String> arrayList;
        CaseAttributes caseAttributes;
        List list;
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        this._targetNode = (DynamicNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        if (nodeType instanceof DynamicPredictionNodeType) {
            this._baseSettings = ((DynamicPredictionNodeType)nodeType).getDynamicNodeBaseSettings();
            this._targetAttrs = ((DynamicPredictionNodeType)nodeType).getPredictionAttributes().getTargetAttributes();
        } else if (nodeType instanceof DynamicClusterNodeType) {
            this._baseSettings = ((DynamicClusterNodeType)nodeType).getDynamicNodeBaseSettings();
        } else if (nodeType instanceof DynamicAnomalyNodeType) {
            this._baseSettings = ((DynamicAnomalyNodeType)nodeType).getDynamicNodeBaseSettings();
        } else if (nodeType instanceof DynamicFeatureNodeType) {
            this._baseSettings = ((DynamicFeatureNodeType)nodeType).getDynamicNodeBaseSettings();
        }
        assert (this._baseSettings != null);
        this.allAutomatic = this._baseSettings.getSupplementalAttributes().getAutoSpec().equals((Object)AutoSpecType.YES);
        JScrollPane jScrollPane = new JScrollPane((Component)this.jOutputsTable);
        this.jOutputsComponent.setComponent((JComponent)jScrollPane);
        this.jOutputsComponent.setLabel(new JLabel(DynamicNodesLrb.get("BUILD_DATA_OUTPUT_LBL")));
        this.installDataUsageActions();
        this.jOutputsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                DynamicOutputPanel.this.handleUsageSelectionChanged(listSelectionModel);
            }
        });
        this.outputDataTblModel = new OutputDataTableModel(this._baseSettings.getSupplementalAttributes());
        this.jOutputsTable.setModel((TableModel)((Object)this.outputDataTblModel));
        TableColumn tableColumn = this.jOutputsTable.getColumnModel().getColumn(0);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        tableColumn.setCellRenderer(attributeNameCellRenderer);
        List<MiningAttributeType> list2 = this.getTargetAttributeList();
        if (list2 != null) {
            attributeNameCellRenderer.setTargetNames(list2);
        }
        if ((list = (caseAttributes = this._baseSettings.getCaseAttributes()).getAttribute()).size() > 0) {
            arrayList = new ArrayList<String>();
            for (AttributeType object : list) {
                arrayList.add(object.getName());
            }
            attributeNameCellRenderer.setKeyNames(arrayList);
        }
        if (this.sortKeys == null) {
            this.sortKeys = new ArrayList<RowSorter.SortKey>();
            this.sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        }
        arrayList = new ArrayList();
        for (RowSorter.SortKey sortKey : this.sortKeys) {
            arrayList.add((String)((Object)sortKey));
        }
        this.sorter = new TableRowSorter<OutputDataTableModel>(this.outputDataTblModel);
        this.sorter.setSortsOnUpdates(false);
        this.sorter.addRowSorterListener(new CustomRowSorterListener());
        this.sorter.setComparator(0, (Comparator<?>)AttributeTypeComparator.getComparator());
        this.sorter.setSortKeys(arrayList);
        this.sorter.setRowFilter(this.rowFilter);
        this.jOutputsTable.setRowSorter(this.sorter);
        if (this.allAutomatic) {
            this.autoBtn.setToolTipText(DynamicNodesLrb.get("BUILD_DATA_USAGE_SET_TO_AUTO"));
        } else {
            this.autoBtn.setToolTipText(DynamicNodesLrb.get("BUILD_DATA_USAGE_SET_TO_MANUAL"));
        }
        this.autoBtn.setSelected(this.allAutomatic);
        this.jOutputsTable.setEnabled(this.isWritable());
        this.autoBtn.setEnabled(this.isWritable());
    }

    private void handleUsageSelectionChanged(ListSelectionModel listSelectionModel) {
        if (this.allAutomatic) {
            this.removeBtn.setEnabled(false);
            return;
        }
        int[] nArray = this.jOutputsTable.getSelectedRowsInModel();
        boolean bl = nArray != null && nArray.length > 0;
        this.removeBtn.setEnabled(bl);
    }

    public List<MiningAttributeType> getTargetAttributeList() {
        return this._targetAttrs.getMiningAttribute();
    }

    public void updateUI(PropertyModel propertyModel) {
        ArrayList<String> arrayList;
        CaseAttributes caseAttributes;
        List list;
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        this._targetNode = (DynamicNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        if (nodeType instanceof DynamicPredictionNodeType) {
            this._baseSettings = ((DynamicPredictionNodeType)nodeType).getDynamicNodeBaseSettings();
            this._targetAttrs = ((DynamicPredictionNodeType)nodeType).getPredictionAttributes().getTargetAttributes();
        } else if (nodeType instanceof DynamicClusterNodeType) {
            this._baseSettings = ((DynamicClusterNodeType)nodeType).getDynamicNodeBaseSettings();
        } else if (nodeType instanceof DynamicAnomalyNodeType) {
            this._baseSettings = ((DynamicAnomalyNodeType)nodeType).getDynamicNodeBaseSettings();
        } else if (nodeType instanceof DynamicFeatureNodeType) {
            this._baseSettings = ((DynamicFeatureNodeType)nodeType).getDynamicNodeBaseSettings();
        }
        assert (this._baseSettings != null);
        this.allAutomatic = this._baseSettings.getSupplementalAttributes().getAutoSpec().equals((Object)AutoSpecType.YES);
        JScrollPane jScrollPane = new JScrollPane((Component)this.jOutputsTable);
        this.jOutputsComponent.setComponent((JComponent)jScrollPane);
        this.jOutputsComponent.setLabel(new JLabel(DynamicNodesLrb.get("BUILD_DATA_OUTPUT_LBL")));
        this.installDataUsageActions();
        this.jOutputsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                DynamicOutputPanel.this.handleUsageSelectionChanged(listSelectionModel);
            }
        });
        this.outputDataTblModel = new OutputDataTableModel(this._baseSettings.getSupplementalAttributes());
        this.jOutputsTable.setModel((TableModel)((Object)this.outputDataTblModel));
        TableColumn tableColumn = this.jOutputsTable.getColumnModel().getColumn(0);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        tableColumn.setCellRenderer(attributeNameCellRenderer);
        List<MiningAttributeType> list2 = this.getTargetAttributeList();
        if (list2 != null) {
            attributeNameCellRenderer.setTargetNames(list2);
        }
        if ((list = (caseAttributes = this._baseSettings.getCaseAttributes()).getAttribute()).size() > 0) {
            arrayList = new ArrayList<String>();
            for (AttributeType object : list) {
                arrayList.add(object.getName());
            }
            attributeNameCellRenderer.setKeyNames(arrayList);
        }
        if (this.sortKeys == null) {
            this.sortKeys = new ArrayList<RowSorter.SortKey>();
            this.sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        }
        arrayList = new ArrayList();
        for (RowSorter.SortKey sortKey : this.sortKeys) {
            arrayList.add((String)((Object)sortKey));
        }
        this.sorter = new TableRowSorter<OutputDataTableModel>(this.outputDataTblModel);
        this.sorter.setSortsOnUpdates(false);
        this.sorter.addRowSorterListener(new CustomRowSorterListener());
        this.sorter.setComparator(0, (Comparator<?>)AttributeTypeComparator.getComparator());
        this.sorter.setSortKeys(arrayList);
        this.sorter.setRowFilter(this.rowFilter);
        this.jOutputsTable.setRowSorter(this.sorter);
        if (this.allAutomatic) {
            this.autoBtn.setToolTipText(DynamicNodesLrb.get("BUILD_DATA_USAGE_SET_TO_AUTO"));
        } else {
            this.autoBtn.setToolTipText(DynamicNodesLrb.get("BUILD_DATA_USAGE_SET_TO_MANUAL"));
        }
        this.autoBtn.setSelected(this.allAutomatic);
        this.jOutputsTable.setEnabled(this.isWritable());
        this.autoBtn.setEnabled(this.isWritable());
    }

    private void setAutoUsage(boolean bl, boolean bl2) {
        this.allAutomatic = bl;
        SupplementalAttributesType supplementalAttributesType = new SupplementalAttributesType();
        List list = _helper.makeListCopies(this._baseSettings.getSupplementalAttributes().getAttribute(), 1);
        supplementalAttributesType.getAttribute().addAll(list.get(0));
        supplementalAttributesType.setAutoSpec(this._baseSettings.getSupplementalAttributes().getAutoSpec());
        SupplementalAttributesType supplementalAttributesType2 = new SupplementalAttributesType();
        if (bl2) {
            supplementalAttributesType2.setAutoSpec(AutoSpecType.YES);
            supplementalAttributesType2 = DynamicNodeUtility.getUpdatedAutoSupplementals(supplementalAttributesType2, this._targetAttrs, this._baseSettings.getCaseAttributes(), this._baseSettings.getPartitionExpressions());
        } else {
            supplementalAttributesType2.setAutoSpec(AutoSpecType.NO);
            supplementalAttributesType2.getAttribute().addAll(list.get(0));
        }
        this.modifySupplementals(supplementalAttributesType2, supplementalAttributesType, bl ? DynamicLrb.get("PI_SET_AUTO_ON") : DynamicLrb.get("PI_SET_AUTO_OFF"));
    }

    private void modifySupplementals(SupplementalAttributesType supplementalAttributesType, SupplementalAttributesType supplementalAttributesType2, String string) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        ComplexProperty complexProperty = new ComplexProperty("OUTPUT_SUPPLEMENTAL", supplementalAttributesType);
        complexProperty.setOldData(supplementalAttributesType2);
        arrayList.add(new Property(String.valueOf(this._model.getRowMapping("OUTPUT_SUPPLEMENTAL")), null, complexProperty, null, null));
        this._model.setValueAt(string, this._targetNode, arrayList);
    }

    private void handleAddSupplementalColumns() {
        ArrayList<MiningAttributeType> arrayList = new ArrayList<MiningAttributeType>();
        List list = this._baseSettings.getPartitionExpressions().getPartitionExpression();
        for (PartitionExpressionType partitionExpressionType : list) {
            arrayList.add(MetaDataHelper.createMiningAttributeFrom(partitionExpressionType.getPartitionAttribute()));
        }
        arrayList.addAll(this._baseSettings.getMiningAttributes().getMiningAttribute());
        AddSupplementalPanel addSupplementalPanel = new AddSupplementalPanel(this.getContext((PropertyModel)this._model), this._targetNode, arrayList, this._baseSettings.getSupplementalAttributes());
        if (addSupplementalPanel.showAsDialog(this) && addSupplementalPanel.isDirty()) {
            PartitionExpressionType partitionExpressionType;
            partitionExpressionType = new SupplementalAttributesType();
            List list2 = _helper.makeListCopies(this._baseSettings.getSupplementalAttributes().getAttribute(), 1);
            partitionExpressionType.getAttribute().addAll(list2.get(0));
            partitionExpressionType.setAutoSpec(this._baseSettings.getSupplementalAttributes().getAutoSpec());
            SupplementalAttributesType supplementalAttributesType = new SupplementalAttributesType();
            for (MiningAttributeType miningAttributeType : addSupplementalPanel.getSelectedAttrsCache()) {
                AttributeType attributeType = MetaDataHelper.createAttributeFrom(miningAttributeType);
                supplementalAttributesType.getAttribute().add(attributeType);
            }
            supplementalAttributesType.setAutoSpec(this.allAutomatic ? AutoSpecType.YES : AutoSpecType.NO);
            this.modifySupplementals(supplementalAttributesType, (SupplementalAttributesType)partitionExpressionType, DynamicLrb.get("PI_ADD_SUPPLEMENTAL_COLUMNS"));
        }
    }

    private void removeSupplementalColumns() {
        int[] nArray = this.jOutputsTable.getSelectedRowsInModel();
        OutputDataTableModel outputDataTableModel = (OutputDataTableModel)((Object)this.jOutputsTable.getModel());
        Vector<AttributeType> vector = outputDataTableModel.getDataVector();
        Vector<AttributeType> vector2 = new Vector<AttributeType>();
        for (int arrayList : nArray) {
            AttributeType attributeType = vector.get(arrayList);
            vector2.add(attributeType);
        }
        SupplementalAttributesType supplementalAttributesType = new SupplementalAttributesType();
        SupplementalAttributesType supplementalAttributesType2 = new SupplementalAttributesType();
        List list = _helper.makeListCopies(this._baseSettings.getSupplementalAttributes().getAttribute(), 2);
        supplementalAttributesType.getAttribute().addAll(list.get(0));
        supplementalAttributesType.setAutoSpec(this._baseSettings.getSupplementalAttributes().getAutoSpec());
        supplementalAttributesType2.getAttribute().addAll(list.get(1));
        supplementalAttributesType2.setAutoSpec(this.allAutomatic ? AutoSpecType.YES : AutoSpecType.NO);
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        block1: for (AttributeType attributeType : vector2) {
            for (AttributeType attributeType2 : supplementalAttributesType2.getAttribute()) {
                if (!attributeType.getName().equals(attributeType2.getName())) continue;
                arrayList.add(attributeType2);
                continue block1;
            }
        }
        if (!arrayList.isEmpty()) {
            supplementalAttributesType2.getAttribute().removeAll(arrayList);
            this.modifySupplementals(supplementalAttributesType2, supplementalAttributesType, DynamicLrb.get("PI_REMOVE_SUPPLEMENTAL_COLUMNS"));
        }
    }

    private void configureSearchField() {
        this.searchField.setPreferredSize(new Dimension(150, 5));
        this.searchField.setPrompt("Find");
        this.rowFilter = new RowFilter<OutputDataTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends OutputDataTableModel, ? extends Integer> entry) {
                boolean bl;
                boolean bl2 = false;
                Integer n = entry.getIdentifier();
                OutputDataTableModel outputDataTableModel = entry.getModel();
                AttributeType attributeType = outputDataTableModel.getRowData(n);
                boolean bl3 = bl = DynamicOutputPanel.this.searchText != null;
                if (!bl) {
                    return true;
                }
                if (DynamicOutputPanel.this.searchText != null && attributeType.getName().toLowerCase().contains(DynamicOutputPanel.this.searchText.toLowerCase())) {
                    bl2 = true;
                }
                return bl2;
            }
        };
        this.searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                DynamicOutputPanel.this.searchText = searchEvent.getSearchText();
                DynamicOutputPanel.this.searchCategory = searchEvent.getSearchCategory();
                DynamicOutputPanel.this.sorter.setRowFilter(DynamicOutputPanel.this.rowFilter);
                DynamicOutputPanel.this.jOutputsTable.setRowSorter((RowSorter)DynamicOutputPanel.this.sorter);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
    }

    class CustomRowSorterListener
    implements RowSorterListener {
        CustomRowSorterListener() {
        }

        @Override
        public void sorterChanged(RowSorterEvent rowSorterEvent) {
            Object object = rowSorterEvent.getSource();
            List<RowSorter.SortKey> list = ((RowSorter)object).getSortKeys();
            if (list.isEmpty()) {
                return;
            }
            DynamicOutputPanel.this.sortKeys.clear();
            for (RowSorter.SortKey sortKey : list) {
                DynamicOutputPanel.this.sortKeys.add(sortKey);
            }
        }
    }
}

