/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.OutputCellEditor;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.controls.renderers.OutputCellRenderer;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.model.common.build.ModelDescription;
import oracle.dmt.dataminer.core.utils.comparator.BooleanComparator;
import oracle.dmt.dataminer.mviewer.coefficients.LoadSVMModelViewer;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNodeUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.server.model.MiningAlgorithms;
import oracle.dmt.dataminer.server.model.MiningFunctions;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.model.EditModelNodePanel;
import oracle.dmt.dataminer.workflow.dialog.model.ModelDescriptionTableModel;
import oracle.dmt.dataminer.workflow.dialog.model.TargetValuesPanel;
import oracle.dmt.dataminer.workflow.inspect.ModelNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowExistingModelNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractModelNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelInfoType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelSettingsODM;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.TargetValues;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.editor.EditorUtil;
import oracle.ide.inspector.PropertyLabel;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Pair;

public class ModelPIComponentPanel
extends PIComponentPanel<AbstractModelNode> {
    private static Icon _refreshIcon;
    private WorkflowNodePropertyProxyModel _model;
    private boolean _bLoading;
    private String _ownerName;
    private JButton _viewBtn;
    private JButton _removeBtn;
    private JButton _refreshBtn;
    private JButton _addBtn;
    private ModelsTableModel _modelsTblModel;
    private TargetValues _targetValues;
    private MiningFunctionType _mft;
    private AttributeType _at;
    private List<ModelNodeType.Models.Model> _models;
    private ModelNodeType.Models _nodeTypeModels;
    private ModelNodeType _nodeData;
    private MiningFunctions _miningFunction;
    private PropertyLabel _jMiningFunctionLabel;
    private JTextField _jMiningFunctionValue;
    private PropertyLabel _jTargetAttributeLabel;
    private JTextField _jTargetAttributeValue;
    private PropertyLabel _jTargetDataTypeLabel;
    private JTextField _jTargetDataTypeValue;
    private JButton _jTargetValuesButton;
    private DataMinerTablePanel jTablePanel;

    public ModelPIComponentPanel(PropertyModel propertyModel) {
        super(propertyModel);
        assert (propertyModel != null) : "PropertyModel for model node is null.";
        AbstractModelNode abstractModelNode = this.getTargetNode(propertyModel);
        assert (abstractModelNode != null) : "Model node is null.";
        if (abstractModelNode == null) {
            return;
        }
        this._models = MetaDataHelper.getModelsCollection((ModelNodeType)abstractModelNode.getData());
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this._jMiningFunctionValue = new JTextField();
        this._jTargetAttributeValue = new JTextField();
        this._jTargetDataTypeValue = new JTextField();
        this._jMiningFunctionLabel = new PropertyLabel();
        this._jTargetAttributeLabel = new PropertyLabel();
        this._jTargetDataTypeLabel = new PropertyLabel();
        this._jTargetValuesButton = new JButton();
        this.jTablePanel = new DataMinerTablePanel();
        this._jMiningFunctionValue.setEditable(false);
        this._jMiningFunctionValue.setText("Classification");
        this._jMiningFunctionValue.setBorder(null);
        this._jTargetAttributeValue.setEditable(false);
        this._jTargetAttributeValue.setText("123456789012345678901234567890");
        this._jTargetAttributeValue.setBorder(null);
        this._jTargetDataTypeValue.setEditable(false);
        this._jTargetDataTypeValue.setText("Varchar");
        this._jTargetDataTypeValue.setBorder(null);
        this._jMiningFunctionLabel.setText("Function:");
        this._jTargetAttributeLabel.setText("Target Attribute:");
        this._jTargetDataTypeLabel.setText("Data Type:");
        this._jTargetValuesButton.setText("Values...");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTablePanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent((Component)this._jTargetAttributeLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this._jMiningFunctionLabel, GroupLayout.Alignment.LEADING, -1, 90, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jMiningFunctionValue, -1, 187, Short.MAX_VALUE).addComponent(this._jTargetAttributeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jTargetValuesButton).addGap(18, 18, 18).addComponent((Component)this._jTargetDataTypeLabel, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jTargetDataTypeValue, -2, 77, -2).addGap(0, 91, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.linkSize(0, this._jMiningFunctionValue, this._jTargetAttributeValue);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this._jMiningFunctionLabel, -1, -1, Short.MAX_VALUE).addComponent(this._jMiningFunctionValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this._jTargetAttributeLabel, -1, -1, Short.MAX_VALUE).addComponent(this._jTargetAttributeValue, -2, -1, -2).addComponent(this._jTargetValuesButton).addComponent((Component)this._jTargetDataTypeLabel, -1, -1, Short.MAX_VALUE).addComponent(this._jTargetDataTypeValue, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTablePanel, -1, 266, Short.MAX_VALUE).addContainerGap()));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this._jMiningFunctionLabel, (Component)this._jMiningFunctionValue, (String)(PropertyLrb.get("PI_MODEL_GROUP_MODEL_FUNCTION") + ":"));
        ResourceUtils.resLabel((JLabel)this._jTargetAttributeLabel, (Component)this._jTargetAttributeValue, (String)(PropertyLrb.get("PI_MODEL_GROUP_MODEL_TARGET_ATTRIBUTE") + ":"));
        ResourceUtils.resLabel((JLabel)this._jTargetDataTypeLabel, (Component)this._jTargetDataTypeLabel, (String)(PropertyLrb.get("PI_MODEL_GROUP_MODEL_TARGET_DATA_TYPE") + ":"));
        ResourceUtils.resButton((AbstractButton)this._jTargetValuesButton, (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_TARGET_VALUES_BUTTON"));
        if (_refreshIcon == null) {
            _refreshIcon = OracleIcons.getIcon((String)"refresh.png");
        }
        this._jTargetAttributeValue.setText("");
        this._jTargetAttributeValue.setFocusable(false);
        this._jTargetAttributeValue.setOpaque(false);
        this._jTargetDataTypeValue.setText("");
        this._jTargetDataTypeValue.setFocusable(false);
        this._jTargetDataTypeValue.setOpaque(false);
        this._jMiningFunctionValue.setText("");
        this._jMiningFunctionValue.setFocusable(false);
        this._jMiningFunctionValue.setOpaque(false);
        this._jTargetValuesButton.setEnabled(false);
        this._jTargetValuesButton.setVisible(false);
    }

    public void loadData(ModelNodeType modelNodeType) {
        this._nodeData = modelNodeType;
        this._mft = modelNodeType.getMiningFunction();
        this._at = modelNodeType.getTargetAttribute();
        this._nodeTypeModels = modelNodeType.getModels();
        this._models = modelNodeType.getModels().getModel();
        if (this._mft != null) {
            String string = MetaDataHelper.getFunctionName(modelNodeType.getMiningFunction());
            this._miningFunction = MiningFunctions.fromString(string);
            this._jMiningFunctionValue.setText(this._miningFunction.toString());
            if (this._mft == MiningFunctionType.CLASSIFICATION || this._mft == MiningFunctionType.REGRESSION) {
                this.showTarget(true);
                this._targetValues = modelNodeType.getTargetValues();
                if (this._mft == MiningFunctionType.CLASSIFICATION) {
                    this._jTargetValuesButton.setEnabled(true);
                    this._jTargetValuesButton.setVisible(true);
                } else {
                    this._jTargetValuesButton.setEnabled(false);
                    this._jTargetValuesButton.setVisible(false);
                }
            } else {
                this.showTarget(false);
                this._jTargetValuesButton.setEnabled(false);
                this._jTargetValuesButton.setVisible(false);
            }
        } else {
            this.showTarget(false);
            this._jMiningFunctionValue.setText("");
            this._jTargetAttributeValue.setText("");
            this._jTargetDataTypeValue.setText("");
            this._miningFunction = null;
        }
        if (this._at != null) {
            this._jTargetAttributeValue.setText(this._at.getName());
            this._jTargetDataTypeValue.setText(this._at.getDataType());
        }
    }

    public void initUI(PropertyModel propertyModel) {
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        AbstractModelNode abstractModelNode = this.getTargetNode(propertyModel);
        if (abstractModelNode == null) {
            return;
        }
        this._bLoading = true;
        this._ownerName = ConnectionFolder.getUserAccountName(this.getContext((PropertyModel)this._model));
        this._ownerName = StringUtils.isDoubleQuotedString(this._ownerName) ? StringUtils.trimDoubleQuotes(this._ownerName) : this._ownerName.toUpperCase();
        boolean bl = this.isWritable();
        ModelNodeType modelNodeType = (ModelNodeType)abstractModelNode.getData();
        this.loadData(modelNodeType);
        this._modelsTblModel = new ModelsTableModel(this._models, this._ownerName);
        this.setupModelsTable(this._modelsTblModel);
        this._modelsTblModel.setWritable(bl);
        this.jTablePanel.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)ModelPIComponentPanel.this.jTablePanel.getTable().getModel());
                    if (modelsTableModel.getSrcData().isEmpty()) {
                        return;
                    }
                    ModelNodeType.Models.Model model = (ModelNodeType.Models.Model)modelsTableModel.getSrcData().get(ModelPIComponentPanel.this.jTablePanel.getTable().getSelectedRow());
                    if (model.getStatus() == RefModelStatusType.VALID) {
                        ModelPIComponentPanel.this.viewModel();
                    }
                }
            }
        });
        this._viewBtn = new JButton(DataMinerIcons.get(Icons.PI_ATTR_GROUP_MODEL_VIEW_MODEL_ENA));
        this._viewBtn.setDisabledIcon(DataMinerIcons.get(Icons.PI_ATTR_GROUP_MODEL_VIEW_MODEL_DIS));
        this._viewBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_VIEW"));
        this._viewBtn.setEnabled(false);
        this._viewBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelPIComponentPanel.this.viewModel();
            }
        });
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(PropertyLrb.get("PI_MODEL_GROUP_MODEL_REMOVE_MODEL"));
        this._removeBtn.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelNodeType.Models models;
                AttributeType attributeType;
                MiningFunctionType miningFunctionType;
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)PropertyLrb.get("PI_MODEL_GROUP_MODEL_REMOVE_MODEL_WARNING_MESG"), (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_REMOVE_MODEL_WARNING_TITLE"), null, (boolean)true)) {
                    return;
                }
                int[] nArray = ModelPIComponentPanel.this.jTablePanel.getTable().getSelectedRowsInModel();
                if (nArray.length == 0) {
                    return;
                }
                ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)ModelPIComponentPanel.this.jTablePanel.getTable().getModel());
                boolean bl = false;
                if (nArray.length == modelsTableModel.getRowCount()) {
                    bl = true;
                }
                modelsTableModel.removeSelectedRows(nArray);
                if (bl) {
                    ModelPIComponentPanel.this._miningFunction = null;
                    miningFunctionType = null;
                    attributeType = null;
                    models = new ModelNodeType.Models();
                } else {
                    miningFunctionType = MiningFunctions.translateToODMServerMiningFunction(ModelPIComponentPanel.this._miningFunction);
                    attributeType = ModelPIComponentPanel.this.createAttributeType(ModelPIComponentPanel.this._jTargetAttributeValue.getText(), ModelPIComponentPanel.this._jTargetDataTypeValue.getText());
                    models = ModelPIComponentPanel.this.createModelsCollection();
                }
                CommandProcessor.getInstance().beginTrans(DialogsLrb.get("MODEL_NODE_EDIT_TRANSACTION_NAME"));
                try {
                    ModelPIComponentPanel.this._model.setValueAt(miningFunctionType, ModelNodePropertyModel.MINING_FUNCTION.index, 0);
                    ModelPIComponentPanel.this._model.setValueAt(attributeType, ModelNodePropertyModel.TARGET_ATTRIBUTE.index, 0);
                    ModelPIComponentPanel.this._model.setValueAt(models, ModelNodePropertyModel.MODELS.index, 0);
                    Element[] elementArray = ModelPIComponentPanel.this.getContext((PropertyModel)ModelPIComponentPanel.this._model).getSelection();
                    WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
                    workflowNodeInspectorElement.validate(true);
                    ModelPIComponentPanel.this.updateWorkFlow();
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_MESG"), null);
                }
                finally {
                    CommandProcessor.getInstance().endTrans();
                }
            }
        });
        this._removeBtn.setEnabled(false);
        this._addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._addBtn.setToolTipText(PropertyLrb.get("PI_MODEL_GROUP_MODEL_ADD_MODEL"));
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelNodePanel editModelNodePanel = new EditModelNodePanel(ModelPIComponentPanel.this.getContext((PropertyModel)ModelPIComponentPanel.this._model), ModelPIComponentPanel.this.getTargetNode((PropertyModel)ModelPIComponentPanel.this._model), (PropertyModel)ModelPIComponentPanel.this._model);
                editModelNodePanel.load();
                DialogHelper dialogHelper = new DialogHelper(editModelNodePanel);
                if (dialogHelper.showAsDialog(ModelPIComponentPanel.this)) {
                    ModelPIComponentPanel.this.updateWorkFlow();
                }
            }
        });
        this._addBtn.setEnabled(bl);
        this._refreshBtn = new JButton(_refreshIcon);
        this._refreshBtn.setToolTipText(PropertyLrb.get("PI_MODEL_GROUP_MODEL_ADD_REFRESH_MODEL"));
        this._refreshBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoadUI loadUI = new LoadUI();
                loadUI.execute();
            }
        });
        this.jTablePanel.addControlBarComponents(this._refreshBtn, this._addBtn, this._removeBtn, this._viewBtn);
        this._jTargetValuesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TargetValuesPanel targetValuesPanel = new TargetValuesPanel(ModelPIComponentPanel.this._at.getName(), ModelPIComponentPanel.this._at.getDataType(), ModelPIComponentPanel.this._targetValues);
                DialogHelper dialogHelper = new DialogHelper(targetValuesPanel);
                dialogHelper.showAsDialog(ModelPIComponentPanel.this);
            }
        });
        this.jTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ModelPIComponentPanel.this.handleModelSelectionChanged();
            }
        });
        this._bLoading = false;
    }

    private AttributeType createAttributeType(String string, String string2) {
        AttributeType attributeType = null;
        if (string.length() > 0) {
            attributeType = new AttributeType();
            attributeType.setDataType(string2);
            attributeType.setName(string);
            attributeType.setStatus(AttributeStatus.VALID);
        }
        return attributeType;
    }

    private ModelNodeType.Models createModelsCollection() {
        ModelNodeType.Models models = new ModelNodeType.Models();
        List list = models.getModel();
        ModelNodeType.Models.Model model = null;
        for (ModelNodeType.Models.Model model2 : this._modelsTblModel.getSrcData()) {
            model = new ModelNodeType.Models.Model();
            model.setName(model2.getName());
            model.setSchema(model2.getSchema());
            model.setMiningAlgorithm(model2.getMiningAlgorithm());
            model.setMiningFunction(model2.getMiningFunction());
            model.setStatus(model2.getStatus());
            model.setUseForOutput(model2.isUseForOutput());
            model.setModelId(model2.getModelId());
            model.setModelSettingsODM(model2.getModelSettingsODM());
            list.add(model);
        }
        return models;
    }

    private void handleModelSelectionChanged() {
        boolean bl = false;
        int n = this.jTablePanel.getTable().getSelectedRowCount();
        if (n == 1) {
            ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this.jTablePanel.getTable().getModel());
            int n2 = this.jTablePanel.getTable().getSelectedRow();
            if (n2 == -1) {
                return;
            }
            ModelNodeType.Models.Model model = (ModelNodeType.Models.Model)modelsTableModel.getSrcData().get(n2);
            if (model.getStatus() == RefModelStatusType.VALID) {
                bl = true;
            }
        }
        this._viewBtn.setEnabled(bl);
        if (this.isWritable()) {
            this._removeBtn.setEnabled(n != 0);
        }
    }

    public void resetModelsTable(PropertyModel propertyModel) {
        AbstractModelNode abstractModelNode = this.getTargetNode(propertyModel);
        if (abstractModelNode == null) {
            return;
        }
        this._models = MetaDataHelper.getModelsCollection((ModelNodeType)abstractModelNode.getData());
        this.reloadUI(propertyModel);
    }

    public void reloadUI(PropertyModel propertyModel) {
        Object object;
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return;
        }
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        AbstractModelNode abstractModelNode = this.getTargetNode(propertyModel);
        if (abstractModelNode == null) {
            return;
        }
        this._bLoading = true;
        this._ownerName = ConnectionFolder.getUserAccountName(this.getContext((PropertyModel)this._model));
        this._ownerName = StringUtils.isDoubleQuotedString(this._ownerName) ? StringUtils.trimDoubleQuotes(this._ownerName) : this._ownerName.toUpperCase();
        ModelNodeType modelNodeType = (ModelNodeType)abstractModelNode.getData();
        this.loadData(modelNodeType);
        int[] nArray = this.jTablePanel.getTable().getSelectedRowsInModel();
        ArrayList<ModelNodeType.Models.Model> arrayList = null;
        if (nArray != null && nArray.length > 0) {
            object = (ModelsTableModel)((Object)this.jTablePanel.getTable().getModel());
            arrayList = new ArrayList<ModelNodeType.Models.Model>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                ModelNodeType.Models.Model model = (ModelNodeType.Models.Model)((ODMrTableModel)((Object)object)).getSrcData().get(nArray[i]);
                arrayList.add(model);
            }
        }
        this._modelsTblModel = new ModelsTableModel(this._models, this._ownerName);
        this.setupModelsTable(this._modelsTblModel);
        if (arrayList != null) {
            Object object2;
            object = new ArrayList();
            List list = this._modelsTblModel.getSrcData();
            for (int i = 0; i < list.size(); ++i) {
                object2 = (ModelNodeType.Models.Model)list.get(i);
                if (!arrayList.contains(object2)) continue;
                object.add(i);
            }
            if (!object.isEmpty()) {
                Integer[] integerArray = object.toArray(new Integer[object.size()]);
                object2 = new int[integerArray.length];
                for (int i = 0; i < integerArray.length; ++i) {
                    object2[i] = (ModelNodeType.Models.Model)integerArray[i];
                }
                this.jTablePanel.getTable().setSelectedRowsInModel((int[])object2);
            }
        }
        this._bLoading = false;
    }

    public boolean isLoading() {
        return this._bLoading;
    }

    private void viewModel() {
        try {
            ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this.jTablePanel.getTable().getModel());
            int n = this.jTablePanel.getTable().convertRowIndexToModel(this.jTablePanel.getTable().getSelectedRow());
            ModelNodeType.Models.Model model = (ModelNodeType.Models.Model)modelsTableModel.getSrcData().get(n);
            MiningAlgorithmType miningAlgorithmType = model.getMiningAlgorithm();
            String string = this.getTargetNode((PropertyModel)this._model).getData().getName();
            if (miningAlgorithmType != MiningAlgorithmType.SUPPORT_VECTOR_MACHINES) {
                String string2 = model.getName();
                Context context = this.getContext((PropertyModel)this._model);
                WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                if (workflowNode == null) {
                    return;
                }
                BaseTreeNode baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, string, string2);
                if (baseTreeNode != null) {
                    EditorUtil.openDefaultEditorInFrame((Node)baseTreeNode);
                } else {
                    MessageDialog.error((Component)this, (Object)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_NODE_ERROR_MESG"), (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_TITLE"), null);
                }
                return;
            }
            LoadSVMModelViewer loadSVMModelViewer = new LoadSVMModelViewer((ModelInfoType)model, this.getContext((PropertyModel)this._model), string);
            loadSVMModelViewer.execute();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)this, (Throwable)exception, (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_TITLE"), (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_MESG"), null);
        }
    }

    private void setupModelsTable(ModelsTableModel modelsTableModel) {
        this.jTablePanel.setup((TableModel)((Object)modelsTableModel), PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODELS"), 0, true);
        this.jTablePanel.getTable().setUpdateSelectionOnSort(true);
        this.jTablePanel.getTable().getTableHeader().setReorderingAllowed(false);
        this.jTablePanel.getTable().setShowToolTips(true);
        TableColumn tableColumn = this.jTablePanel.getTable().getColumnModel().getColumn(2);
        tableColumn.setCellEditor(new OutputCellEditor());
        tableColumn.setCellRenderer(new OutputCellRenderer());
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                int n3 = ModelPIComponentPanel.this.jTablePanel.getTable().convertRowIndexToModel(n);
                ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)ModelPIComponentPanel.this.jTablePanel.getTable().getModel());
                if (((ModelNodeType.Models.Model)modelsTableModel.getSrcData().get(n3)).getStatus() == RefModelStatusType.VALID) {
                    return null;
                }
                return OracleIcons.getIcon((String)"database_error.png");
            }
        });
        tableColumn = this.jTablePanel.getTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(iconCellRenderer);
        tableColumn = this.jTablePanel.getTable().getColumnModel().getColumn(0);
        tableColumn.setMinWidth(100);
    }

    private void showTarget(boolean bl) {
        this._jTargetAttributeValue.setVisible(bl);
        this._jTargetAttributeLabel.setVisible(bl);
        this._jTargetDataTypeValue.setVisible(bl);
        this._jTargetDataTypeLabel.setVisible(bl);
    }

    @Override
    protected AbstractModelNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowExistingModelNodePropertyProxyModel)) {
            return null;
        }
        WorkflowExistingModelNodePropertyProxyModel workflowExistingModelNodePropertyProxyModel = (WorkflowExistingModelNodePropertyProxyModel)propertyModel;
        Context context = workflowExistingModelNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ModelNodeType) {
            return (AbstractModelNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private void setValue(List<Pair<String, Boolean>> list) {
        AbstractModelNode abstractModelNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractModelNode == null) {
            return;
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(new Property(String.valueOf(ModelNodePropertyModel.MODEL_USEFOROUTPUT.index), null, new ComplexProperty("modelUseForOutput", list), null, null));
        this._model.setValueAt("modelUseForOutput", abstractModelNode, arrayList);
        this.updateWorkFlow();
    }

    private class LoadUI
    extends SwingWorker<Boolean, Void> {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;
        private ModelDescriptionTableModel _selectedModelsTableModel;
        private ModelDescriptionTableModel _availModelsTableModel;
        private Context _context;

        private LoadUI() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateModels() {
            ModelNodeType modelNodeType = (ModelNodeType)MetaDataHelper.copyMetadataObject(ModelPIComponentPanel.this._nodeData);
            List list = modelNodeType.getModels().getModel();
            List list2 = this._selectedModelsTableModel.getSrcData();
            block5: for (Object object : list2) {
                for (ModelNodeType.Models.Model model : list) {
                    if (object.getModelName().compareTo(model.getName()) != 0) continue;
                    model.setStatus(object.getStatus());
                    continue block5;
                }
            }
            CommandProcessor.getInstance().beginTrans(DialogsLrb.get("MODEL_NODE_EDIT_TRANSACTION_NAME"));
            try {
                Object object;
                AbstractModelNode abstractModelNode = ModelPIComponentPanel.this.getTargetNode((PropertyModel)ModelPIComponentPanel.this._model);
                object = (OdmrSDMUndoFilter)abstractModelNode.getUndoFilter();
                ((OdmrSDMUndoFilter)((Object)object)).prepareUndo(abstractModelNode, this._context, "modelsGroup", modelNodeType.getModels());
                abstractModelNode.validate(true);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_MESG"), null);
            }
            finally {
                CommandProcessor.getInstance().endTrans();
            }
        }

        private List<ModelDescription> loadSelectedModelsFromNode() {
            AbstractModelNode abstractModelNode = ModelPIComponentPanel.this.getTargetNode((PropertyModel)ModelPIComponentPanel.this._model);
            ModelNodeType modelNodeType = (ModelNodeType)abstractModelNode.getData();
            List list = modelNodeType.getModels().getModel();
            if (list != null) {
                if (list.isEmpty()) {
                    return new ArrayList<ModelDescription>();
                }
            } else {
                return new ArrayList<ModelDescription>();
            }
            ArrayList<ModelDescription> arrayList = new ArrayList<ModelDescription>();
            String string = MetaDataHelper.getFunctionName(modelNodeType.getMiningFunction());
            String string2 = null;
            String string3 = null;
            if (modelNodeType.getTargetAttribute() != null) {
                string2 = modelNodeType.getTargetAttribute().getName();
                string3 = modelNodeType.getTargetAttribute().getDataType();
            }
            String string4 = "";
            for (ModelNodeType.Models.Model model : list) {
                List list2;
                string4 = MiningAlgorithms.translateFromODMServerAlgorithm(model.getMiningAlgorithm().value(), model.getModelSettingsODM());
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilder2 = new StringBuilder();
                if (model.getPartitionExpressions() != null && (list2 = model.getPartitionExpressions().getPartitionExpression()) != null) {
                    for (int i = 0; i < list2.size(); ++i) {
                        PartitionExpressionType partitionExpressionType = (PartitionExpressionType)list2.get(i);
                        if (i > 0) {
                            stringBuilder.append(",");
                            stringBuilder2.append(",");
                        }
                        stringBuilder.append(partitionExpressionType.getPartitionAttribute().getName());
                        stringBuilder2.append(partitionExpressionType.getPartitionAttribute().getDataType());
                    }
                }
                list2 = new ModelDescription(model.getSchema(), model.getName(), string, string4, string2, string3, null, null, model.getStatus(), model.getModelId(), new ModelSettingsODM(), model.isUseForOutput(), stringBuilder.toString(), stringBuilder2.toString());
                arrayList.add((ModelDescription)list2);
            }
            return arrayList;
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            try {
                List<ModelDescription> list = this.loadSelectedModelsFromNode();
                this._context = ModelPIComponentPanel.this._model.getSelectionContext();
                this._availModelsTableModel = new ModelDescriptionTableModel(this._context);
                this._selectedModelsTableModel = new ModelDescriptionTableModel(ModelPIComponentPanel.this._ownerName, list, this._context);
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
                this._availModelsTableModel.load(connectionFolder);
                List<ModelDescription> list2 = this._availModelsTableModel.createMissingRowsBasedOnMatch(this._selectedModelsTableModel.getSrcData());
                this._selectedModelsTableModel.refreshModelStatus(list2);
                this._success = this._selectedModelsTableModel.areAllModelsValid();
            }
            catch (ODMrDAOException oDMrDAOException) {
                this._ex = oDMrDAOException;
            }
            return this._success;
        }

        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    this.updateModels();
                } else if (!this._success && this._ex == null) {
                    if (MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("MODEL_NODE_CHOOSER_REFRESH_MESG"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE")) == 1) {
                        EditModelNodePanel editModelNodePanel = new EditModelNodePanel(ModelPIComponentPanel.this.getContext((PropertyModel)ModelPIComponentPanel.this._model), ModelPIComponentPanel.this.getTargetNode((PropertyModel)ModelPIComponentPanel.this._model), (PropertyModel)ModelPIComponentPanel.this._model);
                        editModelNodePanel.load();
                        DialogHelper dialogHelper = new DialogHelper(editModelNodePanel);
                        if (dialogHelper.showAsDialog(ModelPIComponentPanel.this)) {
                            ModelPIComponentPanel.this.updateWorkFlow();
                        }
                    } else {
                        this.updateModels();
                    }
                } else if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), null);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), null);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), null);
            }
        }
    }

    private class ModelsTableModel
    extends ODMrTableModel<ModelNodeType.Models.Model> {
        private static final int MODEL_NAME = 0;
        private static final int ALGORITHM = 1;
        private static final int OUTPUT = 2;
        private Map<String, ModelNodeType.Models.Model> _srcMapSchemaAndName;
        private Map<String, ModelNodeType.Models.Model> _srcMapName;
        private boolean _ownerOnly;
        private String _ownerName;
        private boolean _writable;

        public ModelsTableModel(List<ModelNodeType.Models.Model> list, String string) {
            super(new String[]{PropertyLrb.get("PI_MODEL_GROUP_MODEL_NAME"), PropertyLrb.get("PI_MODEL_GROUP_MODEL_ALGORITHM"), PropertyLrb.get("PI_ATTRIBUTES_MODEL_USE_FOR_OUTPUT")}, new ArrayList<ModelNodeType.Models.Model>(list));
            this._ownerOnly = true;
            this._writable = true;
            this._ownerName = string;
            this._srcMapSchemaAndName = new HashMap<String, ModelNodeType.Models.Model>();
            this._srcMapName = new HashMap<String, ModelNodeType.Models.Model>();
            for (ModelNodeType.Models.Model model : list) {
                this._srcMapSchemaAndName.put(model.getSchema() + "." + model.getName(), model);
                this._srcMapName.put(model.getName(), model);
            }
            this.areModelsInOwnerSchema();
        }

        private void areModelsInOwnerSchema() {
            boolean bl = true;
            for (ModelNodeType.Models.Model model : this.srcData) {
                if (model.getSchema().compareTo(this._ownerName) == 0) continue;
                bl = false;
                break;
            }
            this._ownerOnly = bl;
        }

        public Comparator<?> getColumnSortComparator(int n) {
            switch (n) {
                case 2: {
                    return BooleanComparator.getComparator();
                }
            }
            return super.getColumnSortComparator(n);
        }

        public void setValueAt(Object object, int n, int n2) {
            ModelNodeType.Models.Model model = (ModelNodeType.Models.Model)this.srcData.get(n);
            if (n2 != 2) {
                return;
            }
            Boolean bl = (Boolean)object;
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            String string = model.getSchema() + "." + model.getName();
            arrayList.add(new Pair((Object)string, (Object)bl));
            ModelPIComponentPanel.this.setValue(arrayList);
            this.fireTableCellUpdated(n, n2);
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds: " + n + ", RowCount: " + this.getRowCount();
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            ModelNodeType.Models.Model model = (ModelNodeType.Models.Model)this.srcData.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    String string = this._ownerName.equals(model.getSchema()) ? model.getName() : model.getSchema() + "." + model.getName();
                    object = string;
                    break;
                }
                case 1: {
                    object = MetaDataHelper.getAlgorithmName(model.getMiningAlgorithm());
                    break;
                }
                case 2: {
                    object = model.isUseForOutput();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public void setWritable(boolean bl) {
            this._writable = bl;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 2) {
                return this._writable;
            }
            return false;
        }

        public void removeSelectedRows(int[] nArray) {
            Vector<ModelNodeType.Models.Model> vector = new Vector<ModelNodeType.Models.Model>();
            ModelNodeType.Models.Model model = null;
            for (int i = 0; i < nArray.length; ++i) {
                model = (ModelNodeType.Models.Model)this.srcData.get(nArray[i]);
                vector.add(model);
            }
            this.srcData.removeAll(vector);
            this.setRowCount(this.srcData.size());
            this.fireTableDataChanged();
        }
    }
}

