/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.CustomPIPopupListener;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.inspect.CachePIComponentPanelSubPanelSamplingSizePercent;
import oracle.dmt.dataminer.workflow.inspect.CachePIComponentPanelSubPanelSamplingSizeRows;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.Settings;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.GraphNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.preferences.CacheSettingsPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.CacheSettings;
import oracle.dmt.dataminer.workflow.xmlschema.DataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphNodeType;
import oracle.ide.config.Preferences;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;

public class CachePIComponentPanel
extends PIComponentPanel
implements ChangeListener,
ActionListener,
Settings<AbstractNode> {
    public static final String RANDOM = PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLING_TYPE_RANDOM");
    static final String STRATIFIED = PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLING_TYPE_STRATIFIED");
    static final String TOP_N = PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLING_TYPE_TOPN");
    static String[] SAMPLING_TYPE = new String[]{RANDOM, STRATIFIED, TOP_N};
    public static final String NUM_ROWS = PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLE_SIZE_NUMROWS");
    static final String PERCENT = PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLE_SIZE_PERCENT");
    static final String[] SAMPLING_SIZE = new String[]{NUM_ROWS, PERCENT};
    protected boolean _bAdjusting;
    private CacheSettings _cacheSettings;
    private CardLayout _samplingSizeLayout;
    protected PropertyModel _propertyModel;
    protected CachePIComponentPanelSubPanelSamplingSizeRows jPanelSamplingSizeRows;
    protected CachePIComponentPanelSubPanelSamplingSizePercent jPanelSamplingSizePercent;
    private CacheSettingsPanelSettings _cachePreffrences = CacheSettingsPanelSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    protected JCheckBox jCheckBoxAllData;
    protected JComboBox jCmbSize;
    protected JLabel jLblSize;
    private JPanel jPanelSamplingSize;

    public CachePIComponentPanel(PropertyModel propertyModel) {
        super(propertyModel);
        this.initComponents();
        this.initRes();
        this.initLayout();
        this.initUI(propertyModel);
    }

    @Override
    public void setSettings(AbstractNode abstractNode) {
        if (abstractNode instanceof AbstractDataNode) {
            DataNodeType dataNodeType = (DataNodeType)abstractNode.getData();
            this._cacheSettings = dataNodeType.getCacheSettings();
        } else if (abstractNode instanceof GraphNode) {
            GraphNodeType graphNodeType = (GraphNodeType)abstractNode.getData();
            this._cacheSettings = graphNodeType.getCacheSettings();
        }
    }

    @Override
    public Object getRandom() {
        return this._cacheSettings.getMethod().getRandom();
    }

    @Override
    public Object getStratified() {
        return this._cacheSettings.getMethod().getStratified();
    }

    @Override
    public Long getNumberOfRows() {
        return this._cacheSettings.getNumberOfRows();
    }

    @Override
    public Double getPercentOfTotal() {
        return this._cacheSettings.getPercentOfTotal();
    }

    @Override
    public void setNumberRows(Integer n) {
        Long l = n != null ? Long.valueOf(n.longValue()) : null;
        this._cacheSettings.setNumberOfRows(l);
    }

    @Override
    public void setPercentOfTotal(Double d) {
        this._cacheSettings.setPercentOfTotal(d);
    }

    @Override
    public boolean isUseFullData() {
        return this._cacheSettings.isGenerateCache();
    }

    private void initComponents() {
        this.jLblSize = new JLabel();
        this.jCmbSize = new JComboBox();
        this.jPanelSamplingSize = new JPanel();
        this.jCheckBoxAllData = new JCheckBox();
        this.jLblSize.setText("Sampling Size:");
        this.jCmbSize.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jPanelSamplingSize.setLayout(new CardLayout());
        this.jCheckBoxAllData.setText("Use All Data");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanelSamplingSize, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxAllData, GroupLayout.Alignment.LEADING, -1, 535, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jLblSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCmbSize, -2, 221, -2))).addContainerGap(17, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxAllData).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblSize).addComponent(this.jCmbSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelSamplingSize, -2, 58, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLblSize, (Component)this.jCmbSize, (String)PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLE_SIZE"));
        this.setCheckBoxText();
    }

    protected void setCheckBoxText() {
        this.jCheckBoxAllData.setText(PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_GENERATE_CACHE"));
    }

    protected DataNodeType getNodeType(PropertyModel propertyModel) {
        AbstractNode abstractNode = this.getNode(propertyModel);
        if (abstractNode instanceof AbstractDataNode) {
            DataNodeType dataNodeType = (DataNodeType)abstractNode.getData();
            return dataNodeType;
        }
        if (abstractNode instanceof GraphNode) {
            GraphNodeType graphNodeType = (GraphNodeType)abstractNode.getData();
            return graphNodeType;
        }
        return null;
    }

    protected AbstractNode getNode(PropertyModel propertyModel) {
        Node node = this.getTargetNode(propertyModel);
        if (node == null || !(node instanceof AbstractDataNode) && !(node instanceof GraphNode)) {
            return null;
        }
        if (node instanceof AbstractDataNode) {
            AbstractDataNode abstractDataNode = (AbstractDataNode)node;
            return abstractDataNode;
        }
        if (node instanceof GraphNode) {
            GraphNode graphNode = (GraphNode)node;
            return graphNode;
        }
        return null;
    }

    private void initLayout() {
        this.jPanelSamplingSize.setOpaque(false);
        this._samplingSizeLayout = (CardLayout)this.jPanelSamplingSize.getLayout();
        this.jPanelSamplingSizeRows = new CachePIComponentPanelSubPanelSamplingSizeRows(this);
        this.jPanelSamplingSizePercent = new CachePIComponentPanelSubPanelSamplingSizePercent(this);
        this.jPanelSamplingSize.add((Component)this.jPanelSamplingSizeRows, NUM_ROWS);
        this.jPanelSamplingSize.add((Component)this.jPanelSamplingSizePercent, PERCENT);
    }

    public void initUI(PropertyModel propertyModel) {
        this._propertyModel = propertyModel;
        this.setSettings(this.getNode(propertyModel));
        boolean bl = this.isUseFullData();
        this.jCheckBoxAllData.setSelected(bl);
        this.selectAllData(this.jCheckBoxAllData.isSelected());
        this.jCheckBoxAllData.addActionListener(this);
        this.jCheckBoxAllData.setOpaque(false);
        this.jCmbSize.setModel(new DefaultComboBoxModel<String>(SAMPLING_SIZE));
        Long l = this.getNumberOfRows();
        Double d = this.getPercentOfTotal();
        if (l == null) {
            this.jCmbSize.setSelectedItem(PERCENT);
            this._samplingSizeLayout.show(this.jPanelSamplingSize, PERCENT);
        } else {
            this.jCmbSize.setSelectedItem(NUM_ROWS);
            this._samplingSizeLayout.show(this.jPanelSamplingSize, NUM_ROWS);
        }
        if (l == null) {
            l = this._cachePreffrences.getNumberOfRows();
        }
        this.jPanelSamplingSizeRows.setNumberOfRows(l);
        if (d == null) {
            d = this._cachePreffrences.getPercentValue();
        }
        this.jPanelSamplingSizePercent.setPercent(d);
        this.jCmbSize.addPopupMenuListener(new CustomPIPopupListener(){

            @Override
            public void updatePropertyModel(Object object) {
                String string = (String)object;
                if (string.equals(NUM_ROWS)) {
                    CachePIComponentPanel.this._samplingSizeLayout.show(CachePIComponentPanel.this.jPanelSamplingSize, NUM_ROWS);
                    CachePIComponentPanel.this.setNumberRows(CachePIComponentPanel.this.jPanelSamplingSizeRows.getNumberOfRows());
                    CachePIComponentPanel.this.setPercentOfTotal(null);
                } else if (string.equals(PERCENT)) {
                    CachePIComponentPanel.this._samplingSizeLayout.show(CachePIComponentPanel.this.jPanelSamplingSize, PERCENT);
                    CachePIComponentPanel.this.setPercentOfTotal(CachePIComponentPanel.this.jPanelSamplingSizePercent.getValue());
                    CachePIComponentPanel.this.setNumberRows(null);
                }
            }
        });
        this.updateUIElements(bl);
    }

    protected void updateUIElements(boolean bl) {
        boolean bl2 = this.isWritable();
        this.jCheckBoxAllData.setEnabled(bl2);
        this.jCmbSize.setEnabled(bl2 && bl);
        this.jPanelSamplingSizeRows.setEnabled(bl2 && bl);
        this.jPanelSamplingSize.setEnabled(bl2 && bl);
        this.jPanelSamplingSizePercent.setEnabled(bl2 && bl);
    }

    protected void selectAllData(boolean bl) {
        boolean bl2 = this.isWritable();
        this.jCheckBoxAllData.setEnabled(bl2);
        this.jCmbSize.setEnabled(bl2 && bl);
        this.jLblSize.setEnabled(bl2 && bl);
        this.jPanelSamplingSizeRows.setEnabled(bl2 && bl);
        this.jPanelSamplingSizePercent.setEnabled(bl2 && bl);
    }

    public void updateUI(PropertyModel propertyModel) {
        this._propertyModel = propertyModel;
        this.setSettings(this.getNode(propertyModel));
        this.jCheckBoxAllData.setSelected(this.isUseFullData());
        this.selectAllData(this.jCheckBoxAllData.isSelected());
        Long l = this.getNumberOfRows();
        Double d = this.getPercentOfTotal();
        if (l == null) {
            this.jCmbSize.setSelectedItem(PERCENT);
            this._samplingSizeLayout.show(this.jPanelSamplingSize, PERCENT);
        } else {
            this.jCmbSize.setSelectedItem(NUM_ROWS);
            this._samplingSizeLayout.show(this.jPanelSamplingSize, NUM_ROWS);
        }
        if (l == null) {
            l = this._cachePreffrences.getNumberOfRows();
        }
        this.jPanelSamplingSizeRows.setNumberOfRows(l);
        if (d == null) {
            d = this._cachePreffrences.getPercentValue();
        }
        this._bAdjusting = true;
        this.jPanelSamplingSizePercent.setPercent(d);
        this.jCheckBoxAllData.setSelected(this.isUseFullData());
        this._bAdjusting = false;
    }

    protected Attributes getAttributes() {
        Attributes attributes = null;
        AbstractNode abstractNode = this.getNode(this._propertyModel);
        if (abstractNode != null) {
            if (abstractNode instanceof DataProvider) {
                attributes = ((AbstractDataNode)abstractNode).getAttributes();
            } else {
                AbstractNode abstractNode2 = abstractNode.findParentNode();
                if (abstractNode2 instanceof DataProvider) {
                    attributes = ((DataProvider)((Object)abstractNode2)).getAttributes();
                }
            }
        }
        return attributes;
    }

    protected List<AttributeType> getAllAttributes() {
        Attributes attributes = this.getAttributes();
        if (attributes == null) {
            return new ArrayList<AttributeType>(0);
        }
        List list = attributes.getAttribute();
        if (list.isEmpty()) {
            return new ArrayList<AttributeType>(0);
        }
        return list;
    }

    protected void setTopN() {
        CacheSettings.Method method = new CacheSettings.Method();
        CacheSettings.Method.TopN topN = new CacheSettings.Method.TopN();
        method.setTopN(topN);
        this._cacheSettings.setMethod(method);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JComboBox) {
            if (this._bAdjusting) {
                return;
            }
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            String string = (String)jComboBox.getSelectedItem();
            this.setTargetAttribute(string);
        } else if (actionEvent.getSource().equals(this.jCheckBoxAllData)) {
            this.selectAllData(this.jCheckBoxAllData.isSelected());
            this.setUseFullData(this.jCheckBoxAllData.isSelected());
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof JSlider) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (jSlider.getValueIsAdjusting()) {
                return;
            }
            double d = jSlider.getValue();
            Double d2 = this.getPercentOfTotal();
            if (d2 != null && d2 != d) {
                if (this._bAdjusting) {
                    return;
                }
                this.setPercent(d);
            }
        } else if (changeEvent.getSource() instanceof JSpinner) {
            JSpinner jSpinner = (JSpinner)changeEvent.getSource();
            if (jSpinner.getName().equals(NUM_ROWS)) {
                Integer n = (Integer)jSpinner.getValue();
                this.setNumberOfRows(n);
            } else if (jSpinner.getName().equals(RANDOM)) {
                Integer n = (Integer)jSpinner.getValue();
                this.setSeed(n);
            }
        }
    }

    protected Object copySettings() {
        CacheSettings cacheSettings = new CacheSettings();
        cacheSettings.setNumberOfRows(this.getNumberOfRows());
        cacheSettings.setPercentOfTotal(this.getPercentOfTotal());
        CacheSettings.Method method = this._cacheSettings.getMethod();
        CacheSettings.Method method2 = new CacheSettings.Method();
        if (null != method.getRandom()) {
            CacheSettings.Method.Random random = new CacheSettings.Method.Random();
            random.setSeed(method.getRandom().getSeed());
            method2.setRandom(random);
        } else if (null != method.getStratified()) {
            CacheSettings.Method.Stratified stratified = new CacheSettings.Method.Stratified();
            stratified.setTargetAttr(method.getStratified().getTargetAttr());
            method2.setStratified(stratified);
        } else if (null != method.getTopN()) {
            CacheSettings.Method.TopN topN = new CacheSettings.Method.TopN();
            method2.setTopN(topN);
        }
        cacheSettings.setMethod(method2);
        cacheSettings.setGenerateCache(this.isUseFullData());
        cacheSettings.setUseFullData(Boolean.valueOf(false));
        cacheSettings.setOutputTable(this._cacheSettings.getOutputTable());
        return cacheSettings;
    }

    protected void updateSettings(Object object, String string) {
        ComplexProperty complexProperty = new ComplexProperty(string, object);
        complexProperty.setOldData(this._cacheSettings);
        if (this._propertyModel instanceof WorkflowNodePropertyProxyModel) {
            WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = (WorkflowNodePropertyProxyModel)this._propertyModel;
            workflowNodePropertyProxyModel.setValueAt(string, (AbstractNode)this.getTargetNode(this._propertyModel), complexProperty, workflowNodePropertyProxyModel.getRowMapping("CACHE_SETTINGS"));
        }
    }

    protected void setStratifiedSettings(String string) {
        CacheSettings cacheSettings = (CacheSettings)this.copySettings();
        CacheSettings.Method.Stratified stratified = new CacheSettings.Method.Stratified();
        stratified.setTargetAttr(string);
        cacheSettings.getMethod().setRandom(null);
        cacheSettings.getMethod().setStratified(stratified);
        cacheSettings.getMethod().setTopN(null);
        this.updateSettings(cacheSettings, AbstractDataNode.CACHE_SETTINGS_STRATIFIED);
    }

    protected void setRandomSettings() {
        CacheSettings cacheSettings = (CacheSettings)this.copySettings();
        CacheSettings.Method.Random random = new CacheSettings.Method.Random();
        random.setSeed(BigInteger.valueOf(this._cachePreffrences.getSeed()));
        cacheSettings.getMethod().setRandom(random);
        cacheSettings.getMethod().setStratified(null);
        cacheSettings.getMethod().setTopN(null);
        this.updateSettings(cacheSettings, AbstractDataNode.CACHE_SETTINGS_RANDOM);
    }

    protected void setTopNSettings() {
        CacheSettings cacheSettings = (CacheSettings)this.copySettings();
        CacheSettings.Method.TopN topN = new CacheSettings.Method.TopN();
        cacheSettings.getMethod().setRandom(null);
        cacheSettings.getMethod().setStratified(null);
        cacheSettings.getMethod().setTopN(topN);
        this.updateSettings(cacheSettings, AbstractDataNode.CACHE_SETTINGS_TOPN);
    }

    protected void setTargetAttribute(String string) {
        CacheSettings cacheSettings = (CacheSettings)this.copySettings();
        cacheSettings.getMethod().getStratified().setTargetAttr(string);
        this.updateSettings(cacheSettings, AbstractDataNode.CACHE_SETTINGS_TARGET);
    }

    protected void setUseFullData(boolean bl) {
        CacheSettings cacheSettings = (CacheSettings)this.copySettings();
        cacheSettings.setGenerateCache(bl);
        this.updateSettings(cacheSettings, AbstractDataNode.CACHE_SETTINGS_PERCENT);
    }

    protected void setPercent(double d) {
        CacheSettings cacheSettings = (CacheSettings)this.copySettings();
        cacheSettings.setPercentOfTotal(Double.valueOf(d));
        cacheSettings.setNumberOfRows(null);
        this.updateSettings(cacheSettings, AbstractDataNode.CACHE_SETTINGS_PERCENT);
    }

    protected void setNumberOfRows(Integer n) {
        CacheSettings cacheSettings = (CacheSettings)this.copySettings();
        cacheSettings.setNumberOfRows(Long.valueOf(n.intValue()));
        cacheSettings.setPercentOfTotal(null);
        this.updateSettings(cacheSettings, AbstractDataNode.CACHE_SETTINGS_NUMBER_OF_ROWS);
    }

    protected void setSeed(Integer n) {
        CacheSettings cacheSettings = (CacheSettings)this.copySettings();
        cacheSettings.getMethod().getRandom().setSeed(BigInteger.valueOf(n.intValue()));
        this.updateSettings(cacheSettings, AbstractDataNode.CACHE_SETTINGS_SEED);
    }

    JPanel getSamplingSizePanel() {
        return this.jPanelSamplingSize;
    }
}

