/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.inspect.NodeProperty;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyGroupImpl;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.inspector.IdePropertyModel;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.javatools.dialogs.MessageDialog;

public abstract class AbstractNodePropertyModel
extends PropertyModel {
    protected static final Object[] COLUMNS = new Object[]{PropertyModel.COLUMN_ID, PropertyModel.COLUMN_VALUE, PropertyModel.COLUMN_VALUE_CLASS, PropertyModel.COLUMN_GROUP, PropertyModel.COLUMN_DISPLAY_NAME, PropertyModel.COLUMN_NAME, PropertyModel.COLUMN_DESCRIPTION, PropertyModel.COLUMN_EDITOR_FACTORY, PropertyModel.COLUMN_EDITOR_FACTORY_2, PropertyModel.COLUMN_IS_READABLE, PropertyModel.COLUMN_IS_WRITABLE, PropertyModel.COLUMN_DISPLAY_VALUE, PropertyModel.COLUMN_ACTIONS, PropertyModel.COLUMN_IS_HIDDEN, IdePropertyModel.COLUMN_HELP};
    protected static List<NodeProperty> properties = new ArrayList<NodeProperty>();
    protected static NodeProperty PROP_NAME;
    protected static NodeProperty PROP_COMMENT;
    private Context context;
    protected WorkflowNodeInspectorElement workflowElement;
    protected final List<Property> rows;

    public AbstractNodePropertyModel(Context context) {
        this.context = context;
        this.rows = new ArrayList<Property>();
        Element[] elementArray = context.getSelection();
        if (elementArray.length > 1) {
            return;
        }
        this.setInspector();
        NodeType nodeType = this.workflowElement.getNode().getData();
        for (NodeProperty nodeProperty : this.getNodeProperties()) {
            String string = nodeProperty.id;
            String string2 = nodeType.getName();
            if (nodeProperty == PROP_NAME || nodeProperty == PROP_COMMENT) {
                string = this.propertyId(nodeProperty.id);
                if (nodeProperty == PROP_COMMENT) {
                    string2 = nodeType.getAnnotation();
                }
            }
            Property property = new Property(string, nodeProperty.displayName, string2, nodeProperty.description, nodeProperty.group);
            this.rows.add(property);
        }
    }

    public void setContext(Context context) {
        this.context = context;
        this.setInspector();
    }

    private void setInspector() {
        Element[] elementArray = this.getContext().getSelection();
        this.workflowElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
    }

    public boolean isCellEditable(int n, int n2) {
        Node node = EditorManager.getEditorManager().getCurrentEditor().getContext().getNode();
        if (!(node instanceof WorkflowNode)) {
            return false;
        }
        WorkflowNode workflowNode = (WorkflowNode)node;
        boolean bl = !workflowNode.isReadOnly();
        return bl;
    }

    public void invalidateValueData() {
    }

    public Context getContext() {
        return this.context;
    }

    public Object[] getColumnMapping() {
        return COLUMNS;
    }

    public List<Property> getRows() {
        return this.rows;
    }

    public String getTargetDisplayName() {
        Element element = this.context.getElement();
        String string = element.getShortLabel();
        return string;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    protected String propertyId(String string) {
        return ((Object)((Object)this)).getClass().getName() + "." + string;
    }

    public Object getValueAt(int n, int n2) {
        boolean bl;
        Property property = this.getRows().get(n);
        Object[] objectArray = this.getColumnMapping();
        Object object = null;
        boolean bl2 = bl = n < 0 || n >= this.getRowCount() || n2 < 0 || n2 >= objectArray.length;
        if (bl) {
            return PropertyModel.DOES_NOT_EXIST;
        }
        Object object2 = objectArray[n2];
        object = PropertyModel.COLUMN_ID.equals(object2) ? property.getId() : (PropertyModel.COLUMN_GROUP.equals(object2) ? property.getGroup() : (PropertyModel.COLUMN_DISPLAY_NAME.equals(object2) ? property.getDisplayName() : (PropertyModel.COLUMN_DISPLAY_VALUE.equals(object2) ? property.getValue() : (PropertyModel.COLUMN_DESCRIPTION.equals(object2) ? property.getDescription() : (PropertyModel.COLUMN_NAME.equals(object2) ? property.getId() : (PropertyModel.COLUMN_VALUE.equals(object2) ? property.getValue() : (PropertyModel.COLUMN_IS_WRITABLE.equals(object2) ? Boolean.valueOf(this.isCellEditable(n, n2)) : (PropertyModel.COLUMN_IS_HIDDEN.equals(object2) ? Boolean.valueOf(false) : (IdePropertyModel.COLUMN_HELP.equals(object2) ? this.getHelpTopic() : PropertyModel.DOES_NOT_EXIST)))))))));
        return object;
    }

    public abstract String getHelpTopic();

    public void setValueAt(Object object, int n, int n2) {
        Object[] objectArray = this.getColumnMapping();
        Object object2 = objectArray[n2];
        if (PropertyModel.COLUMN_VALUE.equals(object2)) {
            boolean bl;
            Object object3 = this.rows.get(n).getValue();
            String string = object3 != null ? object3.toString() : "";
            String string2 = object != null ? object.toString() : "";
            String string3 = null;
            boolean bl2 = bl = n >= 0 && n < properties.size();
            if (bl) {
                string3 = AbstractNodePropertyModel.properties.get((int)n).id;
                if (!string.equals(string2)) {
                    ProcessTextWorker processTextWorker = new ProcessTextWorker(n, string3, string2, this.context);
                    processTextWorker.execute();
                }
            }
        } else if (PropertyModel.COLUMN_ID.equals(object2)) {
            if (n >= this.getPropertyStartIndex() && n <= this.getPropertyEndIndex()) {
                ComplexProperty complexProperty = (ComplexProperty)object;
                this.rows.get(n).setValue(complexProperty.getData());
                this.workflowElement.updateNode(complexProperty);
            } else assert (false) : "Property not handled";
        }
    }

    protected int getPropertyStartIndex() {
        return properties.size();
    }

    protected int getPropertyEndIndex() {
        return this.getNodeProperties().size() - 1;
    }

    protected abstract List<NodeProperty> getNodeProperties();

    static {
        int n = 0;
        PROP_NAME = new NodeProperty("name", PropertyLrb.get("PI_COMMON_GROUP_NODE_NAME"), PropertyLrb.get("PI_COMMON_GROUP_NODE_NAME_DESCRIPTION"), Groups.COMMON, n++);
        properties.add(PROP_NAME);
        PROP_COMMENT = new NodeProperty("comment", PropertyLrb.get("PI_COMMON_GROUP_NODE_COMMENT"), PropertyLrb.get("PI_COMMON_GROUP_NODE_COMMENT_DESCRIPTION"), Groups.COMMON, n++);
        properties.add(PROP_COMMENT);
    }

    private class ProcessTextWorker
    extends SwingWorker<String, Void> {
        private int propIndex;
        private String propName;
        private String text;
        private Context context;

        public ProcessTextWorker(int n, String string, String string2, Context context) {
            this.text = string2;
            this.propName = string;
            this.context = context;
            this.propIndex = n;
            StringUtils.displayOverLayPanel(context);
        }

        @Override
        protected String doInBackground() throws Exception {
            return StringUtils.checkDataLossWithNoMsg(this.context, this.text, false);
        }

        @Override
        protected void done() {
            try {
                String string = (String)this.get();
                if ("".equals(string)) {
                    this.text = this.processText(this.text);
                    AbstractNodePropertyModel.this.getRows().get(this.propIndex).setValue(this.text);
                    AbstractNodePropertyModel.this.workflowElement.updateNode(this.propName, this.text);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)PropertyLrb.get("PI_COMMON_GROUP_NODE_SETTING_ERROR_TITLE"), null);
                }
            }
            catch (IllegalArgumentException | InterruptedException | ExecutionException exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)PropertyLrb.get("PI_COMMON_GROUP_NODE_SETTING_ERROR_TITLE"), null);
            }
            finally {
                StringUtils.hideOverLayPanel(this.context);
            }
        }

        public String processText(String string) throws IllegalArgumentException {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.context);
            if (this.propIndex == AbstractNodePropertyModel.PROP_NAME.index) {
                String string2 = string;
                if (string2.trim().length() == 0) {
                    throw new IllegalArgumentException(PropertyLrb.get("PI_COMMON_GROUP_NODE_NAME_SPACES"));
                }
                if (!StringUtils.checkStringDBLengthMax(string2, connectionFolder, 50, true)) {
                    String string3 = MessageFormat.format(PropertyLrb.get("PI_COMMON_GROUP_NODE_NAME_TOO_LONG"), 50);
                    throw new IllegalArgumentException(string3);
                }
                if (this.containsForwardSlash(string2)) {
                    throw new IllegalArgumentException(PropertyLrb.get("PI_COMMON_GROUP_NODE_NAME_SLASH"));
                }
                if (this.containsAmpersand(string2)) {
                    throw new IllegalArgumentException(PropertyLrb.get("PI_COMMON_GROUP_NODE_NAME_AMPERSAND"));
                }
                if (this.isDuplicateName(string2)) {
                    throw new IllegalArgumentException(WorkflowEditorLrb.get("NODE_NAME_NOT_UNIQUE_MSG"));
                }
                return string2;
            }
            if (this.propIndex == AbstractNodePropertyModel.PROP_COMMENT.index) {
                CharSequence charSequence;
                String string4 = string;
                StringBuffer stringBuffer = new StringBuffer();
                if (string4.length() > 4000) {
                    string4 = string4.substring(0, 4000);
                    charSequence = MessageFormat.format(PropertyLrb.get("PI_COMMON_GROUP_NODE_COMMENT_TOO_LONG"), 4000);
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)charSequence, (String)PropertyLrb.get("PI_COMMON_GROUP_NODE_SETTING_ERROR_TITLE"), null);
                }
                if (!StringUtils.checkStringDBLengthMaxLong(string4, connectionFolder, 4000)) {
                    charSequence = MessageFormat.format(PropertyLrb.get("PI_COMMON_GROUP_NODE_COMMENT_MAX_BYTES"), 4000);
                    throw new IllegalArgumentException((String)charSequence);
                }
                if (StringUtils.checkDataLoss(connectionFolder, string4, stringBuffer)) {
                    charSequence = new StringBuffer();
                    for (int i = 0; i < stringBuffer.length(); ++i) {
                        if (((StringBuffer)charSequence).length() > 0) {
                            ((StringBuffer)charSequence).append(" ");
                        }
                        ((StringBuffer)charSequence).append(stringBuffer.charAt(i));
                    }
                    String string5 = MessageFormat.format(PropertyLrb.get("PI_COMMON_GROUP_NODE_COMMENT_DATA_LOSS"), charSequence);
                    throw new IllegalArgumentException(string5);
                }
                return string4;
            }
            return string;
        }

        private boolean isDuplicateName(String string) {
            boolean bl = false;
            Editor editor = EditorManager.getEditorManager().getCurrentEditor();
            if (editor instanceof WorkflowEditor) {
                WorkflowEditor workflowEditor = (WorkflowEditor)editor;
                bl = workflowEditor.doesNodeNameAlreadyExist(string);
            }
            return bl;
        }

        private boolean containsForwardSlash(String string) {
            return string.indexOf("/") >= 0;
        }

        private boolean containsAmpersand(String string) {
            return string.indexOf("&") >= 0;
        }
    }

    private static class Groups {
        private static final PropertyGroupImpl COMMON = new PropertyGroupImpl(PreferencesLrb.get("PI_COMMON_GROUP_TITLE"));

        private Groups() {
        }
    }
}

