/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.columnFilterDetails;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.CustomPIPopupListener;
import oracle.dmt.dataminer.controls.DBObjectNameEditor;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.core.model.common.xmlschema.OutputAttributeType;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.PIAncestorListener;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UITools;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.columnFilterDetails.AttributeTableModel;
import oracle.dmt.dataminer.workflow.dialog.columnFilterDetails.ColumnDetailsOutputType;
import oracle.dmt.dataminer.workflow.dialog.columnFilterDetails.DialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.columnFilterDetails.WorkflowFilterDetailsDataNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.ColumnFilterNode;
import oracle.dmt.dataminer.workflow.model.ExtractQueryFactory;
import oracle.dmt.dataminer.workflow.model.FilterDetailsDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FilterDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FilterDetailsOutputType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.inspector.PropertyLabel;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.Version;

public class OutputSettingPanel
extends DialogDisplayer<FilterDetailsDataNode> {
    private static int MAX_LENGTH = 32;
    private static int MAX_LENGTH_EX = 130;
    private WorkflowFilterDetailsDataNodePropertyProxyModel _propertyModel;
    private boolean _dirty;
    private FilterDetailsOutputType _filterDetailsOutputType;
    private AttributeTableModel _outputColumnsTableModel;
    private List<OutputAttributeType> _currentOutputColumns;
    private ColumnDetailsOutputType _currentOutputType;
    private DataMinerTablePanel _dataMinerTablePanel;
    private JComboBox _jOutputTypeCombo;
    private PropertyLabel _jOutputTypeLabel;

    public OutputSettingPanel(PropertyModel propertyModel) {
        super((Context)null, null);
        assert (propertyModel != null) : "PropertyModel for FilterDetailsNode node is null.";
        this.initComponents();
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.addAncestorListener(new PIAncestorListener(this));
        this.init((FilterDetailsDataNode)this._data, propertyModel);
    }

    public OutputSettingPanel(Context context, FilterDetailsDataNode filterDetailsDataNode) {
        super(context, filterDetailsDataNode);
        assert (context != null) : "Context must not be null.";
        assert (filterDetailsDataNode != null) : "FilterDetailsDataNode node must not be null.";
        this.init(filterDetailsDataNode, null);
    }

    public OutputSettingPanel(Context context, FilterDetailsDataNode filterDetailsDataNode, PropertyModel propertyModel) {
        super(context, filterDetailsDataNode);
        assert (propertyModel != null) : "PropertyModel for FilterDetailsDataNode node is null.";
        this.setMinimumSize(new Dimension(400, 1000));
        this.init((FilterDetailsDataNode)this._data, propertyModel);
    }

    private void initComponents() {
        this._jOutputTypeLabel = new PropertyLabel();
        this._jOutputTypeCombo = new JComboBox();
        this._dataMinerTablePanel = new DataMinerTablePanel();
        this._jOutputTypeLabel.setText("Output:");
        this._jOutputTypeLabel.setPreferredSize(new Dimension(45, 14));
        this._jOutputTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Full Tree", "Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._dataMinerTablePanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this._jOutputTypeLabel, -2, 66, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jOutputTypeCombo, -2, 142, -2).addGap(0, 302, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this._jOutputTypeLabel, -2, -1, -2).addComponent(this._jOutputTypeCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this._dataMinerTablePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowFilterDetailsDataNodePropertyProxyModel)) {
            return null;
        }
        WorkflowFilterDetailsDataNodePropertyProxyModel workflowFilterDetailsDataNodePropertyProxyModel = (WorkflowFilterDetailsDataNodePropertyProxyModel)propertyModel;
        Context context = workflowFilterDetailsDataNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private FilterDetailsDataNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowFilterDetailsDataNodePropertyProxyModel)) {
            return null;
        }
        WorkflowFilterDetailsDataNodePropertyProxyModel workflowFilterDetailsDataNodePropertyProxyModel = (WorkflowFilterDetailsDataNodePropertyProxyModel)propertyModel;
        Context context = workflowFilterDetailsDataNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof FilterDetailsDataNodeType) {
            return (FilterDetailsDataNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private void init(FilterDetailsDataNode filterDetailsDataNode, PropertyModel propertyModel) {
        if (propertyModel != null) {
            assert (propertyModel instanceof WorkflowFilterDetailsDataNodePropertyProxyModel);
            this._propertyModel = (WorkflowFilterDetailsDataNodePropertyProxyModel)propertyModel;
        }
        this._dirty = false;
        assert (filterDetailsDataNode.getData() instanceof FilterDetailsDataNodeType);
        FilterDetailsDataNodeType filterDetailsDataNodeType = (FilterDetailsDataNodeType)filterDetailsDataNode.getData();
        this._filterDetailsOutputType = (FilterDetailsOutputType)MetaDataHelper.copyMetadataObject(filterDetailsDataNodeType.getFilterDetailsOutput());
        this._outputColumnsTableModel = new AttributeTableModel(this.getContext(), (List<AttributeType>)this._filterDetailsOutputType.getAttributes().getAttribute(), (FilterDetailsDataNode)this.getData(), true, this.isPIMode());
        this._outputColumnsTableModel.setWritable(this.isWritable());
        this._outputColumnsTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                OutputSettingPanel.this._dirty = true;
            }
        });
        this._currentOutputType = ColumnDetailsOutputType.getColumnDetailsOutputType(this._filterDetailsOutputType.getType());
        this.initComponents();
        HelpUtils.setHelpID((JComponent)this, (String)this.getHelpTopic());
        this.initRes();
        this.initUI();
    }

    @Override
    public void initUI() {
        this.setupModelsTable(this._outputColumnsTableModel);
        this.initComboBoxes();
        this._jOutputTypeCombo.addPopupMenuListener(new CustomPIPopupListener(){

            @Override
            public void updatePropertyModel(Object object) {
                OutputSettingPanel.this.processOutputTypeComboAction();
            }
        });
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this._jOutputTypeLabel, (Component)this._jOutputTypeCombo, (String)DialogsLrb.get("COLUMN_FILTER_DETAILS_GROUP_OUTPUT_TYPE"));
        this._jOutputTypeCombo.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("COLUMN_FILTER_DETAILS_GROUP_OUTPUT_TYPE_ADA"));
        this._jOutputTypeCombo.setToolTipText(DialogsLrb.get("COLUMN_FILTER_DETAILS_GROUP_OUTPUT_TYPE_ADA"));
    }

    public void updatePI(PropertyModel propertyModel) {
        assert (propertyModel instanceof WorkflowFilterDetailsDataNodePropertyProxyModel);
        WorkflowFilterDetailsDataNodePropertyProxyModel workflowFilterDetailsDataNodePropertyProxyModel = (WorkflowFilterDetailsDataNodePropertyProxyModel)propertyModel;
        Context context = workflowFilterDetailsDataNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        FilterDetailsDataNode filterDetailsDataNode = (FilterDetailsDataNode)workflowNodeInspectorElement.getNode();
        if (filterDetailsDataNode == null) {
            return;
        }
        this._propertyModel = (WorkflowFilterDetailsDataNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = filterDetailsDataNode;
        this._dirty = false;
        this._filterDetailsOutputType = ((FilterDetailsDataNodeType)filterDetailsDataNode.getData()).getFilterDetailsOutput();
        this._currentOutputType = ColumnDetailsOutputType.getColumnDetailsOutputType(this._filterDetailsOutputType.getType());
        this._currentOutputColumns = OutputAttributeType.convertAttributes((Attributes)this._filterDetailsOutputType.getAttributes());
        this.refreshUI();
    }

    public void refreshUI() {
        this.initComboBoxes();
        this._outputColumnsTableModel.reload(this._currentOutputColumns);
    }

    private void initComboBoxes() {
        if (this._currentOutputType != null) {
            Version version = ConfigUtils.getDatabaseVersion(this._context);
            boolean bl = DbVersionHelper.isDB122Up((Version)version) ? ((FilterDetailsDataNode)this.getData()).getIsADselected() : false;
            this._jOutputTypeCombo.setModel(new DefaultComboBoxModel<ColumnDetailsOutputType>(ColumnDetailsOutputType.getColumnDetailsOutputType(bl)));
            this._jOutputTypeCombo.setEnabled(this.isWritable());
            this._jOutputTypeCombo.setSelectedItem((Object)ColumnDetailsOutputType.getColumnDetailsOutputType(this._filterDetailsOutputType.getType()));
        } else {
            this._jOutputTypeCombo.setModel(new DefaultComboBoxModel());
            this._jOutputTypeCombo.setEnabled(false);
        }
    }

    private void setupModelsTable(AttributeTableModel attributeTableModel) {
        this._dataMinerTablePanel.setup((TableModel)attributeTableModel, DialogsLrb.get("COLUMN_FILTER_DETAILS_COLUMN_TABLE_TITLE"), 0, true);
        if (attributeTableModel.getRowCount() != 0) {
            this._dataMinerTablePanel.getTable().setColumnHeaderSelectionEnabled(true);
            this._dataMinerTablePanel.getTable().setAutoCreateRowSorter(true);
            this._dataMinerTablePanel.getTable().setRolloverHighlightingEnabled(false);
            this._dataMinerTablePanel.getTable().getTableHeader().setReorderingAllowed(false);
            this._dataMinerTablePanel.getTable().sizeTableToContents();
            this._dataMinerTablePanel.getTable().setAutoResizeMode(4);
        }
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                assert (jTable instanceof GenericTable);
                GenericTable genericTable = (GenericTable)jTable;
                int n3 = genericTable.convertRowIndexToModel(n);
                AttributeTableModel attributeTableModel = (AttributeTableModel)OutputSettingPanel.this._dataMinerTablePanel.getTable().getModel();
                OutputAttributeType outputAttributeType = attributeTableModel.getDataVector().get(n3);
                if (outputAttributeType.getStatus() == AttributeStatus.VALID) {
                    return OracleIcons.getIcon((String)"attribute.png");
                }
                if (outputAttributeType.getStatus() == AttributeStatus.MISSING || outputAttributeType.getStatus() == AttributeStatus.INVALID) {
                    return DataMinerIcons.get(Icons.ERROR_STATUS);
                }
                return null;
            }
        });
        TableColumn tableColumn = this._dataMinerTablePanel.getTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(iconCellRenderer);
        DBObjectNameEditor dBObjectNameEditor = new DBObjectNameEditor(this._context);
        boolean bl = SQLHelper.isExpandedObjNameEnabled(this._context);
        dBObjectNameEditor.setDocument(new TextFieldLimit(bl ? MAX_LENGTH_EX : MAX_LENGTH));
        TableColumn tableColumn2 = this._dataMinerTablePanel.getTable().getColumnModel().getColumn(1);
        tableColumn2.setCellEditor(dBObjectNameEditor);
    }

    private void processOutputTypeComboAction() {
        ColumnDetailsOutputType columnDetailsOutputType = (ColumnDetailsOutputType)((Object)this._jOutputTypeCombo.getSelectedItem());
        if (this._currentOutputType != columnDetailsOutputType) {
            this._currentOutputType = columnDetailsOutputType;
            this.initOutputColumns();
            this._outputColumnsTableModel.reload(this._currentOutputColumns);
            if (this.isPIMode()) {
                this.updateNode();
            } else {
                this.setDirty(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNode() {
        FilterDetailsDataNode filterDetailsDataNode = (FilterDetailsDataNode)this.getData();
        assert (filterDetailsDataNode.getData() instanceof FilterDetailsDataNodeType);
        FilterDetailsDataNodeType filterDetailsDataNodeType = (FilterDetailsDataNodeType)filterDetailsDataNode.getData();
        FilterDetailsOutputType filterDetailsOutputType = new FilterDetailsOutputType();
        filterDetailsOutputType.setAttributes(this._outputColumnsTableModel.generateAttributes());
        filterDetailsOutputType.setType(ColumnDetailsOutputType.getColumnDetailsOutputType(this._currentOutputType));
        filterDetailsOutputType.setAutoSpec(filterDetailsDataNodeType.getFilterDetailsOutput().getAutoSpec());
        CommandProcessor.getInstance().beginTrans(DialogsLrb.get("TRANSACTION_NAME_OUTPUT_TYPE"));
        try {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)((FilterDetailsDataNode)this.getData()).getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this.getData(), this.getContext(), "FilterDetailsSpecification", filterDetailsOutputType);
            ((FilterDetailsDataNode)this.getData()).validate(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)UITools.getParentWindow(this), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("ERROR_MODEL_UPDATE_UNEXPECTED"), null);
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    private void initOutputColumns() {
        FilterDetailsDataNode filterDetailsDataNode = (FilterDetailsDataNode)this.getData();
        FilterDetailsDataNodeType filterDetailsDataNodeType = (FilterDetailsDataNodeType)filterDetailsDataNode.getData();
        ColumnFilterNode columnFilterNode = filterDetailsDataNode.getSourceNode();
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNode.getData();
        this._currentOutputColumns = ExtractQueryFactory.getFilterColumnList(ColumnDetailsOutputType.getColumnDetailsOutputType(this._currentOutputType), filterDetailsDataNodeType.getFilterDetailsOutput().getAttributes().getAttribute(), columnFilterNodeType.getColumnFilterResults().getAttrImportanceOutput(), null);
    }

    public FilterDetailsOutputType getFilterDetailsOutputType() {
        return this._filterDetailsOutputType;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    private boolean isPIMode() {
        return this._propertyModel != null;
    }

    private boolean isEditorMode() {
        return this._propertyModel == null;
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        if (this.isDirty() && !this.isPIMode() && this.isEditorMode()) {
            this.updateNode();
        }
        return bl;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("EDIT_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "edit_column_filter_details";
    }
}

