/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.extensible.r;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import oracle.dmt.dataminer.controls.BoundedNumberTextField;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.NumberCellEditor;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.core.model.extensible.r.RFunction;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.extensible.r.DetailOutputTableModel;
import oracle.dmt.dataminer.workflow.dialog.build.extensible.r.FunctionSelectionPanel;
import oracle.dmt.dataminer.workflow.dialog.build.extensible.r.TypeCellEditor;
import oracle.dmt.dataminer.workflow.xmlschema.MiningDataType;
import oracle.dmt.dataminer.workflow.xmlschema.RModelType;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;

public class DetailsFunctionSelectionPanel
extends FunctionSelectionPanel {
    private static final int COLUMN_NAME_BYTE_LIMIT = 30;
    private static final int MAX_VARCHAR2 = 4000;
    private static final int MIN_VARCHAR2 = 1;
    private boolean hasError;
    private DefaultComboBoxModel<RFunction> modelA;
    private RModelType.DetailFunction function = new RModelType.DetailFunction();
    private DetailOutputTableModel tableModel;
    private List<RModelType.DetailFunction.Output.Column> outputColumns;
    private JButton addColumn;
    private JButton deleteColumn;
    private JLabel errorLabel;
    private JCheckBox includeAllSchemasCheckBox;
    private JComboBox<RFunction> jDetailsChoice;
    private JTextArea jDetailsDefinition;
    private JLabel jDetailsDefinitionLabel;
    private JLabel jDetailsFunctionLabel;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private DataMinerTablePanel outputColumnsTable;

    public DetailsFunctionSelectionPanel(Context context, RModelType.DetailFunction detailFunction) {
        super(context);
        if (detailFunction != null) {
            this.cloneBuildFunctions(detailFunction, this.function);
        } else {
            this.function.setOutput(new RModelType.DetailFunction.Output());
            this.outputColumns = this.function.getOutput().getColumn();
        }
        this.tableModel = new DetailOutputTableModel();
        this.tableModel.setSrcData(this.outputColumns);
        this.determineUseOtherSchemas(this.function.getPrimaryFunction());
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void cloneBuildFunctions(RModelType.DetailFunction detailFunction, RModelType.DetailFunction detailFunction2) {
        detailFunction2.setPrimaryFunction(detailFunction.getPrimaryFunction());
        RModelType.DetailFunction.Output output = new RModelType.DetailFunction.Output();
        this.outputColumns = output.getColumn();
        if (detailFunction.getOutput() != null) {
            detailFunction.getOutput().getColumn().forEach(column -> {
                RModelType.DetailFunction.Output.Column column2 = new RModelType.DetailFunction.Output.Column();
                column2.setName(column.getName());
                column2.setType(column.getType());
                column2.setLength(column.getLength());
                this.outputColumns.add(column2);
            });
        }
        detailFunction2.setOutput(output);
    }

    private void initComponents() {
        this.jDetailsFunctionLabel = new JLabel();
        this.jDetailsChoice = new JComboBox();
        this.jDetailsDefinitionLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jDetailsDefinition = new JTextArea();
        this.outputColumnsTable = new DataMinerTablePanel();
        this.jPanel1 = new JPanel();
        this.errorLabel = new JLabel();
        this.includeAllSchemasCheckBox = new JCheckBox();
        this.setMaximumSize(new Dimension(400, Short.MAX_VALUE));
        this.jDetailsFunctionLabel.setText("Model Details Function:");
        this.jDetailsDefinitionLabel.setText("Function Definition:");
        this.jDetailsDefinition.setColumns(20);
        this.jDetailsDefinition.setRows(5);
        this.jScrollPane1.setViewportView(this.jDetailsDefinition);
        this.jPanel1.setMinimumSize(new Dimension(0, 20));
        this.jPanel1.setPreferredSize(new Dimension(139, 18));
        this.errorLabel.setText("Incomplete Column Definition");
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.errorLabel)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel, -1, -1, Short.MAX_VALUE));
        this.includeAllSchemasCheckBox.setText("Include Other Schemas");
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, 414, Short.MAX_VALUE).addComponent(this.outputColumnsTable, -1, 414, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jDetailsDefinitionLabel).addComponent(this.jDetailsChoice, -2, 300, -2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jDetailsFunctionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.includeAllSchemasCheckBox)).addComponent(this.jScrollPane1)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(25, 25, 25).addComponent(this.jDetailsFunctionLabel)).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.includeAllSchemasCheckBox))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jDetailsChoice, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jDetailsDefinitionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 144, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputColumnsTable, -2, 157, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
    }

    @Override
    protected void initializeComponents() {
        this.initComponents();
    }

    @Override
    protected void initRes() {
        ResourceUtils.resLabel((JLabel)this.jDetailsFunctionLabel, this.jDetailsChoice, (String)BuildEditorLrb.get("R_DETAILS_FUNCTION"));
        ResourceUtils.resLabel((JLabel)this.jDetailsDefinitionLabel, (Component)this.jDetailsDefinition, (String)BuildEditorLrb.get("R_FUNCTION_DEFINITION"));
        ResourceUtils.resButton((AbstractButton)this.includeAllSchemasCheckBox, (String)BuildEditorLrb.get("R_FUNCTIONS_ALL_SCHEMAS"));
        ResourceUtils.resLabel((JLabel)this.errorLabel, null, (String)BuildEditorLrb.get("R_INCOMPLETE_OUTPUT_DEFINITION"));
        this.errorLabel.setIcon(OracleIcons.getIcon((String)"warning.png"));
    }

    @Override
    protected void initUI() {
        this.setupFunctionSelectionControls();
        this.setupOutputSignatureTable();
        this.setupToolBar();
        this.includeAllSchemasCheckBox.setSelected(this.isUsingOtherSchemas());
    }

    private void setupFunctionSelectionControls() {
        this.modelA = new DefaultComboBoxModel();
        this.jDetailsChoice.setModel(this.modelA);
        this.jDetailsChoice.setRenderer(new FunctionSelectionPanel.QualifiedFunctionRenderer(this));
        this.jDetailsDefinition.setEditable(false);
    }

    private void setupOutputSignatureTable() {
        this.outputColumnsTable.setup((TableModel)((Object)this.tableModel), BuildEditorLrb.get("R_OUTPUT_COLUMNS"), -1);
        this.outputColumnsTable.removeSearchField();
        DataMinerTable dataMinerTable = this.outputColumnsTable.getTable();
        dataMinerTable.autoSizeColumnsToFit();
        dataMinerTable.setRowSorter(null);
        dataMinerTable.setAutoResizeMode(4);
        dataMinerTable.setNoEntryInstructionText(BuildEditorLrb.get("R_NO_OUTPUT_MSG"));
        this.setupTableCellEditors(dataMinerTable);
    }

    private void setupTableCellEditors(DataMinerTable dataMinerTable) {
        TableColumnModel tableColumnModel = dataMinerTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        JTextField jTextField = new JTextField();
        jTextField.setDocument(new SizeLimitedUTF8Document(30));
        tableColumn.setCellEditor(new DefaultCellEditor(jTextField));
        tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellEditor(new TypeCellEditor(true));
        tableColumn = tableColumnModel.getColumn(2);
        BoundedNumberTextField boundedNumberTextField = new BoundedNumberTextField(1, 4000);
        tableColumn.setCellEditor(new NumberCellEditor(null, boundedNumberTextField));
    }

    private void setupToolBar() {
        this.addColumn = new JButton();
        this.addColumn.setIcon(OracleIcons.getIcon((String)"add.png"));
        this.addColumn.setEnabled(false);
        this.deleteColumn = new JButton();
        this.deleteColumn.setIcon(OracleIcons.getIcon((String)"delete.png"));
        if (this.outputColumns.isEmpty()) {
            this.deleteColumn.setEnabled(false);
        } else {
            this.validateColumns();
        }
        this.outputColumnsTable.addControlBarComponents(this.addColumn, this.deleteColumn);
        this.errorLabel.setVisible(this.hasError);
    }

    private void addActionListeners() {
        this.tableModel.addTableModelListener(new OutputSignatureTableModelListener());
        this.jDetailsChoice.addActionListener(new DetailsFunctionChangeListener(this.modelA, this.jDetailsDefinition));
        this.addColumn.addActionListener(new NewOutputColumnListener());
        this.deleteColumn.addActionListener(new DeleteOutputColumnListener());
        this.includeAllSchemasCheckBox.addActionListener(new DetailsFunctionAllSchemaListener());
    }

    @Override
    protected void afterSuccess() {
        this.populateComboModels(this.modelA);
        String string = this.function.getPrimaryFunction();
        this.addActionListeners();
        this.setSelectedFunctionsFromMetaData(string);
    }

    private void setSelectedFunctionsFromMetaData(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            this.setSelectedFunction(this.modelA, string);
        }
    }

    @Override
    protected void afterReloadSuccess() {
        this.populateComboModels(this.modelA);
        this.isReloading = false;
        String string = this.function.getPrimaryFunction();
        this.setSelectedFunctionsFromMetaData(string);
    }

    @Override
    protected String getWindowTitle() {
        return BuildEditorLrb.get("R_DETAILS_FUNCTION");
    }

    @Override
    protected String getWindowHelpTopic() {
        return "r_details_function";
    }

    @Override
    protected boolean validateForm() {
        boolean bl = StringUtils.isEmpty((String)this.function.getPrimaryFunction());
        if (bl) {
            return false;
        }
        return this.outputColumns.isEmpty() ? false : !this.areSettingsValid(this.outputColumns);
    }

    @Override
    protected String getValidationErrorMessage() {
        return BuildEditorLrb.get("R_INVALID_DETAIL_FUNCTION");
    }

    @Override
    protected void cleanUp() {
        this.function.setOutput(null);
        this.function = null;
    }

    private void validateColumns() {
        List<RModelType.DetailFunction.Output.Column> list = this.tableModel.getSrcData();
        this.hasError = list.isEmpty() ? false : this.areSettingsValid(list);
        this.errorLabel.setVisible(this.hasError);
        this.addColumn.setEnabled(!this.hasError);
    }

    private RModelType.DetailFunction getDetailFunction() {
        return this.function;
    }

    private boolean areSettingsValid(List<RModelType.DetailFunction.Output.Column> list) {
        return list.stream().anyMatch(column -> {
            boolean bl;
            boolean bl2 = bl = StringUtils.isEmpty((String)column.getName()) || column.getType() == null;
            if (MiningDataType.VARCHAR_2.equals((Object)column.getType())) {
                bl = bl || column.getLength() == null || column.getLength().compareTo(BigInteger.ZERO) < 0;
            }
            return bl;
        });
    }

    public static Optional<RModelType.DetailFunction> addDetailFunction(Context context, RModelType.DetailFunction detailFunction) {
        RModelType.DetailFunction detailFunction2 = null;
        DetailsFunctionSelectionPanel detailsFunctionSelectionPanel = new DetailsFunctionSelectionPanel(context, detailFunction);
        detailsFunctionSelectionPanel.load();
        DialogHelper dialogHelper = new DialogHelper(detailsFunctionSelectionPanel);
        if (dialogHelper.showAsDialog()) {
            detailFunction2 = detailsFunctionSelectionPanel.getDetailFunction();
        }
        return Optional.ofNullable(detailFunction2);
    }

    @Override
    protected void afterFailure() {
        this.modelA = new DefaultComboBoxModel();
        this.modelA.addElement(DEFAULT_OPTION);
        this.jDetailsChoice.setModel(this.modelA);
        this.jDetailsChoice.setEnabled(false);
    }

    private class SizeLimitedUTF8Document
    extends PlainDocument {
        private int maxLength;

        public SizeLimitedUTF8Document(int n) {
            this.maxLength = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            int n2;
            if (StringUtils.isNotEmpty((String)string) && ((n2 = this.getLength() + string.length()) > this.maxLength || StringUtils.hasMultiByteCharacters((String)string))) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }

    private class OutputSignatureTableModelListener
    implements TableModelListener {
        private OutputSignatureTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            int n;
            DetailsFunctionSelectionPanel.this.deleteColumn.setEnabled(!DetailsFunctionSelectionPanel.this.outputColumns.isEmpty());
            if (tableModelEvent.getColumn() == 1) {
                MiningDataType miningDataType;
                n = tableModelEvent.getFirstRow();
                String string = (String)DetailsFunctionSelectionPanel.this.tableModel.getValueAt(n, 1);
                MiningDataType miningDataType2 = miningDataType = MiningDataType.VARCHAR_2.value().equals(string) ? MiningDataType.VARCHAR_2 : MiningDataType.NUMBER;
                if (MiningDataType.NUMBER.equals((Object)miningDataType)) {
                    DetailsFunctionSelectionPanel.this.tableModel.setValueAt(null, n, 2);
                }
            }
            if ((n = tableModelEvent.getType()) == 0 || n == 1) {
                DetailsFunctionSelectionPanel.this.validateColumns();
            }
        }
    }

    private class DeleteOutputColumnListener
    implements ActionListener {
        private DataMinerTable table;

        private DeleteOutputColumnListener() {
            this.table = DetailsFunctionSelectionPanel.this.outputColumnsTable.getTable();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.table.removeEditor();
            this.deleteRows(this.getRowsToDelete());
        }

        private final int[] getRowsToDelete() {
            int[] nArray = new int[]{};
            int n = this.table.getEditingRow();
            nArray = n >= 0 ? new int[]{n} : this.table.getSelectedRows();
            return nArray;
        }

        private final void deleteRows(int[] nArray) {
            ArrayList arrayList = new ArrayList(nArray.length);
            for (int n : nArray) {
                arrayList.add(DetailsFunctionSelectionPanel.this.tableModel.getSrcData().get(n));
            }
            DetailsFunctionSelectionPanel.this.tableModel.removeRows(arrayList);
        }
    }

    private class NewOutputColumnListener
    implements ActionListener {
        private NewOutputColumnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RModelType.DetailFunction.Output.Column column = new RModelType.DetailFunction.Output.Column();
            DetailsFunctionSelectionPanel.this.tableModel.addRow(column);
            int n = DetailsFunctionSelectionPanel.this.tableModel.getRowCount() - 1;
            DataMinerTable dataMinerTable = DetailsFunctionSelectionPanel.this.outputColumnsTable.getTable();
            dataMinerTable.setRowSelectionInterval(n, n);
            dataMinerTable.editCellAt(n, 0);
            dataMinerTable.getEditorComponent().requestFocus();
        }
    }

    private class DetailsFunctionChangeListener
    extends FunctionSelectionPanel.FunctionChangeListener {
        private DetailsFunctionChangeListener(DefaultComboBoxModel<RFunction> defaultComboBoxModel, JTextArea jTextArea) {
            super(DetailsFunctionSelectionPanel.this, defaultComboBoxModel, jTextArea);
        }

        @Override
        protected void updateMetaData(String string) {
            DetailsFunctionSelectionPanel.this.function.setPrimaryFunction(string);
        }

        @Override
        protected void afterFirstUserSelection() {
            super.afterFirstUserSelection();
            DetailsFunctionSelectionPanel.this.addColumn.setEnabled(true);
        }
    }

    private class DetailsFunctionAllSchemaListener
    extends FunctionSelectionPanel.QueryAllSchemasListener {
        private DetailsFunctionAllSchemaListener() {
            super(DetailsFunctionSelectionPanel.this);
        }

        @Override
        protected void updateMetaData() {
            RFunction rFunction = (RFunction)DetailsFunctionSelectionPanel.this.modelA.getSelectedItem();
            String string = rFunction.getQualifiedName();
            DetailsFunctionSelectionPanel.this.function.setPrimaryFunction(string);
        }
    }
}

