/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.ModelSVCBuildSettingsSolverOptions;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.Version;

public class ModelSVCBuildSettingsPanel
extends AbstractPropertiesPanel {
    private Version _dbVersion;
    private String regularizer;
    private String batchRows;
    private JButton btnOption;
    private JComboBox<String> cboSolver;
    private JCheckBox jCheckBoxActiveLearning;
    private JCheckBox jCheckBoxComplexityFactors;
    private JCheckBox jCheckBoxEpsilonFactors;
    private JCheckBox jCheckBoxStdDev;
    private JComboBox<String> jComboBoxKernerFunction;
    private JLabel jLabelCacheSize;
    private JLabel jLabelKernelFunction;
    private JLabel jLabelToleranceValue;
    private JScrollPane jScrollPaneTitle;
    private JTextField jTextFieldCacheSize;
    private JTextField jTextFieldComplexityFactors;
    private JTextField jTextFieldEpsilonFactors;
    private JTextField jTextFieldStdDev;
    private JTextField jTextFieldToleranceValue;
    private JLabel lblNumberOfIterations;
    private JLabel lblNumberOfPivots;
    private JLabel lblSolver;
    private JRadioButton radBtnNumberIterationsSystem;
    private JRadioButton radBtnNumberIterationsUser;
    private JTextField txtNumberIterationsUser;
    private JTextField txtNumberOfPivots;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();
    private DefaultComboBoxModel<String> _kernelFunctionsModel;
    private String _currentKernelFunctionName;
    private static final String CLIENT_SVM_LINEAR = AlgSettingsLrb.get("SVMS_LINEAR");
    private static final String CLIENT_SVM_GAUSSIAN = AlgSettingsLrb.get("SVMS_GAUSSIAN");
    private static final String CLIENT_SVMS_SYSTEM_DEFAULT = AlgSettingsLrb.get("SVMS_SYSTEM_DEFAULT");

    public ModelSVCBuildSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        super(advancedSettingsPanel, modelType);
        this._dbVersion = ConnectionFolder.getConnectionFolder(advancedSettingsPanel.getContext()).getDbVersion();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jCheckBoxComplexityFactors = new JCheckBox();
        this.jLabelToleranceValue = new JLabel();
        this.jCheckBoxStdDev = new JCheckBox();
        this.jTextFieldToleranceValue = new NumberTextField();
        this.jTextFieldStdDev = new NumberTextField();
        this.jLabelKernelFunction = new JLabel();
        this.jLabelCacheSize = new JLabel();
        this.jComboBoxKernerFunction = new JComboBox();
        this.jTextFieldCacheSize = new NumberTextField();
        this.jScrollPaneTitle = new JScrollPane();
        this.jCheckBoxEpsilonFactors = new JCheckBox();
        this.jTextFieldEpsilonFactors = new NumberTextField();
        this.jCheckBoxActiveLearning = new JCheckBox();
        this.jTextFieldComplexityFactors = new NumberTextField();
        this.lblNumberOfIterations = new JLabel();
        this.radBtnNumberIterationsSystem = new JRadioButton();
        this.radBtnNumberIterationsUser = new JRadioButton();
        this.txtNumberIterationsUser = new NumberTextField();
        this.lblSolver = new JLabel();
        this.cboSolver = new JComboBox();
        this.btnOption = new JButton();
        this.lblNumberOfPivots = new JLabel();
        this.txtNumberOfPivots = new NumberTextField();
        this.jCheckBoxComplexityFactors.setText("Specify the complexity factors");
        this.jCheckBoxComplexityFactors.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxComplexityFactors.setMargin(new Insets(0, 0, 0, 0));
        this.jLabelToleranceValue.setText("Tolerance Value:");
        this.jCheckBoxStdDev.setText("Specify the standard deviation for gaussian kernel");
        this.jCheckBoxStdDev.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxStdDev.setMargin(new Insets(0, 0, 0, 0));
        this.jTextFieldToleranceValue.setToolTipText("Range: > 0 and <= 0.01");
        this.jTextFieldStdDev.setToolTipText("Range: > 0");
        this.jLabelKernelFunction.setText("Kernel Function");
        this.jLabelCacheSize.setText("Cache Size:");
        this.jComboBoxKernerFunction.setInheritsPopupMenu(true);
        this.jComboBoxKernerFunction.setMinimumSize(new Dimension(58, 18));
        this.jComboBoxKernerFunction.setOpaque(false);
        this.jComboBoxKernerFunction.setPreferredSize(new Dimension(62, 22));
        this.jTextFieldCacheSize.setToolTipText("Range: > 0");
        this.jScrollPaneTitle.setBorder(null);
        this.jScrollPaneTitle.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneTitle.setVerticalScrollBarPolicy(21);
        this.jCheckBoxEpsilonFactors.setText("Specify epsilon factor ");
        this.jCheckBoxEpsilonFactors.setToolTipText("Value of epsilon factor for SVM regression. Default value estimated from the data by the algorithm.SVMS_EPSILON =  TO_CHAR(numeric_expr >0)");
        this.jCheckBoxEpsilonFactors.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxEpsilonFactors.setMargin(new Insets(0, 0, 0, 0));
        this.jTextFieldEpsilonFactors.setToolTipText("Range: > 0");
        this.jCheckBoxActiveLearning.setText("Active Learning");
        this.jCheckBoxActiveLearning.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxActiveLearning.setMargin(new Insets(0, 0, 0, 0));
        this.jTextFieldComplexityFactors.setToolTipText("Range: > 0");
        this.lblNumberOfIterations.setText("Number of iterations:");
        this.radBtnNumberIterationsSystem.setText("System Determined");
        this.radBtnNumberIterationsUser.setText("User Specified:");
        this.lblSolver.setText("Solver:");
        this.cboSolver.setMinimumSize(new Dimension(58, 18));
        this.cboSolver.setPreferredSize(new Dimension(62, 22));
        this.btnOption.setText("option");
        this.lblNumberOfPivots.setText("Number of Pivots used in the Incomplete Cholesky decomposition");
        this.txtNumberOfPivots.setToolTipText("");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(19, 19, 19).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelKernelFunction, -2, 98, -2).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblSolver).addGroup(groupLayout.createSequentialGroup().addGap(23, 23, 23).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radBtnNumberIterationsSystem).addComponent(this.radBtnNumberIterationsUser)))).addGap(27, 27, 27).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.txtNumberIterationsUser, -2, 172, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.cboSolver, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 162, Short.MAX_VALUE).addComponent(this.btnOption)))).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelToleranceValue, -2, 106, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldToleranceValue, -2, 80, -2).addComponent(this.jComboBoxKernerFunction, -2, 160, -2))).addComponent(this.jCheckBoxComplexityFactors, -2, 181, -2).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jTextFieldComplexityFactors, -2, 83, -2)).addComponent(this.jCheckBoxActiveLearning).addComponent(this.jLabelCacheSize, -2, 78, -2).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldCacheSize, -2, 80, -2).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jTextFieldStdDev, -2, 74, -2))).addComponent(this.jCheckBoxStdDev).addComponent(this.jCheckBoxEpsilonFactors, -2, 181, -2).addComponent(this.jTextFieldEpsilonFactors, -2, 83, -2).addComponent(this.lblNumberOfIterations).addComponent(this.txtNumberOfPivots, -2, 164, -2).addComponent(this.lblNumberOfPivots, -2, 341, -2)).addGap(0, 0, Short.MAX_VALUE)))))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTitle, -1, 575, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTitle, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelKernelFunction).addComponent(this.jComboBoxKernerFunction, -2, -1, -2)).addGap(13, 13, 13).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelToleranceValue).addComponent(this.jTextFieldToleranceValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxComplexityFactors).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldComplexityFactors, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jCheckBoxEpsilonFactors).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldEpsilonFactors, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxActiveLearning).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxStdDev).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldStdDev, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelCacheSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldCacheSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblNumberOfIterations).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.radBtnNumberIterationsSystem).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radBtnNumberIterationsUser).addComponent(this.txtNumberIterationsUser, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSolver).addComponent(this.cboSolver, -2, -1, -2).addComponent(this.btnOption)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblNumberOfPivots).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtNumberOfPivots, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private static String convertToServerKernelFunctionName(String string) {
        assert (string != null);
        if (0 == string.compareTo(CLIENT_SVM_GAUSSIAN)) {
            return "SVMS_GAUSSIAN";
        }
        if (0 == string.compareTo(CLIENT_SVM_LINEAR)) {
            return "SVMS_LINEAR";
        }
        return "SVMS_SYSTEM_DETERMINED";
    }

    private void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelKernelFunction, this.jComboBoxKernerFunction, (String)AlgSettingsLrb.get("MODEL_SETTINGS_KERNEL_FUNCTION"));
        ResourceUtils.resLabel((JLabel)this.jLabelToleranceValue, (Component)this.jTextFieldToleranceValue, (String)AlgSettingsLrb.get("MODEL_SETTINGS_TOLERANCE_VALUE"));
        ResourceUtils.resButton((AbstractButton)this.jCheckBoxComplexityFactors, (String)AlgSettingsLrb.get("MODEL_SETTINGS_COMPLEXITY_FACTOR"));
        ResourceUtils.resButton((AbstractButton)this.jCheckBoxEpsilonFactors, (String)AlgSettingsLrb.get("MODEL_SETTINGS_EPSILON_FACTOR"));
        ResourceUtils.resButton((AbstractButton)this.jCheckBoxActiveLearning, (String)AlgSettingsLrb.get("MODEL_SETTINGS_ACTIVE_LEARNING"));
        ResourceUtils.resButton((AbstractButton)this.jCheckBoxStdDev, (String)AlgSettingsLrb.get("MODEL_SETTINGS_CHK_BOX_STDEV"));
        ResourceUtils.resLabel((JLabel)this.jLabelCacheSize, (Component)this.jTextFieldCacheSize, (String)AlgSettingsLrb.get("MODEL_SETTINGS_CACHE_SIZE"));
        if (DbVersionHelper.isDB122Up((Version)this._dbVersion)) {
            ResourceUtils.resLabel((JLabel)this.lblNumberOfIterations, (Component)this.radBtnNumberIterationsSystem, (String)AlgSettingsLrb.get("GLMS_NUM_ITERATIONS"));
            ResourceUtils.resLabel((JLabel)this.lblNumberOfPivots, (Component)this.txtNumberOfPivots, (String)AlgSettingsLrb.get("MODEL_SETTINGS_NUMBER_OF_PIVOTS"));
            ResourceUtils.resLabel((JLabel)this.lblSolver, this.cboSolver, (String)AlgSettingsLrb.get("MODEL_SETTINGS_SOLVER"));
        }
        this.jTextFieldComplexityFactors.setToolTipText(AlgSettingsLrb.get("SVMS_CONV_POSITIVE_VALUE_TOOLTIP"));
        this.jTextFieldStdDev.setToolTipText(AlgSettingsLrb.get("SVMS_CONV_POSITIVE_VALUE_TOOLTIP"));
        this.jTextFieldCacheSize.setToolTipText(AlgSettingsLrb.get("SVMS_CONV_POSITIVE_VALUE_TOOLTIP"));
    }

    private void initUI() {
        Object object;
        final CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        this.loadDescription(this._jDescription, this.jScrollPaneTitle);
        this.setDataType(this.jTextFieldToleranceValue, Double.class);
        ((NumberTextField)this.jTextFieldToleranceValue).setDecimal(true, 4);
        this.setDataType(this.jTextFieldComplexityFactors, Double.class);
        ((NumberTextField)this.jTextFieldComplexityFactors).setDecimal(true, 4);
        this.setDataType(this.jTextFieldEpsilonFactors, Double.class);
        ((NumberTextField)this.jTextFieldEpsilonFactors).setDecimal(true, 4);
        this.setDataType(this.jTextFieldStdDev, Double.class);
        ((NumberTextField)this.jTextFieldStdDev).setDecimal(true, 4);
        this.setDataType(this.jTextFieldCacheSize, Long.class);
        this.setSigned(this.jTextFieldToleranceValue, false);
        this.setSigned(this.jTextFieldComplexityFactors, false);
        this.setSigned(this.jTextFieldEpsilonFactors, false);
        this.setSigned(this.jTextFieldStdDev, false);
        this.setSigned(this.jTextFieldCacheSize, false);
        this.setLocale(this.jTextFieldToleranceValue, commonSettingDataObject.getLocale());
        this.setLocale(this.jTextFieldComplexityFactors, commonSettingDataObject.getLocale());
        this.setSigned(this.jTextFieldEpsilonFactors, false);
        this.setLocale(this.jTextFieldStdDev, commonSettingDataObject.getLocale());
        this.setLocale(this.jTextFieldCacheSize, commonSettingDataObject.getLocale());
        this._kernelFunctionsModel = DbVersionHelper.isDB122Up((Version)this._dbVersion) ? new DefaultComboBoxModel<String>(new String[]{CLIENT_SVM_GAUSSIAN, CLIENT_SVM_LINEAR}) : new DefaultComboBoxModel<String>(new String[]{CLIENT_SVMS_SYSTEM_DEFAULT, CLIENT_SVM_GAUSSIAN, CLIENT_SVM_LINEAR});
        this.jComboBoxKernerFunction.setModel(this._kernelFunctionsModel);
        String string = commonSettingDataObject.getModelSettingStringValue("SVMS_KERNEL_FUNCTION");
        this._currentKernelFunctionName = this.convertToClientKernelFunctionName(string);
        commonSettingDataObject.setBackupValue("SVMS_KERNEL_FUNCTION", ModelSVCBuildSettingsPanel.convertToServerKernelFunctionName(this._currentKernelFunctionName));
        this.jComboBoxKernerFunction.setSelectedItem(this._currentKernelFunctionName);
        this.jComboBoxKernerFunction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)ModelSVCBuildSettingsPanel.this.jComboBoxKernerFunction.getSelectedItem();
                if (string.equals(ModelSVCBuildSettingsPanel.this._currentKernelFunctionName)) {
                    return;
                }
                ModelSVCBuildSettingsPanel.this._currentKernelFunctionName = string;
                ModelSVCBuildSettingsPanel.this.updatePanel();
            }
        });
        BigDecimal bigDecimal = commonSettingDataObject.getModelSettingNumValue("SVMS_CONV_TOLERANCE");
        if (bigDecimal != null) {
            commonSettingDataObject.setBackupValue("SVMS_CONV_TOLERANCE", bigDecimal.doubleValue());
        } else {
            commonSettingDataObject.setBackupNullValue("SVMS_CONV_TOLERANCE");
        }
        this.setNumber(this.jTextFieldToleranceValue, bigDecimal);
        this.jTextFieldToleranceValue.setToolTipText(AlgSettingsLrb.get("SVMS_CONV_TOLERANCE_TOOLTIP"));
        BigDecimal bigDecimal2 = commonSettingDataObject.getModelSettingNumValue("SVMS_COMPLEXITY_FACTOR");
        if (bigDecimal2 == null || 0 == bigDecimal2.compareTo(BigDecimal.ZERO)) {
            this.jCheckBoxComplexityFactors.setSelected(false);
            this.jTextFieldComplexityFactors.setEnabled(false);
            commonSettingDataObject.setBackupNullValue("SVMS_COMPLEXITY_FACTOR");
        } else {
            commonSettingDataObject.setBackupValue("SVMS_COMPLEXITY_FACTOR", bigDecimal2);
            this.jCheckBoxComplexityFactors.setSelected(true);
            this.setNumber(this.jTextFieldComplexityFactors, bigDecimal2);
            this.jTextFieldComplexityFactors.setToolTipText(AlgSettingsLrb.get("SVMS_CONV_POSITIVE_VALUE_TOOLTIP"));
        }
        this.jCheckBoxComplexityFactors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JCheckBox) {
                    JCheckBox jCheckBox = (JCheckBox)object;
                    ModelSVCBuildSettingsPanel.this.jTextFieldComplexityFactors.setEnabled(jCheckBox.isSelected());
                }
            }
        });
        BigDecimal bigDecimal3 = commonSettingDataObject.getModelSettingNumValue("SVMS_EPSILON");
        if (bigDecimal3 == null || 0 == bigDecimal3.compareTo(BigDecimal.ZERO)) {
            this.jCheckBoxEpsilonFactors.setSelected(false);
            this.jTextFieldEpsilonFactors.setEnabled(false);
            commonSettingDataObject.setBackupNullValue("SVMS_EPSILON");
        } else {
            commonSettingDataObject.setBackupValue("SVMS_EPSILON", bigDecimal3);
            this.jCheckBoxEpsilonFactors.setSelected(true);
            this.setNumber(this.jTextFieldEpsilonFactors, bigDecimal3);
            this.jTextFieldEpsilonFactors.setToolTipText(DialogsLrb.get("SVMS_CONV_POSITIVE_VALUE_TOOLTIP"));
        }
        this.jCheckBoxEpsilonFactors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JCheckBox) {
                    JCheckBox jCheckBox = (JCheckBox)object;
                    ModelSVCBuildSettingsPanel.this.jTextFieldEpsilonFactors.setEnabled(jCheckBox.isSelected());
                }
            }
        });
        if (DbVersionHelper.isDB122Up((Version)this._dbVersion)) {
            this.jCheckBoxActiveLearning.setVisible(false);
            this.jLabelCacheSize.setVisible(false);
            this.jTextFieldCacheSize.setVisible(false);
            object = new String[]{DialogsLrb.get("SVMS_SYSTEM_DEFAULT"), DialogsLrb.get("SVMS_SOLVER_SGD"), DialogsLrb.get("SVMS_SOLVER_IPM")};
            this.cboSolver.setModel(new DefaultComboBoxModel<String>((E[])object));
            this.cboSolver.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ModelSVCBuildSettingsPanel.this.updatePanel();
                }
            });
            this.btnOption.setVisible(false);
            String string2 = commonSettingDataObject.getModelSettingStringValue("SVMS_SOLVER");
            if (string2.equals("SVMS_SOLVER_SGD")) {
                this.cboSolver.setSelectedIndex(1);
                this.btnOption.setVisible(true);
            } else if (string2.equals("SVMS_SOLVER_SGD")) {
                this.cboSolver.setSelectedIndex(2);
            } else {
                this.cboSolver.setSelectedIndex(0);
            }
            commonSettingDataObject.setBackupValue("SVMS_SOLVER", string2);
            commonSettingDataObject.setBackupValue("SVMS_REGULARIZER", this.regularizer);
            commonSettingDataObject.setBackupValue("SVMS_BATCH_ROWS", this.batchRows);
            String string3 = commonSettingDataObject.getModelSettingStringValue("SVMS_ACTIVE_LEARNING");
            commonSettingDataObject.setBackupValue("SVMS_ACTIVE_LEARNING", string3);
            this.btnOption.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ModelSVCBuildSettingsSolverOptions modelSVCBuildSettingsSolverOptions;
                    DialogHelper dialogHelper;
                    if (StringUtils.isEmpty((String)ModelSVCBuildSettingsPanel.this.regularizer)) {
                        ModelSVCBuildSettingsPanel.this.regularizer = commonSettingDataObject.getModelSettingStringValue("SVMS_REGULARIZER");
                    }
                    if (StringUtils.isEmpty((String)ModelSVCBuildSettingsPanel.this.batchRows)) {
                        ModelSVCBuildSettingsPanel.this.batchRows = commonSettingDataObject.getModelSettingStringValue("SVMS_BATCH_ROWS");
                    }
                    if ((dialogHelper = new DialogHelper(modelSVCBuildSettingsSolverOptions = new ModelSVCBuildSettingsSolverOptions(ModelSVCBuildSettingsPanel.this.regularizer, ModelSVCBuildSettingsPanel.this.batchRows))).showAsDialog()) {
                        ModelSVCBuildSettingsPanel.this.batchRows = modelSVCBuildSettingsSolverOptions.getBatchRows();
                        ModelSVCBuildSettingsPanel.this.regularizer = modelSVCBuildSettingsSolverOptions.getRegularizer();
                    }
                }
            });
            BigDecimal bigDecimal4 = commonSettingDataObject.getModelSettingNumValue("SVMS_NUM_ITERATIONS");
            if (bigDecimal4 == null) {
                this.radBtnNumberIterationsSystem.setSelected(true);
                this.radBtnNumberIterationsUser.setSelected(false);
                this.txtNumberIterationsUser.setEnabled(false);
            } else {
                this.radBtnNumberIterationsSystem.setSelected(false);
                this.radBtnNumberIterationsUser.setSelected(true);
                this.txtNumberIterationsUser.setEnabled(true);
                this.txtNumberIterationsUser.setText(bigDecimal4.toString());
            }
            commonSettingDataObject.setBackupValue("SVMS_NUM_ITERATIONS", bigDecimal4);
            this.radBtnNumberIterationsSystem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ModelSVCBuildSettingsPanel.this.radBtnNumberIterationsUser.setSelected(false);
                    ModelSVCBuildSettingsPanel.this.txtNumberIterationsUser.setEnabled(false);
                }
            });
            this.radBtnNumberIterationsUser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ModelSVCBuildSettingsPanel.this.radBtnNumberIterationsSystem.setSelected(false);
                    ModelSVCBuildSettingsPanel.this.txtNumberIterationsUser.setEnabled(true);
                }
            });
            if (this.isGaussian()) {
                bigDecimal4 = commonSettingDataObject.getModelSettingNumValue("SVMS_NUM_PIVOTS");
                if (bigDecimal4 == null) {
                    this.txtNumberOfPivots.setText(Double.toString(ServerConstants.SVMSettings.SVMS_NUM_PIVOTS_DEFAULT));
                } else {
                    this.txtNumberOfPivots.setText(bigDecimal4.toString());
                }
            }
        } else {
            object = commonSettingDataObject.getModelSettingStringValue("SVMS_ACTIVE_LEARNING");
            object = object != null ? object : "SVMS_AL_DISABLE";
            commonSettingDataObject.setBackupValue("SVMS_ACTIVE_LEARNING", object);
            this.jCheckBoxActiveLearning.setSelected(((String)object).equals("SVMS_AL_ENABLE"));
            Number number = commonSettingDataObject.getModelSettingNumValue("SVMS_KERNEL_CACHE_SIZE");
            if (null == number || ((Number)number).longValue() == 0L) {
                number = ServerConstants.SVMSettings.SVMS_KERNEL_CACHE_SIZE_DEFAULT;
            }
            commonSettingDataObject.setBackupValue("SVMS_KERNEL_CACHE_SIZE", number);
            this.setNumber(this.jTextFieldCacheSize, number);
            this.jTextFieldCacheSize.setToolTipText(AlgSettingsLrb.get("SVMS_CONV_POSITIVE_VALUE_TOOLTIP"));
            this.lblNumberOfIterations.setVisible(false);
            this.radBtnNumberIterationsSystem.setVisible(false);
            this.radBtnNumberIterationsUser.setVisible(false);
            this.txtNumberIterationsUser.setVisible(false);
            this.lblSolver.setVisible(false);
            this.cboSolver.setVisible(false);
            this.btnOption.setVisible(false);
            this.lblNumberOfPivots.setVisible(false);
            this.txtNumberOfPivots.setVisible(false);
        }
        object = commonSettingDataObject.getModelSettingNumValue("SVMS_STD_DEV");
        if (object == null || 0 == ((BigDecimal)object).compareTo(BigDecimal.ZERO)) {
            commonSettingDataObject.setBackupNullValue("SVMS_STD_DEV");
            this.jCheckBoxStdDev.setSelected(false);
            this.jTextFieldStdDev.setEnabled(false);
        } else {
            commonSettingDataObject.setBackupValue("SVMS_STD_DEV", object);
            this.jCheckBoxStdDev.setSelected(true);
            this.setNumber(this.jTextFieldStdDev, (Number)object);
            this.jTextFieldStdDev.setToolTipText(AlgSettingsLrb.get("SVMS_CONV_POSITIVE_VALUE_TOOLTIP"));
        }
        this.jCheckBoxStdDev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JCheckBox) {
                    JCheckBox jCheckBox = (JCheckBox)object;
                    ModelSVCBuildSettingsPanel.this.jTextFieldStdDev.setEnabled(jCheckBox.isSelected());
                }
            }
        });
        this.updatePanel();
    }

    private String convertToClientKernelFunctionName(String string) {
        if (string != null) {
            if (0 == string.compareTo("SVMS_GAUSSIAN")) {
                return CLIENT_SVM_GAUSSIAN;
            }
            if (0 == string.compareTo("SVMS_LINEAR")) {
                return CLIENT_SVM_LINEAR;
            }
        }
        if (DbVersionHelper.isDB122Up((Version)this._dbVersion)) {
            return CLIENT_SVM_LINEAR;
        }
        return CLIENT_SVMS_SYSTEM_DEFAULT;
    }

    private void updatePanel() {
        ModelType modelType;
        boolean bl = this.isGaussian();
        this.jCheckBoxStdDev.setVisible(bl);
        this.jTextFieldStdDev.setVisible(bl);
        if (!DbVersionHelper.isDB122Up((Version)this._dbVersion)) {
            this.jLabelCacheSize.setVisible(bl);
            this.jTextFieldCacheSize.setVisible(bl);
        }
        if ((modelType = this.getModelType()) instanceof CSupportVectorMachineModelType) {
            this.jTextFieldEpsilonFactors.setVisible(false);
            this.jCheckBoxEpsilonFactors.setVisible(false);
        }
        if (DbVersionHelper.isDB122Up((Version)this._dbVersion)) {
            this.lblSolver.setVisible(true);
            this.cboSolver.setVisible(true);
            String string = this.cboSolver.getSelectedItem().toString();
            if (DialogsLrb.get("SVMS_SOLVER_SGD").equals(string)) {
                this.btnOption.setVisible(true);
            } else {
                this.btnOption.setVisible(false);
            }
            this.lblNumberOfPivots.setVisible(bl);
            this.txtNumberOfPivots.setVisible(bl);
            if (this.isGaussian() && StringUtils.isEmpty((String)this.txtNumberIterationsUser.getText())) {
                this.radBtnNumberIterationsSystem.setSelected(true);
                this.radBtnNumberIterationsUser.setSelected(false);
                this.txtNumberIterationsUser.setEnabled(false);
                CommonSettingDataObject commonSettingDataObject = this.getPanelState();
                commonSettingDataObject.setValue("SVMS_NUM_ITERATIONS", null);
            }
        } else {
            this.lblSolver.setVisible(false);
            this.cboSolver.setVisible(false);
            this.btnOption.setVisible(false);
        }
        this.repaint();
    }

    private boolean isGaussian() {
        boolean bl = false;
        if (this._currentKernelFunctionName != null) {
            bl = this._currentKernelFunctionName.equals(CLIENT_SVM_GAUSSIAN);
        }
        return bl;
    }

    @Override
    public void processInput() {
        Object object;
        boolean bl;
        Number number;
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        commonSettingDataObject.setCommonPerformanceOption();
        this.setObjectValue("SVMS_KERNEL_FUNCTION", ModelSVCBuildSettingsPanel.convertToServerKernelFunctionName(this._currentKernelFunctionName));
        Number number2 = this.getNumber(this.jTextFieldToleranceValue);
        if (null == number2 || number2.doubleValue() <= 0.0 || number2.doubleValue() > 0.01) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("SVMS_CONV_TOLERANCE_OUT_OF_RANGE"));
            return;
        }
        this.setObjectValue("SVMS_CONV_TOLERANCE", Double.valueOf(number2.toString()));
        if (this.jCheckBoxComplexityFactors.isSelected()) {
            number = this.getNumber(this.jTextFieldComplexityFactors);
            if (null == number || number.doubleValue() <= 0.0) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("SVMS_COMPLEXITY_FACTOR_NULL"));
                return;
            }
            this.setObjectValue("SVMS_COMPLEXITY_FACTOR", number);
        } else {
            this.setNullObjectValue("SVMS_COMPLEXITY_FACTOR");
        }
        if (this.jCheckBoxEpsilonFactors.isSelected()) {
            number = this.getNumber(this.jTextFieldEpsilonFactors);
            if (null == number || number.doubleValue() <= 0.0) {
                this.setValidationErrorObjectValue(DialogsLrb.get("SVMS_EPSILON_FACTOR_NULL"));
                return;
            }
            this.setObjectValue("SVMS_EPSILON", number);
        } else {
            this.setNullObjectValue("SVMS_EPSILON");
        }
        if (!DbVersionHelper.isDB122Up((Version)this._dbVersion)) {
            this.setObjectValue("SVMS_ACTIVE_LEARNING", this.jCheckBoxActiveLearning.isSelected() ? "SVMS_AL_ENABLE" : "SVMS_AL_DISABLE");
        }
        if (!(bl = this.isGaussian())) {
            commonSettingDataObject.removeValue("SVMS_STD_DEV");
            commonSettingDataObject.removeValue("SVMS_KERNEL_CACHE_SIZE");
            return;
        }
        if (this.jCheckBoxStdDev.isSelected()) {
            object = this.getNumber(this.jTextFieldStdDev);
            if (null == object || ((Number)object).doubleValue() <= 0.0) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("SVMS_COMPLEXITY_STD_DEV_NULL"));
                return;
            }
            this.setObjectValue("SVMS_STD_DEV", object);
        } else {
            this.setNullObjectValue("SVMS_STD_DEV");
        }
        if (DbVersionHelper.isDB122Up((Version)this._dbVersion)) {
            if (StringUtils.isNotEmpty((String)this.batchRows)) {
                this.setObjectValue("SVMS_BATCH_ROWS", null);
            }
            if (StringUtils.isNotEmpty((String)this.regularizer)) {
                this.setObjectValue("SVMS_REGULARIZER", null);
            }
            if (this.radBtnNumberIterationsSystem.isSelected()) {
                this.setObjectValue("SVMS_NUM_ITERATIONS", null);
            } else {
                object = this.getNumber(this.txtNumberIterationsUser);
                if (null == object || ((Number)object).doubleValue() < 0.0) {
                    this.setValidationErrorObjectValue(AlgSettingsLrb.get("SVMS_NUM_ITERATIONS_OUT_OF_RANGE"));
                    return;
                }
                this.setObjectValue("SVMS_NUM_ITERATIONS", object);
            }
            object = this.cboSolver.getSelectedItem().toString();
            if (DialogsLrb.get("SVMS_SYSTEM_DEFAULT").equals(object)) {
                this.setObjectValue("SVMS_SOLVER", null);
            } else if (DialogsLrb.get("SVMS_SOLVER_SGD").equals(object)) {
                this.setObjectValue("SVMS_SOLVER", "SVMS_SOLVER_SGD");
            } else {
                this.setObjectValue("SVMS_SOLVER", "SVMS_SOLVER_IPM");
            }
            if (bl) {
                Number number3 = this.getNumber(this.txtNumberOfPivots);
                if (null == number3) {
                    number3 = ServerConstants.SVMSettings.SVMS_NUM_PIVOTS_DEFAULT;
                }
                Double d = ServerConstants.SVMSettings.SVMS_NUM_PIVOTS_MAX;
                if (number3.doubleValue() <= 0.0 || number3.doubleValue() > d) {
                    this.setValidationErrorObjectValue(AlgSettingsLrb.get("SVMS_NUM_PIVOTS_OUT_OF_RANGE"));
                    return;
                }
                this.setObjectValue("SVMS_NUM_PIVOTS", number3);
            } else {
                this.setObjectValue("SVMS_NUM_PIVOTS", null);
            }
        } else {
            object = this.getNumber(this.jTextFieldCacheSize);
            if (null == object || ((Number)object).doubleValue() <= 0.0) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("SVMS_COMPLEXITY_CACHE_SIZE_NULL"));
                return;
            }
            this.setObjectValue("SVMS_KERNEL_CACHE_SIZE", object);
        }
    }

    public void getIgnoredSettingsList() {
    }

    public boolean isNewDataInput(boolean bl) throws ValidationException {
        Object object;
        String string;
        Object object2;
        Object object3;
        String string2;
        String string3;
        Number number = this.getNumber(this.jTextFieldToleranceValue);
        if (null == number || number.doubleValue() < 0.0 || number.doubleValue() > 0.01) {
            throw new ValidationException(AlgSettingsLrb.get("SVMS_CONV_TOLERANCE_OUT_OF_RANGE"));
        }
        Number number2 = null;
        if (this.jCheckBoxComplexityFactors.isSelected() && null == (number2 = this.getNumber(this.jTextFieldComplexityFactors))) {
            throw new ValidationException(AlgSettingsLrb.get("SVMS_COMPLEXITY_FACTOR_NULL"));
        }
        Number number3 = null;
        if (this.jCheckBoxEpsilonFactors.isSelected() && null == (number3 = this.getNumber(this.jTextFieldEpsilonFactors))) {
            throw new ValidationException(DialogsLrb.get("SVMS_EPSILON_FACTOR_NULL"));
        }
        Number number4 = null;
        Number number5 = null;
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        if (!DbVersionHelper.isDB122Up((Version)this._dbVersion)) {
            string3 = null;
            if (this.jCheckBoxActiveLearning.isSelected()) {
                if (this.jCheckBoxStdDev.isSelected() && null == (number4 = this.getNumber(this.jTextFieldStdDev))) {
                    throw new ValidationException(AlgSettingsLrb.get("SVMS_COMPLEXITY_STD_DEV_NULL"));
                }
                number5 = this.getNumber(this.jTextFieldCacheSize);
                if (null == number5) {
                    throw new ValidationException(AlgSettingsLrb.get("SVMS_COMPLEXITY_CACHE_SIZE_NULL"));
                }
                string3 = "SVMS_AL_ENABLE";
            } else {
                string3 = "SVMS_AL_DISABLE";
            }
            string2 = (String)commonSettingDataObject.getBackupValue("SVMS_ACTIVE_LEARNING");
            if (0 != string3.compareTo(string2)) {
                return true;
            }
            object3 = null;
            object2 = null;
            if (string2.equals("SVMS_AL_ENABLE")) {
                object3 = commonSettingDataObject.getBackupValue("SVMS_STD_DEV");
                if (!this.areEqual(object3, number4)) {
                    return true;
                }
                object2 = commonSettingDataObject.getBackupValue("SVMS_KERNEL_CACHE_SIZE");
                if (!this.areEqual(object2, number5)) {
                    return true;
                }
            }
        }
        if (!bl) {
            return bl;
        }
        string3 = (String)commonSettingDataObject.getBackupValue("SVMS_KERNEL_FUNCTION");
        if (0 != string3.compareTo(string2 = ModelSVCBuildSettingsPanel.convertToServerKernelFunctionName(this._currentKernelFunctionName))) {
            return true;
        }
        object3 = (Double)commonSettingDataObject.getBackupValue("SVMS_CONV_TOLERANCE");
        if (!NameValuePair.areEqual((double)number.doubleValue(), (double)((Double)object3))) {
            return true;
        }
        object2 = commonSettingDataObject.getBackupValue("SVMS_COMPLEXITY_FACTOR");
        if (!this.areEqual(object2, number2)) {
            return true;
        }
        Object object4 = commonSettingDataObject.getBackupValue("SVMS_REGULARIZER");
        if (!this.regularizer.equals(object4)) {
            return true;
        }
        Object object5 = commonSettingDataObject.getBackupValue("SVMS_BATCH_ROWS");
        if (!this.batchRows.equals(object5)) {
            return true;
        }
        Object object6 = commonSettingDataObject.getBackupValue("SVMS_SOLVER");
        if (!object6.equals(string = this.cboSolver.getSelectedItem().toString())) {
            return true;
        }
        Object object7 = commonSettingDataObject.getBackupValue("SVMS_NUM_ITERATIONS");
        Number number6 = null;
        if (this.radBtnNumberIterationsSystem.isSelected()) {
            if (object7 != null && (object = object7.toString()) != null) {
                return true;
            }
        } else if (this.radBtnNumberIterationsUser.isSelected()) {
            number6 = this.getNumber(this.txtNumberIterationsUser);
            if (null == number6 || number6.intValue() < 0) {
                throw new ValidationException(AlgSettingsLrb.get("SVMS_NUM_ITERATIONS_OUT_OF_RANGE"));
            }
            if (object7 != null && !((String)(object = object7.toString())).equals(this.getNumber(this.txtNumberIterationsUser).toString())) {
                return true;
            }
        }
        if (this.isGaussian()) {
            object = commonSettingDataObject.getBackupValue("SVMS_NUM_PIVOTS");
            Number number7 = this.getNumber(this.txtNumberOfPivots);
            if (number7 == null && object != null || number7 != null && object == null || !number7.toString().equals(object.toString())) {
                return true;
            }
        }
        return false;
    }

    private boolean areEqual(Object object, Number number) {
        return !(object instanceof BigDecimal ? !NameValuePair.areEqual((double)number.doubleValue(), (double)((BigDecimal)object).doubleValue()) : object instanceof String && number != null);
    }
}

